/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.library;

import jakarta.persistence.CascadeType;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.Lob;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.OneToOne;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Size;
import org.hibernate.annotations.JdbcTypeCode;
import org.squashtest.tm.core.foundation.sanitizehtml.HTMLSanitizeUtils;
import org.squashtest.tm.domain.attachment.AttachmentHolder;
import org.squashtest.tm.domain.attachment.AttachmentList;
import org.squashtest.tm.domain.audit.BaseAuditableEntity;
import org.squashtest.tm.domain.library.LibraryNode;
import org.squashtest.tm.domain.project.Project;

@MappedSuperclass
public abstract class GenericLibraryNode
extends BaseAuditableEntity
implements LibraryNode,
AttachmentHolder {
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="PROJECT_ID")
    private Project project;
    @NotBlank
    @Size(max=255)
    private @NotBlank @Size(max=255) String name;
    @Lob
    @JdbcTypeCode(value=-1)
    private String description;
    @OneToOne(cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.DETACH, CascadeType.REMOVE}, fetch=FetchType.LAZY)
    @JoinColumn(name="ATTACHMENT_LIST_ID", updatable=false)
    private final AttachmentList attachmentList = new AttachmentList();

    @Override
    public Project getProject() {
        return this.project;
    }

    @Override
    public void setName(String name) {
        if (name != null) {
            this.name = name.trim();
        }
    }

    @Override
    public void setDescription(String description) {
        this.description = HTMLSanitizeUtils.cleanHtml((String)description);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return HTMLSanitizeUtils.cleanHtml((String)this.description);
    }

    @Override
    public void notifyAssociatedWithProject(Project project) {
        this.project = project;
    }

    @Override
    public AttachmentList getAttachmentList() {
        return this.attachmentList;
    }

    @Override
    public Long getAttachmentHolderProjectId() {
        return this.project.getId();
    }

    protected abstract Class<? extends GenericLibraryNode> getGenericNodeClass();

    public int hashCode() {
        int result = 1;
        Long id = this.getId();
        Class<? extends GenericLibraryNode> mygenericClass = this.getGenericNodeClass();
        result = 31 * result + (id == null ? 0 : id.hashCode());
        result = 31 * result + (mygenericClass == null ? 0 : mygenericClass.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!GenericLibraryNode.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        GenericLibraryNode other = (GenericLibraryNode)obj;
        Long id = this.getId();
        Class<? extends GenericLibraryNode> mygenericClass = this.getGenericNodeClass();
        if (id == null ? other.getId() != null : !id.equals(other.getId())) {
            return false;
        }
        return mygenericClass.equals(other.getGenericNodeClass());
    }
}

