/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.jpql;

import java.util.List;
import java.util.Map;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.dialect.MariaDBDialect;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.squashtest.tm.domain.jpql.HibernateDialectExtensions;

public class MariaDBEnhancedDialect
extends MariaDBDialect {
    private static final String STRAIGHT_JOIN = "STRAIGHT_JOIN";

    public void initializeFunctionRegistry(FunctionContributions functionContributions) {
        super.initializeFunctionRegistry(functionContributions);
        Map<String, StandardSQLFunction> extensions = HibernateDialectExtensions.getMariaDBDialectExtensions();
        for (Map.Entry<String, StandardSQLFunction> extension : extensions.entrySet()) {
            functionContributions.getFunctionRegistry().register(extension.getKey(), (SqmFunctionDescriptor)extension.getValue());
        }
    }

    public String getQueryHintString(String sql, List<String> hints) {
        if (hints.contains(STRAIGHT_JOIN)) {
            sql = sql.replaceAll("(select|SELECT)", "SELECT STRAIGHT_JOIN");
        }
        return sql;
    }
}

