/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.jpql;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.query.ReturnableType;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.type.BasicTypeReference;
import org.hibernate.type.StandardBasicTypes;

public final class HibernateDialectExtensions {
    private static final String LOWER = "(LOWER(";
    public static final String FN_NAME_GROUP_CONCAT = "group_concat";
    public static final String FN_NAME_MATCHES = "matches";
    public static final String FN_NAME_I_MATCHES = "i_matches";
    public static final String FN_NAME_FULLTEXT = "fulltext_search";
    public static final String FN_INSENSITIVE_LIKE = "i_like";
    public static final String FN_INSENSITIVE_EQUALS = "i_equals";
    public static final String FN_NAME_WEEK = "week";
    public static final String FN_NAME_SUM = "s_sum";
    public static final String FN_NAME_CNT = "s_count";
    public static final String FN_NAME_MIN = "s_min";
    public static final String FN_NAME_MAX = "s_max";
    public static final String FN_NAME_AVG = "s_avg";

    private HibernateDialectExtensions() {
    }

    public static Map<String, StandardSQLFunction> getMariaDBDialectExtensions() {
        Map<String, StandardSQLFunction> extensions = HibernateDialectExtensions.getCommonExtensions();
        extensions.put(FN_NAME_GROUP_CONCAT, new GroupConcatFunction(FN_NAME_GROUP_CONCAT, (BasicTypeReference<String>)StandardBasicTypes.STRING));
        extensions.put(FN_NAME_MATCHES, new Regexp());
        extensions.put(FN_NAME_I_MATCHES, new InsensitiveRegexp());
        extensions.put(FN_NAME_FULLTEXT, new MatchFullTextSearch());
        extensions.put(FN_INSENSITIVE_LIKE, new LikeInsensitiveSearch());
        extensions.put(FN_INSENSITIVE_EQUALS, new EqualsInsensitiveSearch());
        return extensions;
    }

    public static Map<String, StandardSQLFunction> getH2DialectExtensions() {
        Map<String, StandardSQLFunction> extensions = HibernateDialectExtensions.getCommonExtensions();
        extensions.put(FN_NAME_GROUP_CONCAT, new GroupConcatFunction(FN_NAME_GROUP_CONCAT, (BasicTypeReference<String>)StandardBasicTypes.STRING));
        extensions.put(FN_NAME_MATCHES, new Regexp());
        extensions.put(FN_NAME_I_MATCHES, new InsensitiveRegexp());
        extensions.put(FN_INSENSITIVE_LIKE, new LikeInsensitiveSearch());
        extensions.put(FN_INSENSITIVE_EQUALS, new EqualsInsensitiveSearch());
        return extensions;
    }

    public static Map<String, StandardSQLFunction> getPostgresDialectExtensions() {
        Map<String, StandardSQLFunction> extensions = HibernateDialectExtensions.getCommonExtensions();
        extensions.put(FN_NAME_GROUP_CONCAT, new StringAggFunction(FN_NAME_GROUP_CONCAT, (BasicTypeReference<String>)StandardBasicTypes.STRING));
        extensions.put(FN_NAME_WEEK, new ExtractWeek(FN_NAME_WEEK, StandardBasicTypes.INTEGER));
        extensions.put(FN_NAME_MATCHES, new TildeStar());
        extensions.put(FN_NAME_I_MATCHES, new InsensitiveTildeStar());
        extensions.put(FN_NAME_FULLTEXT, new TsQueryFullTextSearch());
        extensions.put(FN_INSENSITIVE_LIKE, new ILikeSearch());
        extensions.put(FN_INSENSITIVE_EQUALS, new EqualsInsensitiveSearch());
        return extensions;
    }

    private static Map<String, StandardSQLFunction> getCommonExtensions() {
        HashMap<String, StandardSQLFunction> extensions = new HashMap<String, StandardSQLFunction>();
        extensions.put(FN_NAME_SUM, new StandardSQLFunction("sum"));
        extensions.put(FN_NAME_MIN, new StandardSQLFunction("min"));
        extensions.put(FN_NAME_MAX, new StandardSQLFunction("max"));
        extensions.put(FN_NAME_AVG, new StandardSQLFunction("avg", StandardBasicTypes.DOUBLE));
        extensions.put(FN_NAME_CNT, new SCountDistinctFunction());
        return extensions;
    }

    private static final class EqualsInsensitiveSearch
    extends StandardSQLFunction {
        public EqualsInsensitiveSearch() {
            super("EQUALS_INSENSITIVE_SEARCH", StandardBasicTypes.BOOLEAN);
        }

        public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> arguments, ReturnableType<?> returnableType, SqlAstTranslator<?> translator) {
            sqlAppender.appendSql(HibernateDialectExtensions.LOWER);
            arguments.get(0).accept(translator);
            sqlAppender.appendSql(") = LOWER(");
            arguments.get(1).accept(translator);
            sqlAppender.appendSql("))");
        }
    }

    private static final class ExtractWeek
    extends StandardSQLFunction {
        ExtractWeek(String name) {
            super(name);
        }

        public ExtractWeek(String name, BasicTypeReference<?> registeredType) {
            super(name, registeredType);
        }

        public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> arguments, ReturnableType<?> returnableType, SqlAstTranslator<?> translator) {
            sqlAppender.appendSql("extract(week from ");
            arguments.get(0).accept(translator);
            sqlAppender.appendSql(")");
        }
    }

    private static class GroupConcatFunction
    extends StandardSQLFunction {
        GroupConcatFunction(String name, BasicTypeReference<String> registeredType) {
            super(name, registeredType);
        }

        GroupConcatFunction(String name) {
            super(name);
        }

        public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> arguments, ReturnableType<?> returnableType, SqlAstTranslator<?> translator) {
            if (arguments.size() == 1) {
                super.render((SqlAppender)arguments.get(0), arguments, returnableType, translator);
            } else {
                try {
                    String separator;
                    String direction = arguments.size() >= 4 ? this.getStringValueOrNull(arguments.get(3)) : "asc";
                    String string = separator = arguments.size() >= 5 ? this.getStringValueOrNull(arguments.get(4)) : ",";
                    if (!"asc".equalsIgnoreCase(direction) && !"desc".equalsIgnoreCase(direction)) {
                        throw new IllegalArgumentException();
                    }
                    if (!"order by".equalsIgnoreCase(this.getStringValueOrNull(arguments.get(1)))) {
                        throw new IllegalArgumentException();
                    }
                    this.createSqlQuery(sqlAppender, arguments, translator, direction, separator);
                }
                catch (IllegalArgumentException ex) {
                    throw new IllegalArgumentException("usage of custom hql group_concat : group_concat(col id, [ 'order by', col id2, ['asc|desc']]", ex);
                }
            }
        }

        protected void createSqlQuery(SqlAppender sqlAppender, List<? extends SqlAstNode> arguments, SqlAstTranslator<?> translator, String direction, String separator) {
            sqlAppender.appendSql("group_concat(");
            arguments.get(0).accept(translator);
            sqlAppender.appendSql(" order by ");
            arguments.get(2).accept(translator);
            sqlAppender.appendSql(" ");
            sqlAppender.appendSql(direction);
            sqlAppender.appendSql(" separator '");
            sqlAppender.appendSql(separator);
            sqlAppender.appendSql("')");
        }

        private String getStringValueOrNull(SqlAstNode node) {
            if (node instanceof Literal) {
                return ((Literal)node).getLiteralValue().toString();
            }
            return null;
        }
    }

    private static final class ILikeSearch
    extends StandardSQLFunction {
        public ILikeSearch() {
            super("ILIKE_SEARCH", StandardBasicTypes.BOOLEAN);
        }

        public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> arguments, ReturnableType<?> returnableType, SqlAstTranslator<?> translator) {
            sqlAppender.appendSql("(");
            arguments.get(0).accept(translator);
            sqlAppender.appendSql(" ILIKE ");
            arguments.get(1).accept(translator);
            sqlAppender.appendSql(")");
        }
    }

    private static final class InsensitiveRegexp
    extends StandardSQLFunction {
        public InsensitiveRegexp() {
            super("INSENSITIVE_REGEXP", StandardBasicTypes.BOOLEAN);
        }

        public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> arguments, ReturnableType<?> returnableType, SqlAstTranslator<?> translator) {
            sqlAppender.appendSql(HibernateDialectExtensions.LOWER);
            arguments.get(0).accept(translator);
            sqlAppender.appendSql(") regexp LOWER(");
            arguments.get(1).accept(translator);
            sqlAppender.appendSql("))");
        }
    }

    private static final class InsensitiveTildeStar
    extends StandardSQLFunction {
        public InsensitiveTildeStar() {
            super("INSENSITIVE_TILDE_STAR", StandardBasicTypes.BOOLEAN);
        }

        public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> arguments, ReturnableType<?> returnableType, SqlAstTranslator<?> translator) {
            sqlAppender.appendSql("(");
            arguments.get(0).accept(translator);
            sqlAppender.appendSql(" ~* ");
            arguments.get(1).accept(translator);
            sqlAppender.appendSql(")");
        }
    }

    private static final class LikeInsensitiveSearch
    extends StandardSQLFunction {
        public LikeInsensitiveSearch() {
            super("LIKE_INSENSITIVE_SEARCH", StandardBasicTypes.BOOLEAN);
        }

        public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> arguments, ReturnableType<?> returnableType, SqlAstTranslator<?> translator) {
            sqlAppender.appendSql(HibernateDialectExtensions.LOWER);
            arguments.get(0).accept(translator);
            sqlAppender.appendSql(") like ");
            arguments.get(1).accept(translator);
            sqlAppender.appendSql(")");
        }
    }

    private static final class MatchFullTextSearch
    extends StandardSQLFunction {
        public MatchFullTextSearch() {
            super("MATCH_FULL_TEXT_SEARCH", StandardBasicTypes.BOOLEAN);
        }

        public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> arguments, ReturnableType<?> returnableType, SqlAstTranslator<?> translator) {
            sqlAppender.appendSql("(MATCH(");
            arguments.get(0).accept(translator);
            sqlAppender.appendSql(") AGAINST(");
            arguments.get(1).accept(translator);
            sqlAppender.appendSql(" in natural language mode) > 0)");
        }
    }

    private static final class Regexp
    extends StandardSQLFunction {
        public Regexp() {
            super("REGEXP", StandardBasicTypes.BOOLEAN);
        }

        public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> arguments, ReturnableType<?> returnableType, SqlAstTranslator<?> translator) {
            sqlAppender.appendSql("( ");
            arguments.get(0).accept(translator);
            sqlAppender.appendSql(" regexp ");
            arguments.get(1).accept(translator);
            sqlAppender.appendSql(" )");
        }
    }

    private static class SCountDistinctFunction
    extends StandardSQLFunction {
        SCountDistinctFunction() {
            super("count", StandardBasicTypes.LONG);
        }

        public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> arguments, ReturnableType<?> returnableType, SqlAstTranslator<?> translator) {
            sqlAppender.appendSql("count(distinct ");
            arguments.get(0).accept(translator);
            sqlAppender.appendSql(")");
        }
    }

    private static final class StringAggFunction
    extends GroupConcatFunction {
        StringAggFunction(String name) {
            super(name);
        }

        StringAggFunction(String name, BasicTypeReference<String> registeredType) {
            super(name, registeredType);
        }

        @Override
        public void createSqlQuery(SqlAppender sqlAppender, List<? extends SqlAstNode> arguments, SqlAstTranslator<?> translator, String direction, String separator) {
            sqlAppender.appendSql("string_agg(cast(");
            arguments.get(0).accept(translator);
            sqlAppender.appendSql(" as text),'");
            sqlAppender.appendSql(separator);
            sqlAppender.appendSql("' order by ");
            arguments.get(2).accept(translator);
            sqlAppender.appendSql(" ");
            sqlAppender.appendSql(direction);
            sqlAppender.appendSql(")");
        }
    }

    private static final class TildeStar
    extends StandardSQLFunction {
        public TildeStar() {
            super("TILDE_STAR", StandardBasicTypes.BOOLEAN);
        }

        public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> arguments, ReturnableType<?> returnableType, SqlAstTranslator<?> translator) {
            sqlAppender.appendSql("(");
            arguments.get(0).accept(translator);
            sqlAppender.appendSql(" ~ ");
            arguments.get(1).accept(translator);
            sqlAppender.appendSql(")");
        }
    }

    private static final class TsQueryFullTextSearch
    extends StandardSQLFunction {
        public TsQueryFullTextSearch() {
            super("TS_QUERY_FULL_TEXT_SEARCH", StandardBasicTypes.BOOLEAN);
        }

        public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> arguments, ReturnableType<?> returnableType, SqlAstTranslator<?> translator) {
            sqlAppender.appendSql("(");
            arguments.get(0).accept(translator);
            sqlAppender.appendSql(" @@ to_tsquery(");
            arguments.get(1).accept(translator);
            sqlAppender.appendSql("))");
        }
    }
}

