/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.jpql;

import com.querydsl.jpa.hibernate.NoSessionHolder;
import com.querydsl.jpa.hibernate.SessionHolder;
import org.hibernate.Session;
import org.hibernate.StatelessSession;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;

final class FixedSessionHolders {
    public static final Logger LOGGER = LoggerFactory.getLogger(FixedSessionHolders.class);

    private FixedSessionHolders() {
    }

    public static SessionHolder defaultSessionHolder(Session session) {
        return new FixedDefaultSessionHolder(session);
    }

    public static SessionHolder statelessSessionHolder(StatelessSession session) {
        return new FixedStatelessSessionHolder(session);
    }

    public static SessionHolder noSessionHolder() {
        return NoSessionHolder.DEFAULT;
    }

    private static final class FixedDefaultSessionHolder
    implements SessionHolder {
        private final Session session;

        public FixedDefaultSessionHolder(Session session) {
            this.session = session;
        }

        public Query<?> createQuery(String queryString) {
            LOGGER.info("Query String: {}", new Object[]{queryString});
            return this.session.createQuery(queryString, Object.class);
        }

        public NativeQuery<?> createSQLQuery(String queryString) {
            return this.session.createNativeQuery(queryString, Object.class);
        }
    }

    private static final class FixedStatelessSessionHolder
    implements SessionHolder {
        private final StatelessSession session;

        public FixedStatelessSessionHolder(StatelessSession session) {
            this.session = session;
        }

        public Query<?> createQuery(String queryString) {
            return this.session.createQuery(queryString, Object.class);
        }

        public NativeQuery<?> createSQLQuery(String queryString) {
            return this.session.createNativeQuery(queryString, Object.class);
        }
    }
}

