/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.helper;

import java.util.List;
import org.squashtest.tm.exception.OptionAlreadyExistException;
import org.squashtest.tm.exception.WrongStringSizeException;
import org.squashtest.tm.exception.customfield.StringDoesNotMatchesPatternException;

public final class EntityOptionHelper {
    private EntityOptionHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static void checkCodePattern(String code, String codeRegexp, int minCodeSize, int maxCodeSize) {
        if (!code.matches(codeRegexp)) {
            throw new StringDoesNotMatchesPatternException(code, codeRegexp, "optionCode");
        }
        if (code.length() > maxCodeSize || code.length() < minCodeSize) {
            throw new WrongStringSizeException("code", minCodeSize, maxCodeSize);
        }
    }

    public static void checkLabelAvailability(String label, List<String> optionLabels, String entityType) {
        if (label.length() > 255 || label.length() < 1) {
            throw new WrongStringSizeException("label", 1, 255);
        }
        if (!EntityOptionHelper.isLabelAvailable(label, optionLabels)) {
            throw new OptionAlreadyExistException(label, entityType);
        }
    }

    private static boolean isLabelAvailable(String newLabel, List<String> optionLabels) {
        return !optionLabels.contains(newLabel);
    }

    public static boolean isCodeAvailable(String code, List<String> optionCodes) {
        return !optionCodes.contains(code);
    }
}

