/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.gridconfiguration;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotNull;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.gridconfiguration.GridColumnDisplayReference;

@Entity
@Table(name="GRID_COLUMN_DISPLAY_CONFIGURATION")
public class GridColumnDisplayConfiguration
implements Identified {
    public static final String CUF_COLUMN_PREFIX_FOR_CONFIGURATIONS = "cuf|";
    @Id
    @Column(name="GCDC_ID")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="grid_column_display_configuration_gcdc_id_seq")
    @SequenceGenerator(name="grid_column_display_configuration_gcdc_id_seq", sequenceName="grid_column_display_configuration_gcdc_id_seq", allocationSize=1)
    private Long id;
    @ManyToOne
    @JoinColumn(name="GCDR_ID", referencedColumnName="GCDR_ID")
    private GridColumnDisplayReference gridColumnDisplayReference;
    @NotNull
    @Column(name="ACTIVE_COLUMN_ID")
    private String activeColumnId;

    @Override
    public Long getId() {
        return this.id;
    }

    public GridColumnDisplayReference getGridColumnDisplayReference() {
        return this.gridColumnDisplayReference;
    }

    public void setGridColumnDisplayReference(GridColumnDisplayReference gridColumnDisplayReference) {
        this.gridColumnDisplayReference = gridColumnDisplayReference;
    }

    public String getActiveColumnId() {
        return this.activeColumnId;
    }

    public void setActiveColumnId(String activeColumnId) {
        this.activeColumnId = activeColumnId;
    }

    public static String getCufColumnNameFromCufId(Long id) {
        return CUF_COLUMN_PREFIX_FOR_CONFIGURATIONS + String.valueOf(id);
    }
}

