/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.execution;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.Lob;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import jakarta.persistence.Transient;
import jakarta.validation.constraints.NotNull;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.text.StringEscapeUtils;
import org.hibernate.annotations.Formula;
import org.hibernate.annotations.JdbcTypeCode;
import org.springframework.context.MessageSource;
import org.squashtest.tm.core.foundation.sanitizehtml.HTMLSanitizeUtils;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.attachment.Attachment;
import org.squashtest.tm.domain.attachment.AttachmentHolder;
import org.squashtest.tm.domain.attachment.AttachmentList;
import org.squashtest.tm.domain.audit.Auditable;
import org.squashtest.tm.domain.audit.BaseAuditableEntity;
import org.squashtest.tm.domain.bdd.Keyword;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.bugtracker.IssueDetector;
import org.squashtest.tm.domain.bugtracker.IssueList;
import org.squashtest.tm.domain.campaign.CampaignLibrary;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedFieldHolder;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedFieldHolderType;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.execution.ExecutionParameterInterpolator;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.library.HasExecutionStatus;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.testcase.ActionTestStep;
import org.squashtest.tm.domain.testcase.CallTestStep;
import org.squashtest.tm.domain.testcase.Dataset;
import org.squashtest.tm.domain.testcase.KeywordTestStep;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestStep;
import org.squashtest.tm.domain.testcase.TestStepVisitor;
import org.squashtest.tm.security.annotation.AclConstrainedObject;

@Entity
@Auditable
public class ExecutionStep
extends BaseAuditableEntity
implements AttachmentHolder,
IssueDetector,
TestStepVisitor,
Identified,
HasExecutionStatus,
DenormalizedFieldHolder,
BoundEntity {
    public static final Set<ExecutionStatus> LEGAL_EXEC_STATUS;
    private static final String KEYWORD_DOCSTRING_MARKER = "\"\"\"";
    private static final String KEYWORD_COMMENT_MARKER = "#";
    private static final String BR_TAG = "<br>";
    @Id
    @Column(name="EXECUTION_STEP_ID")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="execution_step_execution_step_id_seq")
    @SequenceGenerator(name="execution_step_execution_step_id_seq", sequenceName="execution_step_execution_step_id_seq", allocationSize=1)
    private Long id;
    @Lob
    @JdbcTypeCode(value=-1)
    @NotNull
    private String action = "";
    @Lob
    @JdbcTypeCode(value=-1)
    @NotNull
    private String expectedResult = "";
    @Enumerated(value=EnumType.STRING)
    private ExecutionStatus executionStatus = ExecutionStatus.READY;
    @Lob
    @JdbcTypeCode(value=-1)
    private String comment;
    @Column(insertable=false)
    private String lastExecutedBy;
    @Column(insertable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date lastExecutedOn;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="TEST_STEP_ID")
    private TestStep referencedTestStep;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinTable(name="EXECUTION_EXECUTION_STEPS", joinColumns={@JoinColumn(name="EXECUTION_STEP_ID", insertable=false, updatable=false)}, inverseJoinColumns={@JoinColumn(name="EXECUTION_ID", insertable=false, updatable=false)})
    private Execution execution;
    @Formula(value="(select EXECUTION_EXECUTION_STEPS.EXECUTION_STEP_ORDER from  EXECUTION_EXECUTION_STEPS where  EXECUTION_EXECUTION_STEPS.EXECUTION_STEP_ID = EXECUTION_STEP_ID)")
    private Integer executionStepOrder;
    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.DETACH, CascadeType.REMOVE})
    @JoinColumn(name="ATTACHMENT_LIST_ID")
    private final AttachmentList attachmentList = new AttachmentList();
    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.DETACH, CascadeType.REMOVE})
    @JoinColumn(name="ISSUE_LIST_ID")
    private IssueList issueList = new IssueList();
    @Transient
    private ExecutionParameterInterpolator.CollectedParameters collectedParameters = ExecutionParameterInterpolator.CollectedParameters.empty();
    @Transient
    private MessageSource messageSource;
    @Transient
    private Locale locale;

    static {
        HashSet<ExecutionStatus> set = new HashSet<ExecutionStatus>();
        set.add(ExecutionStatus.UNTESTABLE);
        set.add(ExecutionStatus.SUCCESS);
        set.add(ExecutionStatus.BLOCKED);
        set.add(ExecutionStatus.FAILURE);
        set.add(ExecutionStatus.READY);
        set.add(ExecutionStatus.SETTLED);
        set.add(ExecutionStatus.SKIPPED);
        set.add(ExecutionStatus.CANCELLED);
        LEGAL_EXEC_STATUS = Collections.unmodifiableSet(set);
    }

    public ExecutionStep() {
    }

    public ExecutionStep(ActionTestStep testStep) {
        this(testStep, null);
    }

    public ExecutionStep(ActionTestStep testStep, Dataset dataset) {
        this.referencedTestStep = testStep;
        this.fillParameterMapPrivately(dataset);
        testStep.accept(this);
        for (Attachment actionStepAttach : testStep.getAllAttachments()) {
            Attachment clone = actionStepAttach.shallowCopy();
            this.attachmentList.addAttachment(clone);
        }
    }

    public ExecutionStep(KeywordTestStep keywordTestStep) {
        this.action = keywordTestStep.getKeyword().toString() + " " + keywordTestStep.getActionWord().createWord();
        this.addKeywordStepDetails(keywordTestStep);
        this.referencedTestStep = keywordTestStep;
    }

    public ExecutionStep(KeywordTestStep keywordTestStep, Dataset dataset, MessageSource messageSource, Locale locale) {
        this.messageSource = messageSource;
        this.locale = locale;
        this.referencedTestStep = keywordTestStep;
        this.fillParameterMapPrivately(dataset);
        keywordTestStep.accept(this);
    }

    public void fillParameterMap(Dataset dataset) {
        this.fillParameterMapPrivately(dataset);
    }

    private void fillParameterMapPrivately(Dataset datasetParam) {
        if (datasetParam != null) {
            this.collectedParameters = ExecutionParameterInterpolator.collectParameters(datasetParam);
        }
    }

    public TestStep getReferencedTestStep() {
        return this.referencedTestStep;
    }

    public Execution getExecution() {
        return this.execution;
    }

    public void setExecution(Execution execution) {
        this.execution = execution;
    }

    public Integer getExecutionStepOrder() {
        return this.executionStepOrder;
    }

    public String getExpectedResult() {
        return this.expectedResult;
    }

    public void setExpectedResult(String expectedResult) {
        this.expectedResult = expectedResult;
    }

    @Override
    public ExecutionStatus getExecutionStatus() {
        return this.executionStatus;
    }

    @Override
    public Set<ExecutionStatus> getLegalStatusSet() {
        return LEGAL_EXEC_STATUS;
    }

    public void setExecutionStatus(ExecutionStatus executionStatus) {
        this.executionStatus = executionStatus;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getLastExecutedBy() {
        return this.lastExecutedBy;
    }

    public void setLastExecutedBy(String lastExecutedBy) {
        this.lastExecutedBy = lastExecutedBy;
    }

    public Date getLastExecutedOn() {
        return this.lastExecutedOn;
    }

    public void setLastExecutedOn(Date lastExecutedOn) {
        this.lastExecutedOn = lastExecutedOn;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getAction() {
        return this.action;
    }

    public boolean isFirst() {
        return this.executionStepOrder == 0;
    }

    @Override
    public AttachmentList getAttachmentList() {
        return this.attachmentList;
    }

    @Override
    public Long getAttachmentHolderProjectId() {
        return this.getProject().getId();
    }

    @Override
    public Long getIssueListId() {
        return this.issueList.getId();
    }

    @AclConstrainedObject
    public CampaignLibrary getCampaignLibrary() {
        return this.execution.getCampaignLibrary();
    }

    @Override
    public GenericProject getProject() {
        return this.execution.getProject();
    }

    @Override
    public IssueList getIssueList() {
        return this.issueList;
    }

    @Override
    public void detachIssue(Long id) {
        this.issueList.removeIssue(id);
    }

    @Override
    public void visit(ActionTestStep visited) {
        String originalAction = visited.getAction();
        String originalExpectedResult = visited.getExpectedResult();
        this.action = this.valueParams(originalAction);
        this.expectedResult = this.valueParams(originalExpectedResult);
    }

    private String valueParams(String content) {
        return ExecutionParameterInterpolator.replaceParams(content, this.referencedTestStep.getTestCase().getId(), this.collectedParameters);
    }

    private String keywordValueParams(String content) {
        return ExecutionParameterInterpolator.replaceKeywordParams(content, this.referencedTestStep.getTestCase().getId(), this.collectedParameters);
    }

    @Override
    public void visit(CallTestStep visited) {
        this.action = visited.getCalledTestCase().getName();
    }

    @Override
    public void visit(KeywordTestStep keywordStep) {
        boolean wrapParameterValuesWithDoubleQuotes = false;
        if (keywordStep.getTestCase() != null && keywordStep.getTestCase().getAutomatedTestTechnology() != null) {
            String automatedTestTechnology = keywordStep.getTestCase().getAutomatedTestTechnology().getName();
            wrapParameterValuesWithDoubleQuotes = "Cucumber 4".equals(automatedTestTechnology) || "Cucumber 5+".equals(automatedTestTechnology);
        }
        String awWordScript = keywordStep.writeTestStepActionWordScript(true, wrapParameterValuesWithDoubleQuotes);
        String unescapedAWWordScript = StringEscapeUtils.unescapeHtml4((String)awWordScript);
        String replacedParamValueWord = this.keywordValueParams(unescapedAWWordScript);
        Keyword keyword = keywordStep.getKeyword();
        if (this.messageSource != null && this.locale != null) {
            String internationalizedKeyword = this.messageSource.getMessage(keyword.i18nKeywordNameKey(), null, this.locale);
            this.action = internationalizedKeyword + " " + replacedParamValueWord;
        } else {
            this.action = keyword.getLabel() + " " + replacedParamValueWord;
        }
        this.addKeywordStepDetails(keywordStep);
    }

    private void addKeywordStepDetails(KeywordTestStep keywordStep) {
        this.addKeywordStepDatatable(keywordStep.getDatatable());
        this.addKeywordStepDocstring(keywordStep.getDocstring());
        this.addKeywordStepComment(keywordStep.getComment());
    }

    private void addKeywordStepDatatable(String keywordStepDatatable) {
        if (keywordStepDatatable != null && !keywordStepDatatable.isEmpty()) {
            String datatable = BR_TAG + this.plainTextToHtml(keywordStepDatatable);
            this.action = String.valueOf(this.action) + datatable;
        }
    }

    private void addKeywordStepDocstring(String keywordStepDocstring) {
        if (keywordStepDocstring != null && !keywordStepDocstring.isEmpty()) {
            String docstring = "<br>\"\"\"<br>" + this.plainTextToHtml(keywordStepDocstring);
            this.action = String.valueOf(this.action) + docstring + "<br>\"\"\"";
        }
    }

    private String plainTextToHtml(String text) {
        return HTMLSanitizeUtils.cleanHtml((String)text.replace("\n", BR_TAG));
    }

    private void addKeywordStepComment(String keywordStepComment) {
        if (keywordStepComment != null && !keywordStepComment.isEmpty()) {
            String formattedComment = "<br>#" + keywordStepComment.replace("\n", "<br>#");
            this.action = String.valueOf(this.action) + HTMLSanitizeUtils.cleanHtml((String)formattedComment);
        }
    }

    @Override
    public List<Long> getAllIssueListId() {
        LinkedList<Long> ids = new LinkedList<Long>();
        ids.add(this.issueList.getId());
        return ids;
    }

    @Override
    public TestCase getReferencedTestCase() {
        return this.execution.getReferencedTestCase();
    }

    @Override
    public BugTracker getBugTracker() {
        return this.getProject().findBugTracker();
    }

    @Override
    public Long getDenormalizedFieldHolderId() {
        return this.getId();
    }

    @Override
    public DenormalizedFieldHolderType getDenormalizedFieldHolderType() {
        return DenormalizedFieldHolderType.EXECUTION_STEP;
    }

    @Override
    public Long getBoundEntityId() {
        return this.getId();
    }

    @Override
    public BindableEntity getBoundEntityType() {
        return BindableEntity.EXECUTION_STEP;
    }

    @Override
    public EntityReference toEntityReference() {
        return new EntityReference(EntityType.EXECUTION_STEP, this.getId());
    }
}

