/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.execution;

import jakarta.validation.constraints.NotNull;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.squashtest.tm.aspect.validation.NotNullValidatorAspect;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.execution.ExecutionStep;

public class ExecutionStatusReport {
    private Map<ExecutionStatus, Integer> statusCount = new HashMap<ExecutionStatus, Integer>(ExecutionStatus.values().length);

    public ExecutionStatusReport() {
        for (ExecutionStatus status : ExecutionStep.LEGAL_EXEC_STATUS) {
            this.statusCount.put(status, 0);
        }
        this.statusCount.put(ExecutionStatus.RUNNING, 0);
    }

    int getTotal() {
        int total = 0;
        for (Integer partial : this.statusCount.values()) {
            total += partial.intValue();
        }
        return total;
    }

    public int get(@NotNull ExecutionStatus status) {
        ExecutionStatus executionStatus = status;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)executionStatus);
        return this.statusCount.get(status);
    }

    public void set(@NotNull ExecutionStatus status, int count) {
        ExecutionStatus executionStatus = status;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)executionStatus);
        this.statusCount.put(status, count);
    }

    public boolean has(@NotNull ExecutionStatus status) {
        ExecutionStatus executionStatus = status;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)executionStatus);
        return this.statusCount.get(status) > 0;
    }

    public boolean allOf(ExecutionStatus ... statuses) {
        ExecutionStatus[] executionStatusArray = statuses;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)executionStatusArray);
        HashSet<ExecutionStatus> uniqueStatuses = new HashSet<ExecutionStatus>(Arrays.asList(statuses));
        int expectedCount = 0;
        for (ExecutionStatus status : uniqueStatuses) {
            expectedCount += this.statusCount.get(status).intValue();
        }
        return expectedCount == this.getTotal();
    }

    public boolean anyOf(ExecutionStatus ... statuses) {
        ExecutionStatus[] executionStatusArray = statuses;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)executionStatusArray);
        boolean found = false;
        ExecutionStatus[] executionStatusArray2 = statuses;
        int n = statuses.length;
        int n2 = 0;
        while (n2 < n) {
            ExecutionStatus status = executionStatusArray2[n2];
            if (this.has(status)) {
                found = true;
                break;
            }
            ++n2;
        }
        return found;
    }
}

