/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.environmentvariable;

import jakarta.persistence.Column;
import jakarta.persistence.DiscriminatorColumn;
import jakarta.persistence.DiscriminatorType;
import jakarta.persistence.DiscriminatorValue;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.SequenceGenerator;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.environmentvariable.EVInputType;
import org.squashtest.tm.exception.environmentvariable.ValueDoesNotMatchesPatternException;

@Entity
@DiscriminatorColumn(name="FIELD_TYPE", discriminatorType=DiscriminatorType.STRING)
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@DiscriminatorValue(value="EV")
public class EnvironmentVariable
implements Identified {
    public static final String NAME_REGEXP = "^[A-Za-z0-9_]*$";
    @Id
    @Column(name="EV_ID")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="environment_variable_ev_id_seq")
    @SequenceGenerator(name="environment_variable_ev_id_seq", sequenceName="environment_variable_ev_id_seq", allocationSize=1)
    protected Long id;
    @NotBlank
    @Size(max=255)
    @Pattern(regexp="^[A-Za-z0-9_]*$", message="{org.squashtest.tm.validation.constraint.onlyStdChars}")
    protected @NotBlank @Size(max=255) @Pattern(regexp="^[A-Za-z0-9_]*$", message="{org.squashtest.tm.validation.constraint.onlyStdChars}") String name;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    @Column(updatable=false)
    protected EVInputType inputType = EVInputType.PLAIN_TEXT;

    public EnvironmentVariable() {
    }

    public EnvironmentVariable(String name, EVInputType inputType) {
        this.name = name;
        this.inputType = inputType;
    }

    public EnvironmentVariable(EVInputType inputType) {
        this.inputType = inputType;
    }

    public void checkValueMatchPattern(String value) {
        if (!value.matches(this.inputType.pattern)) {
            throw new ValueDoesNotMatchesPatternException(value, this.inputType, "value");
        }
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name.trim();
    }

    public EVInputType getInputType() {
        return this.inputType;
    }

    public void setInputType(EVInputType inputType) {
        this.inputType = inputType;
    }
}

