/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.denormalizedfield;

import jakarta.persistence.DiscriminatorValue;
import jakarta.persistence.Entity;
import jakarta.persistence.Lob;
import org.hibernate.annotations.JdbcTypeCode;
import org.squashtest.tm.domain.customfield.CustomField;
import org.squashtest.tm.domain.customfield.CustomFieldValue;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedFieldHolderType;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedFieldValue;

@Entity
@DiscriminatorValue(value="RTF")
public class DenormalizedRichValue
extends DenormalizedFieldValue {
    @Lob
    @JdbcTypeCode(value=-1)
    private String largeValue;

    public DenormalizedRichValue() {
    }

    public DenormalizedRichValue(CustomFieldValue customFieldValue, Long denormalizedFieldHolderId, DenormalizedFieldHolderType denormalizedFieldHolderType) {
        this.customFieldValue = customFieldValue;
        CustomField cuf = customFieldValue.getCustomField();
        this.code = cuf.getCode();
        this.inputType = cuf.getInputType();
        this.label = cuf.getLabel();
        this.value = null;
        this.largeValue = customFieldValue.getValue();
        this.position = customFieldValue.getBinding().getPosition();
        this.renderingLocations = customFieldValue.getBinding().copyRenderingLocations();
        this.denormalizedFieldHolderId = denormalizedFieldHolderId;
        this.denormalizedFieldHolderType = denormalizedFieldHolderType;
    }

    @Override
    public void setValue(String value) {
        this.largeValue = value;
    }

    @Override
    public String getValue() {
        return this.largeValue;
    }
}

