/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.customreport;

import jakarta.persistence.Column;
import jakarta.persistence.DiscriminatorType;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderColumn;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.annotations.Any;
import org.hibernate.annotations.AnyDiscriminator;
import org.hibernate.annotations.AnyDiscriminatorValue;
import org.hibernate.annotations.AnyDiscriminatorValues;
import org.hibernate.annotations.AnyKeyJavaClass;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.Referenceable;
import org.squashtest.tm.domain.chart.ChartDefinition;
import org.squashtest.tm.domain.customreport.CustomReportCustomExport;
import org.squashtest.tm.domain.customreport.CustomReportDashboard;
import org.squashtest.tm.domain.customreport.CustomReportFolder;
import org.squashtest.tm.domain.customreport.CustomReportLibrary;
import org.squashtest.tm.domain.customreport.CustomReportTreeDefinition;
import org.squashtest.tm.domain.customreport.CustomReportTreeEntity;
import org.squashtest.tm.domain.customreport.CustomReportTreeLibraryNode;
import org.squashtest.tm.domain.report.ReportDefinition;
import org.squashtest.tm.domain.tree.TreeLibraryNode;
import org.squashtest.tm.exception.DuplicateNameException;
import org.squashtest.tm.security.annotation.AclConstrainedObject;

@Entity
@Table(name="CUSTOM_REPORT_LIBRARY_NODE")
public class CustomReportLibraryNode
implements CustomReportTreeLibraryNode,
Referenceable {
    private static final String CRLN_ID = "CRLN_ID";
    @Id
    @Column(name="CRLN_ID")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="custom_report_library_node_crln_id_seq")
    @SequenceGenerator(name="custom_report_library_node_crln_id_seq", sequenceName="custom_report_library_node_crln_id_seq", allocationSize=1)
    private Long id;
    @Enumerated(value=EnumType.STRING)
    @Column(insertable=false, updatable=false, name="ENTITY_TYPE")
    private CustomReportTreeDefinition entityType;
    @Column(insertable=false, updatable=false, name="ENTITY_ID")
    private Long entityId;
    @Column
    @Size(max=255)
    private @Size(max=255) String name;
    @JoinTable(name="CRLN_RELATIONSHIP", joinColumns={@JoinColumn(name="DESCENDANT_ID", referencedColumnName="CRLN_ID", insertable=false, updatable=false)}, inverseJoinColumns={@JoinColumn(name="ANCESTOR_ID", referencedColumnName="CRLN_ID", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY, targetEntity=CustomReportLibraryNode.class)
    private CustomReportTreeLibraryNode parent;
    @JoinTable(name="CRLN_RELATIONSHIP", joinColumns={@JoinColumn(name="ANCESTOR_ID", referencedColumnName="CRLN_ID")}, inverseJoinColumns={@JoinColumn(name="DESCENDANT_ID", referencedColumnName="CRLN_ID")})
    @OneToMany(cascade={jakarta.persistence.CascadeType.ALL}, fetch=FetchType.LAZY, targetEntity=CustomReportLibraryNode.class)
    @OrderColumn(name="CONTENT_ORDER")
    private List<CustomReportTreeLibraryNode> children = new ArrayList<CustomReportTreeLibraryNode>();
    @Any(fetch=FetchType.LAZY)
    @AnyDiscriminator(value=DiscriminatorType.STRING)
    @AnyDiscriminatorValues(value={@AnyDiscriminatorValue(discriminator="REPORT", entity=ReportDefinition.class), @AnyDiscriminatorValue(discriminator="CHART", entity=ChartDefinition.class), @AnyDiscriminatorValue(discriminator="FOLDER", entity=CustomReportFolder.class), @AnyDiscriminatorValue(discriminator="LIBRARY", entity=CustomReportLibrary.class), @AnyDiscriminatorValue(discriminator="DASHBOARD", entity=CustomReportDashboard.class), @AnyDiscriminatorValue(discriminator="CUSTOM_EXPORT", entity=CustomReportCustomExport.class)})
    @AnyKeyJavaClass(value=Long.class)
    @Column(name="ENTITY_TYPE")
    @JoinColumn(name="ENTITY_ID")
    @Cascade(value={CascadeType.ALL})
    private CustomReportTreeEntity entity;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="CRL_ID")
    private CustomReportLibrary library;

    public CustomReportLibraryNode() {
    }

    public CustomReportLibraryNode(CustomReportTreeDefinition entityType, Long entityId, String name, CustomReportLibrary library) {
        this.entityType = entityType;
        this.entityId = entityId;
        this.name = name;
        this.library = library;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public CustomReportTreeLibraryNode getParent() {
        return this.parent;
    }

    @Override
    public void setParent(CustomReportTreeLibraryNode parent) {
        this.parent = parent;
    }

    @Override
    public List<CustomReportTreeLibraryNode> getChildren() {
        return this.children;
    }

    @Override
    public CustomReportLibrary getLibrary() {
        return this.library;
    }

    @AclConstrainedObject
    public CustomReportLibrary getCustomReportLibrary() {
        return this.library;
    }

    public void setLibrary(CustomReportLibrary library) {
        this.library = library;
    }

    @Override
    public long getEntityId() {
        return this.entityId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public CustomReportTreeDefinition getEntityType() {
        return this.entityType;
    }

    @Override
    public void setEntityType(CustomReportTreeDefinition entityType) {
        this.entityType = entityType;
    }

    @Override
    public CustomReportTreeEntity getEntity() {
        return this.entity;
    }

    @Override
    public void setEntity(CustomReportTreeEntity treeEntity) {
        this.entity = treeEntity;
    }

    @Override
    public void addChild(CustomReportTreeLibraryNode treeLibraryNode) {
        if (treeLibraryNode == null) {
            throw new IllegalArgumentException("Cannot add a null child to a library node");
        }
        if (treeLibraryNode.getEntity() == null) {
            throw new IllegalArgumentException("Cannot add a library node representing a null entity");
        }
        if (!this.getEntityType().isContainer()) {
            throw new UnsupportedOperationException("This type of library node doesn't accept childs");
        }
        treeLibraryNode.isCoherentWithEntity();
        String newChildName = treeLibraryNode.getName();
        if (this.childNameAlreadyUsed(newChildName)) {
            CustomReportTreeLibraryNode node = this.getContentNodeByName(newChildName);
            throw new DuplicateNameException(node.getEntityType().getTypeName(), newChildName);
        }
        this.getChildren().add(treeLibraryNode);
    }

    @Override
    public void isCoherentWithEntity() {
        String entityName;
        String nodeName = this.getName();
        if (!nodeName.equals(entityName = this.getEntity().getName())) {
            String message = "Cannot add a library node of with name %s to represent an entity with diffrent name %s";
            throw new IllegalArgumentException(String.format(message, nodeName, entityName));
        }
    }

    @Override
    public boolean childNameAlreadyUsed(String newChildName) {
        for (TreeLibraryNode treeLibraryNode : this.children) {
            if (!treeLibraryNode.getName().equals(newChildName)) continue;
            return true;
        }
        return false;
    }

    private CustomReportTreeLibraryNode getContentNodeByName(String name) {
        for (CustomReportTreeLibraryNode child : this.children) {
            if (!child.getName().equals(name)) continue;
            return child;
        }
        return null;
    }

    @Override
    public void removeChild(CustomReportTreeLibraryNode treeLibraryNode) {
        this.children.remove(treeLibraryNode);
        this.children = new ArrayList<CustomReportTreeLibraryNode>(this.children);
    }

    @Override
    public boolean hasContent() {
        if (!this.getEntityType().isContainer()) {
            return false;
        }
        return !this.children.isEmpty();
    }

    @Override
    public void renameNode(String newName) {
        if (this.getEntityType().equals(CustomReportTreeDefinition.LIBRARY)) {
            throw new IllegalArgumentException("Cannot rename a library, rename the project instead");
        }
        if (this.nameAlreadyUsedBySibling(newName)) {
            throw new DuplicateNameException(newName, this.getEntityType().getTypeName());
        }
        this.setName(newName);
        this.getEntity().setName(newName);
    }

    @Override
    public EntityReference toEntityReference() {
        EntityType type = this.entityType.asNodeType().toEntityType();
        return new EntityReference(type, this.getEntityId());
    }

    private boolean nameAlreadyUsedBySibling(String newName) {
        List<String> siblingsNames = this.getSiblingsNames();
        return siblingsNames.contains(newName);
    }

    private List<String> getSiblingsNames() {
        List<CustomReportTreeLibraryNode> siblings = this.getSiblings();
        ArrayList<String> siblingNames = new ArrayList<String>();
        for (TreeLibraryNode treeLibraryNode : siblings) {
            siblingNames.add(treeLibraryNode.getName());
        }
        return siblingNames;
    }

    private List<CustomReportTreeLibraryNode> getSiblings() {
        CustomReportTreeLibraryNode parentNode = this.getParent();
        return parentNode.getChildren();
    }
}

