/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.customfield;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Hibernate;
import org.hibernate.proxy.HibernateProxy;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.customfield.CustomFieldValue;
import org.squashtest.tm.domain.customfield.MultiValuedCustomFieldValue;
import org.squashtest.tm.domain.customfield.SingleValuedCustomFieldValue;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedFieldValue;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedFieldVisitor;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedMultiSelectField;

public class RawValue
implements DenormalizedFieldVisitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RawValue.class);
    private String value;
    private List<String> values;

    public RawValue() {
    }

    public RawValue(String value) {
        this.value = value;
    }

    public RawValue(List<String> values) {
        this.values = values;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public List<String> getValues() {
        return this.values;
    }

    public void setValues(List<String> values) {
        this.values = values;
    }

    public void setValueFor(CustomFieldValue field) {
        CustomFieldValue unproxiedField = this.initializeAndUnproxy(field);
        if (MultiValuedCustomFieldValue.class.isAssignableFrom(unproxiedField.getClass())) {
            this.setValueFor((MultiValuedCustomFieldValue)((Object)unproxiedField));
        } else if (SingleValuedCustomFieldValue.class.isAssignableFrom(unproxiedField.getClass())) {
            this.setValueFor((SingleValuedCustomFieldValue)unproxiedField);
        } else {
            this.logError(field);
        }
    }

    public void setValueFor(DenormalizedFieldValue field) {
        field.accept(this);
    }

    public void setValueFor(SingleValuedCustomFieldValue field) {
        field.setValue(this.value);
    }

    public void setValueFor(MultiValuedCustomFieldValue field) {
        field.setValues(this.values);
    }

    public boolean isEmpty() {
        boolean isEmpty = false;
        if (this.value == null && (this.values == null || this.values.isEmpty())) {
            isEmpty = true;
        } else if (this.value != null && StringUtils.isBlank((CharSequence)this.value)) {
            isEmpty = true;
        } else if (this.values != null && this.values.isEmpty()) {
            isEmpty = true;
        }
        return isEmpty;
    }

    private void logError(CustomFieldValue field) {
        if (!LOGGER.isErrorEnabled()) {
            return;
        }
        String debugvalue = "<null>";
        if (this.value != null) {
            debugvalue = this.value;
        } else if (this.values != null) {
            StringBuilder builder = new StringBuilder();
            for (String v : this.values) {
                builder.append(v).append(", ");
            }
            debugvalue = builder.toString();
        }
        LOGGER.error("could not set custom field {} (type {}) with value {}. Does this custom field implement either SingleValuedCustomField or MultiValuedCustomField?", new Object[]{field.getCustomField().getCode(), field.getCustomField().getInputType(), debugvalue});
    }

    @Override
    public void visit(DenormalizedFieldValue standardValue) {
        standardValue.setValue(this.value);
    }

    @Override
    public void visit(DenormalizedMultiSelectField multiselect) {
        multiselect.setValues(this.values);
    }

    private <T> T initializeAndUnproxy(T entity) {
        if (entity == null) {
            throw new NullPointerException("Entity passed for initialization is null");
        }
        Hibernate.initialize(entity);
        if (entity instanceof HibernateProxy) {
            entity = ((HibernateProxy)entity).getHibernateLazyInitializer().getImplementation();
        }
        return entity;
    }
}

