/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.customfield;

import jakarta.validation.constraints.NotNull;
import org.squashtest.tm.aspect.validation.NotNullValidatorAspect;
import org.squashtest.tm.core.foundation.i18n.Internationalizable;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.campaign.CampaignFolder;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.Sprint;
import org.squashtest.tm.domain.campaign.SprintGroup;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.customfield.RenderingLocation;
import org.squashtest.tm.domain.customreport.CustomReportFolder;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.execution.ExecutionStep;
import org.squashtest.tm.domain.requirement.RequirementFolder;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.domain.testcase.ActionTestStep;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseFolder;

public enum BindableEntity implements Internationalizable
{
    REQUIREMENT_FOLDER{

        @Override
        public Class<?> getReferencedClass() {
            return RequirementFolder.class;
        }

        @Override
        public RenderingLocation[] getValidRenderingLocations() {
            return new RenderingLocation[0];
        }
    }
    ,
    CAMPAIGN_FOLDER{

        @Override
        public Class<?> getReferencedClass() {
            return CampaignFolder.class;
        }

        @Override
        public RenderingLocation[] getValidRenderingLocations() {
            return new RenderingLocation[0];
        }
    }
    ,
    TESTCASE_FOLDER{

        @Override
        public Class<?> getReferencedClass() {
            return TestCaseFolder.class;
        }

        @Override
        public RenderingLocation[] getValidRenderingLocations() {
            return new RenderingLocation[0];
        }
    }
    ,
    CUSTOM_REPORT_FOLDER{

        @Override
        public Class<?> getReferencedClass() {
            return CustomReportFolder.class;
        }

        @Override
        public RenderingLocation[] getValidRenderingLocations() {
            return new RenderingLocation[0];
        }
    }
    ,
    TEST_CASE{

        @Override
        public Class<?> getReferencedClass() {
            return TestCase.class;
        }

        @Override
        public RenderingLocation[] getValidRenderingLocations() {
            return new RenderingLocation[0];
        }
    }
    ,
    TEST_STEP{

        @Override
        public Class<?> getReferencedClass() {
            return ActionTestStep.class;
        }

        @Override
        public RenderingLocation[] getValidRenderingLocations() {
            return new RenderingLocation[]{RenderingLocation.STEP_TABLE};
        }
    }
    ,
    CAMPAIGN{

        @Override
        public Class<?> getReferencedClass() {
            return Campaign.class;
        }

        @Override
        public RenderingLocation[] getValidRenderingLocations() {
            return new RenderingLocation[0];
        }
    }
    ,
    ITERATION{

        @Override
        public Class<?> getReferencedClass() {
            return Iteration.class;
        }

        @Override
        public RenderingLocation[] getValidRenderingLocations() {
            return new RenderingLocation[0];
        }
    }
    ,
    TEST_SUITE{

        @Override
        public Class<?> getReferencedClass() {
            return TestSuite.class;
        }

        @Override
        public RenderingLocation[] getValidRenderingLocations() {
            return new RenderingLocation[0];
        }
    }
    ,
    SPRINT{

        @Override
        public Class<?> getReferencedClass() {
            return Sprint.class;
        }

        @Override
        public RenderingLocation[] getValidRenderingLocations() {
            return new RenderingLocation[0];
        }
    }
    ,
    SPRINT_GROUP{

        @Override
        public Class<?> getReferencedClass() {
            return SprintGroup.class;
        }

        @Override
        public RenderingLocation[] getValidRenderingLocations() {
            return new RenderingLocation[0];
        }
    }
    ,
    REQUIREMENT_VERSION{

        @Override
        public Class<?> getReferencedClass() {
            return RequirementVersion.class;
        }

        @Override
        public RenderingLocation[] getValidRenderingLocations() {
            return new RenderingLocation[0];
        }
    }
    ,
    EXECUTION{

        @Override
        public Class<?> getReferencedClass() {
            return Execution.class;
        }

        @Override
        public RenderingLocation[] getValidRenderingLocations() {
            return new RenderingLocation[0];
        }
    }
    ,
    EXECUTION_STEP{

        @Override
        public Class<?> getReferencedClass() {
            return ExecutionStep.class;
        }

        @Override
        public RenderingLocation[] getValidRenderingLocations() {
            return new RenderingLocation[]{RenderingLocation.STEP_TABLE};
        }
    };

    private static final String I18N_NAMESPACE = "label.customField.bindableEntity.";

    public String getI18nKey() {
        return I18N_NAMESPACE + this.name();
    }

    public abstract Class<?> getReferencedClass();

    public abstract RenderingLocation[] getValidRenderingLocations();

    public static BindableEntity coerceToBindableEntity(@NotNull Class<?> entityType) {
        Class<?> clazz = entityType;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289(clazz);
        BindableEntity[] bindableEntityArray = BindableEntity.values();
        int n = bindableEntityArray.length;
        int n2 = 0;
        while (n2 < n) {
            BindableEntity be = bindableEntityArray[n2];
            if (be.getReferencedClass().isAssignableFrom(entityType)) {
                return be;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Type cannot be coerced to a BindableEntity : " + entityType.getName());
    }
}

