/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.chart;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ChartSeries {
    private List<Object[]> abscissa;
    private List<String> colours = new ArrayList<String>();
    private LinkedHashMap<String, List<Object>> series = new LinkedHashMap();

    public void setAbscissa(List<Object[]> abscissa) {
        this.abscissa = abscissa;
    }

    public void addSerie(String name, List<Object> serie) {
        this.series.put(name, serie);
    }

    public List<Object[]> getSerie(String name) {
        return this.makeSerie(this.series.get(name));
    }

    public List<Object[]> getSerie(int serieIndex) {
        List<Object> serie = null;
        int i = 0;
        for (List<Object> s : this.series.values()) {
            if (i == serieIndex) {
                serie = s;
                break;
            }
            ++i;
        }
        if (serie != null) {
            return this.makeSerie(serie);
        }
        throw new IllegalArgumentException("no serie at index '" + serieIndex + "'");
    }

    private List<Object[]> makeSerie(List<Object> serie) {
        ArrayList<Object[]> result = new ArrayList<Object[]>(this.abscissa.size());
        Iterator<Object[]> absIter = this.abscissa.iterator();
        Iterator<Object> serIter = serie.iterator();
        while (absIter.hasNext()) {
            Object[] abs = absIter.next();
            Object ser = serIter.next();
            Object[] merge = new Object[abs.length + 1];
            System.arraycopy(abs, 0, merge, 0, abs.length);
            merge[abs.length] = ser;
            result.add(merge);
        }
        return result;
    }

    public Map<String, List<Object>> getSeries() {
        return this.series;
    }

    public void setSeries(Map<String, List<Object>> series) {
        this.series = (LinkedHashMap)series;
    }

    public List<Object[]> getAbscissa() {
        return this.abscissa;
    }

    public List<String> getColours() {
        return this.colours;
    }

    public void setColours(List<String> colours) {
        this.colours = colours;
    }
}

