/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.campaign.testplan;

import jakarta.annotation.Nullable;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.OrderBy;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.squashtest.tm.aspect.validation.NotNullValidatorAspect;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.audit.Auditable;
import org.squashtest.tm.domain.audit.BaseAuditableEntity;
import org.squashtest.tm.domain.campaign.CampaignLibrary;
import org.squashtest.tm.domain.campaign.ExploratorySessionOverview;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.campaign.testplan.TestPlan;
import org.squashtest.tm.domain.common.ordered.Ordered;
import org.squashtest.tm.domain.common.ordered.OrderedListHelper;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.testautomation.FailureDetail;
import org.squashtest.tm.domain.testcase.ConsumerForExploratoryTestCaseVisitor;
import org.squashtest.tm.domain.testcase.Dataset;
import org.squashtest.tm.domain.testcase.ExploratoryTestCase;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseExecutionMode;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.security.annotation.AclConstrainedObject;

@Entity
@Auditable
public class TestPlanItem
extends BaseAuditableEntity
implements Identified,
Ordered {
    @Id
    @Column(name="TEST_PLAN_ITEM_ID")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="test_plan_item_test_plan_item_id_seq")
    @SequenceGenerator(name="test_plan_item_test_plan_item_id_seq", sequenceName="test_plan_item_test_plan_item_id_seq", allocationSize=1)
    private Long id;
    @Column(name="ITEM_ORDER")
    private Integer itemOrder;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="TEST_PLAN_ID")
    private TestPlan testPlan;
    @Enumerated(value=EnumType.STRING)
    private ExecutionStatus executionStatus = ExecutionStatus.READY;
    private String label = "";
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ASSIGNEE_ID")
    private User assignee;
    @Column(insertable=false)
    private String lastExecutedBy;
    @Column(insertable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date lastExecutedOn;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="TCLN_ID", referencedColumnName="TCLN_ID")
    private TestCase referencedTestCase;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="DATASET_ID", referencedColumnName="DATASET_ID")
    private Dataset referencedDataset;
    @OneToMany(mappedBy="testPlanItem", cascade={CascadeType.ALL}, orphanRemoval=true)
    @OrderBy(value="executionOrder")
    private final Set<Execution> executions = new LinkedHashSet<Execution>();
    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="OVERVIEW_ID", referencedColumnName="OVERVIEW_ID")
    private ExploratorySessionOverview exploratorySessionOverview;
    @ManyToMany(cascade={CascadeType.PERSIST, CascadeType.MERGE}, mappedBy="testPlanItems")
    private List<TestSuite> testSuites = new ArrayList<TestSuite>();
    @OneToMany(mappedBy="testPlanItem", cascade={CascadeType.PERSIST, CascadeType.REMOVE})
    private List<FailureDetail> failureDetailList = new ArrayList<FailureDetail>();

    public TestPlanItem(TestPlan testPlan, TestCase referencedTestCase) {
        this(testPlan, referencedTestCase, null);
    }

    public TestPlanItem(TestPlan testPlan, TestCase referencedTestCase, Dataset referencedDataset) {
        this.testPlan = testPlan;
        this.referencedTestCase = referencedTestCase;
        this.label = referencedTestCase.getName();
        this.referencedDataset = referencedDataset;
        referencedTestCase.accept(new ConsumerForExploratoryTestCaseVisitor(exploratoryTestCase -> {
            ExploratorySessionOverview exploratorySessionOverview = this.exploratorySessionOverview = new ExploratorySessionOverview((ExploratoryTestCase)exploratoryTestCase, this);
        }));
    }

    protected TestPlanItem() {
    }

    public static TestPlanItem createItemWithoutTestCase(TestPlan testPlan, String label) {
        TestPlanItem item = new TestPlanItem();
        item.testPlan = testPlan;
        item.label = label;
        return item;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @AclConstrainedObject
    public CampaignLibrary getCampaignLibrary() {
        return this.testPlan.getCampaignLibrary();
    }

    public TestPlan getTestPlan() {
        return this.testPlan;
    }

    public String getLabel() {
        return this.label;
    }

    public void setAssignee(User assignee) {
        this.assignee = assignee;
    }

    public TestCase getReferencedTestCase() {
        return this.referencedTestCase;
    }

    public void setReferencedTestCase(TestCase referencedTestCase) {
        this.referencedTestCase = referencedTestCase;
    }

    public Dataset getReferencedDataset() {
        return this.referencedDataset;
    }

    public void setReferencedDataset(@Nullable Dataset dataset) {
        if (dataset == null) {
            this.referencedDataset = null;
        } else {
            long datasetTestCaseId;
            long referencedTestCaseId = this.referencedTestCase.getId();
            if (referencedTestCaseId != (datasetTestCaseId = dataset.getTestCase().getId().longValue())) {
                throw new IllegalArgumentException("Dataset #" + String.valueOf(dataset.getId()) + " doesn't belong to test case #" + referencedTestCaseId);
            }
            this.referencedDataset = dataset;
        }
    }

    public Set<Execution> getExecutions() {
        return this.executions;
    }

    public void addExecution(Execution executionToAdd) {
        this.addExecution(executionToAdd, null);
    }

    public void addExecution(Execution executionToAdd, Integer position) {
        boolean isNotExploratory;
        executionToAdd.setTestPlanItem(this);
        ArrayList<Execution> executionList = new ArrayList<Execution>(this.executions);
        new OrderedListHelper<Execution>(executionList).addContent(executionToAdd, position);
        this.executions.clear();
        this.executions.addAll(executionList);
        boolean bl = isNotExploratory = !TestCaseExecutionMode.EXPLORATORY.equals(executionToAdd.getExecutionMode());
        if (isNotExploratory) {
            this.updateLatestExecutionFields();
            this.updateIterationAutoDates();
        }
    }

    public void addNewExecution(Execution execution) {
        boolean isNotExploratory;
        execution.setTestPlanItem(this);
        boolean bl = isNotExploratory = !TestCaseExecutionMode.EXPLORATORY.equals(execution.getExecutionMode());
        if (isNotExploratory) {
            this.lastExecutedBy = execution.getLastExecutedBy();
            this.lastExecutedOn = execution.getLastExecutedOn();
            this.executionStatus = execution.getExecutionStatus();
        }
    }

    public void removeExecutionsById(List<Long> executionIds) {
        boolean deletingLatestExecution = executionIds.contains(this.getLatestExecution().getId());
        this.executions.removeIf(execution -> executionIds.contains(execution.getId()));
        if (deletingLatestExecution) {
            this.updateLatestExecutionFields();
            Iteration parentIteration = this.testPlan.getParentIteration();
            if (parentIteration != null) {
                parentIteration.updateAutoDatesAfterExecutionDetach(this);
            }
        }
    }

    public void reorderExecutions() {
        ArrayList<Execution> executionList = new ArrayList<Execution>(this.executions);
        new OrderedListHelper<Execution>(executionList).reorder();
        this.executions.clear();
        this.executions.addAll(executionList);
    }

    private void updateLatestExecutionFields() {
        Execution latestExecution = this.getLatestExecution();
        if (latestExecution == null) {
            this.lastExecutedBy = null;
            this.lastExecutedOn = null;
            this.executionStatus = ExecutionStatus.READY;
        } else {
            this.lastExecutedBy = latestExecution.getLastExecutedBy();
            this.lastExecutedOn = latestExecution.getLastExecutedOn();
            this.executionStatus = latestExecution.getExecutionStatus();
        }
    }

    public void setExploratorySessionOverview(ExploratorySessionOverview exploratorySessionOverview) {
        this.exploratorySessionOverview = exploratorySessionOverview;
    }

    @Override
    public void setOrder(Integer order) {
        this.itemOrder = order;
    }

    public boolean isTestCaseDeleted() {
        return this.referencedTestCase == null;
    }

    public GenericProject getProject() {
        return this.testPlan.getProject();
    }

    public void autoUpdateExecutionStatus() {
        Execution latestExecution = this.getLatestExecution();
        this.executionStatus = latestExecution == null ? ExecutionStatus.READY : latestExecution.getExecutionStatus();
    }

    public void updateLastExecutionAndAssignee(Date lastExecutedOn, User lastExecutedBy) {
        this.lastExecutedBy = lastExecutedBy == null ? null : lastExecutedBy.getLogin();
        this.lastExecutedOn = lastExecutedOn;
        this.assignee = lastExecutedBy;
        this.updateIterationAutoDates();
    }

    public void updateLastExecution(Date lastExecutedOn, String lastExecutedBy) {
        this.lastExecutedBy = lastExecutedBy;
        this.lastExecutedOn = lastExecutedOn;
        this.updateIterationAutoDates();
    }

    public void applyFastPass(ExecutionStatus status, User user) {
        this.executionStatus = status;
        this.lastExecutedBy = user.getLogin();
        this.lastExecutedOn = new Date();
        this.assignee = user;
        this.updateIterationAutoDates();
    }

    public Execution getLatestExecution() {
        return this.executions.isEmpty() ? null : (Execution)this.executions.stream().reduce((first, second) -> second).orElse(null);
    }

    public String getLastExecutedBy() {
        return this.lastExecutedBy;
    }

    public Date getLastExecutedOn() {
        return this.lastExecutedOn;
    }

    public ExecutionStatus getExecutionStatus() {
        return this.executionStatus;
    }

    public List<TestSuite> getTestSuites() {
        return this.testSuites;
    }

    public void addTestSuite(@NotNull TestSuite suite) {
        TestSuite testSuite = suite;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)testSuite);
        this.checkIsSameTestPlan(suite, suite.getIteration().getTestPlan());
        this.testSuites.add(suite);
        suite.bindTestPlanItem(this);
    }

    public void addTestSuite(@NotNull TestSuite suite, @NotNull Iteration suiteIteration) {
        Iteration iteration = suiteIteration;
        TestSuite testSuite = suite;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)testSuite);
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$2$7531eba5((Object)iteration);
        this.checkIsSameTestPlan(suite, suiteIteration.getTestPlan());
        this.testSuites.add(suite);
    }

    private void checkIsSameTestPlan(@NotNull TestSuite suiteToAdd, @NotNull TestPlan suiteToAddTestPlan) {
        TestPlan testPlan = suiteToAddTestPlan;
        TestSuite testSuite = suiteToAdd;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)testSuite);
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$2$7531eba5((Object)testPlan);
        if (!this.testPlan.equalsById(suiteToAddTestPlan)) {
            throw new IllegalArgumentException("The test suite with name '%s' does not belong to the test plan with ID '%d'. It cannot be added.".formatted(suiteToAdd.getName(), this.testPlan.getId()));
        }
    }

    public User getAssignee() {
        return this.assignee;
    }

    public boolean isAssignedToUser(String login) {
        return this.assignee != null && this.assignee.getLogin().equals(login);
    }

    public boolean isExecutableThroughTestSuite() {
        if (this.executions.isEmpty()) {
            return !this.isTestCaseDeleted();
        }
        return this.isLatestExecutionStillRunning();
    }

    private boolean isLatestExecutionStillRunning() {
        return this.getLatestExecution().hasUnexecutedSteps();
    }

    public boolean equalsById(TestPlanItem other) {
        if (this.equals(other)) {
            return true;
        }
        if (this.id != null && other.getId() != null) {
            return this.id.equals(other.getId());
        }
        return false;
    }

    public TestPlanItem createCopy(TestPlan testPlan) {
        TestPlanItem copy = new TestPlanItem();
        copy.testPlan = testPlan;
        copy.executionStatus = ExecutionStatus.READY;
        copy.label = this.label;
        copy.assignee = this.assignee;
        copy.referencedTestCase = this.referencedTestCase;
        copy.referencedDataset = this.referencedDataset;
        copy.itemOrder = this.itemOrder;
        if (this.exploratorySessionOverview != null) {
            copy.exploratorySessionOverview = this.exploratorySessionOverview.createCopy();
            copy.exploratorySessionOverview.setTestPlanItem(copy);
        }
        return copy;
    }

    private void updateIterationAutoDates() {
        Iteration parentIteration = this.getParentIteration();
        if (parentIteration != null) {
            parentIteration.updateAutoDates(this.lastExecutedOn);
        }
    }

    public Iteration getParentIteration() {
        return this.testPlan.getParentIteration();
    }

    public boolean isAutomated() {
        if (this.referencedTestCase == null) {
            return false;
        }
        return this.referencedTestCase.isAutomated() && this.referencedTestCase.getProject() != null && this.referencedTestCase.getProject().isTestAutomationEnabled();
    }

    public void notifyAutomatedExecutionAddition(Execution execution) {
        boolean isNotExploratory;
        boolean bl = isNotExploratory = !TestCaseExecutionMode.EXPLORATORY.equals(execution.getExecutionMode());
        if (isNotExploratory) {
            this.executionStatus = execution.getExecutionStatus();
        }
        this.lastExecutedBy = null;
        this.lastExecutedOn = null;
        this.updateIterationAutoDates();
    }

    public List<FailureDetail> getFailureDetailList() {
        return this.failureDetailList;
    }

    public ExploratorySessionOverview getExploratorySessionOverview() {
        return this.exploratorySessionOverview;
    }

    public TestCaseExecutionMode getExecutionMode() {
        Execution latest = this.getLatestExecution();
        return latest == null ? TestCaseExecutionMode.UNDEFINED : latest.getExecutionMode();
    }
}

