/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.campaign;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.Lob;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedEntityGraph;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.OrderColumn;
import jakarta.persistence.SequenceGenerator;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.hibernate.annotations.JdbcTypeCode;
import org.squashtest.tm.aspect.validation.NotNullValidatorAspect;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.attachment.Attachment;
import org.squashtest.tm.domain.attachment.AttachmentHolder;
import org.squashtest.tm.domain.attachment.AttachmentList;
import org.squashtest.tm.domain.audit.Auditable;
import org.squashtest.tm.domain.audit.BaseAuditableEntity;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.TestPlanOwner;
import org.squashtest.tm.domain.campaign.testplan.TestPlanItem;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.library.Copiable;
import org.squashtest.tm.domain.library.HasExecutionStatus;
import org.squashtest.tm.domain.library.NodeVisitor;
import org.squashtest.tm.domain.library.TreeNode;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.milestone.MilestoneMember;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.testautomation.AutomatedSuite;
import org.squashtest.tm.exception.DuplicateNameException;
import org.squashtest.tm.exception.execution.EmptyTestSuiteTestPlanException;
import org.squashtest.tm.exception.execution.TestPlanItemNotExecutableException;
import org.squashtest.tm.security.annotation.InheritsAcls;

@Auditable
@Entity
@InheritsAcls(constrainedClass=Iteration.class, collectionName="testSuites")
@NamedEntityGraph(name="TestSuite.allProperties", includeAllAttributes=true)
public class TestSuite
extends BaseAuditableEntity
implements Identified,
Copiable,
TreeNode,
BoundEntity,
AttachmentHolder,
MilestoneMember,
HasExecutionStatus,
TestPlanOwner {
    public static final String SIMPLE_CLASS_NAME = "org.squashtest.tm.domain.campaign.TestSuite";
    static final Set<ExecutionStatus> LEGAL_EXEC_STATUS;
    @Id
    @Column(name="ID")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="test_suite_id_seq")
    @SequenceGenerator(name="test_suite_id_seq", sequenceName="test_suite_id_seq", allocationSize=1)
    private Long id;
    @NotNull
    @Column(name="UUID")
    @Pattern(regexp="[0-9a-fA-F]{8}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{12}")
    private @NotNull @Pattern(regexp="[0-9a-fA-F]{8}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{12}") String uuid;
    @NotBlank
    @Size(max=255)
    private @NotBlank @Size(max=255) String name;
    @Lob
    @JdbcTypeCode(value=-1)
    private String description;
    @Enumerated(value=EnumType.STRING)
    private ExecutionStatus executionStatus = ExecutionStatus.READY;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinTable(name="ITERATION_TEST_SUITE", joinColumns={@JoinColumn(name="TEST_SUITE_ID", updatable=false, insertable=false)}, inverseJoinColumns={@JoinColumn(name="ITERATION_ID", updatable=false, insertable=false)})
    private Iteration iteration;
    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.DETACH, CascadeType.REMOVE})
    @JoinColumn(name="ATTACHMENT_LIST_ID")
    private final AttachmentList attachmentList = new AttachmentList();
    @ManyToMany(cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @OrderColumn(name="TEST_PLAN_ORDER")
    @JoinTable(name="TEST_SUITE_TEST_PLAN_ITEM", inverseJoinColumns={@JoinColumn(name="TPI_ID", referencedColumnName="TEST_PLAN_ITEM_ID")}, joinColumns={@JoinColumn(name="SUITE_ID", referencedColumnName="ID")})
    private List<TestPlanItem> testPlanItems = new LinkedList<TestPlanItem>();
    @OneToMany(mappedBy="testSuite", cascade={CascadeType.REMOVE})
    private List<AutomatedSuite> automatedSuites = new ArrayList<AutomatedSuite>();

    static {
        HashSet<ExecutionStatus> set = new HashSet<ExecutionStatus>();
        set.add(ExecutionStatus.SUCCESS);
        set.add(ExecutionStatus.BLOCKED);
        set.add(ExecutionStatus.FAILURE);
        set.add(ExecutionStatus.RUNNING);
        set.add(ExecutionStatus.READY);
        set.add(ExecutionStatus.UNTESTABLE);
        set.add(ExecutionStatus.SETTLED);
        set.add(ExecutionStatus.SKIPPED);
        set.add(ExecutionStatus.CANCELLED);
        LEGAL_EXEC_STATUS = Collections.unmodifiableSet(set);
    }

    public TestSuite() {
        UUID newUUID = UUID.randomUUID();
        this.uuid = newUUID.toString();
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name.trim();
    }

    public void rename(String newName) {
        String trimedName = newName.trim();
        if (!this.iteration.checkSuiteNameAvailable(trimedName)) {
            throw new DuplicateNameException("Cannot rename suite %s : new name %s already exists in iteration %s".formatted(this.name, trimedName, this.iteration.getName()));
        }
        this.name = trimedName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public ExecutionStatus getExecutionStatus() {
        return this.executionStatus;
    }

    public void setExecutionStatus(ExecutionStatus executionStatus) {
        this.executionStatus = executionStatus;
    }

    @Override
    public Set<ExecutionStatus> getLegalStatusSet() {
        return LEGAL_EXEC_STATUS;
    }

    void setIteration(@NotNull Iteration iteration) {
        Iteration iteration2 = iteration;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)iteration2);
        this.iteration = iteration;
    }

    public Iteration getIteration() {
        return this.iteration;
    }

    @Override
    public AttachmentList getAttachmentList() {
        return this.attachmentList;
    }

    @Override
    public Long getAttachmentHolderProjectId() {
        return this.getProject().getId();
    }

    public TestPlanItem getFirstTestPlanItem(String testerLogin) {
        for (TestPlanItem item : this.testPlanItems) {
            if (testerLogin != null && !item.isAssignedToUser(testerLogin)) continue;
            return item;
        }
        throw new EmptyTestSuiteTestPlanException(this);
    }

    public void bindTestPlanItems(List<TestPlanItem> items) {
        for (TestPlanItem item : items) {
            this.bindTestPlanItem(item);
        }
    }

    public void bindTestPlanItems(List<TestPlanItem> items, Iteration suiteIteration) {
        items.forEach(item -> {
            if (!this.isBoundToThisSuite((TestPlanItem)item)) {
                this.testPlanItems.add((TestPlanItem)item);
                item.addTestSuite(this, suiteIteration);
            }
        });
    }

    public void bindTestPlanItem(TestPlanItem item) {
        if (!this.isBoundToThisSuite(item)) {
            this.testPlanItems.add(item);
            item.addTestSuite(this);
        }
    }

    public void unBindTestPlan(List<TestPlanItem> items) {
        for (TestPlanItem item : items) {
            this.unBindTestPlan(item);
        }
    }

    public void unBindTestPlan(TestPlanItem item) {
        if (this.isBoundToThisSuite(item)) {
            this.testPlanItems.remove(item);
            item.getTestSuites().remove(this);
        }
    }

    public void bindTestPlanItemsById(List<Long> itemIds) {
        for (Long itemId : itemIds) {
            for (TestPlanItem item : this.iteration.getTestPlan().getTestPlanItems()) {
                if (!item.getId().equals(itemId)) continue;
                this.bindTestPlanItem(item);
            }
        }
    }

    public void reorderTestPlan(int newIndex, List<TestPlanItem> movedItems) {
        if (!this.testPlanItems.isEmpty()) {
            this.testPlanItems.removeAll(movedItems);
            this.testPlanItems.addAll(newIndex, movedItems);
        }
    }

    @Override
    public TestSuite createCopy() {
        TestSuite testSuiteCopy = new TestSuite();
        testSuiteCopy.setName(this.getName());
        testSuiteCopy.setDescription(this.getDescription());
        for (Attachment attach : this.getAttachmentList().getAllAttachments()) {
            Attachment copyAttach = attach.shallowCopy();
            testSuiteCopy.getAttachmentList().addAttachment(copyAttach);
        }
        return testSuiteCopy;
    }

    public boolean isFirstExecutableTestPlanItem(long itemId) {
        for (TestPlanItem item : this.testPlanItems) {
            if (item.isTestCaseDeleted()) continue;
            return itemId == item.getId();
        }
        return false;
    }

    @Override
    public TestPlanItem findNextExecutableTestPlanItem(long testPlanItemId) {
        return this.findNextExecutableTestPlanItem(testPlanItemId, null);
    }

    @Override
    public TestPlanItem findNextExecutableTestPlanItem(long testPlanItemId, String testerLogin) {
        List<TestPlanItem> remaining = this.getRemainingPlanById(testPlanItemId);
        for (TestPlanItem item : remaining) {
            if (testerLogin != null && !item.isAssignedToUser(testerLogin) || !item.isExecutableThroughTestSuite()) continue;
            return item;
        }
        throw new TestPlanItemNotExecutableException("No more executable item in this suite's test plan");
    }

    @Override
    public TestPlanItem findFirstExecutableTestPlanItem(String testerLogin) {
        TestPlanItem firstTestPlanItem = this.getFirstTestPlanItem(testerLogin);
        if (firstTestPlanItem.isExecutableThroughTestSuite()) {
            return firstTestPlanItem;
        }
        return this.findNextExecutableTestPlanItem(firstTestPlanItem.getId(), testerLogin);
    }

    private List<TestPlanItem> getRemainingPlanById(long testPlanItemId) {
        List<TestPlanItem> items = this.getTestPlanItems();
        int i = 0;
        while (i < items.size()) {
            if (testPlanItemId == items.get(i).getId()) {
                return items.subList(i + 1, items.size());
            }
            ++i;
        }
        throw new IllegalArgumentException("Item[%d] does not belong to test plan of TestSuite[%d]".formatted(testPlanItemId, this.id));
    }

    @Override
    public Long getBoundEntityId() {
        return this.getId();
    }

    @Override
    public BindableEntity getBoundEntityType() {
        return BindableEntity.TEST_SUITE;
    }

    @Override
    public Project getProject() {
        if (this.iteration != null) {
            return this.iteration.getProject();
        }
        return null;
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Set<Milestone> getMilestones() {
        return this.getIteration().getMilestones();
    }

    @Override
    public boolean isMemberOf(Milestone milestone) {
        return this.getIteration().isMemberOf(milestone);
    }

    @Override
    public Boolean doMilestonesAllowCreation() {
        return this.getMilestones().stream().allMatch(m -> m.getStatus().isAllowObjectCreateAndDelete());
    }

    @Override
    public Boolean doMilestonesAllowEdition() {
        return this.getMilestones().stream().allMatch(m -> m.getStatus().isAllowObjectModification());
    }

    public String getUuid() {
        return this.uuid;
    }

    @Deprecated
    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public List<AutomatedSuite> getAutomatedSuites() {
        return this.automatedSuites;
    }

    @Override
    public EntityReference toEntityReference() {
        return new EntityReference(EntityType.TEST_SUITE, this.id);
    }

    private boolean isBoundToThisSuite(TestPlanItem item) {
        for (TestPlanItem testPlanItem : this.testPlanItems) {
            if (!testPlanItem.equalsById(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<TestPlanItem> getTestPlanItems() {
        return this.testPlanItems;
    }
}

