/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.campaign;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.net.URL;
import java.util.Date;
import org.squashtest.tm.domain.campaign.SprintReqVersion;
import org.squashtest.tm.domain.requirement.RemoteRequirementPerimeterStatus;
import org.squashtest.tm.domain.synchronisation.RemoteSynchronisation;

@Entity
public class SprintRequirementSyncExtender {
    @Id
    @Column(name="SPRINT_REQ_SYNC_ID")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="sprint_requirement_sync_extender_sprint_req_sync_id_seq")
    @SequenceGenerator(name="sprint_requirement_sync_extender_sprint_req_sync_id_seq", sequenceName="sprint_requirement_sync_extender_sprint_req_sync_id_seq", allocationSize=1)
    private Long id;
    @OneToOne
    @JoinColumn(name="SPRINT_REQ_VERSION_ID", referencedColumnName="SPRINT_REQ_VERSION_ID")
    private SprintReqVersion sprintReqVersion;
    @Column
    private String remoteReqId;
    @Column
    private String remoteProjectId;
    @Column(name="REMOTE_REQ_URL")
    private URL remoteReqUrl;
    @Column(name="REMOTE_LAST_UPDATED")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date remoteLastUpdated;
    @ManyToOne
    @JoinColumn(name="REMOTE_SYNCHRONISATION_ID")
    private RemoteSynchronisation remoteSynchronisation;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    @Column(name="REMOTE_PERIMETER_STATUS")
    private RemoteRequirementPerimeterStatus remotePerimeterStatus = RemoteRequirementPerimeterStatus.UNKNOWN;
    @Column
    @Size(max=20)
    private @Size(max=20) String remoteReqState;

    public SprintReqVersion getSprintReqVersion() {
        return this.sprintReqVersion;
    }

    public void setSprintReqVersion(SprintReqVersion sprintReqVersion) {
        this.sprintReqVersion = sprintReqVersion;
    }

    public String getRemoteReqId() {
        return this.remoteReqId;
    }

    public void setRemoteReqId(String remoteReqId) {
        this.remoteReqId = remoteReqId;
    }

    public String getRemoteProjectId() {
        return this.remoteProjectId;
    }

    public void setRemoteProjectId(String remoteProjectId) {
        this.remoteProjectId = remoteProjectId;
    }

    public URL getRemoteReqUrl() {
        return this.remoteReqUrl;
    }

    public void setRemoteReqUrl(URL remoteUrl) {
        this.remoteReqUrl = remoteUrl;
    }

    public Date getRemoteLastUpdated() {
        return this.remoteLastUpdated;
    }

    public void setRemoteLastUpdated(Date remoteLastUpdated) {
        this.remoteLastUpdated = remoteLastUpdated;
    }

    public RemoteSynchronisation getRemoteSynchronisation() {
        return this.remoteSynchronisation;
    }

    public void setRemoteSynchronisation(RemoteSynchronisation remoteSynchronisation) {
        this.remoteSynchronisation = remoteSynchronisation;
    }

    public RemoteRequirementPerimeterStatus getRemotePerimeterStatus() {
        return this.remotePerimeterStatus;
    }

    public void setRemotePerimeterStatus(RemoteRequirementPerimeterStatus remotePerimeterStatus) {
        this.remotePerimeterStatus = remotePerimeterStatus;
    }

    public String getRemoteReqState() {
        return this.remoteReqState;
    }

    public void setRemoteReqState(String remoteReqState) {
        this.remoteReqState = remoteReqState;
    }
}

