/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.campaign;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.OrderBy;
import jakarta.persistence.PrimaryKeyJoinColumn;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.attachment.Attachment;
import org.squashtest.tm.domain.campaign.CampaignLibraryNode;
import org.squashtest.tm.domain.campaign.CampaignLibraryNodeVisitor;
import org.squashtest.tm.domain.campaign.SprintReqVersion;
import org.squashtest.tm.domain.campaign.SprintStatus;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.library.NodeVisitor;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.synchronisation.RemoteSynchronisation;
import org.squashtest.tm.exception.campaign.SprintNotLinkableException;

@Entity
@PrimaryKeyJoinColumn(name="CLN_ID")
public class Sprint
extends CampaignLibraryNode
implements BoundEntity {
    public static final String SIMPLE_CLASS_NAME = "org.squashtest.tm.domain.campaign.Sprint";
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="REMOTE_SYNCHRONISATION_ID")
    private RemoteSynchronisation remoteSynchronisation;
    @Column(name="REMOTE_SPRINT_ID")
    private Long remoteSprintId;
    @Column(name="REMOTE_NAME")
    private String remoteName;
    @Column(name="REMOTE_STATE")
    private String remoteState;
    @Column(name="START_DATE")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date startDate;
    @Column(name="END_DATE")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date endDate;
    @Size(max=50)
    @Column(name="REFERENCE")
    private @Size(max=50) String reference;
    @NotNull
    @Column(name="STATUS")
    @Enumerated(value=EnumType.STRING)
    private SprintStatus status = SprintStatus.UPCOMING;
    @OrderBy
    @OneToMany(mappedBy="sprint", cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    private List<SprintReqVersion> sprintReqVersions = new ArrayList<SprintReqVersion>();

    @Override
    public void accept(CampaignLibraryNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public EntityReference toEntityReference() {
        return new EntityReference(EntityType.SPRINT, this.getId());
    }

    @Override
    public Sprint createCopy() {
        Sprint copy = new Sprint();
        copy.notifyAssociatedWithProject((Project)this.getProject());
        copy.setName(this.getName());
        copy.setDescription(this.getDescription());
        copy.setReference(this.getReference());
        copy.setStatus(SprintStatus.UPCOMING);
        copy.setStartDate(this.getStartDate());
        copy.setEndDate(this.getEndDate());
        for (Attachment attach : this.getAttachmentList().getAllAttachments()) {
            Attachment copyAttach = attach.shallowCopy();
            copy.getAttachmentList().addAttachment(copyAttach);
        }
        copy.setSprintReqVersions(this.sprintReqVersions.stream().map(sprintReqVersion -> sprintReqVersion.createCopy(copy)).toList());
        return copy;
    }

    @Override
    public Long getBoundEntityId() {
        return this.getId();
    }

    @Override
    public BindableEntity getBoundEntityType() {
        return BindableEntity.SPRINT;
    }

    public RemoteSynchronisation getRemoteSynchronisation() {
        return this.remoteSynchronisation;
    }

    public void setRemoteSynchronisation(RemoteSynchronisation remoteSynchronisation) {
        this.remoteSynchronisation = remoteSynchronisation;
    }

    public String getReference() {
        return this.reference;
    }

    public String getRemoteName() {
        return this.remoteName;
    }

    public void setRemoteName(String remoteName) {
        this.remoteName = remoteName;
    }

    public String getRemoteState() {
        return this.remoteState;
    }

    public void setRemoteState(String remoteState) {
        this.remoteState = remoteState;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public Long getRemoteSprintId() {
        return this.remoteSprintId;
    }

    public void setRemoteSprintId(Long remoteSprintId) {
        this.remoteSprintId = remoteSprintId;
    }

    public SprintStatus getStatus() {
        return this.status;
    }

    public void setStatus(SprintStatus status) {
        this.status = status;
    }

    public List<SprintReqVersion> getSprintReqVersions() {
        return this.sprintReqVersions;
    }

    public void setSprintReqVersions(List<SprintReqVersion> sprintReqVersions) {
        this.sprintReqVersions = sprintReqVersions;
    }

    public void checkLinkable() {
        if (this.status == SprintStatus.CLOSED) {
            throw new SprintNotLinkableException();
        }
    }

    @Override
    public boolean allowIdenticalName() {
        return true;
    }

    public void migrateTestPlans() {
        this.sprintReqVersions.forEach(SprintReqVersion::migrateTestPlan);
    }

    public boolean isSynchronized() {
        return Objects.nonNull(this.remoteSynchronisation);
    }
}

