/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.campaign;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotNull;
import java.util.Collections;
import java.util.List;
import org.squashtest.tm.aspect.validation.NotNullValidatorAspect;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.RelatedToAuditable;
import org.squashtest.tm.domain.audit.AuditableMixin;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.testcase.Dataset;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.security.annotation.InheritsAcls;

@Entity
@Table(name="CAMPAIGN_TEST_PLAN_ITEM")
@InheritsAcls(constrainedClass=Campaign.class, collectionName="testPlan")
public class CampaignTestPlanItem
implements Identified,
RelatedToAuditable {
    @ManyToOne
    @JoinColumn(name="USER_ID")
    private User user;
    @Id
    @Column(name="CTPI_ID")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="campaign_test_plan_item_ctpi_id_seq")
    @SequenceGenerator(name="campaign_test_plan_item_ctpi_id_seq", sequenceName="campaign_test_plan_item_ctpi_id_seq", allocationSize=1)
    private Long id;
    @ManyToOne
    @JoinColumn(name="TEST_CASE_ID")
    private TestCase referencedTestCase;
    @ManyToOne
    @JoinColumn(name="DATASET_ID", referencedColumnName="DATASET_ID")
    private Dataset referencedDataset;
    @ManyToOne
    @JoinColumn(name="CAMPAIGN_ID", insertable=false, updatable=false)
    private Campaign campaign;

    public CampaignTestPlanItem() {
    }

    public CampaignTestPlanItem(TestCase testCase) {
        this.referencedTestCase = testCase;
    }

    public CampaignTestPlanItem(TestCase testCase, Dataset dataset) {
        this.referencedTestCase = testCase;
        this.referencedDataset = dataset;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public TestCase getReferencedTestCase() {
        return this.referencedTestCase;
    }

    public void setReferencedTestCase(TestCase referencedTestCase) {
        this.referencedTestCase = referencedTestCase;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public User getUser() {
        return this.user;
    }

    public CampaignTestPlanItem createCampaignlessCopy() {
        CampaignTestPlanItem copy = new CampaignTestPlanItem();
        copy.setUser(this.getUser());
        copy.setReferencedTestCase(this.getReferencedTestCase());
        copy.setReferencedDataset(this.getReferencedDataset());
        return copy;
    }

    public Project getProject() {
        return this.campaign.getProject();
    }

    public Campaign getCampaign() {
        return this.campaign;
    }

    public Dataset getReferencedDataset() {
        return this.referencedDataset;
    }

    public void setReferencedDataset(Dataset referencedDataset) {
        this.referencedDataset = referencedDataset;
    }

    protected void setCampaign(@NotNull Campaign campaign) {
        Campaign campaign2 = campaign;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)campaign2);
        this.campaign = campaign;
    }

    @Override
    public List<AuditableMixin> getAssociatedAuditableList() {
        return Collections.singletonList(this.campaign);
    }

    public boolean isTestCaseDeleted() {
        return this.getReferencedTestCase() == null;
    }
}

