/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.bugtracker;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import org.squashtest.tm.domain.common.ordered.Ordered;
import org.squashtest.tm.domain.project.GenericProject;

@Entity
public class BugtrackerProject
implements Ordered {
    @Id
    @Column(name="BUGTRACKER_PROJECT_ID")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="bugtracker_project_bugtracker_project_id_seq")
    @SequenceGenerator(name="bugtracker_project_bugtracker_project_id_seq", sequenceName="bugtracker_project_bugtracker_project_id_seq", allocationSize=1)
    private Long id;
    @NotNull
    @Size(max=255)
    private @NotNull @Size(max=255) String bugtrackerProjectName;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="PROJECT_ID", nullable=false)
    private GenericProject project;
    @Column(name="BUGTRACKER_PROJECT_ORDER")
    private int order;

    public BugtrackerProject(String bugtrackerProjectName, GenericProject project) {
        this.bugtrackerProjectName = bugtrackerProjectName;
        this.project = project;
    }

    public BugtrackerProject() {
    }

    public BugtrackerProject(String bugtrackerProjectName, GenericProject project, int order) {
        this.bugtrackerProjectName = bugtrackerProjectName;
        this.project = project;
        this.order = order;
    }

    public Long getId() {
        return this.id;
    }

    public String getBugtrackerProjectName() {
        return this.bugtrackerProjectName;
    }

    public void setBugtrackerProjectName(String bugtrackerProjectName) {
        this.bugtrackerProjectName = bugtrackerProjectName;
    }

    public GenericProject getProject() {
        return this.project;
    }

    public void setProject(GenericProject project) {
        this.project = project;
    }

    public int getOrder() {
        return this.order;
    }

    @Override
    public void setOrder(Integer newOrder) {
        this.order = newOrder;
    }
}

