/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.acl;

import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Lob;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import org.hibernate.annotations.JdbcTypeCode;
import org.squashtest.tm.aspect.validation.NotNullValidatorAspect;
import org.squashtest.tm.core.foundation.sanitizehtml.HTMLSanitizeUtils;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.audit.Auditable;
import org.squashtest.tm.domain.audit.BaseAuditableEntity;

@Entity
@Table(name="ACL_GROUP")
@Auditable
public class AclGroup
extends BaseAuditableEntity
implements Identified {
    private static final String SYSTEM_PROFILE_START = "squashtest.acl.group.tm.";
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="acl_group_id_seq")
    @SequenceGenerator(name="acl_group_id_seq", sequenceName="acl_group_id_seq", allocationSize=1)
    private long id;
    @Size(max=50)
    @NotNull
    private @Size(max=50) @NotNull String qualifiedName;
    private boolean active = true;
    @Lob
    @JdbcTypeCode(value=-1)
    private String description = "";
    private transient String simpleName;

    public AclGroup(long id, String qualifiedName) {
        this.id = id;
        this.qualifiedName = qualifiedName;
        if (qualifiedName != null) {
            this.calculateSimpleName();
        }
    }

    public AclGroup(String qualifiedName, String description) {
        this(0L, qualifiedName);
        this.description = description;
    }

    public AclGroup() {
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public void setQualifiedName(String qualifiedName) {
        this.checkAndForbidOperationForDefaultSystemProfile();
        this.qualifiedName = qualifiedName;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public String getSimpleName() {
        if (this.simpleName == null && this.qualifiedName != null) {
            this.calculateSimpleName();
        }
        return this.simpleName;
    }

    private void calculateSimpleName() {
        this.simpleName = this.qualifiedName.substring(this.qualifiedName.lastIndexOf(46) + 1);
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public String getDescription() {
        return HTMLSanitizeUtils.cleanHtml((String)this.description);
    }

    public void setDescription(@NotNull String description) {
        String string = description;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)string);
        this.checkAndForbidOperationForDefaultSystemProfile();
        this.description = HTMLSanitizeUtils.cleanHtml((String)description);
    }

    public boolean isSystem() {
        return AclGroup.isSystem(this.qualifiedName);
    }

    public static boolean isSystem(String qualifiedName) {
        return qualifiedName.startsWith(SYSTEM_PROFILE_START);
    }

    public void checkAndForbidOperationForDefaultSystemProfile() {
        AclGroup.checkAndForbidOperationForDefaultSystemProfile(this.qualifiedName);
    }

    public static void checkAndForbidOperationForDefaultSystemProfile(String qualifiedName) {
        if (AclGroup.isSystem(qualifiedName)) {
            throw new UnsupportedOperationException("This operation is not allowed for the default system profile.");
        }
    }
}

