/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.squashtest.tm.core.foundation.lang.Assert;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.NodeType;

public class NodeReference {
    private NodeType nodeType;
    private Long id;

    public NodeReference(NodeType nodeType, Long entityId) {
        this.nodeType = nodeType;
        this.id = entityId;
        Assert.parameterNotNull((Object)((Object)nodeType), (String)"nodeType");
        Assert.parameterNotNull((Object)entityId, (String)"entityId");
    }

    public NodeType getNodeType() {
        return this.nodeType;
    }

    public Long getId() {
        return this.id;
    }

    public String toString() {
        return "[" + this.nodeType.toString() + ":" + String.valueOf(this.id) + "]";
    }

    public String toNodeId() {
        return this.nodeType.getTypeName() + "-" + String.valueOf(this.id);
    }

    public static List<String> toNodeIds(Collection<NodeReference> nodeReferences) {
        return nodeReferences.stream().map(NodeReference::toNodeId).toList();
    }

    public static Set<NodeReference> fromNodeIds(Collection<String> ids) {
        return ids.stream().map(NodeReference::fromNodeId).collect(Collectors.toSet());
    }

    public static NodeReference fromNodeId(String asString) throws IllegalArgumentException {
        if (StringUtils.isBlank((CharSequence)asString)) {
            throw new IllegalArgumentException("Entity reference id as String should not be blank");
        }
        Pattern p = Pattern.compile("(.+)-(\\d+)");
        Matcher m = p.matcher(asString);
        if (m.matches()) {
            String type = m.group(1).replace("-", "");
            Long id = Long.valueOf(m.group(2));
            NodeType etype = NodeType.fromTypeName(type);
            return new NodeReference(etype, id);
        }
        throw new IllegalArgumentException("The string " + asString + " has not the correct format. Provide something like NodeType-NodeId. ex: TestCaseLibrary-1");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeReference that = (NodeReference)o;
        return this.nodeType == that.nodeType && this.id.equals(that.id);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.nodeType, this.id});
    }

    public EntityReference toEntityReference() {
        return new EntityReference(this.nodeType.toEntityType(), this.id);
    }
}

