/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain;

import java.util.EnumSet;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.squashtest.tm.domain.actionword.ActionWordLibrary;
import org.squashtest.tm.domain.attachment.Attachment;
import org.squashtest.tm.domain.attachment.AttachmentList;
import org.squashtest.tm.domain.bdd.ActionWord;
import org.squashtest.tm.domain.bugtracker.Issue;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.campaign.CampaignFolder;
import org.squashtest.tm.domain.campaign.CampaignLibrary;
import org.squashtest.tm.domain.campaign.ExploratorySessionOverview;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.Sprint;
import org.squashtest.tm.domain.campaign.SprintGroup;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.campaign.testplan.TestPlanItem;
import org.squashtest.tm.domain.chart.ChartDefinition;
import org.squashtest.tm.domain.customreport.CustomReportCustomExport;
import org.squashtest.tm.domain.customreport.CustomReportDashboard;
import org.squashtest.tm.domain.customreport.CustomReportFolder;
import org.squashtest.tm.domain.customreport.CustomReportLibrary;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.execution.ExecutionStep;
import org.squashtest.tm.domain.execution.SessionNote;
import org.squashtest.tm.domain.infolist.InfoListItem;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.project.ProjectTemplate;
import org.squashtest.tm.domain.report.ReportDefinition;
import org.squashtest.tm.domain.requirement.HighLevelRequirement;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementFolder;
import org.squashtest.tm.domain.requirement.RequirementLibrary;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.domain.scm.ScmRepository;
import org.squashtest.tm.domain.testautomation.AutomatedExecutionExtender;
import org.squashtest.tm.domain.testautomation.AutomatedSuite;
import org.squashtest.tm.domain.testautomation.AutomatedTest;
import org.squashtest.tm.domain.testcase.ActionTestStep;
import org.squashtest.tm.domain.testcase.Dataset;
import org.squashtest.tm.domain.testcase.Parameter;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseFolder;
import org.squashtest.tm.domain.testcase.TestCaseLibrary;
import org.squashtest.tm.domain.testcase.TestStep;
import org.squashtest.tm.domain.tf.automationrequest.AutomationRequest;
import org.squashtest.tm.domain.users.User;

public enum EntityType {
    ACTION_TEST_STEP(ActionTestStep.class),
    ACTION_WORD(ActionWord.class),
    ACTION_WORD_LIBRARY(ActionWordLibrary.class),
    ATTACHMENT(Attachment.class),
    ATTACHMENT_LIST(AttachmentList.class),
    AUTOMATED_EXECUTION_EXTENDER(AutomatedExecutionExtender.class),
    AUTOMATED_SUITE(AutomatedSuite.class),
    AUTOMATED_TEST(AutomatedTest.class),
    AUTOMATION_REQUEST(AutomationRequest.class),
    CAMPAIGN(Campaign.class),
    CAMPAIGN_FOLDER(CampaignFolder.class),
    CAMPAIGN_LIBRARY(CampaignLibrary.class),
    CHART_DEFINITION(ChartDefinition.class),
    CUSTOM_REPORT_CUSTOM_EXPORT(CustomReportCustomExport.class),
    CUSTOM_REPORT_DASHBOARD(CustomReportDashboard.class),
    CUSTOM_REPORT_FOLDER(CustomReportFolder.class),
    CUSTOM_REPORT_LIBRARY(CustomReportLibrary.class),
    DATASET(Dataset.class),
    EXECUTION(Execution.class),
    EXECUTION_STEP(ExecutionStep.class),
    EXPLORATORY_SESSION_OVERVIEW(ExploratorySessionOverview.class),
    HIGH_LEVEL_REQUIREMENT(HighLevelRequirement.class),
    INFO_LIST_ITEM(InfoListItem.class),
    ISSUE(Issue.class),
    ITEM_TEST_PLAN(TestPlanItem.class),
    ITERATION(Iteration.class),
    MILESTONE(Milestone.class),
    PARAMETER(Parameter.class),
    PROJECT(Project.class),
    PROJECT_TEMPLATE(ProjectTemplate.class),
    REPORT_DEFINITION(ReportDefinition.class),
    REQUIREMENT(Requirement.class),
    REQUIREMENT_FOLDER(RequirementFolder.class),
    REQUIREMENT_LIBRARY(RequirementLibrary.class),
    REQUIREMENT_VERSION(RequirementVersion.class),
    SCM_REPOSITORY(ScmRepository.class),
    SESSION_NOTE(SessionNote.class),
    SPRINT(Sprint.class),
    SPRINT_GROUP(SprintGroup.class),
    TEST_CASE(TestCase.class),
    TEST_CASE_FOLDER(TestCaseFolder.class),
    TEST_CASE_LIBRARY(TestCaseLibrary.class),
    TEST_CASE_STEP(TestStep.class),
    TEST_STEP(TestStep.class),
    TEST_SUITE(TestSuite.class),
    USER(User.class);

    private Class<?> clazz;

    private EntityType(Class<?> clazz) {
        this.clazz = clazz;
    }

    public Class<?> getEntityClass() {
        return this.clazz;
    }

    public String getSimpleClassName() {
        return this.clazz.getSimpleName();
    }

    public static EntityType fromSimpleName(String simpleClassName) {
        if (StringUtils.isBlank((CharSequence)simpleClassName)) {
            throw new IllegalArgumentException("Simple Name can't be empty");
        }
        EnumSet<EntityType> entityTypes = EnumSet.allOf(EntityType.class);
        Optional<EntityType> type = entityTypes.stream().filter(entityType -> entityType.getSimpleClassName().equals(simpleClassName)).findFirst();
        if (type.isPresent()) {
            return type.get();
        }
        throw new IllegalArgumentException("No Entity Type for simple class name : " + simpleClassName);
    }
}

