ace.define("ace/keyboard/vim",["require","exports","module","ace/range","ace/lib/event_emitter","ace/lib/dom","ace/lib/oop","ace/lib/keys","ace/lib/event","ace/search","ace/lib/useragent","ace/search_highlight","ace/commands/multi_select_commands","ace/mode/text","ace/multi_select"],(function(e,t,r){"use strict";function n(){var e="";function t(e){if(typeof e!="object")return e+"";if("line"in e){return e.line+":"+e.ch}if("anchor"in e){return t(e.anchor)+"->"+t(e.head)}if(Array.isArray(e))return"["+e.map((function(e){return t(e)}))+"]";return JSON.stringify(e)}for(var r=0;r<arguments.length;r++){var n=arguments[r];var i=t(n);e+=i+"  "}console.log(e)}var i=e("../range").Range;var a=e("../lib/event_emitter").EventEmitter;var o=e("../lib/dom");var s=e("../lib/oop");var l=e("../lib/keys");var c=e("../lib/event");var u=e("../search").Search;var f=e("../lib/useragent");var h=e("../search_highlight").SearchHighlight;var p=e("../commands/multi_select_commands");var d=e("../mode/text").Mode.prototype.tokenRe;e("../multi_select");var v=function(e){this.ace=e;this.state={};this.marks={};this.$uid=0;this.onChange=this.onChange.bind(this);this.onSelectionChange=this.onSelectionChange.bind(this);this.onBeforeEndOperation=this.onBeforeEndOperation.bind(this);this.ace.on("change",this.onChange);this.ace.on("changeSelection",this.onSelectionChange);this.ace.on("beforeEndOperation",this.onBeforeEndOperation)};v.Pos=function(e,t){if(!(this instanceof x))return new x(e,t);this.line=e;this.ch=t};v.defineOption=function(e,t,r){};v.commands={redo:function(e){e.ace.redo()},undo:function(e){e.ace.undo()},newlineAndIndent:function(e){e.ace.insert("\n")}};v.keyMap={};v.addClass=v.rmClass=function(){};v.e_stop=v.e_preventDefault=c.stopEvent;v.keyName=function(e){var t=l[e.keyCode]||e.key||"";if(t.length==1)t=t.toUpperCase();t=c.getModifierString(e).replace(/(^|-)\w/g,(function(e){return e.toUpperCase()}))+t;return t};v.keyMap["default"]=function(e){return function(t){var r=t.ace.commands.commandKeyBinding[e.toLowerCase()];return r&&t.ace.execCommand(r)!==false}};v.lookupKey=function e(t,r,n){if(!r)r="default";if(typeof r=="string")r=v.keyMap[r];var i=typeof r=="function"?r(t):r[t];if(i===false)return"nothing";if(i==="...")return"multi";if(i!=null&&n(i))return"handled";if(r.fallthrough){if(!Array.isArray(r.fallthrough))return e(t,r.fallthrough,n);for(var a=0;a<r.fallthrough.length;a++){var o=e(t,r.fallthrough[a],n);if(o)return o}}};v.signal=function(e,t,r){return e._signal(t,r)};v.on=c.addListener;v.off=c.removeListener;v.isWordChar=function(e){if(e<"")return/^\w$/.test(e);d.lastIndex=0;return d.test(e)};(function(){s.implement(v.prototype,a);this.destroy=function(){this.ace.off("change",this.onChange);this.ace.off("changeSelection",this.onSelectionChange);this.ace.off("beforeEndOperation",this.onBeforeEndOperation);this.removeOverlay()};this.virtualSelectionMode=function(){return this.ace.inVirtualSelectionMode&&this.ace.selection.index};this.onChange=function(e){var t={text:e.action[0]=="i"?e.lines:[]};var r=this.curOp=this.curOp||{};if(!r.changeHandlers)r.changeHandlers=this._eventRegistry["change"]&&this._eventRegistry["change"].slice();if(!r.lastChange){r.lastChange=r.change=t}else{r.lastChange.next=r.lastChange=t}this.$updateMarkers(e)};this.onSelectionChange=function(){var e=this.curOp=this.curOp||{};if(!e.cursorActivityHandlers)e.cursorActivityHandlers=this._eventRegistry["cursorActivity"]&&this._eventRegistry["cursorActivity"].slice();this.curOp.cursorActivity=true;if(this.ace.inMultiSelectMode){this.ace.keyBinding.removeKeyboardHandler(p.keyboardHandler)}};this.operation=function(e,t){if(!t&&this.curOp||t&&this.curOp&&this.curOp.force){return e()}if(t||!this.ace.curOp){if(this.curOp)this.onBeforeEndOperation()}if(!this.ace.curOp){var r=this.ace.prevOp;this.ace.startOperation({command:{name:"vim",scrollIntoView:"cursor"}})}var n=this.curOp=this.curOp||{};this.curOp.force=t;var i=e();if(this.ace.curOp&&this.ace.curOp.command.name=="vim"){if(this.state.dialog)this.ace.curOp.command.scrollIntoView=false;this.ace.endOperation();if(!n.cursorActivity&&!n.lastChange&&r)this.ace.prevOp=r}if(t||!this.ace.curOp){if(this.curOp)this.onBeforeEndOperation()}return i};this.onBeforeEndOperation=function(){var e=this.curOp;if(e){if(e.change){this.signal("change",e.change,e)}if(e&&e.cursorActivity){this.signal("cursorActivity",null,e)}this.curOp=null}};this.signal=function(e,t,r){var n=r?r[e+"Handlers"]:(this._eventRegistry||{})[e];if(!n)return;n=n.slice();for(var i=0;i<n.length;i++)n[i](this,t)};this.firstLine=function(){return 0};this.lastLine=function(){return this.ace.session.getLength()-1};this.lineCount=function(){return this.ace.session.getLength()};this.setCursor=function(e,t){if(typeof e==="object"){t=e.ch;e=e.line}if(!this.ace.inVirtualSelectionMode)this.ace.exitMultiSelectMode();this.ace.session.unfold({row:e,column:t});this.ace.selection.moveTo(e,t)};this.getCursor=function(e){var t=this.ace.selection;var r=e=="anchor"?t.isEmpty()?t.lead:t.anchor:e=="head"||!e?t.lead:t.getRange()[e];return g(r)};this.listSelections=function(e){var t=this.ace.multiSelect.rangeList.ranges;if(!t.length||this.ace.inVirtualSelectionMode)return[{anchor:this.getCursor("anchor"),head:this.getCursor("head")}];return t.map((function(e){return{anchor:this.clipPos(g(e.cursor==e.end?e.start:e.end)),head:this.clipPos(g(e.cursor))}}),this)};this.setSelections=function(e,t){var r=this.ace.multiSelect;var n=e.map((function(e){var t=m(e.anchor);var r=m(e.head);var n=i.comparePoints(t,r)<0?new i.fromPoints(t,r):new i.fromPoints(r,t);n.cursor=i.comparePoints(n.start,r)?n.end:n.start;return n}));if(this.ace.inVirtualSelectionMode){this.ace.selection.fromOrientedRange(n[0]);return}if(!t){n=n.reverse()}else if(n[t]){n.push(n.splice(t,1)[0])}r.toSingleRange(n[0].clone());var a=this.ace.session;for(var o=0;o<n.length;o++){var s=a.$clipRangeToDocument(n[o]);r.addRange(s)}};this.setSelection=function(e,t,r){var n=this.ace.selection;n.moveTo(e.line,e.ch);n.selectTo(t.line,t.ch);if(r&&r.origin=="*mouse"){this.onBeforeEndOperation()}};this.somethingSelected=function(e){return!this.ace.selection.isEmpty()};this.clipPos=function(e){var t=this.ace.session.$clipPositionToDocument(e.line,e.ch);return g(t)};this.markText=function(e){return{clear:function(){},find:function(){}}};this.$updateMarkers=function(e){var t=e.action=="insert";var r=e.start;var n=e.end;var a=(n.row-r.row)*(t?1:-1);var o=(n.column-r.column)*(t?1:-1);if(t)n=r;for(var s in this.marks){var l=this.marks[s];var c=i.comparePoints(l,r);if(c<0){continue}if(c===0){if(t){if(l.bias==1){c=1}else{l.bias=-1;continue}}}var u=t?c:i.comparePoints(l,n);if(u>0){l.row+=a;l.column+=l.row==n.row?o:0;continue}if(!t&&u<=0){l.row=r.row;l.column=r.column;if(u===0)l.bias=1}}};var e=function(e,t,r,n){this.cm=e;this.id=t;this.row=r;this.column=n;e.marks[this.id]=this};e.prototype.clear=function(){delete this.cm.marks[this.id]};e.prototype.find=function(){return g(this)};this.setBookmark=function(t,r){var n=new e(this,this.$uid++,t.line,t.ch);if(!r||!r.insertLeft)n.$insertRight=true;this.marks[n.id]=n;return n};this.moveH=function(e,t){if(t=="char"){var r=this.ace.selection;r.clearSelection();r.moveCursorBy(0,e)}};this.findPosV=function(e,t,r,n){if(r=="page"){var i=this.ace.renderer;var a=i.layerConfig;t=t*Math.floor(a.height/a.lineHeight);r="line"}if(r=="line"){var o=this.ace.session.documentToScreenPosition(e.line,e.ch);if(n!=null)o.column=n;o.row+=t;o.row=Math.min(Math.max(0,o.row),this.ace.session.getScreenLength()-1);var s=this.ace.session.screenToDocumentPosition(o.row,o.column);return g(s)}else{debugger}};this.charCoords=function(e,t){if(t=="div"||!t){var r=this.ace.session.documentToScreenPosition(e.line,e.ch);return{left:r.column,top:r.row}}if(t=="local"){var n=this.ace.renderer;var r=this.ace.session.documentToScreenPosition(e.line,e.ch);var i=n.layerConfig.lineHeight;var a=n.layerConfig.characterWidth;var o=i*r.row;return{left:r.column*a,top:o,bottom:o+i}}};this.coordsChar=function(e,t){var r=this.ace.renderer;if(t=="local"){var n=Math.max(0,Math.floor(e.top/r.lineHeight));var i=Math.max(0,Math.floor(e.left/r.characterWidth));var a=r.session.screenToDocumentPosition(n,i);return g(a)}else if(t=="div"){throw"not implemented"}};this.getSearchCursor=function(e,t,r){var n=false;var i=false;if(e instanceof RegExp&&!e.global){n=!e.ignoreCase;e=e.source;i=true}var a=new u;if(t.ch==undefined)t.ch=Number.MAX_VALUE;var o={row:t.line,column:t.ch};var s=this;var l=null;return{findNext:function(){return this.find(false)},findPrevious:function(){return this.find(true)},find:function(t){a.setOptions({needle:e,caseSensitive:n,wrap:false,backwards:t,regExp:i,start:l||o});var r=a.find(s.ace.session);if(r&&r.isEmpty()){if(s.getLine(r.start.row).length==r.start.column){a.$options.start=r;r=a.find(s.ace.session)}}l=r;return l},from:function(){return l&&g(l.start)},to:function(){return l&&g(l.end)},replace:function(e){if(l){l.end=s.ace.session.doc.replace(l,e)}}}};this.scrollTo=function(e,t){var r=this.ace.renderer;var n=r.layerConfig;var i=n.maxHeight;i-=(r.$size.scrollerHeight-r.lineHeight)*r.$scrollPastEnd;if(t!=null)this.ace.session.setScrollTop(Math.max(0,Math.min(t,i)));if(e!=null)this.ace.session.setScrollLeft(Math.max(0,Math.min(e,n.width)))};this.scrollInfo=function(){return 0};this.scrollIntoView=function(e,t){if(e){var r=this.ace.renderer;var n={top:0,bottom:t};r.scrollCursorIntoView(m(e),r.lineHeight*2/r.$size.scrollerHeight,n)}};this.getLine=function(e){return this.ace.session.getLine(e)};this.getRange=function(e,t){return this.ace.session.getTextRange(new i(e.line,e.ch,t.line,t.ch))};this.replaceRange=function(e,t,r){if(!r)r=t;return this.ace.session.replace(new i(t.line,t.ch,r.line,r.ch),e)};this.replaceSelection=this.replaceSelections=function(e){var t=this.ace.selection;if(this.ace.inVirtualSelectionMode){this.ace.session.replace(t.getRange(),e[0]||"");return}t.inVirtualSelectionMode=true;var r=t.rangeList.ranges;if(!r.length)r=[this.ace.multiSelect.getRange()];for(var n=r.length;n--;)this.ace.session.replace(r[n],e[n]||"");t.inVirtualSelectionMode=false};this.getSelection=function(){return this.ace.getSelectedText()};this.getSelections=function(){return this.listSelections().map((function(e){return this.getRange(e.anchor,e.head)}),this)};this.getInputField=function(){return this.ace.textInput.getElement()};this.getWrapperElement=function(){return this.ace.container};var t={indentWithTabs:"useSoftTabs",indentUnit:"tabSize",tabSize:"tabSize",firstLineNumber:"firstLineNumber",readOnly:"readOnly"};this.setOption=function(e,r){this.state[e]=r;switch(e){case"indentWithTabs":e=t[e];r=!r;break;case"keyMap":this.state.$keyMap=r;return;break;default:e=t[e]}if(e)this.ace.setOption(e,r)};this.getOption=function(e,r){var n=t[e];if(n)r=this.ace.getOption(n);switch(e){case"indentWithTabs":e=t[e];return!r;case"keyMap":return this.state.$keyMap}return n?r:this.state[e]};this.toggleOverwrite=function(e){this.state.overwrite=e;return this.ace.setOverwrite(e)};this.addOverlay=function(e){if(!this.$searchHighlight||!this.$searchHighlight.session){var t=new h(null,"ace_highlight-marker","text");var r=this.ace.session.addDynamicMarker(t);t.id=r.id;t.session=this.ace.session;t.destroy=function(e){t.session.off("change",t.updateOnChange);t.session.off("changeEditor",t.destroy);t.session.removeMarker(t.id);t.session=null};t.updateOnChange=function(e){var r=e.start.row;if(r==e.end.row)t.cache[r]=undefined;else t.cache.splice(r,t.cache.length)};t.session.on("changeEditor",t.destroy);t.session.on("change",t.updateOnChange)}var n=new RegExp(e.query.source,"gmi");this.$searchHighlight=e.highlight=t;this.$searchHighlight.setRegexp(n);this.ace.renderer.updateBackMarkers()};this.removeOverlay=function(e){if(this.$searchHighlight&&this.$searchHighlight.session){this.$searchHighlight.destroy()}};this.getScrollInfo=function(){var e=this.ace.renderer;var t=e.layerConfig;return{left:e.scrollLeft,top:e.scrollTop,height:t.maxHeight,width:t.width,clientHeight:t.height,clientWidth:t.width}};this.getValue=function(){return this.ace.getValue()};this.setValue=function(e){return this.ace.setValue(e,-1)};this.getTokenTypeAt=function(e){var t=this.ace.session.getTokenAt(e.line,e.ch);return t&&/comment|string/.test(t.type)?"string":""};this.findMatchingBracket=function(e){var t=this.ace.session.findMatchingBracket(m(e));return{to:t&&g(t)}};this.indentLine=function(e,t){if(t===true)this.ace.session.indentRows(e,e,"\t");else if(t===false)this.ace.session.outdentRows(new i(e,0,e,0))};this.indexFromPos=function(e){return this.ace.session.doc.positionToIndex(m(e))};this.posFromIndex=function(e){return g(this.ace.session.doc.indexToPosition(e))};this.focus=function(e){return this.ace.textInput.focus()};this.blur=function(e){return this.ace.blur()};this.defaultTextHeight=function(e){return this.ace.renderer.layerConfig.lineHeight};this.scanForBracket=function(e,t,r,n){var i=n.bracketRegex.source;var a=/paren|text|operator|tag/;if(t==1){var o=this.ace.session.$findClosingBracket(i.slice(1,2),m(e),a)}else{var o=this.ace.session.$findOpeningBracket(i.slice(-2,-1),{row:e.line,column:e.ch+1},a)}return o&&{pos:g(o)}};this.refresh=function(){return this.ace.resize(true)};this.getMode=function(){return{name:this.getOption("mode")}};this.execCommand=function(e){if(e=="indentAuto")this.ace.execCommand("autoindent");else console.log(e+" is not implemented")}}).call(v.prototype);function m(e){return{row:e.line,column:e.ch}}function g(e){return new x(e.row,e.column)}var y=v.StringStream=function(e,t){this.pos=this.start=0;this.string=e;this.tabSize=t||8;this.lastColumnPos=this.lastColumnValue=0;this.lineStart=0};y.prototype={eol:function(){return this.pos>=this.string.length},sol:function(){return this.pos==this.lineStart},peek:function(){return this.string.charAt(this.pos)||undefined},next:function(){if(this.pos<this.string.length)return this.string.charAt(this.pos++)},eat:function(e){var t=this.string.charAt(this.pos);if(typeof e=="string")var r=t==e;else var r=t&&(e.test?e.test(t):e(t));if(r){++this.pos;return t}},eatWhile:function(e){var t=this.pos;while(this.eat(e)){}return this.pos>t},eatSpace:function(){var e=this.pos;while(/[\s\u00a0]/.test(this.string.charAt(this.pos)))++this.pos;return this.pos>e},skipToEnd:function(){this.pos=this.string.length},skipTo:function(e){var t=this.string.indexOf(e,this.pos);if(t>-1){this.pos=t;return true}},backUp:function(e){this.pos-=e},column:function(){throw"not implemented"},indentation:function(){throw"not implemented"},match:function(e,t,r){if(typeof e=="string"){var n=function(e){return r?e.toLowerCase():e};var i=this.string.substr(this.pos,e.length);if(n(i)==n(e)){if(t!==false)this.pos+=e.length;return true}}else{var a=this.string.slice(this.pos).match(e);if(a&&a.index>0)return null;if(a&&t!==false)this.pos+=a[0].length;return a}},current:function(){return this.string.slice(this.start,this.pos)},hideFirstChars:function(e,t){this.lineStart+=e;try{return t()}finally{this.lineStart-=e}}};v.defineExtension=function(e,t){v.prototype[e]=t};o.importCssString(".normal-mode .ace_cursor{    border: none;    background-color: rgba(255,0,0,0.5);}.normal-mode .ace_hidden-cursors .ace_cursor{  background-color: transparent;  border: 1px solid red;  opacity: 0.7}.ace_dialog {  position: absolute;  left: 0; right: 0;  background: inherit;  z-index: 15;  padding: .1em .8em;  overflow: hidden;  color: inherit;}.ace_dialog-top {  border-bottom: 1px solid #444;  top: 0;}.ace_dialog-bottom {  border-top: 1px solid #444;  bottom: 0;}.ace_dialog input {  border: none;  outline: none;  background: transparent;  width: 20em;  color: inherit;  font-family: monospace;}","vimMode");(function(){function e(e,t,r){var n=e.ace.container;var i;i=n.appendChild(document.createElement("div"));if(r)i.className="ace_dialog ace_dialog-bottom";else i.className="ace_dialog ace_dialog-top";if(typeof t=="string"){i.innerHTML=t}else{i.appendChild(t)}return i}function t(e,t){if(e.state.currentNotificationClose)e.state.currentNotificationClose();e.state.currentNotificationClose=t}v.defineExtension("openDialog",(function(r,n,i){if(this.virtualSelectionMode())return;if(!i)i={};t(this,null);var a=e(this,r,i.bottom);var o=false,s=this;this.state.dialog=a;function l(e){if(typeof e=="string"){c.value=e}else{if(o)return;if(e&&e.type=="blur"){if(document.activeElement===c)return}s.state.dialog=null;o=true;a.parentNode.removeChild(a);s.focus();if(i.onClose)i.onClose(a)}}var c=a.getElementsByTagName("input")[0],u;if(c){if(i.value){c.value=i.value;if(i.selectValueOnOpen!==false)c.select()}if(i.onInput)v.on(c,"input",(function(e){i.onInput(e,c.value,l)}));if(i.onKeyUp)v.on(c,"keyup",(function(e){i.onKeyUp(e,c.value,l)}));v.on(c,"keydown",(function(e){if(i&&i.onKeyDown&&i.onKeyDown(e,c.value,l)){return}if(e.keyCode==13)n(c.value);if(e.keyCode==27||i.closeOnEnter!==false&&e.keyCode==13){c.blur();v.e_stop(e);l()}}));if(i.closeOnBlur!==false)v.on(c,"blur",l);c.focus()}else if(u=a.getElementsByTagName("button")[0]){v.on(u,"click",(function(){l();s.focus()}));if(i.closeOnBlur!==false)v.on(u,"blur",l);u.focus()}return l}));v.defineExtension("openNotification",(function(r,n){if(this.virtualSelectionMode())return;t(this,l);var i=e(this,r,n&&n.bottom);var a=false,o;var s=n&&typeof n.duration!=="undefined"?n.duration:5e3;function l(){if(a)return;a=true;clearTimeout(o);i.parentNode.removeChild(i)}v.on(i,"click",(function(e){v.e_preventDefault(e);l()}));if(s)o=setTimeout(l,s);return l}))})();var k=[{keys:"<Left>",type:"keyToKey",toKeys:"h"},{keys:"<Right>",type:"keyToKey",toKeys:"l"},{keys:"<Up>",type:"keyToKey",toKeys:"k"},{keys:"<Down>",type:"keyToKey",toKeys:"j"},{keys:"<Space>",type:"keyToKey",toKeys:"l"},{keys:"<BS>",type:"keyToKey",toKeys:"h",context:"normal"},{keys:"<Del>",type:"keyToKey",toKeys:"x",context:"normal"},{keys:"<C-Space>",type:"keyToKey",toKeys:"W"},{keys:"<C-BS>",type:"keyToKey",toKeys:"B",context:"normal"},{keys:"<S-Space>",type:"keyToKey",toKeys:"w"},{keys:"<S-BS>",type:"keyToKey",toKeys:"b",context:"normal"},{keys:"<C-n>",type:"keyToKey",toKeys:"j"},{keys:"<C-p>",type:"keyToKey",toKeys:"k"},{keys:"<C-[>",type:"keyToKey",toKeys:"<Esc>"},{keys:"<C-c>",type:"keyToKey",toKeys:"<Esc>"},{keys:"<C-[>",type:"keyToKey",toKeys:"<Esc>",context:"insert"},{keys:"<C-c>",type:"keyToKey",toKeys:"<Esc>",context:"insert"},{keys:"<C-Esc>",type:"keyToKey",toKeys:"<Esc>"},{keys:"<C-Esc>",type:"keyToKey",toKeys:"<Esc>",context:"insert"},{keys:"s",type:"keyToKey",toKeys:"cl",context:"normal"},{keys:"s",type:"keyToKey",toKeys:"c",context:"visual"},{keys:"S",type:"keyToKey",toKeys:"cc",context:"normal"},{keys:"S",type:"keyToKey",toKeys:"VdO",context:"visual"},{keys:"<Home>",type:"keyToKey",toKeys:"0"},{keys:"<End>",type:"keyToKey",toKeys:"$"},{keys:"<PageUp>",type:"keyToKey",toKeys:"<C-b>"},{keys:"<PageDown>",type:"keyToKey",toKeys:"<C-f>"},{keys:"<CR>",type:"keyToKey",toKeys:"j^",context:"normal"},{keys:"<Ins>",type:"action",action:"toggleOverwrite",context:"insert"},{keys:"H",type:"motion",motion:"moveToTopLine",motionArgs:{linewise:true,toJumplist:true}},{keys:"M",type:"motion",motion:"moveToMiddleLine",motionArgs:{linewise:true,toJumplist:true}},{keys:"L",type:"motion",motion:"moveToBottomLine",motionArgs:{linewise:true,toJumplist:true}},{keys:"h",type:"motion",motion:"moveByCharacters",motionArgs:{forward:false}},{keys:"l",type:"motion",motion:"moveByCharacters",motionArgs:{forward:true}},{keys:"j",type:"motion",motion:"moveByLines",motionArgs:{forward:true,linewise:true}},{keys:"k",type:"motion",motion:"moveByLines",motionArgs:{forward:false,linewise:true}},{keys:"gj",type:"motion",motion:"moveByDisplayLines",motionArgs:{forward:true}},{keys:"gk",type:"motion",motion:"moveByDisplayLines",motionArgs:{forward:false}},{keys:"w",type:"motion",motion:"moveByWords",motionArgs:{forward:true,wordEnd:false}},{keys:"W",type:"motion",motion:"moveByWords",motionArgs:{forward:true,wordEnd:false,bigWord:true}},{keys:"e",type:"motion",motion:"moveByWords",motionArgs:{forward:true,wordEnd:true,inclusive:true}},{keys:"E",type:"motion",motion:"moveByWords",motionArgs:{forward:true,wordEnd:true,bigWord:true,inclusive:true}},{keys:"b",type:"motion",motion:"moveByWords",motionArgs:{forward:false,wordEnd:false}},{keys:"B",type:"motion",motion:"moveByWords",motionArgs:{forward:false,wordEnd:false,bigWord:true}},{keys:"ge",type:"motion",motion:"moveByWords",motionArgs:{forward:false,wordEnd:true,inclusive:true}},{keys:"gE",type:"motion",motion:"moveByWords",motionArgs:{forward:false,wordEnd:true,bigWord:true,inclusive:true}},{keys:"{",type:"motion",motion:"moveByParagraph",motionArgs:{forward:false,toJumplist:true}},{keys:"}",type:"motion",motion:"moveByParagraph",motionArgs:{forward:true,toJumplist:true}},{keys:"(",type:"motion",motion:"moveBySentence",motionArgs:{forward:false}},{keys:")",type:"motion",motion:"moveBySentence",motionArgs:{forward:true}},{keys:"<C-f>",type:"motion",motion:"moveByPage",motionArgs:{forward:true}},{keys:"<C-b>",type:"motion",motion:"moveByPage",motionArgs:{forward:false}},{keys:"<C-d>",type:"motion",motion:"moveByScroll",motionArgs:{forward:true,explicitRepeat:true}},{keys:"<C-u>",type:"motion",motion:"moveByScroll",motionArgs:{forward:false,explicitRepeat:true}},{keys:"gg",type:"motion",motion:"moveToLineOrEdgeOfDocument",motionArgs:{forward:false,explicitRepeat:true,linewise:true,toJumplist:true}},{keys:"G",type:"motion",motion:"moveToLineOrEdgeOfDocument",motionArgs:{forward:true,explicitRepeat:true,linewise:true,toJumplist:true}},{keys:"0",type:"motion",motion:"moveToStartOfLine"},{keys:"^",type:"motion",motion:"moveToFirstNonWhiteSpaceCharacter"},{keys:"+",type:"motion",motion:"moveByLines",motionArgs:{forward:true,toFirstChar:true}},{keys:"-",type:"motion",motion:"moveByLines",motionArgs:{forward:false,toFirstChar:true}},{keys:"_",type:"motion",motion:"moveByLines",motionArgs:{forward:true,toFirstChar:true,repeatOffset:-1}},{keys:"$",type:"motion",motion:"moveToEol",motionArgs:{inclusive:true}},{keys:"%",type:"motion",motion:"moveToMatchedSymbol",motionArgs:{inclusive:true,toJumplist:true}},{keys:"f<character>",type:"motion",motion:"moveToCharacter",motionArgs:{forward:true,inclusive:true}},{keys:"F<character>",type:"motion",motion:"moveToCharacter",motionArgs:{forward:false}},{keys:"t<character>",type:"motion",motion:"moveTillCharacter",motionArgs:{forward:true,inclusive:true}},{keys:"T<character>",type:"motion",motion:"moveTillCharacter",motionArgs:{forward:false}},{keys:";",type:"motion",motion:"repeatLastCharacterSearch",motionArgs:{forward:true}},{keys:",",type:"motion",motion:"repeatLastCharacterSearch",motionArgs:{forward:false}},{keys:"'<character>",type:"motion",motion:"goToMark",motionArgs:{toJumplist:true,linewise:true}},{keys:"`<character>",type:"motion",motion:"goToMark",motionArgs:{toJumplist:true}},{keys:"]`",type:"motion",motion:"jumpToMark",motionArgs:{forward:true}},{keys:"[`",type:"motion",motion:"jumpToMark",motionArgs:{forward:false}},{keys:"]'",type:"motion",motion:"jumpToMark",motionArgs:{forward:true,linewise:true}},{keys:"['",type:"motion",motion:"jumpToMark",motionArgs:{forward:false,linewise:true}},{keys:"]p",type:"action",action:"paste",isEdit:true,actionArgs:{after:true,isEdit:true,matchIndent:true}},{keys:"[p",type:"action",action:"paste",isEdit:true,actionArgs:{after:false,isEdit:true,matchIndent:true}},{keys:"]<character>",type:"motion",motion:"moveToSymbol",motionArgs:{forward:true,toJumplist:true}},{keys:"[<character>",type:"motion",motion:"moveToSymbol",motionArgs:{forward:false,toJumplist:true}},{keys:"|",type:"motion",motion:"moveToColumn"},{keys:"o",type:"motion",motion:"moveToOtherHighlightedEnd",context:"visual"},{keys:"O",type:"motion",motion:"moveToOtherHighlightedEnd",motionArgs:{sameLine:true},context:"visual"},{keys:"d",type:"operator",operator:"delete"},{keys:"y",type:"operator",operator:"yank"},{keys:"c",type:"operator",operator:"change"},{keys:"=",type:"operator",operator:"indentAuto"},{keys:">",type:"operator",operator:"indent",operatorArgs:{indentRight:true}},{keys:"<",type:"operator",operator:"indent",operatorArgs:{indentRight:false}},{keys:"g~",type:"operator",operator:"changeCase"},{keys:"gu",type:"operator",operator:"changeCase",operatorArgs:{toLower:true},isEdit:true},{keys:"gU",type:"operator",operator:"changeCase",operatorArgs:{toLower:false},isEdit:true},{keys:"n",type:"motion",motion:"findNext",motionArgs:{forward:true,toJumplist:true}},{keys:"N",type:"motion",motion:"findNext",motionArgs:{forward:false,toJumplist:true}},{keys:"x",type:"operatorMotion",operator:"delete",motion:"moveByCharacters",motionArgs:{forward:true},operatorMotionArgs:{visualLine:false}},{keys:"X",type:"operatorMotion",operator:"delete",motion:"moveByCharacters",motionArgs:{forward:false},operatorMotionArgs:{visualLine:true}},{keys:"D",type:"operatorMotion",operator:"delete",motion:"moveToEol",motionArgs:{inclusive:true},context:"normal"},{keys:"D",type:"operator",operator:"delete",operatorArgs:{linewise:true},context:"visual"},{keys:"Y",type:"operatorMotion",operator:"yank",motion:"expandToLine",motionArgs:{linewise:true},context:"normal"},{keys:"Y",type:"operator",operator:"yank",operatorArgs:{linewise:true},context:"visual"},{keys:"C",type:"operatorMotion",operator:"change",motion:"moveToEol",motionArgs:{inclusive:true},context:"normal"},{keys:"C",type:"operator",operator:"change",operatorArgs:{linewise:true},context:"visual"},{keys:"~",type:"operatorMotion",operator:"changeCase",motion:"moveByCharacters",motionArgs:{forward:true},operatorArgs:{shouldMoveCursor:true},context:"normal"},{keys:"~",type:"operator",operator:"changeCase",context:"visual"},{keys:"<C-w>",type:"operatorMotion",operator:"delete",motion:"moveByWords",motionArgs:{forward:false,wordEnd:false},context:"insert"},{keys:"<C-w>",type:"idle",context:"normal"},{keys:"<C-i>",type:"action",action:"jumpListWalk",actionArgs:{forward:true}},{keys:"<C-o>",type:"action",action:"jumpListWalk",actionArgs:{forward:false}},{keys:"<C-e>",type:"action",action:"scroll",actionArgs:{forward:true,linewise:true}},{keys:"<C-y>",type:"action",action:"scroll",actionArgs:{forward:false,linewise:true}},{keys:"a",type:"action",action:"enterInsertMode",isEdit:true,actionArgs:{insertAt:"charAfter"},context:"normal"},{keys:"A",type:"action",action:"enterInsertMode",isEdit:true,actionArgs:{insertAt:"eol"},context:"normal"},{keys:"A",type:"action",action:"enterInsertMode",isEdit:true,actionArgs:{insertAt:"endOfSelectedArea"},context:"visual"},{keys:"i",type:"action",action:"enterInsertMode",isEdit:true,actionArgs:{insertAt:"inplace"},context:"normal"},{keys:"gi",type:"action",action:"enterInsertMode",isEdit:true,actionArgs:{insertAt:"lastEdit"},context:"normal"},{keys:"I",type:"action",action:"enterInsertMode",isEdit:true,actionArgs:{insertAt:"firstNonBlank"},context:"normal"},{keys:"gI",type:"action",action:"enterInsertMode",isEdit:true,actionArgs:{insertAt:"bol"},context:"normal"},{keys:"I",type:"action",action:"enterInsertMode",isEdit:true,actionArgs:{insertAt:"startOfSelectedArea"},context:"visual"},{keys:"o",type:"action",action:"newLineAndEnterInsertMode",isEdit:true,interlaceInsertRepeat:true,actionArgs:{after:true},context:"normal"},{keys:"O",type:"action",action:"newLineAndEnterInsertMode",isEdit:true,interlaceInsertRepeat:true,actionArgs:{after:false},context:"normal"},{keys:"v",type:"action",action:"toggleVisualMode"},{keys:"V",type:"action",action:"toggleVisualMode",actionArgs:{linewise:true}},{keys:"<C-v>",type:"action",action:"toggleVisualMode",actionArgs:{blockwise:true}},{keys:"<C-q>",type:"action",action:"toggleVisualMode",actionArgs:{blockwise:true}},{keys:"gv",type:"action",action:"reselectLastSelection"},{keys:"J",type:"action",action:"joinLines",isEdit:true},{keys:"gJ",type:"action",action:"joinLines",actionArgs:{keepSpaces:true},isEdit:true},{keys:"p",type:"action",action:"paste",isEdit:true,actionArgs:{after:true,isEdit:true}},{keys:"P",type:"action",action:"paste",isEdit:true,actionArgs:{after:false,isEdit:true}},{keys:"r<character>",type:"action",action:"replace",isEdit:true},{keys:"@<character>",type:"action",action:"replayMacro"},{keys:"q<character>",type:"action",action:"enterMacroRecordMode"},{keys:"R",type:"action",action:"enterInsertMode",isEdit:true,actionArgs:{replace:true},context:"normal"},{keys:"R",type:"operator",operator:"change",operatorArgs:{linewise:true,fullLine:true},context:"visual",exitVisualBlock:true},{keys:"u",type:"action",action:"undo",context:"normal"},{keys:"u",type:"operator",operator:"changeCase",operatorArgs:{toLower:true},context:"visual",isEdit:true},{keys:"U",type:"operator",operator:"changeCase",operatorArgs:{toLower:false},context:"visual",isEdit:true},{keys:"<C-r>",type:"action",action:"redo"},{keys:"m<character>",type:"action",action:"setMark"},{keys:'"<character>',type:"action",action:"setRegister"},{keys:"zz",type:"action",action:"scrollToCursor",actionArgs:{position:"center"}},{keys:"z.",type:"action",action:"scrollToCursor",actionArgs:{position:"center"},motion:"moveToFirstNonWhiteSpaceCharacter"},{keys:"zt",type:"action",action:"scrollToCursor",actionArgs:{position:"top"}},{keys:"z<CR>",type:"action",action:"scrollToCursor",actionArgs:{position:"top"},motion:"moveToFirstNonWhiteSpaceCharacter"},{keys:"z-",type:"action",action:"scrollToCursor",actionArgs:{position:"bottom"}},{keys:"zb",type:"action",action:"scrollToCursor",actionArgs:{position:"bottom"},motion:"moveToFirstNonWhiteSpaceCharacter"},{keys:".",type:"action",action:"repeatLastEdit"},{keys:"<C-a>",type:"action",action:"incrementNumberToken",isEdit:true,actionArgs:{increase:true,backtrack:false}},{keys:"<C-x>",type:"action",action:"incrementNumberToken",isEdit:true,actionArgs:{increase:false,backtrack:false}},{keys:"<C-t>",type:"action",action:"indent",actionArgs:{indentRight:true},context:"insert"},{keys:"<C-d>",type:"action",action:"indent",actionArgs:{indentRight:false},context:"insert"},{keys:"a<character>",type:"motion",motion:"textObjectManipulation"},{keys:"i<character>",type:"motion",motion:"textObjectManipulation",motionArgs:{textObjectInner:true}},{keys:"/",type:"search",searchArgs:{forward:true,querySrc:"prompt",toJumplist:true}},{keys:"?",type:"search",searchArgs:{forward:false,querySrc:"prompt",toJumplist:true}},{keys:"*",type:"search",searchArgs:{forward:true,querySrc:"wordUnderCursor",wholeWordOnly:true,toJumplist:true}},{keys:"#",type:"search",searchArgs:{forward:false,querySrc:"wordUnderCursor",wholeWordOnly:true,toJumplist:true}},{keys:"g*",type:"search",searchArgs:{forward:true,querySrc:"wordUnderCursor",toJumplist:true}},{keys:"g#",type:"search",searchArgs:{forward:false,querySrc:"wordUnderCursor",toJumplist:true}},{keys:":",type:"ex"}];var C=k.length;var w=[{name:"colorscheme",shortName:"colo"},{name:"map"},{name:"imap",shortName:"im"},{name:"nmap",shortName:"nm"},{name:"vmap",shortName:"vm"},{name:"unmap"},{name:"write",shortName:"w"},{name:"undo",shortName:"u"},{name:"redo",shortName:"red"},{name:"set",shortName:"se"},{name:"set",shortName:"se"},{name:"setlocal",shortName:"setl"},{name:"setglobal",shortName:"setg"},{name:"sort",shortName:"sor"},{name:"substitute",shortName:"s",possiblyAsync:true},{name:"nohlsearch",shortName:"noh"},{name:"yank",shortName:"y"},{name:"delmarks",shortName:"delm"},{name:"registers",shortName:"reg",excludeFromCommandHistory:true},{name:"global",shortName:"g"}];var x=v.Pos;var M=function(){return se};function S(e){e.setOption("disableInput",true);e.setOption("showCursorWhenSelecting",false);v.signal(e,"vim-mode-change",{mode:"normal"});e.on("cursorActivity",Yt);ne(e);v.on(e.getInputField(),"paste",B(e))}function A(e){e.setOption("disableInput",false);e.off("cursorActivity",Yt);v.off(e.getInputField(),"paste",B(e));e.state.vim=null}function b(e,t){if(this==v.keyMap.vim)v.rmClass(e.getWrapperElement(),"cm-fat-cursor");if(!t||t.attach!=L)A(e)}function L(e,t){if(this==v.keyMap.vim)v.addClass(e.getWrapperElement(),"cm-fat-cursor");if(!t||t.attach!=L)S(e)}v.defineOption("vimMode",false,(function(e,t,r){if(t&&e.getOption("keyMap")!="vim")e.setOption("keyMap","vim");else if(!t&&r!=v.Init&&/^vim/.test(e.getOption("keyMap")))e.setOption("keyMap","default")}));function O(e,t){if(!t){return undefined}if(this[e]){return this[e]}var r=R(e);if(!r){return false}var n=v.Vim.findKey(t,r);if(typeof n=="function"){v.signal(t,"vim-keypress",r)}return n}var T={Shift:"S",Ctrl:"C",Alt:"A",Cmd:"D",Mod:"A"};var E={Enter:"CR",Backspace:"BS",Delete:"Del",Insert:"Ins"};function R(e){if(e.charAt(0)=="'"){return e.charAt(1)}var t=e.split(/-(?!$)/);var r=t[t.length-1];if(t.length==1&&t[0].length==1){return false}else if(t.length==2&&t[0]=="Shift"&&r.length==1){return false}var n=false;for(var i=0;i<t.length;i++){var a=t[i];if(a in T){t[i]=T[a]}else{n=true}if(a in E){t[i]=E[a]}}if(!n){return false}if(z(r)){t[t.length-1]=r.toLowerCase()}return"<"+t.join("-")+">"}function B(e){var t=e.state.vim;if(!t.onPasteFn){t.onPasteFn=function(){if(!t.insertMode){e.setCursor(Se(e.getCursor(),0,1));Ce.enterInsertMode(e,{},t)}}}return t.onPasteFn}var I=/[\d]/;var K=[v.isWordChar,function(e){return e&&!v.isWordChar(e)&&!/\s/.test(e)}],N=[function(e){return/\S/.test(e)}];function P(e,t){var r=[];for(var n=e;n<e+t;n++){r.push(String.fromCharCode(n))}return r}var _=P(65,26);var H=P(97,26);var V=P(48,10);var $=[].concat(_,H,V,["<",">"]);var j=[].concat(_,H,V,["-",'"',".",":","/"]);function D(e,t){return t>=e.firstLine()&&t<=e.lastLine()}function W(e){return/^[a-z]$/.test(e)}function F(e){return"()[]{}".indexOf(e)!=-1}function U(e){return I.test(e)}function z(e){return/^[A-Z]$/.test(e)}function J(e){return/^\s*$/.test(e)}function q(e){return".?!".indexOf(e)!=-1}function Q(e,t){for(var r=0;r<t.length;r++){if(t[r]==e){return true}}return false}var G={};function X(e,t,r,n,i){if(t===undefined&&!i){throw Error("defaultValue is required unless callback is provided")}if(!r){r="string"}G[e]={type:r,defaultValue:t,callback:i};if(n){for(var a=0;a<n.length;a++){G[n[a]]=G[e]}}if(t){Z(e,t)}}function Z(e,t,r,n){var i=G[e];n=n||{};var a=n.scope;if(!i){return new Error("Unknown option: "+e)}if(i.type=="boolean"){if(t&&t!==true){return new Error("Invalid argument: "+e+"="+t)}else if(t!==false){t=true}}if(i.callback){if(a!=="local"){i.callback(t,undefined)}if(a!=="global"&&r){i.callback(t,r)}}else{if(a!=="local"){i.value=i.type=="boolean"?!!t:t}if(a!=="global"&&r){r.state.vim.options[e]={value:t}}}}function Y(e,t,r){var n=G[e];r=r||{};var i=r.scope;if(!n){return new Error("Unknown option: "+e)}if(n.callback){var a=t&&n.callback(undefined,t);if(i!=="global"&&a!==undefined){return a}if(i!=="local"){return n.callback()}return}else{var a=i!=="global"&&t&&t.state.vim.options[e];return(a||i!=="local"&&n||{}).value}}X("filetype",undefined,"string",["ft"],(function(e,t){if(t===undefined){return}if(e===undefined){var r=t.getOption("mode");return r=="null"?"":r}else{var r=e==""?"null":e;t.setOption("mode",r)}}));var ee=function(){var e=100;var t=-1;var r=0;var n=0;var i=new Array(e);function a(a,o,s){var l=t%e;var c=i[l];function u(r){var n=++t%e;var o=i[n];if(o){o.clear()}i[n]=a.setBookmark(r)}if(c){var f=c.find();if(f&&!Ee(f,o)){u(o)}}else{u(o)}u(s);r=t;n=t-e+1;if(n<0){n=0}}function o(a,o){t+=o;if(t>r){t=r}else if(t<n){t=n}var s=i[(e+t)%e];if(s&&!s.find()){var l=o>0?1:-1;var c;var u=a.getCursor();do{t+=l;s=i[(e+t)%e];if(s&&(c=s.find())&&!Ee(u,c)){break}}while(t<r&&t>n)}return s}function s(e,r){var n=t;var i=o(e,r);t=n;return i&&i.find()}return{cachedCursor:undefined,add:a,find:s,move:o}};var te=function(e){if(e){return{changes:e.changes,expectCursorActivityForChange:e.expectCursorActivityForChange}}return{changes:[],expectCursorActivityForChange:false}};function re(){this.latestRegister=undefined;this.isPlaying=false;this.isRecording=false;this.replaySearchQueries=[];this.onRecordingDone=undefined;this.lastInsertModeChanges=te()}re.prototype={exitMacroRecordMode:function(){var e=ie.macroModeState;if(e.onRecordingDone){e.onRecordingDone()}e.onRecordingDone=undefined;e.isRecording=false},enterMacroRecordMode:function(e,t){var r=ie.registerController.getRegister(t);if(r){r.clear();this.latestRegister=t;if(e.openDialog){this.onRecordingDone=e.openDialog("(recording)["+t+"]",null,{bottom:true})}this.isRecording=true}}};function ne(e){if(!e.state.vim){e.state.vim={inputState:new le,lastEditInputState:undefined,lastEditActionCommand:undefined,lastHPos:-1,lastHSPos:-1,lastMotion:null,marks:{},fakeCursor:null,insertMode:false,insertModeRepeat:undefined,visualMode:false,visualLine:false,visualBlock:false,lastSelection:null,lastPastedText:null,sel:{},options:{}}}return e.state.vim}var ie;function ae(){ie={searchQuery:null,searchIsReversed:false,lastSubstituteReplacePart:undefined,jumpList:ee(),macroModeState:new re,lastCharacterSearch:{increment:0,forward:true,selectedCharacter:""},registerController:new he({}),searchHistoryController:new pe,exCommandHistoryController:new pe};for(var e in G){var t=G[e];t.value=t.defaultValue}}var oe;var se={buildKeyMap:function(){},getRegisterController:function(){return ie.registerController},resetVimGlobalState_:ae,getVimGlobalState_:function(){return ie},maybeInitVimState_:ne,suppressErrorLogging:false,InsertModeKey:rr,map:function(e,t,r){Wt.map(e,t,r)},unmap:function(e,t){Wt.unmap(e,t)},noremap:function(e,t,r){function n(e){return e?[e]:["normal","insert","visual"]}var i=n(r);var a=k.length,o=C;for(var s=a-o;s<a&&i.length;s++){var l=k[s];if(l.keys==t&&(!r||!l.context||l.context===r)&&l.type.substr(0,2)!=="ex"&&l.type.substr(0,3)!=="key"){var c={};for(var u in l){c[u]=l[u]}c.keys=e;if(r&&!c.context){c.context=r}this._mapCommand(c);var f=n(l.context);i=i.filter((function(e){return f.indexOf(e)===-1}))}}},mapclear:function(e){var t=k.length,r=C;var n=k.slice(0,t-r);k=k.slice(t-r);if(e){for(var i=n.length-1;i>=0;i--){var a=n[i];if(e!==a.context){if(a.context){this._mapCommand(a)}else{var o=["normal","insert","visual"];for(var s in o){if(o[s]!==e){var l={};for(var c in a){l[c]=a[c]}l.context=o[s];this._mapCommand(l)}}}}}}},setOption:Z,getOption:Y,defineOption:X,defineEx:function(e,t,r){if(!t){t=e}else if(e.indexOf(t)!==0){throw new Error('(Vim.defineEx) "'+t+'" is not a prefix of "'+e+'", command not registered')}Dt[e]=r;Wt.commandMap_[t]={name:e,shortName:t,type:"api"}},handleKey:function(e,t,r){var n=this.findKey(e,t,r);if(typeof n==="function"){return n()}},findKey:function(e,t,r){var n=ne(e);function i(){var n=ie.macroModeState;if(n.isRecording){if(t=="q"){n.exitMacroRecordMode();ce(e);return true}if(r!="mapping"){Qt(n,t)}}}function a(){if(t=="<Esc>"){ce(e);if(n.visualMode){qe(e)}else if(n.insertMode){Ut(e)}return true}}function o(r){var n;while(r){n=/<\w+-.+?>|<\w+>|./.exec(r);t=n[0];r=r.substring(n.index+t.length);v.Vim.handleKey(e,t,"mapping")}}function s(){if(a()){return true}var r=n.inputState.keyBuffer=n.inputState.keyBuffer+t;var i=t.length==1;var o=de.matchCommand(r,k,n.inputState,"insert");while(r.length>1&&o.type!="full"){var r=n.inputState.keyBuffer=r.slice(1);var s=de.matchCommand(r,k,n.inputState,"insert");if(s.type!="none"){o=s}}if(o.type=="none"){ce(e);return false}else if(o.type=="partial"){if(oe){window.clearTimeout(oe)}oe=window.setTimeout((function(){if(n.insertMode&&n.inputState.keyBuffer){ce(e)}}),Y("insertModeEscKeysTimeout"));return!i}if(oe){window.clearTimeout(oe)}if(i){var l=e.listSelections();for(var c=0;c<l.length;c++){var u=l[c].head;e.replaceRange("",Se(u,0,-(r.length-1)),u,"+input")}ie.macroModeState.lastInsertModeChanges.changes.pop()}ce(e);return o.command}function l(){if(i()||a()){return true}var r=n.inputState.keyBuffer=n.inputState.keyBuffer+t;if(/^[1-9]\d*$/.test(r)){return true}var o=/^(\d*)(.*)$/.exec(r);if(!o){ce(e);return false}var s=n.visualMode?"visual":"normal";var l=de.matchCommand(o[2]||o[1],k,n.inputState,s);if(l.type=="none"){ce(e);return false}else if(l.type=="partial"){return true}n.inputState.keyBuffer="";var o=/^(\d*)(.*)$/.exec(r);if(o[1]&&o[1]!="0"){n.inputState.pushRepeatDigit(o[1])}return l.command}var c;if(n.insertMode){c=s()}else{c=l()}if(c===false){return undefined}else if(c===true){return function(){return true}}else{return function(){if((c.operator||c.isEdit)&&e.getOption("readOnly"))return;return e.operation((function(){e.curOp.isVimOp=true;try{if(c.type=="keyToKey"){o(c.toKeys)}else{de.processCommand(e,n,c)}}catch(t){e.state.vim=undefined;ne(e);if(!v.Vim.suppressErrorLogging){console["log"](t)}throw t}return true}))}}},handleEx:function(e,t){Wt.processCommand(e,t)},defineMotion:me,defineAction:we,defineOperator:ke,mapCommand:Jt,_mapCommand:zt,defineRegister:fe,exitVisualMode:qe,exitInsertMode:Ut};function le(){this.prefixRepeat=[];this.motionRepeat=[];this.operator=null;this.operatorArgs=null;this.motion=null;this.motionArgs=null;this.keyBuffer=[];this.registerName=null}le.prototype.pushRepeatDigit=function(e){if(!this.operator){this.prefixRepeat=this.prefixRepeat.concat(e)}else{this.motionRepeat=this.motionRepeat.concat(e)}};le.prototype.getRepeat=function(){var e=0;if(this.prefixRepeat.length>0||this.motionRepeat.length>0){e=1;if(this.prefixRepeat.length>0){e*=parseInt(this.prefixRepeat.join(""),10)}if(this.motionRepeat.length>0){e*=parseInt(this.motionRepeat.join(""),10)}}return e};function ce(e,t){e.state.vim.inputState=new le;v.signal(e,"vim-command-done",t)}function ue(e,t,r){this.clear();this.keyBuffer=[e||""];this.insertModeChanges=[];this.searchQueries=[];this.linewise=!!t;this.blockwise=!!r}ue.prototype={setText:function(e,t,r){this.keyBuffer=[e||""];this.linewise=!!t;this.blockwise=!!r},pushText:function(e,t){if(t){if(!this.linewise){this.keyBuffer.push("\n")}this.linewise=true}this.keyBuffer.push(e)},pushInsertModeChanges:function(e){this.insertModeChanges.push(te(e))},pushSearchQuery:function(e){this.searchQueries.push(e)},clear:function(){this.keyBuffer=[];this.insertModeChanges=[];this.searchQueries=[];this.linewise=false},toString:function(){return this.keyBuffer.join("")}};function fe(e,t){var r=ie.registerController.registers;if(!e||e.length!=1){throw Error("Register name must be 1 character")}r[e]=t;j.push(e)}function he(e){this.registers=e;this.unnamedRegister=e['"']=new ue;e["."]=new ue;e[":"]=new ue;e["/"]=new ue}he.prototype={pushText:function(e,t,r,n,i){if(n&&r.charAt(r.length-1)!=="\n"){r+="\n"}var a=this.isValidRegister(e)?this.getRegister(e):null;if(!a){switch(t){case"yank":this.registers["0"]=new ue(r,n,i);break;case"delete":case"change":if(r.indexOf("\n")==-1){this.registers["-"]=new ue(r,n)}else{this.shiftNumericRegisters_();this.registers["1"]=new ue(r,n)}break}this.unnamedRegister.setText(r,n,i);return}var o=z(e);if(o){a.pushText(r,n)}else{a.setText(r,n,i)}this.unnamedRegister.setText(a.toString(),n)},getRegister:function(e){if(!this.isValidRegister(e)){return this.unnamedRegister}e=e.toLowerCase();if(!this.registers[e]){this.registers[e]=new ue}return this.registers[e]},isValidRegister:function(e){return e&&Q(e,j)},shiftNumericRegisters_:function(){for(var e=9;e>=2;e--){this.registers[e]=this.getRegister(""+(e-1))}}};function pe(){this.historyBuffer=[];this.iterator=0;this.initialPrefix=null}pe.prototype={nextMatch:function(e,t){var r=this.historyBuffer;var n=t?-1:1;if(this.initialPrefix===null)this.initialPrefix=e;for(var i=this.iterator+n;t?i>=0:i<r.length;i+=n){var a=r[i];for(var o=0;o<=a.length;o++){if(this.initialPrefix==a.substring(0,o)){this.iterator=i;return a}}}if(i>=r.length){this.iterator=r.length;return this.initialPrefix}if(i<0)return e},pushInput:function(e){var t=this.historyBuffer.indexOf(e);if(t>-1)this.historyBuffer.splice(t,1);if(e.length)this.historyBuffer.push(e)},reset:function(){this.initialPrefix=null;this.iterator=this.historyBuffer.length}};var de={matchCommand:function(e,t,r,n){var i=Ae(e,t,n,r);if(!i.full&&!i.partial){return{type:"none"}}else if(!i.full&&i.partial){return{type:"partial"}}var a;for(var o=0;o<i.full.length;o++){var s=i.full[o];if(!a){a=s}}if(a.keys.slice(-11)=="<character>"){var l=Le(e);if(/<C-.>/.test(l)||!l)return{type:"none"};r.selectedCharacter=l}return{type:"full",command:a}},processCommand:function(e,t,r){t.inputState.repeatOverride=r.repeatOverride;switch(r.type){case"motion":this.processMotion(e,t,r);break;case"operator":this.processOperator(e,t,r);break;case"operatorMotion":this.processOperatorMotion(e,t,r);break;case"action":this.processAction(e,t,r);break;case"search":this.processSearch(e,t,r);break;case"ex":case"keyToEx":this.processEx(e,t,r);break;default:break}},processMotion:function(e,t,r){t.inputState.motion=r.motion;t.inputState.motionArgs=Me(r.motionArgs);this.evalInput(e,t)},processOperator:function(e,t,r){var n=t.inputState;if(n.operator){if(n.operator==r.operator){n.motion="expandToLine";n.motionArgs={linewise:true};this.evalInput(e,t);return}else{ce(e)}}n.operator=r.operator;n.operatorArgs=Me(r.operatorArgs);if(r.exitVisualBlock){t.visualBlock=false;Ue(e)}if(t.visualMode){this.evalInput(e,t)}},processOperatorMotion:function(e,t,r){var n=t.visualMode;var i=Me(r.operatorMotionArgs);if(i){if(n&&i.visualLine){t.visualLine=true}}this.processOperator(e,t,r);if(!n){this.processMotion(e,t,r)}},processAction:function(e,t,r){var n=t.inputState;var i=n.getRepeat();var a=!!i;var o=Me(r.actionArgs)||{};if(n.selectedCharacter){o.selectedCharacter=n.selectedCharacter}if(r.operator){this.processOperator(e,t,r)}if(r.motion){this.processMotion(e,t,r)}if(r.motion||r.operator){this.evalInput(e,t)}o.repeat=i||1;o.repeatIsExplicit=a;o.registerName=n.registerName;ce(e);t.lastMotion=null;if(r.isEdit){this.recordLastEdit(t,n,r)}Ce[r.action](e,o,t)},processSearch:function(e,t,r){if(!e.getSearchCursor){return}var n=r.searchArgs.forward;var i=r.searchArgs.wholeWordOnly;vt(e).setReversed(!n);var a=n?"/":"?";var o=vt(e).getQuery();var s=e.getScrollInfo();function l(n,i,a){ie.searchHistoryController.pushInput(n);ie.searchHistoryController.reset();try{Bt(e,n,i,a)}catch(t){Lt(e,"Invalid regex: "+n);ce(e);return}de.processMotion(e,t,{type:"motion",motion:"findNext",motionArgs:{forward:true,toJumplist:r.searchArgs.toJumplist}})}function c(t){e.scrollTo(s.left,s.top);l(t,true,true);var r=ie.macroModeState;if(r.isRecording){Xt(r,t)}}function u(t,r,i){var a=v.keyName(t),o,l;if(a=="Up"||a=="Down"){o=a=="Up"?true:false;l=t.target?t.target.selectionEnd:0;r=ie.searchHistoryController.nextMatch(r,o)||"";i(r);if(l&&t.target)t.target.selectionEnd=t.target.selectionStart=Math.min(l,t.target.value.length)}else{if(a!="Left"&&a!="Right"&&a!="Ctrl"&&a!="Alt"&&a!="Shift")ie.searchHistoryController.reset()}var c;try{c=Bt(e,r,true,true)}catch(t){}if(c){e.scrollIntoView(Nt(e,!n,c),30)}else{Pt(e);e.scrollTo(s.left,s.top)}}function f(t,r,n){var i=v.keyName(t);if(i=="Esc"||i=="Ctrl-C"||i=="Ctrl-["||i=="Backspace"&&r==""){ie.searchHistoryController.pushInput(r);ie.searchHistoryController.reset();Bt(e,o);Pt(e);e.scrollTo(s.left,s.top);v.e_stop(t);ce(e);n();e.focus()}else if(i=="Up"||i=="Down"){v.e_stop(t)}else if(i=="Ctrl-U"){v.e_stop(t);n("")}}switch(r.searchArgs.querySrc){case"prompt":var h=ie.macroModeState;if(h.isPlaying){var p=h.replaySearchQueries.shift();l(p,true,false)}else{Et(e,{onClose:c,prefix:a,desc:Tt,onKeyUp:u,onKeyDown:f})}break;case"wordUnderCursor":var d=Ze(e,false,true,false,true);var m=true;if(!d){d=Ze(e,false,true,false,false);m=false}if(!d){return}var p=e.getLine(d.start.line).substring(d.start.ch,d.end.ch);if(m&&i){p="\\b"+p+"\\b"}else{p=_e(p)}ie.jumpList.cachedCursor=e.getCursor();e.setCursor(d.start);l(p,true,false);break}},processEx:function(e,t,r){function n(t){ie.exCommandHistoryController.pushInput(t);ie.exCommandHistoryController.reset();Wt.processCommand(e,t)}function i(t,r,n){var i=v.keyName(t),a,o;if(i=="Esc"||i=="Ctrl-C"||i=="Ctrl-["||i=="Backspace"&&r==""){ie.exCommandHistoryController.pushInput(r);ie.exCommandHistoryController.reset();v.e_stop(t);ce(e);n();e.focus()}if(i=="Up"||i=="Down"){v.e_stop(t);a=i=="Up"?true:false;o=t.target?t.target.selectionEnd:0;r=ie.exCommandHistoryController.nextMatch(r,a)||"";n(r);if(o&&t.target)t.target.selectionEnd=t.target.selectionStart=Math.min(o,t.target.value.length)}else if(i=="Ctrl-U"){v.e_stop(t);n("")}else{if(i!="Left"&&i!="Right"&&i!="Ctrl"&&i!="Alt"&&i!="Shift")ie.exCommandHistoryController.reset()}}if(r.type=="keyToEx"){Wt.processCommand(e,r.exArgs.input)}else{if(t.visualMode){Et(e,{onClose:n,prefix:":",value:"'<,'>",onKeyDown:i,selectValueOnOpen:false})}else{Et(e,{onClose:n,prefix:":",onKeyDown:i})}}},evalInput:function(e,t){var r=t.inputState;var n=r.motion;var i=r.motionArgs||{};var a=r.operator;var o=r.operatorArgs||{};var s=r.registerName;var l=t.sel;var c=Te(t.visualMode?xe(e,l.head):e.getCursor("head"));var u=Te(t.visualMode?xe(e,l.anchor):e.getCursor("anchor"));var f=Te(c);var h=Te(u);var p,d;var v;if(a){this.recordLastEdit(t,r)}if(r.repeatOverride!==undefined){v=r.repeatOverride}else{v=r.getRepeat()}if(v>0&&i.explicitRepeat){i.repeatIsExplicit=true}else if(i.noRepeat||!i.explicitRepeat&&v===0){v=1;i.repeatIsExplicit=false}if(r.selectedCharacter){i.selectedCharacter=o.selectedCharacter=r.selectedCharacter}i.repeat=v;ce(e);if(n){var m=ve[n](e,c,i,t);t.lastMotion=ve[n];if(!m){return}if(i.toJumplist){if(!a&&e.ace.curOp!=null)e.ace.curOp.command.scrollIntoView="center-animate";var g=ie.jumpList;var y=g.cachedCursor;if(y){Ye(e,y,m);delete g.cachedCursor}else{Ye(e,c,m)}}if(m instanceof Array){d=m[0];p=m[1]}else{p=m}if(!p){p=Te(c)}if(t.visualMode){if(!(t.visualBlock&&p.ch===Infinity)){p=xe(e,p,t.visualBlock)}if(d){d=xe(e,d,true)}d=d||h;l.anchor=d;l.head=p;Ue(e);lt(e,t,"<",Re(d,p)?d:p);lt(e,t,">",Re(d,p)?p:d)}else if(!a){p=xe(e,p);e.setCursor(p.line,p.ch)}}if(a){if(o.lastSel){d=h;var k=o.lastSel;var C=Math.abs(k.head.line-k.anchor.line);var w=Math.abs(k.head.ch-k.anchor.ch);if(k.visualLine){p=x(h.line+C,h.ch)}else if(k.visualBlock){p=x(h.line+C,h.ch+w)}else if(k.head.line==k.anchor.line){p=x(h.line,h.ch+w)}else{p=x(h.line+C,h.ch)}t.visualMode=true;t.visualLine=k.visualLine;t.visualBlock=k.visualBlock;l=t.sel={anchor:d,head:p};Ue(e)}else if(t.visualMode){o.lastSel={anchor:Te(l.anchor),head:Te(l.head),visualBlock:t.visualBlock,visualLine:t.visualLine}}var M,S,A,b;var L;if(t.visualMode){M=Be(l.head,l.anchor);S=Ie(l.head,l.anchor);A=t.visualLine||o.linewise;b=t.visualBlock?"block":A?"line":"char";L=ze(e,{anchor:M,head:S},b);if(A){var O=L.ranges;if(b=="block"){for(var T=0;T<O.length;T++){O[T].head.ch=Ne(e,O[T].head.line)}}else if(b=="line"){O[0].head=x(O[0].head.line+1,0)}}}else{M=Te(d||h);S=Te(p||f);if(Re(S,M)){var E=M;M=S;S=E}A=i.linewise||o.linewise;if(A){Ge(e,M,S)}else if(i.forward){Qe(e,M,S)}b="char";var R=!i.inclusive||A;L=ze(e,{anchor:M,head:S},b,R)}e.setSelections(L.ranges,L.primary);t.lastMotion=null;o.repeat=v;o.registerName=s;o.linewise=A;var B=ye[a](e,o,L.ranges,h,p);if(t.visualMode){qe(e,B!=null)}if(B){e.setCursor(B)}}},recordLastEdit:function(e,t,r){var n=ie.macroModeState;if(n.isPlaying){return}e.lastEditInputState=t;e.lastEditActionCommand=r;n.lastInsertModeChanges.changes=[];n.lastInsertModeChanges.expectCursorActivityForChange=false;n.lastInsertModeChanges.visualBlock=e.visualBlock?e.sel.head.line-e.sel.anchor.line:0}};var ve={moveToTopLine:function(e,t,r){var n=Ht(e).top+r.repeat-1;return x(n,Xe(e.getLine(n)))},moveToMiddleLine:function(e){var t=Ht(e);var r=Math.floor((t.top+t.bottom)*.5);return x(r,Xe(e.getLine(r)))},moveToBottomLine:function(e,t,r){var n=Ht(e).bottom-r.repeat+1;return x(n,Xe(e.getLine(n)))},expandToLine:function(e,t,r){var n=t;return x(n.line+r.repeat-1,Infinity)},findNext:function(e,t,r){var n=vt(e);var i=n.getQuery();if(!i){return}var a=!r.forward;a=n.isReversed()?!a:a;Kt(e,i);return Nt(e,a,i,r.repeat)},goToMark:function(e,t,r,n){var i=Vt(e,n,r.selectedCharacter);if(i){return r.linewise?{line:i.line,ch:Xe(e.getLine(i.line))}:i}return null},moveToOtherHighlightedEnd:function(e,t,r,n){if(n.visualBlock&&r.sameLine){var i=n.sel;return[xe(e,x(i.anchor.line,i.head.ch)),xe(e,x(i.head.line,i.anchor.ch))]}else{return[n.sel.head,n.sel.anchor]}},jumpToMark:function(e,t,r,n){var i=t;for(var a=0;a<r.repeat;a++){var o=i;for(var s in n.marks){if(!W(s)){continue}var l=n.marks[s].find();var c=r.forward?Re(l,o):Re(o,l);if(c){continue}if(r.linewise&&l.line==o.line){continue}var u=Ee(o,i);var f=r.forward?Ke(o,l,i):Ke(i,l,o);if(u||f){i=l}}}if(r.linewise){i=x(i.line,Xe(e.getLine(i.line)))}return i},moveByCharacters:function(e,t,r){var n=t;var i=r.repeat;var a=r.forward?n.ch+i:n.ch-i;return x(n.line,a)},moveByLines:function(e,t,r,n){var i=t;var a=i.ch;switch(n.lastMotion){case this.moveByLines:case this.moveByDisplayLines:case this.moveByScroll:case this.moveToColumn:case this.moveToEol:a=n.lastHPos;break;default:n.lastHPos=a}var o=r.repeat+(r.repeatOffset||0);var s=r.forward?i.line+o:i.line-o;var l=e.firstLine();var c=e.lastLine();if(s<l&&i.line==l){return this.moveToStartOfLine(e,t,r,n)}else if(s>c&&i.line==c){return this.moveToEol(e,t,r,n,true)}var u=e.ace.session.getFoldLine(s);if(u){if(r.forward){if(s>u.start.row)s=u.end.row+1}else{s=u.start.row}}if(r.toFirstChar){a=Xe(e.getLine(s));n.lastHPos=a}n.lastHSPos=e.charCoords(x(s,a),"div").left;return x(s,a)},moveByDisplayLines:function(e,t,r,n){var i=t;switch(n.lastMotion){case this.moveByDisplayLines:case this.moveByScroll:case this.moveByLines:case this.moveToColumn:case this.moveToEol:break;default:n.lastHSPos=e.charCoords(i,"div").left}var a=r.repeat;var o=e.findPosV(i,r.forward?a:-a,"line",n.lastHSPos);if(o.hitSide){if(r.forward){var s=e.charCoords(o,"div");var l={top:s.top+8,left:n.lastHSPos};var o=e.coordsChar(l,"div")}else{var c=e.charCoords(x(e.firstLine(),0),"div");c.left=n.lastHSPos;o=e.coordsChar(c,"div")}}n.lastHPos=o.ch;return o},moveByPage:function(e,t,r){var n=t;var i=r.repeat;return e.findPosV(n,r.forward?i:-i,"page")},moveByParagraph:function(e,t,r){var n=r.forward?1:-1;return ut(e,t,r.repeat,n)},moveBySentence:function(e,t,r){var n=r.forward?1:-1;return ft(e,t,r.repeat,n)},moveByScroll:function(e,t,r,n){var i=e.getScrollInfo();var a=null;var o=r.repeat;if(!o){o=i.clientHeight/(2*e.defaultTextHeight())}var s=e.charCoords(t,"local");r.repeat=o;var a=ve.moveByDisplayLines(e,t,r,n);if(!a){return null}var l=e.charCoords(a,"local");e.scrollTo(null,i.top+l.top-s.top);return a},moveByWords:function(e,t,r){return at(e,t,r.repeat,!!r.forward,!!r.wordEnd,!!r.bigWord)},moveTillCharacter:function(e,t,r){var n=r.repeat;var i=ot(e,n,r.forward,r.selectedCharacter);var a=r.forward?-1:1;et(a,r);if(!i)return null;i.ch+=a;return i},moveToCharacter:function(e,t,r){var n=r.repeat;et(0,r);return ot(e,n,r.forward,r.selectedCharacter)||t},moveToSymbol:function(e,t,r){var n=r.repeat;return nt(e,n,r.forward,r.selectedCharacter)||t},moveToColumn:function(e,t,r,n){var i=r.repeat;n.lastHPos=i-1;n.lastHSPos=e.charCoords(t,"div").left;return st(e,i)},moveToEol:function(e,t,r,n,i){var a=t;var o=x(a.line+r.repeat-1,Infinity);var s=e.clipPos(o);s.ch--;if(!i){n.lastHPos=Infinity;n.lastHSPos=e.charCoords(s,"div").left}return o},moveToFirstNonWhiteSpaceCharacter:function(e,t){var r=t;return x(r.line,Xe(e.getLine(r.line)))},moveToMatchedSymbol:function(e,t){var r=t;var n=r.line;var i=r.ch;var a=e.getLine(n);var o;for(;i<a.length;i++){o=a.charAt(i);if(o&&F(o)){var s=e.getTokenTypeAt(x(n,i+1));if(s!=="string"&&s!=="comment"){break}}}if(i<a.length){var l=/[<>]/.test(a[i])?/[(){}[\]<>]/:/[(){}[\]]/;var c=e.findMatchingBracket(x(n,i+1),{bracketRegex:l});return c.to}else{return r}},moveToStartOfLine:function(e,t){return x(t.line,0)},moveToLineOrEdgeOfDocument:function(e,t,r){var n=r.forward?e.lastLine():e.firstLine();if(r.repeatIsExplicit){n=r.repeat-e.getOption("firstLineNumber")}return x(n,Xe(e.getLine(n)))},textObjectManipulation:function(e,t,r,n){var i={"(":")",")":"(","{":"}","}":"{","[":"]","]":"[","<":">",">":"<"};var a={"'":true,'"':true,"`":true};var o=r.selectedCharacter;if(o=="b"){o="("}else if(o=="B"){o="{"}var s=!r.textObjectInner;var l;if(i[o]){l=ht(e,t,o,s)}else if(a[o]){l=pt(e,t,o,s)}else if(o==="W"){l=Ze(e,s,true,true)}else if(o==="w"){l=Ze(e,s,true,false)}else if(o==="p"){l=ut(e,t,r.repeat,0,s);r.linewise=true;if(n.visualMode){if(!n.visualLine){n.visualLine=true}}else{var c=n.inputState.operatorArgs;if(c){c.linewise=true}l.end.line--}}else{return null}if(!e.state.vim.visualMode){return[l.start,l.end]}else{return Fe(e,l.start,l.end)}},repeatLastCharacterSearch:function(e,t,r){var n=ie.lastCharacterSearch;var i=r.repeat;var a=r.forward===n.forward;var o=(n.increment?1:0)*(a?-1:1);e.moveH(-o,"char");r.inclusive=a?true:false;var s=ot(e,i,a,n.selectedCharacter);if(!s){e.moveH(o,"char");return t}s.ch+=o;return s}};function me(e,t){ve[e]=t}function ge(e,t){var r=[];for(var n=0;n<t;n++){r.push(e)}return r}var ye={change:function(e,t,r){var n,i;var a=e.state.vim;var o=r[0].anchor,s=r[0].head;if(!a.visualMode){i=e.getRange(o,s);var l=a.lastEditInputState||{};if(l.motion=="moveByWords"&&!J(i)){var c=/\s+$/.exec(i);if(c&&l.motionArgs&&l.motionArgs.forward){s=Se(s,0,-c[0].length);i=i.slice(0,-c[0].length)}}var u=new x(o.line-1,Number.MAX_VALUE);var f=e.firstLine()==e.lastLine();if(s.line>e.lastLine()&&t.linewise&&!f){e.replaceRange("",u,s)}else{e.replaceRange("",o,s)}if(t.linewise){if(!f){e.setCursor(u);v.commands.newlineAndIndent(e)}o.ch=Number.MAX_VALUE}n=o}else if(t.fullLine){s.ch=Number.MAX_VALUE;s.line--;e.setSelection(o,s);i=e.getSelection();e.replaceSelection("");n=o}else{i=e.getSelection();var h=ge("",r.length);e.replaceSelections(h);n=Be(r[0].head,r[0].anchor)}ie.registerController.pushText(t.registerName,"change",i,t.linewise,r.length>1);Ce.enterInsertMode(e,{head:n},e.state.vim)},delete:function(e,t,r){var n,i;var a=e.state.vim;if(!a.visualBlock){var o=r[0].anchor,s=r[0].head;if(t.linewise&&s.line!=e.firstLine()&&o.line==e.lastLine()&&o.line==s.line-1){if(o.line==e.firstLine()){o.ch=0}else{o=x(o.line-1,Ne(e,o.line-1))}}i=e.getRange(o,s);e.replaceRange("",o,s);n=o;if(t.linewise){n=ve.moveToFirstNonWhiteSpaceCharacter(e,o)}}else{i=e.getSelection();var l=ge("",r.length);e.replaceSelections(l);n=r[0].anchor}ie.registerController.pushText(t.registerName,"delete",i,t.linewise,a.visualBlock);var c=a.insertMode;return xe(e,n,c)},indent:function(e,t,r){var n=e.state.vim;var i=r[0].anchor.line;var a=n.visualBlock?r[r.length-1].anchor.line:r[0].head.line;var o=n.visualMode?t.repeat:1;if(t.linewise){a--}for(var s=i;s<=a;s++){for(var l=0;l<o;l++){e.indentLine(s,t.indentRight)}}return ve.moveToFirstNonWhiteSpaceCharacter(e,r[0].anchor)},indentAuto:function(e,t,r){e.execCommand("indentAuto");return ve.moveToFirstNonWhiteSpaceCharacter(e,r[0].anchor)},changeCase:function(e,t,r,n,i){var a=e.getSelections();var o=[];var s=t.toLower;for(var l=0;l<a.length;l++){var c=a[l];var u="";if(s===true){u=c.toLowerCase()}else if(s===false){u=c.toUpperCase()}else{for(var f=0;f<c.length;f++){var h=c.charAt(f);u+=z(h)?h.toLowerCase():h.toUpperCase()}}o.push(u)}e.replaceSelections(o);if(t.shouldMoveCursor){return i}else if(!e.state.vim.visualMode&&t.linewise&&r[0].anchor.line+1==r[0].head.line){return ve.moveToFirstNonWhiteSpaceCharacter(e,n)}else if(t.linewise){return n}else{return Be(r[0].anchor,r[0].head)}},yank:function(e,t,r,n){var i=e.state.vim;var a=e.getSelection();var o=i.visualMode?Be(i.sel.anchor,i.sel.head,r[0].head,r[0].anchor):n;ie.registerController.pushText(t.registerName,"yank",a,t.linewise,i.visualBlock);return o}};function ke(e,t){ye[e]=t}var Ce={jumpListWalk:function(e,t,r){if(r.visualMode){return}var n=t.repeat;var i=t.forward;var a=ie.jumpList;var o=a.move(e,i?n:-n);var s=o?o.find():undefined;s=s?s:e.getCursor();e.setCursor(s);e.ace.curOp.command.scrollIntoView="center-animate"},scroll:function(e,t,r){if(r.visualMode){return}var n=t.repeat||1;var i=e.defaultTextHeight();var a=e.getScrollInfo().top;var o=i*n;var s=t.forward?a+o:a-o;var l=Te(e.getCursor());var c=e.charCoords(l,"local");if(t.forward){if(s>c.top){l.line+=(s-c.top)/i;l.line=Math.ceil(l.line);e.setCursor(l);c=e.charCoords(l,"local");e.scrollTo(null,c.top)}else{e.scrollTo(null,s)}}else{var u=s+e.getScrollInfo().clientHeight;if(u<c.bottom){l.line-=(c.bottom-u)/i;l.line=Math.floor(l.line);e.setCursor(l);c=e.charCoords(l,"local");e.scrollTo(null,c.bottom-e.getScrollInfo().clientHeight)}else{e.scrollTo(null,s)}}},scrollToCursor:function(e,t){var r=e.getCursor().line;var n=e.charCoords(x(r,0),"local");var i=e.getScrollInfo().clientHeight;var a=n.top;var o=n.bottom-a;switch(t.position){case"center":a=a-i/2+o;break;case"bottom":a=a-i+o;break}e.scrollTo(null,a)},replayMacro:function(e,t,r){var n=t.selectedCharacter;var i=t.repeat;var a=ie.macroModeState;if(n=="@"){n=a.latestRegister}else{a.latestRegister=n}while(i--){qt(e,r,a,n)}},enterMacroRecordMode:function(e,t){var r=ie.macroModeState;var n=t.selectedCharacter;if(ie.registerController.isValidRegister(n)){r.enterMacroRecordMode(e,n)}},toggleOverwrite:function(e){if(!e.state.overwrite){e.toggleOverwrite(true);e.setOption("keyMap","vim-replace");v.signal(e,"vim-mode-change",{mode:"replace"})}else{e.toggleOverwrite(false);e.setOption("keyMap","vim-insert");v.signal(e,"vim-mode-change",{mode:"insert"})}},enterInsertMode:function(e,t,r){if(e.getOption("readOnly")){return}r.insertMode=true;r.insertModeRepeat=t&&t.repeat||1;var n=t?t.insertAt:null;var i=r.sel;var a=t.head||e.getCursor("head");var o=e.listSelections().length;if(n=="eol"){a=x(a.line,Ne(e,a.line))}else if(n=="bol"){a=x(a.line,0)}else if(n=="charAfter"){a=Se(a,0,1)}else if(n=="firstNonBlank"){a=ve.moveToFirstNonWhiteSpaceCharacter(e,a)}else if(n=="startOfSelectedArea"){if(!r.visualMode)return;if(!r.visualBlock){if(i.head.line<i.anchor.line){a=i.head}else{a=x(i.anchor.line,0)}}else{a=x(Math.min(i.head.line,i.anchor.line),Math.min(i.head.ch,i.anchor.ch));o=Math.abs(i.head.line-i.anchor.line)+1}}else if(n=="endOfSelectedArea"){if(!r.visualMode)return;if(!r.visualBlock){if(i.head.line>=i.anchor.line){a=Se(i.head,0,1)}else{a=x(i.anchor.line,0)}}else{a=x(Math.min(i.head.line,i.anchor.line),Math.max(i.head.ch+1,i.anchor.ch));o=Math.abs(i.head.line-i.anchor.line)+1}}else if(n=="inplace"){if(r.visualMode){return}}else if(n=="lastEdit"){a=$t(e)||a}e.setOption("disableInput",false);if(t&&t.replace){e.toggleOverwrite(true);e.setOption("keyMap","vim-replace");v.signal(e,"vim-mode-change",{mode:"replace"})}else{e.toggleOverwrite(false);e.setOption("keyMap","vim-insert");v.signal(e,"vim-mode-change",{mode:"insert"})}if(!ie.macroModeState.isPlaying){e.on("change",Zt);v.on(e.getInputField(),"keydown",nr)}if(r.visualMode){qe(e)}$e(e,a,o)},toggleVisualMode:function(e,t,r){var n=t.repeat;var i=e.getCursor();var a;if(!r.visualMode){r.visualMode=true;r.visualLine=!!t.linewise;r.visualBlock=!!t.blockwise;a=xe(e,x(i.line,i.ch+n-1),true);r.sel={anchor:i,head:a};v.signal(e,"vim-mode-change",{mode:"visual",subMode:r.visualLine?"linewise":r.visualBlock?"blockwise":""});Ue(e);lt(e,r,"<",Be(i,a));lt(e,r,">",Ie(i,a))}else if(r.visualLine^t.linewise||r.visualBlock^t.blockwise){r.visualLine=!!t.linewise;r.visualBlock=!!t.blockwise;v.signal(e,"vim-mode-change",{mode:"visual",subMode:r.visualLine?"linewise":r.visualBlock?"blockwise":""});Ue(e)}else{qe(e)}},reselectLastSelection:function(e,t,r){var n=r.lastSelection;if(r.visualMode){We(e,r)}if(n){var i=n.anchorMark.find();var a=n.headMark.find();if(!i||!a){return}r.sel={anchor:i,head:a};r.visualMode=true;r.visualLine=n.visualLine;r.visualBlock=n.visualBlock;Ue(e);lt(e,r,"<",Be(i,a));lt(e,r,">",Ie(i,a));v.signal(e,"vim-mode-change",{mode:"visual",subMode:r.visualLine?"linewise":r.visualBlock?"blockwise":""})}},joinLines:function(e,t,r){var n,i;if(r.visualMode){n=e.getCursor("anchor");i=e.getCursor("head");if(Re(i,n)){var a=i;i=n;n=a}i.ch=Ne(e,i.line)-1}else{var o=Math.max(t.repeat,2);n=e.getCursor();i=xe(e,x(n.line+o-1,Infinity))}var s=0;for(var l=n.line;l<i.line;l++){s=Ne(e,n.line);var a=x(n.line+1,Ne(e,n.line+1));var c=e.getRange(n,a);c=t.keepSpaces?c.replace(/\n\r?/g,""):c.replace(/\n\s*/g," ");e.replaceRange(c,n,a)}var u=x(n.line,s);if(r.visualMode){qe(e,false)}e.setCursor(u)},newLineAndEnterInsertMode:function(e,t,r){r.insertMode=true;var n=Te(e.getCursor());if(n.line===e.firstLine()&&!t.after){e.replaceRange("\n",x(e.firstLine(),0));e.setCursor(e.firstLine(),0)}else{n.line=t.after?n.line:n.line-1;n.ch=Ne(e,n.line);e.setCursor(n);var i=v.commands.newlineAndIndentContinueComment||v.commands.newlineAndIndent;i(e)}this.enterInsertMode(e,{repeat:t.repeat},r)},paste:function(e,t,r){var n=Te(e.getCursor());var i=ie.registerController.getRegister(t.registerName);var a=i.toString();if(!a){return}if(t.matchIndent){var o=e.getOption("tabSize");var s=function(e){var t=e.split("\t").length-1;var r=e.split(" ").length-1;return t*o+r*1};var l=e.getLine(e.getCursor().line);var c=s(l.match(/^\s*/)[0]);var u=a.replace(/\n$/,"");var f=a!==u;var h=s(a.match(/^\s*/)[0]);var a=u.replace(/^\s*/gm,(function(t){var r=c+(s(t)-h);if(r<0){return""}else if(e.getOption("indentWithTabs")){var n=Math.floor(r/o);return Array(n+1).join("\t")}else{return Array(r+1).join(" ")}}));a+=f?"\n":""}if(t.repeat>1){var a=Array(t.repeat+1).join(a)}var p=i.linewise;var d=i.blockwise;if(d){a=a.split("\n");if(p){a.pop()}for(var v=0;v<a.length;v++){a[v]=a[v]==""?" ":a[v]}n.ch+=t.after?1:0;n.ch=Math.min(Ne(e,n.line),n.ch)}else if(p){if(r.visualMode){a=r.visualLine?a.slice(0,-1):"\n"+a.slice(0,a.length-1)+"\n"}else if(t.after){a="\n"+a.slice(0,a.length-1);n.ch=Ne(e,n.line)}else{n.ch=0}}else{n.ch+=t.after?1:0}var m;var g;if(r.visualMode){r.lastPastedText=a;var y;var k=De(e,r);var C=k[0];var w=k[1];var M=e.getSelection();var S=e.listSelections();var A=new Array(S.length).join("1").split("1");if(r.lastSelection){y=r.lastSelection.headMark.find()}ie.registerController.unnamedRegister.setText(M);if(d){e.replaceSelections(A);w=x(C.line+a.length-1,C.ch);e.setCursor(C);Ve(e,w);e.replaceSelections(a);m=C}else if(r.visualBlock){e.replaceSelections(A);e.setCursor(C);e.replaceRange(a,C,C);m=C}else{e.replaceRange(a,C,w);m=e.posFromIndex(e.indexFromPos(C)+a.length-1)}if(y){r.lastSelection.headMark=e.setBookmark(y)}if(p){m.ch=0}}else{if(d){e.setCursor(n);for(var v=0;v<a.length;v++){var b=n.line+v;if(b>e.lastLine()){e.replaceRange("\n",x(b,0))}var L=Ne(e,b);if(L<n.ch){He(e,b,n.ch)}}e.setCursor(n);Ve(e,x(n.line+a.length-1,n.ch));e.replaceSelections(a);m=n}else{e.replaceRange(a,n);if(p&&t.after){m=x(n.line+1,Xe(e.getLine(n.line+1)))}else if(p&&!t.after){m=x(n.line,Xe(e.getLine(n.line)))}else if(!p&&t.after){g=e.indexFromPos(n);m=e.posFromIndex(g+a.length-1)}else{g=e.indexFromPos(n);m=e.posFromIndex(g+a.length)}}}if(r.visualMode){qe(e,false)}e.setCursor(m)},undo:function(e,t){e.operation((function(){Oe(e,v.commands.undo,t.repeat)();e.setCursor(e.getCursor("anchor"))}))},redo:function(e,t){Oe(e,v.commands.redo,t.repeat)()},setRegister:function(e,t,r){r.inputState.registerName=t.selectedCharacter},setMark:function(e,t,r){var n=t.selectedCharacter;lt(e,r,n,e.getCursor())},replace:function(e,t,r){var n=t.selectedCharacter;var i=e.getCursor();var a;var o;var s=e.listSelections();if(r.visualMode){i=e.getCursor("start");o=e.getCursor("end")}else{var l=e.getLine(i.line);a=i.ch+t.repeat;if(a>l.length){a=l.length}o=x(i.line,a)}if(n=="\n"){if(!r.visualMode)e.replaceRange("",i,o);(v.commands.newlineAndIndentContinueComment||v.commands.newlineAndIndent)(e)}else{var c=e.getRange(i,o);c=c.replace(/[^\n]/g,n);if(r.visualBlock){var u=new Array(e.getOption("tabSize")+1).join(" ");c=e.getSelection();c=c.replace(/\t/g,u).replace(/[^\n]/g,n).split("\n");e.replaceSelections(c)}else{e.replaceRange(c,i,o)}if(r.visualMode){i=Re(s[0].anchor,s[0].head)?s[0].anchor:s[0].head;e.setCursor(i);qe(e,false)}else{e.setCursor(Se(o,0,-1))}}},incrementNumberToken:function(e,t){var r=e.getCursor();var n=e.getLine(r.line);var i=/(-?)(?:(0x)([\da-f]+)|(0b|0|)(\d+))/gi;var a;var o;var s;var l;while((a=i.exec(n))!==null){o=a.index;s=o+a[0].length;if(r.ch<s)break}if(!t.backtrack&&s<=r.ch)return;if(a){var c=a[2]||a[4];var u=a[3]||a[5];var f=t.increase?1:-1;var h={"0b":2,0:8,"":10,"0x":16}[c.toLowerCase()];var p=parseInt(a[1]+u,h)+f*t.repeat;l=p.toString(h);var d=c?new Array(u.length-l.length+1+a[1].length).join("0"):"";if(l.charAt(0)==="-"){l="-"+c+d+l.substr(1)}else{l=c+d+l}var v=x(r.line,o);var m=x(r.line,s);e.replaceRange(l,v,m)}else{return}e.setCursor(x(r.line,o+l.length-1))},repeatLastEdit:function(e,t,r){var n=r.lastEditInputState;if(!n){return}var i=t.repeat;if(i&&t.repeatIsExplicit){r.lastEditInputState.repeatOverride=i}else{i=r.lastEditInputState.repeatOverride||i}ir(e,r,i,false)},indent:function(e,t){e.indentLine(e.getCursor().line,t.indentRight)},exitInsertMode:Ut};function we(e,t){Ce[e]=t}function xe(e,t,r){var n=Math.min(Math.max(e.firstLine(),t.line),e.lastLine());var i=Ne(e,n)-1;i=r?i+1:i;var a=Math.min(Math.max(0,t.ch),i);return x(n,a)}function Me(e){var t={};for(var r in e){if(e.hasOwnProperty(r)){t[r]=e[r]}}return t}function Se(e,t,r){if(typeof t==="object"){r=t.ch;t=t.line}return x(e.line+t,e.ch+r)}function Ae(e,t,r,n){var i,a=[],o=[];for(var s=0;s<t.length;s++){var l=t[s];if(r=="insert"&&l.context!="insert"||l.context&&l.context!=r||n.operator&&l.type=="action"||!(i=be(e,l.keys))){continue}if(i=="partial"){a.push(l)}if(i=="full"){o.push(l)}}return{partial:a.length&&a,full:o.length&&o}}function be(e,t){if(t.slice(-11)=="<character>"){var r=t.length-11;var n=e.slice(0,r);var i=t.slice(0,r);return n==i&&e.length>r?"full":i.indexOf(n)==0?"partial":false}else{return e==t?"full":t.indexOf(e)==0?"partial":false}}function Le(e){var t=/^.*(<[^>]+>)$/.exec(e);var r=t?t[1]:e.slice(-1);if(r.length>1){switch(r){case"<CR>":r="\n";break;case"<Space>":r=" ";break;default:r="";break}}return r}function Oe(e,t,r){return function(){for(var n=0;n<r;n++){t(e)}}}function Te(e){return x(e.line,e.ch)}function Ee(e,t){return e.ch==t.ch&&e.line==t.line}function Re(e,t){if(e.line<t.line){return true}if(e.line==t.line&&e.ch<t.ch){return true}return false}function Be(e,t){if(arguments.length>2){t=Be.apply(undefined,Array.prototype.slice.call(arguments,1))}return Re(e,t)?e:t}function Ie(e,t){if(arguments.length>2){t=Ie.apply(undefined,Array.prototype.slice.call(arguments,1))}return Re(e,t)?t:e}function Ke(e,t,r){var n=Re(e,t);var i=Re(t,r);return n&&i}function Ne(e,t){return e.getLine(t).length}function Pe(e){if(e.trim){return e.trim()}return e.replace(/^\s+|\s+$/g,"")}function _e(e){return e.replace(/([.?*+$\[\]\/\\(){}|\-])/g,"\\$1")}function He(e,t,r){var n=Ne(e,t);var i=new Array(r-n+1).join(" ");e.setCursor(x(t,n));e.replaceRange(i,e.getCursor())}function Ve(e,t){var r=[],n=e.listSelections();var i=Te(e.clipPos(t));var a=!Ee(t,i);var o=e.getCursor("head");var s=je(n,o);var l=Ee(n[s].head,n[s].anchor);var c=n.length-1;var u=c-s>s?c:0;var f=n[u].anchor;var h=Math.min(f.line,i.line);var p=Math.max(f.line,i.line);var d=f.ch,v=i.ch;var m=n[u].head.ch-d;var g=v-d;if(m>0&&g<=0){d++;if(!a){v--}}else if(m<0&&g>=0){d--;if(!l){v++}}else if(m<0&&g==-1){d--;v++}for(var y=h;y<=p;y++){var k={anchor:new x(y,d),head:new x(y,v)};r.push(k)}e.setSelections(r);t.ch=v;f.ch=d;return f}function $e(e,t,r){var n=[];for(var i=0;i<r;i++){var a=Se(t,i,0);n.push({anchor:a,head:a})}e.setSelections(n,0)}function je(e,t,r){for(var n=0;n<e.length;n++){var i=r!="head"&&Ee(e[n].anchor,t);var a=r!="anchor"&&Ee(e[n].head,t);if(i||a){return n}}return-1}function De(e,t){var r=t.lastSelection;var n=function(){var t=e.listSelections();var r=t[0];var n=t[t.length-1];var i=Re(r.anchor,r.head)?r.anchor:r.head;var a=Re(n.anchor,n.head)?n.head:n.anchor;return[i,a]};var i=function(){var t=e.getCursor();var n=e.getCursor();var i=r.visualBlock;if(i){var a=i.width;var o=i.height;n=x(t.line+o,t.ch+a);var s=[];for(var l=t.line;l<n.line;l++){var c=x(l,t.ch);var u=x(l,n.ch);var f={anchor:c,head:u};s.push(f)}e.setSelections(s)}else{var h=r.anchorMark.find();var p=r.headMark.find();var d=p.line-h.line;var v=p.ch-h.ch;n={line:n.line+d,ch:d?n.ch:v+n.ch};if(r.visualLine){t=x(t.line,0);n=x(n.line,Ne(e,n.line))}e.setSelection(t,n)}return[t,n]};if(!t.visualMode){return i()}else{return n()}}function We(e,t){var r=t.sel.anchor;var n=t.sel.head;if(t.lastPastedText){n=e.posFromIndex(e.indexFromPos(r)+t.lastPastedText.length);t.lastPastedText=null}t.lastSelection={anchorMark:e.setBookmark(r),headMark:e.setBookmark(n),anchor:Te(r),head:Te(n),visualMode:t.visualMode,visualLine:t.visualLine,visualBlock:t.visualBlock}}function Fe(e,t,r){var n=e.state.vim.sel;var i=n.head;var a=n.anchor;var o;if(Re(r,t)){o=r;r=t;t=o}if(Re(i,a)){i=Be(t,i);a=Ie(a,r)}else{a=Be(t,a);i=Ie(i,r);i=Se(i,0,-1);if(i.ch==-1&&i.line!=e.firstLine()){i=x(i.line-1,Ne(e,i.line-1))}}return[a,i]}function Ue(e,t,r){var n=e.state.vim;t=t||n.sel;var r=r||n.visualLine?"line":n.visualBlock?"block":"char";var i=ze(e,t,r);e.setSelections(i.ranges,i.primary);er(e)}function ze(e,t,r,n){var i=Te(t.head);var a=Te(t.anchor);if(r=="char"){var o=!n&&!Re(t.head,t.anchor)?1:0;var s=Re(t.head,t.anchor)?1:0;i=Se(t.head,0,o);a=Se(t.anchor,0,s);return{ranges:[{anchor:a,head:i}],primary:0}}else if(r=="line"){if(!Re(t.head,t.anchor)){a.ch=0;var l=e.lastLine();if(i.line>l){i.line=l}i.ch=Ne(e,i.line)}else{i.ch=0;a.ch=Ne(e,a.line)}return{ranges:[{anchor:a,head:i}],primary:0}}else if(r=="block"){var c=Math.min(a.line,i.line),u=Math.min(a.ch,i.ch),f=Math.max(a.line,i.line),h=Math.max(a.ch,i.ch)+1;var p=f-c+1;var d=i.line==c?0:p-1;var v=[];for(var m=0;m<p;m++){v.push({anchor:x(c+m,u),head:x(c+m,h)})}return{ranges:v,primary:d}}}function Je(e){var t=e.getCursor("head");if(e.getSelection().length==1){t=Be(t,e.getCursor("anchor"))}return t}function qe(e,t){var r=e.state.vim;if(t!==false){e.setCursor(xe(e,r.sel.head))}We(e,r);r.visualMode=false;r.visualLine=false;r.visualBlock=false;v.signal(e,"vim-mode-change",{mode:"normal"});if(r.fakeCursor){r.fakeCursor.clear()}}function Qe(e,t,r){var n=e.getRange(t,r);if(/\n\s*$/.test(n)){var i=n.split("\n");i.pop();var a;for(var a=i.pop();i.length>0&&a&&J(a);a=i.pop()){r.line--;r.ch=0}if(a){r.line--;r.ch=Ne(e,r.line)}else{r.ch=0}}}function Ge(e,t,r){t.ch=0;r.ch=0;r.line++}function Xe(e){if(!e){return 0}var t=e.search(/\S/);return t==-1?e.length:t}function Ze(e,t,r,n,i){var a=Je(e);var o=e.getLine(a.line);var s=a.ch;var l=i?K[0]:N[0];while(!l(o.charAt(s))){s++;if(s>=o.length){return null}}if(n){l=N[0]}else{l=K[0];if(!l(o.charAt(s))){l=K[1]}}var c=s,u=s;while(l(o.charAt(c))&&c<o.length){c++}while(l(o.charAt(u))&&u>=0){u--}u++;if(t){var f=c;while(/\s/.test(o.charAt(c))&&c<o.length){c++}if(f==c){var h=u;while(/\s/.test(o.charAt(u-1))&&u>0){u--}if(!u){u=h}}}return{start:x(a.line,u),end:x(a.line,c)}}function Ye(e,t,r){if(!Ee(t,r)){ie.jumpList.add(e,t,r)}}function et(e,t){ie.lastCharacterSearch.increment=e;ie.lastCharacterSearch.forward=t.forward;ie.lastCharacterSearch.selectedCharacter=t.selectedCharacter}var tt={"(":"bracket",")":"bracket","{":"bracket","}":"bracket","[":"section","]":"section","*":"comment","/":"comment",m:"method",M:"method","#":"preprocess"};var rt={bracket:{isComplete:function(e){if(e.nextCh===e.symb){e.depth++;if(e.depth>=1)return true}else if(e.nextCh===e.reverseSymb){e.depth--}return false}},section:{init:function(e){e.curMoveThrough=true;e.symb=(e.forward?"]":"[")===e.symb?"{":"}"},isComplete:function(e){return e.index===0&&e.nextCh===e.symb}},comment:{isComplete:function(e){var t=e.lastCh==="*"&&e.nextCh==="/";e.lastCh=e.nextCh;return t}},method:{init:function(e){e.symb=e.symb==="m"?"{":"}";e.reverseSymb=e.symb==="{"?"}":"{"},isComplete:function(e){if(e.nextCh===e.symb)return true;return false}},preprocess:{init:function(e){e.index=0},isComplete:function(e){if(e.nextCh==="#"){var t=e.lineText.match(/#(\w+)/)[1];if(t==="endif"){if(e.forward&&e.depth===0){return true}e.depth++}else if(t==="if"){if(!e.forward&&e.depth===0){return true}e.depth--}if(t==="else"&&e.depth===0)return true}return false}}};function nt(e,t,r,n){var i=Te(e.getCursor());var a=r?1:-1;var o=r?e.lineCount():-1;var s=i.ch;var l=i.line;var c=e.getLine(l);var u={lineText:c,nextCh:c.charAt(s),lastCh:null,index:s,symb:n,reverseSymb:(r?{")":"(","}":"{"}:{"(":")","{":"}"})[n],forward:r,depth:0,curMoveThrough:false};var f=tt[n];if(!f)return i;var h=rt[f].init;var p=rt[f].isComplete;if(h){h(u)}while(l!==o&&t){u.index+=a;u.nextCh=u.lineText.charAt(u.index);if(!u.nextCh){l+=a;u.lineText=e.getLine(l)||"";if(a>0){u.index=0}else{var d=u.lineText.length;u.index=d>0?d-1:0}u.nextCh=u.lineText.charAt(u.index)}if(p(u)){i.line=l;i.ch=u.index;t--}}if(u.nextCh||u.curMoveThrough){return x(l,u.index)}return i}function it(e,t,r,n,i){var a=t.line;var o=t.ch;var s=e.getLine(a);var l=r?1:-1;var c=n?N:K;if(i&&s==""){a+=l;s=e.getLine(a);if(!D(e,a)){return null}o=r?0:s.length}while(true){if(i&&s==""){return{from:0,to:0,line:a}}var u=l>0?s.length:-1;var f=u,h=u;while(o!=u){var p=false;for(var d=0;d<c.length&&!p;++d){if(c[d](s.charAt(o))){f=o;while(o!=u&&c[d](s.charAt(o))){o+=l}h=o;p=f!=h;if(f==t.ch&&a==t.line&&h==f+l){continue}else{return{from:Math.min(f,h+1),to:Math.max(f,h),line:a}}}}if(!p){o+=l}}a+=l;if(!D(e,a)){return null}s=e.getLine(a);o=l>0?0:s.length}}function at(e,t,r,n,i,a){var o=Te(t);var s=[];if(n&&!i||!n&&i){r++}var l=!(n&&i);for(var c=0;c<r;c++){var u=it(e,t,n,a,l);if(!u){var f=Ne(e,e.lastLine());s.push(n?{line:e.lastLine(),from:f,to:f}:{line:0,from:0,to:0});break}s.push(u);t=x(u.line,n?u.to-1:u.from)}var h=s.length!=r;var p=s[0];var d=s.pop();if(n&&!i){if(!h&&(p.from!=o.ch||p.line!=o.line)){d=s.pop()}return x(d.line,d.from)}else if(n&&i){return x(d.line,d.to-1)}else if(!n&&i){if(!h&&(p.to!=o.ch||p.line!=o.line)){d=s.pop()}return x(d.line,d.to)}else{return x(d.line,d.from)}}function ot(e,t,r,n){var i=e.getCursor();var a=i.ch;var o;for(var s=0;s<t;s++){var l=e.getLine(i.line);o=ct(a,l,n,r,true);if(o==-1){return null}a=o}return x(e.getCursor().line,o)}function st(e,t){var r=e.getCursor().line;return xe(e,x(r,t-1))}function lt(e,t,r,n){if(!Q(r,$)){return}if(t.marks[r]){t.marks[r].clear()}t.marks[r]=e.setBookmark(n)}function ct(e,t,r,n,i){var a;if(n){a=t.indexOf(r,e+1);if(a!=-1&&!i){a-=1}}else{a=t.lastIndexOf(r,e-1);if(a!=-1&&!i){a+=1}}return a}function ut(e,t,r,n,i){var a=t.line;var o=e.firstLine();var s=e.lastLine();var l,c,u=a;function f(t){return!/\S/.test(e.getLine(t))}function h(e,t,r){if(r){return f(e)!=f(e+t)}return!f(e)&&f(e+t)}function p(t){n=n>0?1:-1;var r=e.ace.session.getFoldLine(t);if(r){if(t+n>r.start.row&&t+n<r.end.row)n=(n>0?r.end.row:r.start.row)-t}}if(n){while(o<=u&&u<=s&&r>0){p(u);if(h(u,n)){r--}u+=n}return new x(u,0)}var d=e.state.vim;if(d.visualLine&&h(a,1,true)){var v=d.sel.anchor;if(h(v.line,-1,true)){if(!i||v.line!=a){a+=1}}}var m=f(a);for(u=a;u<=s&&r;u++){if(h(u,1,true)){if(!i||f(u)!=m){r--}}}c=new x(u,0);if(u>s&&!m){m=true}else{i=false}for(u=a;u>o;u--){if(!i||f(u)==m||u==a){if(h(u,-1,true)){break}}}l=new x(u,0);return{start:l,end:c}}function ft(e,t,r,n){function i(e,t){if(t.pos+t.dir<0||t.pos+t.dir>=t.line.length){t.ln+=t.dir;if(!D(e,t.ln)){t.line=null;t.ln=null;t.pos=null;return}t.line=e.getLine(t.ln);t.pos=t.dir>0?0:t.line.length-1}else{t.pos+=t.dir}}function a(e,t,r,n){var a=e.getLine(t);var o=a==="";var s={line:a,ln:t,pos:r,dir:n};var l={ln:s.ln,pos:s.pos};var c=s.line==="";i(e,s);while(s.line!==null){l.ln=s.ln;l.pos=s.pos;if(s.line===""&&!c){return{ln:s.ln,pos:s.pos}}else if(o&&s.line!==""&&!J(s.line[s.pos])){return{ln:s.ln,pos:s.pos}}else if(q(s.line[s.pos])&&!o&&(s.pos===s.line.length-1||J(s.line[s.pos+1]))){o=true}i(e,s)}var a=e.getLine(l.ln);l.pos=0;for(var u=a.length-1;u>=0;--u){if(!J(a[u])){l.pos=u;break}}return l}function o(e,t,r,n){var a=e.getLine(t);var o={line:a,ln:t,pos:r,dir:n};var s={ln:o.ln,pos:null};var l=o.line==="";i(e,o);while(o.line!==null){if(o.line===""&&!l){if(s.pos!==null){return s}else{return{ln:o.ln,pos:o.pos}}}else if(q(o.line[o.pos])&&s.pos!==null&&!(o.ln===s.ln&&o.pos+1===s.pos)){return s}else if(o.line!==""&&!J(o.line[o.pos])){l=false;s={ln:o.ln,pos:o.pos}}i(e,o)}var a=e.getLine(s.ln);s.pos=0;for(var c=0;c<a.length;++c){if(!J(a[c])){s.pos=c;break}}return s}var s={ln:t.line,pos:t.ch};while(r>0){if(n<0){s=o(e,s.ln,s.pos,n)}else{s=a(e,s.ln,s.pos,n)}r--}return x(s.ln,s.pos)}function ht(e,t,r,n){var i=t,a,o;var s={"(":/[()]/,")":/[()]/,"[":/[[\]]/,"]":/[[\]]/,"{":/[{}]/,"}":/[{}]/,"<":/[<>]/,">":/[<>]/}[r];var l={"(":"(",")":"(","[":"[","]":"[","{":"{","}":"{","<":"<",">":"<"}[r];var c=e.getLine(i.line).charAt(i.ch);var u=c===l?1:0;a=e.scanForBracket(x(i.line,i.ch+u),-1,undefined,{bracketRegex:s});o=e.scanForBracket(x(i.line,i.ch+u),1,undefined,{bracketRegex:s});if(!a||!o){return{start:i,end:i}}a=a.pos;o=o.pos;if(a.line==o.line&&a.ch>o.ch||a.line>o.line){var f=a;a=o;o=f}if(n){o.ch+=1}else{a.ch+=1}return{start:a,end:o}}function pt(e,t,r,n){var i=Te(t);var a=e.getLine(i.line);var o=a.split("");var s,l,c,u;var f=o.indexOf(r);if(i.ch<f){i.ch=f}else if(f<i.ch&&o[i.ch]==r){l=i.ch;--i.ch}if(o[i.ch]==r&&!l){s=i.ch+1}else{for(c=i.ch;c>-1&&!s;c--){if(o[c]==r){s=c+1}}}if(s&&!l){for(c=s,u=o.length;c<u&&!l;c++){if(o[c]==r){l=c}}}if(!s||!l){return{start:i,end:i}}if(n){--s;++l}return{start:x(i.line,s),end:x(i.line,l)}}X("pcre",true,"boolean");function dt(){}dt.prototype={getQuery:function(){return ie.query},setQuery:function(e){ie.query=e},getOverlay:function(){return this.searchOverlay},setOverlay:function(e){this.searchOverlay=e},isReversed:function(){return ie.isReversed},setReversed:function(e){ie.isReversed=e},getScrollbarAnnotate:function(){return this.annotate},setScrollbarAnnotate:function(e){this.annotate=e}};function vt(e){var t=e.state.vim;return t.searchState_||(t.searchState_=new dt)}function mt(e,t,r,n,i){if(e.openDialog){e.openDialog(t,n,{bottom:true,value:i.value,onKeyDown:i.onKeyDown,onKeyUp:i.onKeyUp,selectValueOnOpen:false,onClose:function(){if(e.state.vim){e.state.vim.status="";e.ace.renderer.$loop.schedule(e.ace.renderer.CHANGE_CURSOR)}}})}else{n(prompt(r,""))}}function gt(e){return kt(e,"/")}function yt(e){return Ct(e,"/")}function kt(e,t){var r=Ct(e,t)||[];if(!r.length)return[];var n=[];if(r[0]!==0)return;for(var i=0;i<r.length;i++){if(typeof r[i]=="number")n.push(e.substring(r[i]+1,r[i+1]))}return n}function Ct(e,t){if(!t)t="/";var r=false;var n=[];for(var i=0;i<e.length;i++){var a=e.charAt(i);if(!r&&a==t){n.push(i)}r=!r&&a=="\\"}return n}function wt(e){var t="|(){";var r="}";var n=false;var i=[];for(var a=-1;a<e.length;a++){var o=e.charAt(a)||"";var s=e.charAt(a+1)||"";var l=s&&t.indexOf(s)!=-1;if(n){if(o!=="\\"||!l){i.push(o)}n=false}else{if(o==="\\"){n=true;if(s&&r.indexOf(s)!=-1){l=true}if(!l||s==="\\"){i.push(o)}}else{i.push(o);if(l&&s!=="\\"){i.push("\\")}}}}return i.join("")}var xt={"\\n":"\n","\\r":"\r","\\t":"\t"};function Mt(e){var t=false;var r=[];for(var n=-1;n<e.length;n++){var i=e.charAt(n)||"";var a=e.charAt(n+1)||"";if(xt[i+a]){r.push(xt[i+a]);n++}else if(t){r.push(i);t=false}else{if(i==="\\"){t=true;if(U(a)||a==="$"){r.push("$")}else if(a!=="/"&&a!=="\\"){r.push("\\")}}else{if(i==="$"){r.push("$")}r.push(i);if(a==="/"){r.push("\\")}}}}return r.join("")}var St={"\\/":"/","\\\\":"\\","\\n":"\n","\\r":"\r","\\t":"\t"};function At(e){var t=new v.StringStream(e);var r=[];while(!t.eol()){while(t.peek()&&t.peek()!="\\"){r.push(t.next())}var n=false;for(var i in St){if(t.match(i,true)){n=true;r.push(St[i]);break}}if(!n){r.push(t.next())}}return r.join("")}function bt(e,t,r){var n=ie.registerController.getRegister("/");n.setText(e);if(e instanceof RegExp){return e}var i=yt(e);var a;var o;if(!i.length){a=e}else{a=e.substring(0,i[0]);var s=e.substring(i[0]);o=s.indexOf("i")!=-1}if(!a){return null}if(!Y("pcre")){a=wt(a)}if(r){t=/^[^A-Z]*$/.test(a)}var l=new RegExp(a,t||o?"i":undefined);return l}function Lt(e,t){if(e.openNotification){e.openNotification('<span style="color: red">'+t+"</span>",{bottom:true,duration:5e3})}else{alert(t)}}function Ot(e,t){var r='<span style="font-family: monospace; white-space: pre">'+(e||"")+'<input type="text" autocorrect="off" autocapitalize="none" autocomplete="off"></span>';if(t)r+=' <span style="color: #888">'+t+"</span>";return r}var Tt="(Javascript regexp)";function Et(e,t){var r=(t.prefix||"")+" "+(t.desc||"");var n=Ot(t.prefix,t.desc);mt(e,n,r,t.onClose,t)}function Rt(e,t){if(e instanceof RegExp&&t instanceof RegExp){var r=["global","multiline","ignoreCase","source"];for(var n=0;n<r.length;n++){var i=r[n];if(e[i]!==t[i]){return false}}return true}return false}function Bt(e,t,r,n){if(!t){return}var i=vt(e);var a=bt(t,!!r,!!n);if(!a){return}Kt(e,a);if(Rt(a,i.getQuery())){return a}i.setQuery(a);return a}function It(e){if(e.source.charAt(0)=="^"){var t=true}return{token:function(r){if(t&&!r.sol()){r.skipToEnd();return}var n=r.match(e,false);if(n){if(n[0].length==0){r.next();return"searching"}if(!r.sol()){r.backUp(1);if(!e.exec(r.next()+n[0])){r.next();return null}}r.match(e);return"searching"}while(!r.eol()){r.next();if(r.match(e,false))break}},query:e}}function Kt(e,t){var r=vt(e);var n=r.getOverlay();if(!n||t!=n.query){if(n){e.removeOverlay(n)}n=It(t);e.addOverlay(n);if(e.showMatchesOnScrollbar){if(r.getScrollbarAnnotate()){r.getScrollbarAnnotate().clear()}r.setScrollbarAnnotate(e.showMatchesOnScrollbar(t))}r.setOverlay(n)}}function Nt(e,t,r,n){if(n===undefined){n=1}return e.operation((function(){var i=e.getCursor();var a=e.getSearchCursor(r,i);for(var o=0;o<n;o++){var s=a.find(t);if(o==0&&s&&Ee(a.from(),i)){s=a.find(t)}if(!s){a=e.getSearchCursor(r,t?x(e.lastLine()):x(e.firstLine(),0));if(!a.find(t)){return}}}return a.from()}))}function Pt(e){var t=vt(e);e.removeOverlay(vt(e).getOverlay());t.setOverlay(null);if(t.getScrollbarAnnotate()){t.getScrollbarAnnotate().clear();t.setScrollbarAnnotate(null)}}function _t(e,t,r){if(typeof e!="number"){e=e.line}if(t instanceof Array){return Q(e,t)}else{if(r){return e>=t&&e<=r}else{return e==t}}}function Ht(e){var t=e.ace.renderer;return{top:t.getFirstFullyVisibleRow(),bottom:t.getLastFullyVisibleRow()}}function Vt(e,t,r){if(r=="'"||r=="`"){return ie.jumpList.find(e,-1)||x(0,0)}else if(r=="."){return $t(e)}var n=t.marks[r];return n&&n.find()}function $t(e){var t=e.ace.session.$undoManager;if(t&&t.$lastDelta)return g(t.$lastDelta.end)}var jt=function(){this.buildCommandMap_()};jt.prototype={processCommand:function(e,t,r){var n=this;e.operation((function(){e.curOp.isVimOp=true;n._processCommand(e,t,r)}))},_processCommand:function(e,t,r){var n=e.state.vim;var i=ie.registerController.getRegister(":");var a=i.toString();if(n.visualMode){qe(e)}var o=new v.StringStream(t);i.setText(t);var s=r||{};s.input=t;try{this.parseInput_(e,o,s)}catch(t){Lt(e,t);throw t}var l;var c;if(!s.commandName){if(s.line!==undefined){c="move"}}else{l=this.matchCommand_(s.commandName);if(l){c=l.name;if(l.excludeFromCommandHistory){i.setText(a)}this.parseCommandArgs_(o,s,l);if(l.type=="exToKey"){for(var u=0;u<l.toKeys.length;u++){v.Vim.handleKey(e,l.toKeys[u],"mapping")}return}else if(l.type=="exToEx"){this.processCommand(e,l.toInput);return}}}if(!c){Lt(e,'Not an editor command ":'+t+'"');return}try{Dt[c](e,s);if((!l||!l.possiblyAsync)&&s.callback){s.callback()}}catch(t){Lt(e,t);throw t}},parseInput_:function(e,t,r){t.eatWhile(":");if(t.eat("%")){r.line=e.firstLine();r.lineEnd=e.lastLine()}else{r.line=this.parseLineSpec_(e,t);if(r.line!==undefined&&t.eat(",")){r.lineEnd=this.parseLineSpec_(e,t)}}var n=t.match(/^(\w+)/);if(n){r.commandName=n[1]}else{r.commandName=t.match(/.*/)[0]}return r},parseLineSpec_:function(e,t){var r=t.match(/^(\d+)/);if(r){return parseInt(r[1],10)-1}switch(t.next()){case".":return this.parseLineSpecOffset_(t,e.getCursor().line);case"$":return this.parseLineSpecOffset_(t,e.lastLine());case"'":var n=t.next();var i=Vt(e,e.state.vim,n);if(!i)throw new Error("Mark not set");return this.parseLineSpecOffset_(t,i.line);case"-":case"+":t.backUp(1);return this.parseLineSpecOffset_(t,e.getCursor().line);default:t.backUp(1);return undefined}},parseLineSpecOffset_:function(e,t){var r=e.match(/^([+-])?(\d+)/);if(r){var n=parseInt(r[2],10);if(r[1]=="-"){t-=n}else{t+=n}}return t},parseCommandArgs_:function(e,t,r){if(e.eol()){return}t.argString=e.match(/.*/)[0];var n=r.argDelimiter||/\s+/;var i=Pe(t.argString).split(n);if(i.length&&i[0]){t.args=i}},matchCommand_:function(e){for(var t=e.length;t>0;t--){var r=e.substring(0,t);if(this.commandMap_[r]){var n=this.commandMap_[r];if(n.name.indexOf(e)===0){return n}}}return null},buildCommandMap_:function(){this.commandMap_={};for(var e=0;e<w.length;e++){var t=w[e];var r=t.shortName||t.name;this.commandMap_[r]=t}},map:function(e,t,r){if(e!=":"&&e.charAt(0)==":"){if(r){throw Error("Mode not supported for ex mappings")}var n=e.substring(1);if(t!=":"&&t.charAt(0)==":"){this.commandMap_[n]={name:n,type:"exToEx",toInput:t.substring(1),user:true}}else{this.commandMap_[n]={name:n,type:"exToKey",toKeys:t,user:true}}}else{if(t!=":"&&t.charAt(0)==":"){var i={keys:e,type:"keyToEx",exArgs:{input:t.substring(1)}};if(r){i.context=r}k.unshift(i)}else{var i={keys:e,type:"keyToKey",toKeys:t};if(r){i.context=r}k.unshift(i)}}},unmap:function(e,t){if(e!=":"&&e.charAt(0)==":"){if(t){throw Error("Mode not supported for ex mappings")}var r=e.substring(1);if(this.commandMap_[r]&&this.commandMap_[r].user){delete this.commandMap_[r];return}}else{var n=e;for(var i=0;i<k.length;i++){if(n==k[i].keys&&k[i].context===t){k.splice(i,1);return}}}}};var Dt={colorscheme:function(e,t){if(!t.args||t.args.length<1){Lt(e,e.getOption("theme"));return}e.setOption("theme",t.args[0])},map:function(e,t,r){var n=t.args;if(!n||n.length<2){if(e){Lt(e,"Invalid mapping: "+t.input)}return}Wt.map(n[0],n[1],r)},imap:function(e,t){this.map(e,t,"insert")},nmap:function(e,t){this.map(e,t,"normal")},vmap:function(e,t){this.map(e,t,"visual")},unmap:function(e,t,r){var n=t.args;if(!n||n.length<1){if(e){Lt(e,"No such mapping: "+t.input)}return}Wt.unmap(n[0],r)},move:function(e,t){de.processCommand(e,e.state.vim,{type:"motion",motion:"moveToLineOrEdgeOfDocument",motionArgs:{forward:false,explicitRepeat:true,linewise:true},repeatOverride:t.line+1})},set:function(e,t){var r=t.args;var n=t.setCfg||{};if(!r||r.length<1){if(e){Lt(e,"Invalid mapping: "+t.input)}return}var i=r[0].split("=");var a=i[0];var o=i[1];var s=false;if(a.charAt(a.length-1)=="?"){if(o){throw Error("Trailing characters: "+t.argString)}a=a.substring(0,a.length-1);s=true}if(o===undefined&&a.substring(0,2)=="no"){a=a.substring(2);o=false}var l=G[a]&&G[a].type=="boolean";if(l&&o==undefined){o=true}if(!l&&o===undefined||s){var c=Y(a,e,n);if(c instanceof Error){Lt(e,c.message)}else if(c===true||c===false){Lt(e," "+(c?"":"no")+a)}else{Lt(e,"  "+a+"="+c)}}else{var u=Z(a,o,e,n);if(u instanceof Error){Lt(e,u.message)}}},setlocal:function(e,t){t.setCfg={scope:"local"};this.set(e,t)},setglobal:function(e,t){t.setCfg={scope:"global"};this.set(e,t)},registers:function(e,t){var r=t.args;var n=ie.registerController.registers;var i="----------Registers----------<br><br>";if(!r){for(var a in n){var o=n[a].toString();if(o.length){i+='"'+a+"    "+o+"<br>"}}}else{var a;r=r.join("");for(var s=0;s<r.length;s++){a=r.charAt(s);if(!ie.registerController.isValidRegister(a)){continue}var l=n[a]||new ue;i+='"'+a+"    "+l.toString()+"<br>"}}Lt(e,i)},sort:function(e,t){var r,n,i,a,o;function s(){if(t.argString){var e=new v.StringStream(t.argString);if(e.eat("!")){r=true}if(e.eol()){return}if(!e.eatSpace()){return"Invalid arguments"}var s=e.match(/([dinuox]+)?\s*(\/.+\/)?\s*/);if(!s&&!e.eol()){return"Invalid arguments"}if(s[1]){n=s[1].indexOf("i")!=-1;i=s[1].indexOf("u")!=-1;var l=s[1].indexOf("d")!=-1||s[1].indexOf("n")!=-1&&1;var c=s[1].indexOf("x")!=-1&&1;var u=s[1].indexOf("o")!=-1&&1;if(l+c+u>1){return"Invalid arguments"}a=l&&"decimal"||c&&"hex"||u&&"octal"}if(s[2]){o=new RegExp(s[2].substr(1,s[2].length-2),n?"i":"")}}}var l=s();if(l){Lt(e,l+": "+t.argString);return}var c=t.line||e.firstLine();var u=t.lineEnd||t.line||e.lastLine();if(c==u){return}var f=x(c,0);var h=x(u,Ne(e,u));var p=e.getRange(f,h).split("\n");var d=o?o:a=="decimal"?/(-?)([\d]+)/:a=="hex"?/(-?)(?:0x)?([0-9a-f]+)/i:a=="octal"?/([0-7]+)/:null;var m=a=="decimal"?10:a=="hex"?16:a=="octal"?8:null;var g=[],y=[];if(a||o){for(var k=0;k<p.length;k++){var C=o?p[k].match(o):null;if(C&&C[0]!=""){g.push(C)}else if(!o&&d.exec(p[k])){g.push(p[k])}else{y.push(p[k])}}}else{y=p}function w(e,t){if(r){var i;i=e;e=t;t=i}if(n){e=e.toLowerCase();t=t.toLowerCase()}var o=a&&d.exec(e);var s=a&&d.exec(t);if(!o){return e<t?-1:1}o=parseInt((o[1]+o[2]).toLowerCase(),m);s=parseInt((s[1]+s[2]).toLowerCase(),m);return o-s}function M(e,t){if(r){var i;i=e;e=t;t=i}if(n){e[0]=e[0].toLowerCase();t[0]=t[0].toLowerCase()}return e[0]<t[0]?-1:1}g.sort(o?M:w);if(o){for(var k=0;k<g.length;k++){g[k]=g[k].input}}else if(!a){y.sort(w)}p=!r?y.concat(g):g.concat(y);if(i){var S=p;var A;p=[];for(var k=0;k<S.length;k++){if(S[k]!=A){p.push(S[k])}A=S[k]}}e.replaceRange(p.join("\n"),f,h)},global:function(e,t){var r=t.argString;if(!r){Lt(e,"Regular Expression missing from global");return}var n=t.line!==undefined?t.line:e.firstLine();var i=t.lineEnd||t.line||e.lastLine();var a=gt(r);var o=r,s;if(a.length){o=a[0];s=a.slice(1,a.length).join("/")}if(o){try{Bt(e,o,true,true)}catch(t){Lt(e,"Invalid regex: "+o);return}}var l=vt(e).getQuery();var c=[],u="";for(var f=n;f<=i;f++){var h=l.test(e.getLine(f));if(h){c.push(f+1);u+=e.getLine(f)+"<br>"}}if(!s){Lt(e,u);return}var p=0;var d=function(){if(p<c.length){var t=c[p]+s;Wt.processCommand(e,t,{callback:d})}p++};d()},substitute:function(e,t){if(!e.getSearchCursor){throw new Error("Search feature not available. Requires searchcursor.js or "+"any other getSearchCursor implementation.")}var r=t.argString;var n=r?kt(r,r[0]):[];var i,a="",o,s,l;var c=false;var u=false;if(n.length){i=n[0];if(Y("pcre")&&i!==""){i=new RegExp(i).source}a=n[1];if(i&&i[i.length-1]==="$"){i=i.slice(0,i.length-1)+"\\n";a=a?a+"\n":"\n"}if(a!==undefined){if(Y("pcre")){a=At(a.replace(/([^\\])&/g,"$1$$&"))}else{a=Mt(a)}ie.lastSubstituteReplacePart=a}o=n[2]?n[2].split(" "):[]}else{if(r&&r.length){Lt(e,"Substitutions should be of the form "+":s/pattern/replace/");return}}if(o){s=o[0];l=parseInt(o[1]);if(s){if(s.indexOf("c")!=-1){c=true;s.replace("c","")}if(s.indexOf("g")!=-1){u=true;s.replace("g","")}if(Y("pcre")){i=i+"/"+s}else{i=i.replace(/\//g,"\\/")+"/"+s}}}if(i){try{Bt(e,i,true,true)}catch(t){Lt(e,"Invalid regex: "+i);return}}a=a||ie.lastSubstituteReplacePart;if(a===undefined){Lt(e,"No previous substitute regular expression");return}var f=vt(e);var h=f.getQuery();var p=t.line!==undefined?t.line:e.getCursor().line;var d=t.lineEnd||p;if(p==e.firstLine()&&d==e.lastLine()){d=Infinity}if(l){p=d;d=p+l-1}var v=xe(e,x(p,0));var m=e.getSearchCursor(h,v);Ft(e,c,u,p,d,m,h,a,t.callback)},redo:v.commands.redo,undo:v.commands.undo,write:function(e){if(v.commands.save){v.commands.save(e)}else if(e.save){e.save()}},nohlsearch:function(e){Pt(e)},yank:function(e){var t=Te(e.getCursor());var r=t.line;var n=e.getLine(r);ie.registerController.pushText("0","yank",n,true,true)},delmarks:function(e,t){if(!t.argString||!Pe(t.argString)){Lt(e,"Argument required");return}var r=e.state.vim;var n=new v.StringStream(Pe(t.argString));while(!n.eol()){n.eatSpace();var i=n.pos;if(!n.match(/[a-zA-Z]/,false)){Lt(e,"Invalid argument: "+t.argString.substring(i));return}var a=n.next();if(n.match("-",true)){if(!n.match(/[a-zA-Z]/,false)){Lt(e,"Invalid argument: "+t.argString.substring(i));return}var o=a;var s=n.next();if(W(o)&&W(s)||z(o)&&z(s)){var l=o.charCodeAt(0);var c=s.charCodeAt(0);if(l>=c){Lt(e,"Invalid argument: "+t.argString.substring(i));return}for(var u=0;u<=c-l;u++){var f=String.fromCharCode(l+u);delete r.marks[f]}}else{Lt(e,"Invalid argument: "+o+"-");return}}else{delete r.marks[a]}}}};var Wt=new jt;function Ft(e,t,r,n,i,a,o,s,l){e.state.vim.exMode=true;var c=false;var u=a.from();function f(){e.operation((function(){while(!c){h();p()}d()}))}function h(){var t=e.getRange(a.from(),a.to());var r=t.replace(o,s);a.replace(r)}function p(){while(a.findNext()&&_t(a.from(),n,i)){if(!r&&u&&a.from().line==u.line){continue}e.scrollIntoView(a.from(),30);e.setSelection(a.from(),a.to());u=a.from();c=false;return}c=true}function d(t){if(t){t()}e.focus();if(u){e.setCursor(u);var r=e.state.vim;r.exMode=false;r.lastHPos=r.lastHSPos=u.ch}if(l){l()}}function m(t,r,n){v.e_stop(t);var i=v.keyName(t);switch(i){case"Y":h();p();break;case"N":p();break;case"A":var a=l;l=undefined;e.operation(f);l=a;break;case"L":h();case"Q":case"Esc":case"Ctrl-C":case"Ctrl-[":d(n);break}if(c){d(n)}return true}p();if(c){Lt(e,"No matches for "+o.source);return}if(!t){f();if(l){l()}return}Et(e,{prefix:"replace with <strong>"+s+"</strong> (y/n/a/q/l)",onKeyDown:m})}v.keyMap.vim={attach:L,detach:b,call:O};function Ut(e){var t=e.state.vim;var r=ie.macroModeState;var n=ie.registerController.getRegister(".");var i=r.isPlaying;var a=r.lastInsertModeChanges;if(!i){e.off("change",Zt);v.off(e.getInputField(),"keydown",nr)}if(!i&&t.insertModeRepeat>1){ir(e,t,t.insertModeRepeat-1,true);t.lastEditInputState.repeatOverride=t.insertModeRepeat}delete t.insertModeRepeat;t.insertMode=false;e.setCursor(e.getCursor().line,e.getCursor().ch-1);e.setOption("keyMap","vim");e.setOption("disableInput",true);e.toggleOverwrite(false);n.setText(a.changes.join(""));v.signal(e,"vim-mode-change",{mode:"normal"});if(r.isRecording){Gt(r)}}function zt(e){k.unshift(e)}function Jt(e,t,r,n,i){var a={keys:e,type:t};a[t]=r;a[t+"Args"]=n;for(var o in i)a[o]=i[o];zt(a)}X("insertModeEscKeysTimeout",200,"number");v.keyMap["vim-insert"]={fallthrough:["default"],attach:L,detach:b,call:O};v.keyMap["vim-replace"]={Backspace:"goCharLeft",fallthrough:["vim-insert"],attach:L,detach:b,call:O};function qt(e,t,r,n){var i=ie.registerController.getRegister(n);if(n==":"){if(i.keyBuffer[0]){Wt.processCommand(e,i.keyBuffer[0])}r.isPlaying=false;return}var a=i.keyBuffer;var o=0;r.isPlaying=true;r.replaySearchQueries=i.searchQueries.slice(0);for(var s=0;s<a.length;s++){var l=a[s];var c,u;while(l){c=/<\w+-.+?>|<\w+>|./.exec(l);u=c[0];l=l.substring(c.index+u.length);v.Vim.handleKey(e,u,"macro");if(t.insertMode){var f=i.insertModeChanges[o++].changes;ie.macroModeState.lastInsertModeChanges.changes=f;ar(e,f,1);Ut(e)}}}r.isPlaying=false}function Qt(e,t){if(e.isPlaying){return}var r=e.latestRegister;var n=ie.registerController.getRegister(r);if(n){n.pushText(t)}}function Gt(e){if(e.isPlaying){return}var t=e.latestRegister;var r=ie.registerController.getRegister(t);if(r&&r.pushInsertModeChanges){r.pushInsertModeChanges(e.lastInsertModeChanges)}}function Xt(e,t){if(e.isPlaying){return}var r=e.latestRegister;var n=ie.registerController.getRegister(r);if(n&&n.pushSearchQuery){n.pushSearchQuery(t)}}function Zt(e,t){var r=ie.macroModeState;var n=r.lastInsertModeChanges;if(!r.isPlaying){while(t){n.expectCursorActivityForChange=true;if(n.ignoreCount>1){n.ignoreCount--}else if(t.origin=="+input"||t.origin=="paste"||t.origin===undefined){var i=e.listSelections().length;if(i>1)n.ignoreCount=i;var a=t.text.join("\n");if(n.maybeReset){n.changes=[];n.maybeReset=false}if(a){if(e.state.overwrite&&!/\n/.test(a)){n.changes.push([a])}else{n.changes.push(a)}}}t=t.next}}}function Yt(e){var t=e.state.vim;if(t.insertMode){var r=ie.macroModeState;if(r.isPlaying){return}var n=r.lastInsertModeChanges;if(n.expectCursorActivityForChange){n.expectCursorActivityForChange=false}else{n.maybeReset=true}}else if(!e.curOp.isVimOp){tr(e,t)}if(t.visualMode){er(e)}}function er(e){var t=e.state.vim;var r=xe(e,Te(t.sel.head));var n=Se(r,0,1);if(t.fakeCursor){t.fakeCursor.clear()}t.fakeCursor=e.markText(r,n,{className:"cm-animate-fat-cursor"})}function tr(e,t,r){var n=e.getCursor("anchor");var i=e.getCursor("head");if(t.visualMode&&!e.somethingSelected()){qe(e,false)}else if(!t.visualMode&&!t.insertMode&&e.somethingSelected()){t.visualMode=true;t.visualLine=false;v.signal(e,"vim-mode-change",{mode:"visual"})}if(t.visualMode){var a=!Re(i,n)?-1:0;var o=Re(i,n)?-1:0;i=Se(i,0,a);n=Se(n,0,o);t.sel={anchor:n,head:i};lt(e,t,"<",Be(i,n));lt(e,t,">",Ie(i,n))}else if(!t.insertMode&&!r){t.lastHPos=e.getCursor().ch}}function rr(e){this.keyName=e}function nr(e){var t=ie.macroModeState;var r=t.lastInsertModeChanges;var n=v.keyName(e);if(!n){return}function i(){if(r.maybeReset){r.changes=[];r.maybeReset=false}r.changes.push(new rr(n));return true}if(n.indexOf("Delete")!=-1||n.indexOf("Backspace")!=-1){v.lookupKey(n,"vim-insert",i)}}function ir(e,t,r,n){var i=ie.macroModeState;i.isPlaying=true;var a=!!t.lastEditActionCommand;var o=t.inputState;function s(){if(a){de.processAction(e,t,t.lastEditActionCommand)}else{de.evalInput(e,t)}}function l(r){if(i.lastInsertModeChanges.changes.length>0){r=!t.lastEditActionCommand?1:r;var n=i.lastInsertModeChanges;ar(e,n.changes,r)}}t.inputState=t.lastEditInputState;if(a&&t.lastEditActionCommand.interlaceInsertRepeat){for(var c=0;c<r;c++){s();l(1)}}else{if(!n){s()}l(r)}t.inputState=o;if(t.insertMode&&!n){Ut(e)}i.isPlaying=false}function ar(e,t,r){function n(t){if(typeof t=="string"){v.commands[t](e)}else{t(e)}return true}var i=e.getCursor("head");var a=ie.macroModeState.lastInsertModeChanges.visualBlock;if(a){$e(e,i,a+1);r=e.listSelections().length;e.setCursor(i)}for(var o=0;o<r;o++){if(a){e.setCursor(Se(i,o,0))}for(var s=0;s<t.length;s++){var l=t[s];if(l instanceof rr){v.lookupKey(l.keyName,"vim-insert",n)}else if(typeof l=="string"){var c=e.getCursor();e.replaceRange(l,c,c)}else{var u=e.getCursor();var f=Se(u,0,l[0].length);e.replaceRange(l[0],u,f)}}}if(a){e.setCursor(Se(i,0,1))}}ae();v.Vim=M();M=v.Vim;var or={return:"CR",backspace:"BS",delete:"Del",esc:"Esc",left:"Left",right:"Right",up:"Up",down:"Down",space:"Space",home:"Home",end:"End",pageup:"PageUp",pagedown:"PageDown",enter:"CR"};function sr(e,t,r){if(t.length>1&&t[0]=="n"){t=t.replace("numpad","")}t=or[t]||t;var n="";if(r.ctrlKey){n+="C-"}if(r.altKey){n+="A-"}if((n||t.length>1)&&r.shiftKey){n+="S-"}n+=t;if(n.length>1){n="<"+n+">"}return n}var lr=M.handleKey.bind(M);M.handleKey=function(e,t,r){return e.operation((function(){return lr(e,t,r)}),true)};function cr(e){var t=new e.constructor;Object.keys(e).forEach((function(r){var n=e[r];if(Array.isArray(n))n=n.slice();else if(n&&typeof n=="object"&&n.constructor!=Object)n=cr(n);t[r]=n}));if(e.sel){t.sel={head:e.sel.head&&Te(e.sel.head),anchor:e.sel.anchor&&Te(e.sel.anchor)}}return t}function ur(e,t,r){var n=false;var i=M.maybeInitVimState_(e);var a=i.visualBlock||i.wasInVisualBlock;var o=e.ace.inMultiSelectMode;if(i.wasInVisualBlock&&!o){i.wasInVisualBlock=false}else if(o&&i.visualBlock){i.wasInVisualBlock=true}if(t=="<Esc>"&&!i.insertMode&&!i.visualMode&&o){e.ace.exitMultiSelectMode()}else if(a||!o||e.ace.inVirtualSelectionMode){n=M.handleKey(e,t,r)}else{var s=cr(i);e.operation((function(){e.ace.forEachSelection((function(){var i=e.ace.selection;e.state.vim.lastHPos=i.$desiredColumn==null?i.lead.column:i.$desiredColumn;var a=e.getCursor("head");var o=e.getCursor("anchor");var l=!Re(a,o)?-1:0;var c=Re(a,o)?-1:0;a=Se(a,0,l);o=Se(o,0,c);e.state.vim.sel.head=a;e.state.vim.sel.anchor=o;n=lr(e,t,r);i.$desiredColumn=e.state.vim.lastHPos==-1?null:e.state.vim.lastHPos;if(e.virtualSelectionMode()){e.state.vim=cr(s)}}));if(e.curOp.cursorActivity&&!n)e.curOp.cursorActivity=false}),true)}if(n&&!i.visualMode&&!i.insert&&i.visualMode!=e.somethingSelected()){tr(e,i,true)}return n}t.CodeMirror=v;var fr=M.maybeInitVimState_;t.handler={$id:"ace/keyboard/vim",drawCursor:function(e,t,r,n,a){var s=this.state.vim||{};var l=r.characterWidth;var c=r.lineHeight;var u=t.top;var f=t.left;if(!s.insertMode){var h=!n.cursor?a.selection.isBackwards()||a.selection.isEmpty():i.comparePoints(n.cursor,n.start)<=0;if(!h&&f>l)f-=l}if(!s.insertMode&&s.status){c=c/2;u+=c}o.translate(e,f,u);o.setStyle(e.style,"width",l+"px");o.setStyle(e.style,"height",c+"px")},handleKeyboard:function(e,t,r,n,i){var a=e.editor;var o=a.state.cm;var s=fr(o);if(n==-1)return;if(!s.insertMode){if(t==-1){if(r.charCodeAt(0)>255){if(e.inputKey){r=e.inputKey;if(r&&e.inputHash==4)r=r.toUpperCase()}}e.inputChar=r}else if(t==4||t==0){if(e.inputKey==r&&e.inputHash==t&&e.inputChar){r=e.inputChar;t=-1}else{e.inputChar=null;e.inputKey=r;e.inputHash=t}}else{e.inputChar=e.inputKey=null}}if(r=="c"&&t==1){if(!f.isMac&&a.getCopyText()){a.once("copy",(function(){a.selection.clearSelection()}));return{command:"null",passEvent:true}}}if(r=="esc"&&!s.insertMode&&!s.visualMode&&!o.ace.inMultiSelectMode){var l=vt(o);var c=l.getOverlay();if(c)o.removeOverlay(c)}if(t==-1||t&1||t===0&&r.length>1){var u=s.insertMode;var h=sr(t,r,i||{});if(s.status==null)s.status="";var p=ur(o,h,"user");s=fr(o);if(p&&s.status!=null)s.status+=h;else if(s.status==null)s.status="";o._signal("changeStatus");if(!p&&(t!=-1||u))return;return{command:"null",passEvent:!p}}},attach:function(e){if(!e.state)e.state={};var t=new v(e);e.state.cm=t;e.$vimModeHandler=this;v.keyMap.vim.attach(t);fr(t).status=null;t.on("vim-command-done",(function(){if(t.virtualSelectionMode())return;fr(t).status=null;t.ace._signal("changeStatus");t.ace.session.markUndoGroup()}));t.on("changeStatus",(function(){t.ace.renderer.updateCursor();t.ace._signal("changeStatus")}));t.on("vim-mode-change",(function(){if(t.virtualSelectionMode())return;r();t._signal("changeStatus")}));function r(){var r=fr(t).insertMode;t.ace.renderer.setStyle("normal-mode",!r);e.textInput.setCommandMode(!r);e.renderer.$keepTextAreaAtCursor=r;e.renderer.$blockCursor=!r}r();e.renderer.$cursorLayer.drawCursor=this.drawCursor.bind(t)},detach:function(e){var t=e.state.cm;v.keyMap.vim.detach(t);t.destroy();e.state.cm=null;e.$vimModeHandler=null;e.renderer.$cursorLayer.drawCursor=null;e.renderer.setStyle("normal-mode",false);e.textInput.setCommandMode(false);e.renderer.$keepTextAreaAtCursor=true},getStatusText:function(e){var t=e.state.cm;var r=fr(t);if(r.insertMode)return"INSERT";var n="";if(r.visualMode){n+="VISUAL";if(r.visualLine)n+=" LINE";if(r.visualBlock)n+=" BLOCK"}if(r.status)n+=(n?" ":"")+r.status;return n}};M.defineOption({name:"wrap",set:function(e,t){if(t){t.ace.setOption("wrap",e)}},type:"boolean"},false);M.defineEx("write","w",(function(){console.log(":write is not implemented")}));k.push({keys:"zc",type:"action",action:"fold",actionArgs:{open:false}},{keys:"zC",type:"action",action:"fold",actionArgs:{open:false,all:true}},{keys:"zo",type:"action",action:"fold",actionArgs:{open:true}},{keys:"zO",type:"action",action:"fold",actionArgs:{open:true,all:true}},{keys:"za",type:"action",action:"fold",actionArgs:{toggle:true}},{keys:"zA",type:"action",action:"fold",actionArgs:{toggle:true,all:true}},{keys:"zf",type:"action",action:"fold",actionArgs:{open:true,all:true}},{keys:"zd",type:"action",action:"fold",actionArgs:{open:true,all:true}},{keys:"<C-A-k>",type:"action",action:"aceCommand",actionArgs:{name:"addCursorAbove"}},{keys:"<C-A-j>",type:"action",action:"aceCommand",actionArgs:{name:"addCursorBelow"}},{keys:"<C-A-S-k>",type:"action",action:"aceCommand",actionArgs:{name:"addCursorAboveSkipCurrent"}},{keys:"<C-A-S-j>",type:"action",action:"aceCommand",actionArgs:{name:"addCursorBelowSkipCurrent"}},{keys:"<C-A-h>",type:"action",action:"aceCommand",actionArgs:{name:"selectMoreBefore"}},{keys:"<C-A-l>",type:"action",action:"aceCommand",actionArgs:{name:"selectMoreAfter"}},{keys:"<C-A-S-h>",type:"action",action:"aceCommand",actionArgs:{name:"selectNextBefore"}},{keys:"<C-A-S-l>",type:"action",action:"aceCommand",actionArgs:{name:"selectNextAfter"}});Ce.aceCommand=function(e,t,r){e.vimCmd=t;if(e.ace.inVirtualSelectionMode)e.ace.on("beforeEndOperation",hr);else hr(null,e.ace)};function hr(e,t){t.off("beforeEndOperation",hr);var r=t.state.cm.vimCmd;if(r){t.execCommand(r.exec?r:r.name,r.args)}t.curOp=t.prevOp}Ce.fold=function(e,t,r){e.ace.execCommand(["toggleFoldWidget","toggleFoldWidget","foldOther","unfoldall"][(t.all?2:0)+(t.open?1:0)])};t.handler.defaultKeymap=k;t.handler.actions=Ce;t.Vim=M}));(function(){ace.require(["ace/keyboard/vim"],(function(e){if(typeof module=="object"&&typeof exports=="object"&&module){module.exports=e}}))})();