﻿/*
Copyright (c) 2009, Yahoo! Inc. All rights reserved.
Code licensed under the BSD License:
http://developer.yahoo.net/yui/license.txt
version: 2.7.0
*/
if ( typeof YAHOO == "undefined" || !YAHOO ) {
	var YAHOO = {};
}
YAHOO.namespace = function() {
	var A = arguments,
		E = null,
		C, B, D;
	for ( C = 0; C < A.length; C = C + 1 ) {
		D = ( "" + A[ C ] ).split( "." );
		E = YAHOO;
		for ( B = ( D[ 0 ] == "YAHOO" ) ? 1 : 0; B < D.length; B = B + 1 ) {
			E[ D[ B ] ] = E[ D[ B ] ] || {};
			E = E[ D[ B ] ];
		}
	}
	return E;
};
YAHOO.log = function( D, A, C ) {
	var B = YAHOO.widget.Logger;
	if ( B && B.log ) {
		return B.log( D, A, C );
	} else {
		return false;
	}
};
YAHOO.register = function( A, E, D ) {
	var I = YAHOO.env.modules,
		B, H, G, F, C;
	if ( !I[ A ] ) {
		I[ A ] = { versions: [], builds: [] };
	}
	B = I[ A ];
	H = D.version;
	G = D.build;
	F = YAHOO.env.listeners;
	B.name = A;
	B.version = H;
	B.build = G;
	B.versions.push( H );
	B.builds.push( G );
	B.mainClass = E;
	for ( C = 0; C < F.length; C = C + 1 ) {
		F[ C ]( B );
	}
	if ( E ) {
		E.VERSION = H;
		E.BUILD = G;
	} else {
		YAHOO.log( "mainClass is undefined for module " + A, "warn" );
	}
};
YAHOO.env = YAHOO.env || { modules: [], listeners: [] }; YAHOO.env.getVersion = function( A ) {
	return YAHOO.env.modules[ A ] || null;
};
YAHOO.env.ua = function() {
	var C = { ie: 0, opera: 0, gecko: 0, webkit: 0, mobile: null, air: 0, caja: 0 },
		B = navigator.userAgent,
		A; if ( ( /KHTML/ ).test( B ) ) {
		C.webkit = 1;
	}
	A = B.match( /AppleWebKit\/([^\s]*)/ );
	if ( A && A[ 1 ] ) {
		C.webkit = parseFloat( A[ 1 ] );
		if ( / Mobile\//.test( B ) ) {
			C.mobile = "Apple";
		} else {
			A = B.match( /NokiaN[^\/]*/ );
			if ( A ) {
				C.mobile = A[ 0 ];
			}
		}
		A = B.match( /AdobeAIR\/([^\s]*)/ );
		if ( A ) {
			C.air = A[ 0 ];
		}
	}
	if ( !C.webkit ) {
		A = B.match( /Opera[\s\/]([^\s]*)/ );
		if ( A && A[ 1 ] ) {
			C.opera = parseFloat( A[ 1 ] );
			A = B.match( /Opera Mini[^;]*/ );
			if ( A ) {
				C.mobile = A[ 0 ];
			}
		} else {
			A = B.match( /MSIE\s([^;]*)/ );
			if ( A && A[ 1 ] ) {
				C.ie = parseFloat( A[ 1 ] );
			} else {
				A = B.match( /Gecko\/([^\s]*)/ );
				if ( A ) {
					C.gecko = 1;
					A = B.match( /rv:([^\s\)]*)/ );
					if ( A && A[ 1 ] ) {
						C.gecko = parseFloat( A[ 1 ] );
					}
				}
			}
		}
	}
	A = B.match( /Caja\/([^\s]*)/ );
	if ( A && A[ 1 ] ) {
		C.caja = parseFloat( A[ 1 ] );
	}
	return C;
}();
(function() {
	YAHOO.namespace( "util", "widget", "example" );
	if ( "undefined" !== typeof YAHOO_config ) {
		var B = YAHOO_config.listener,
			A = YAHOO.env.listeners,
			D = true,
			C;
		if ( B ) {
			for ( C = 0; C < A.length; C = C + 1 ) {
				if ( A[ C ] == B ) {
					D = false;
					break;
				}
			}
			if ( D ) {
				A.push( B );
			}
		}
	}
})();
YAHOO.lang = YAHOO.lang || {};
(function() {
	var B = YAHOO.lang,
		F = "[object Array]",
		C = "[object Function]",
		A = Object.prototype,
		E = [ "toString", "valueOf" ],
		D = {
			isArray: function( G ) {
				return A.toString.apply( G ) === F;
			},
			isBoolean: function( G ) {
				return typeof G === "boolean";
			},
			isFunction: function( G ) {
				return A.toString.apply( G ) === C;
			},
			isNull: function( G ) {
				return G === null;
			},
			isNumber: function( G ) {
				return typeof G === "number" && isFinite( G );
			},
			isObject: function( G ) {
				return ( G && ( typeof G === "object" || B.isFunction( G ) ) ) || false;
			},
			isString: function( G ) {
				return typeof G === "string";
			},
			isUndefined: function( G ) {
				return typeof G === "undefined";
			},
			_IEEnumFix: ( YAHOO.env.ua.ie ) ?
			function( I, H ) {
				var G, K, J; for ( G = 0; G < E.length; G = G + 1 ) {
					K = E[ G ];
					J = H[ K ];
					if ( B.isFunction( J ) && J != A[ K ] ) {
						I[ K ] = J;
					}
				}
			} : function() {},
			extend: function( J, K, I ) {
				if ( !K || !J ) {
					throw new Error( "extend failed, please check that " + "all dependencies are included." );
				}
				var H = function() {},
					G;
				H.prototype = K.prototype;
				J.prototype = new H();
				J.prototype.constructor = J;
				J.superclass = K.prototype;
				if ( K.prototype.constructor == A.constructor ) {
					K.prototype.constructor = K;
				}
				if ( I ) {
					for ( G in I ) {
						if ( B.hasOwnProperty( I, G ) ) {
							J.prototype[ G ] = I[ G ];
						}
					}
					B._IEEnumFix( J.prototype, I );
				}
			},
			augmentObject: function( K, J ) {
				if ( !J || !K ) {
					throw new Error( "Absorb failed, verify dependencies." );
				}
				var G = arguments,
					I, L,
					H = G[ 2 ];
				if ( H && H !== true ) {
					for ( I = 2; I < G.length; I = I + 1 ) {
						K[ G[ I ] ] = J[ G[ I ] ];
					}
				} else {
					for ( L in J ) {
						if ( H || !( L in K ) ) {
							K[ L ] = J[ L ];
						}
					}
					B._IEEnumFix( K, J );
				}
			},
			augmentProto: function( J, I ) {
				if ( !I || !J ) {
					throw new Error( "Augment failed, verify dependencies." );
				}
				var G = [ J.prototype, I.prototype ],
					H;
				for ( H = 2; H < arguments.length; H = H + 1 ) {
					G.push( arguments[ H ] );
				}
				B.augmentObject.apply( this, G );
			},
			dump: function( G, L ) {
				var I, K,
					N = [],
					O = "{...}",
					H = "f(){...}",
					M = ", ",
					J = " => ";
				if ( !B.isObject( G ) ) {
					return G + "";
				} else {
					if ( G instanceof Date || ( "nodeType" in G && "tagName" in G ) ) {
						return G;
					} else {
						if ( B.isFunction( G ) ) {
							return H;
						}
					}
				}
				L = ( B.isNumber( L ) ) ? L : 3;
				if ( B.isArray( G ) ) {
					N.push( "[" );
					for ( I = 0, K = G.length; I < K; I = I + 1 ) {
						if ( B.isObject( G[ I ] ) ) {
							N.push( ( L > 0 ) ? B.dump( G[ I ], L - 1 ) : O );
						} else {
							N.push( G[ I ] );
						}
						N.push( M );
					}
					if ( N.length > 1 ) {
						N.pop();
					}
					N.push( "]" );
				} else {
					N.push( "{" );
					for ( I in G ) {
						if ( B.hasOwnProperty( G, I ) ) {
							N.push( I + J );
							if ( B.isObject( G[ I ] ) ) {
								N.push( ( L > 0 ) ? B.dump( G[ I ], L - 1 ) : O );
							} else {
								N.push( G[ I ] );
							}
							N.push( M );
						}
					}
					if ( N.length > 1 ) {
						N.pop();
					}
					N.push( "}" );
				}
				return N.join( "" );
			},
			substitute: function( V, H, O ) {
				var L, K, J, R, S, U,
					Q = [],
					I,
					M = "dump",
					P = " ",
					G = "{",
					T = "}",
					N;
				for ( ;; ) {
					L = V.lastIndexOf( G );
					if ( L < 0 ) {
						break;
					}
					K = V.indexOf( T, L );
					if ( L + 1 >= K ) {
						break;
					}
					I = V.substring( L + 1, K );
					R = I;
					U = null;
					J = R.indexOf( P );
					if ( J > -1 ) {
						U = R.substring( J + 1 );
						R = R.substring( 0, J );
					}
					S = H[ R ];
					if ( O ) {
						S = O( R, S, U );
					}
					if ( B.isObject( S ) ) {
						if ( B.isArray( S ) ) {
							S = B.dump( S, parseInt( U, 10 ) );
						} else {
							U = U || "";
							N = U.indexOf( M );
							if ( N > -1 ) {
								U = U.substring( 4 );
							}
							if ( S.toString === A.toString || N > -1 ) {
								S = B.dump( S, parseInt( U, 10 ) );
							} else {
								S = S.toString();
							}
						}
					} else {
						if ( !B.isString( S ) && !B.isNumber( S ) ) {
							S = "~-" + Q.length + "-~";
							Q[ Q.length ] = I;
						}
					}
					V = V.substring( 0, L ) + S + V.substring( K + 1 );
				}
				for ( L = Q.length - 1; L >= 0; L = L - 1 ) {
					V = V.replace( new RegExp( "~-" + L + "-~" ), "{" + Q[ L ] + "}", "g" );
				}
				return V;
			},
			trim: function( G ) {
				try {
					return G.replace( /^\s+|\s+$/g, "" );
				} catch ( H ) {
					return G;
				}
			},
			merge: function() {
				var J = {},
					H = arguments,
					G = H.length,
					I;
				for ( I = 0; I < G; I = I + 1 ) {
					B.augmentObject( J, H[ I ], true );
				}
				return J;
			},
			later: function( N, H, O, J, K ) {
				N = N || 0; H = H || {};
				var I = O,
					M = J,
					L, G;
				if ( B.isString( O ) ) {
					I = H[ O ];
				}
				if ( !I ) {
					throw new TypeError( "method undefined" );
				}
				if ( !B.isArray( M ) ) {
					M = [ J ];
				}
				L = function() {
					I.apply( H, M );
				};
				G = ( K ) ? setInterval( L, N ) : setTimeout( L, N );
				return {
					interval: K, cancel: function() {
						if ( this.interval ) {
							clearInterval( G );
						} else {
							clearTimeout( G );
						}
					} };
			},
			isValue: function( G ) {
				return ( B.isObject( G ) || B.isString( G ) || B.isNumber( G ) || B.isBoolean( G ) );
			} }; B.hasOwnProperty = ( A.hasOwnProperty ) ?
	function( G, H ) {
		return G && G.hasOwnProperty( H );
	} : function( G, H ) {
		return !B.isUndefined( G[ H ] ) && G.constructor.prototype[ H ] !== G[ H ];
	};
	D.augmentObject( B, D, true );
	YAHOO.util.Lang = B;
	B.augment = B.augmentProto;
	YAHOO.augment = B.augmentProto;
	YAHOO.extend = B.extend;
})();
YAHOO.register( "yahoo", YAHOO, { version: "2.7.0", build: "1796" } );
(function() {
	YAHOO.env._id_counter = YAHOO.env._id_counter || 0;
	var E = YAHOO.util,
		L = YAHOO.lang,
		m = YAHOO.env.ua,
		A = YAHOO.lang.trim,
		d = {},
		h = {},
		N = /^t(?:able|d|h)$/i,
		X = /color$/i,
		K = window.document,
		W = K.documentElement,
		e = "ownerDocument",
		n = "defaultView",
		v = "documentElement",
		t = "compatMode",
		b = "offsetLeft",
		P = "offsetTop",
		u = "offsetParent",
		Z = "parentNode",
		l = "nodeType",
		C = "tagName",
		O = "scrollLeft",
		i = "scrollTop",
		Q = "getBoundingClientRect",
		w = "getComputedStyle",
		a = "currentStyle",
		M = "CSS1Compat",
		c = "BackCompat",
		g = "class",
		F = "className",
		J = "",
		B = " ",
		s = "(?:^|\\s)",
		k = "(?= |$)",
		U = "g",
		p = "position",
		f = "fixed",
		V = "relative",
		j = "left",
		o = "top",
		r = "medium",
		q = "borderLeftWidth",
		R = "borderTopWidth",
		D = m.opera,
		I = m.webkit,
		H = m.gecko,
		T = m.ie;
	E.Dom = {
		CUSTOM_ATTRIBUTES: ( !W.hasAttribute ) ? { "for": "htmlFor", "class": F } : { "htmlFor": "for", "className": g },
		get: function( y ) {
			var AA, Y, z, x, G; if ( y ) {
				if ( y[ l ] || y.item ) {
					return y;
				}
				if ( typeof y === "string" ) {
					AA = y;
					y = K.getElementById( y );
					if ( y && y.id === AA ) {
						return y;
					} else {
						if ( y && K.all ) {
							y = null;
							Y = K.all[ AA ];
							for ( x = 0, G = Y.length; x < G; ++x ) {
								if ( Y[ x ].id === AA ) {
									return Y[ x ];
								}
							}
						}
					}
					return y;
				}
				if ( y.DOM_EVENTS ) {
					y = y.get( "element" );
				}
				if ( "length" in y ) {
					z = [];
					for ( x = 0, G = y.length; x < G; ++x ) {
						z[ z.length ] = E.Dom.get( y[ x ] );
					}
					return z;
				}
				return y;
			}
			return null;
		},
		getComputedStyle: function( G, Y ) {
			if ( window[ w ] ) {
				return G[ e ][ n ][ w ]( G, null )[ Y ];
			} else {
				if ( G[ a ] ) {
					return E.Dom.IE_ComputedStyle.get( G, Y );
				}
			}
		},
		getStyle: function( G, Y ) {
			return E.Dom.batch( G, E.Dom._getStyle, Y );
		},
		_getStyle: function() {
			if ( window[ w ] ) {
				return function( G, y ) {
					y = ( y === "float" ) ? y = "cssFloat" : E.Dom._toCamel( y );
					var x = G.style[ y ],
						Y;
					if ( !x ) {
						Y = G[ e ][ n ][ w ]( G, null );
						if ( Y ) {
							x = Y[ y ];
						}
					}
					return x;
				};
			} else {
				if ( W[ a ] ) {
					return function( G, y ) {
						var x;
						switch ( y ) {
							case "opacity":
								x = 100;
								try {
									x = G.filters[ "DXImageTransform.Microsoft.Alpha" ].opacity;
								} catch ( z ) {
									try {
										x = G.filters( "alpha" ).opacity;
									} catch ( Y ) {}
								}
								return x / 100;case "float":
								y = "styleFloat";default:
								y = E.Dom._toCamel( y );
								x = G[ a ] ? G[ a ][ y ] : null;
								return ( G.style[ y ] || x );
						}
					};
				}
			}
		}(), setStyle: function( G, Y, x ) {
			E.Dom.batch( G, E.Dom._setStyle, { prop: Y, val: x } );
		},
		_setStyle: function() {
			if ( T ) {
				return function( Y, G ) {
					var x = E.Dom._toCamel( G.prop ),
						y = G.val;
					if ( Y ) {
						switch ( x ) {
							case "opacity":
								if ( L.isString( Y.style.filter ) ) {
									Y.style.filter = "alpha(opacity=" + y * 100 + ")";
									if ( !Y[ a ] || !Y[ a ].hasLayout ) {
										Y.style.zoom = 1;
									}
								}
								break;case "float":
								x = "styleFloat";default:
								Y.style[ x ] = y;
						}
					} else {}
				};
			} else {
				return function( Y, G ) {
					var x = E.Dom._toCamel( G.prop ),
						y = G.val;
					if ( Y ) {
						if ( x == "float" ) {
							x = "cssFloat";
						}
						Y.style[ x ] = y;
					} else {}
				};
			}
		}(), getXY: function( G ) {
			return E.Dom.batch( G, E.Dom._getXY );
		},
		_canPosition: function( G ) {
			return ( E.Dom._getStyle( G, "display" ) !== "none" && E.Dom._inDoc( G ) );
		},
		_getXY: function() {
			if ( K[ v ][ Q ] ) {
				return function( y ) {
					var z, Y, AA, AF, AE, AD, AC, G, x,
						AB = Math.floor,
						AG = false;
					if ( E.Dom._canPosition( y ) ) {
						AA = y[ Q ]();
						AF = y[ e ];
						z = E.Dom.getDocumentScrollLeft( AF );
						Y = E.Dom.getDocumentScrollTop( AF );
						AG = [ AB( AA[ j ] ), AB( AA[ o ] ) ];
						if ( T && m.ie < 8 ) {
							AE = 2;
							AD = 2;
							AC = AF[ t ];
							G = S( AF[ v ], q );
							x = S( AF[ v ], R );
							if ( m.ie === 6 ) {
								if ( AC !== c ) {
									AE = 0;
									AD = 0;
								}
							}
							if ( ( AC == c ) ) {
								if ( G !== r ) {
									AE = parseInt( G, 10 );
								}
								if ( x !== r ) {
									AD = parseInt( x, 10 );
								}
							}
							AG[ 0 ] -= AE;
							AG[ 1 ] -= AD;
						}
						if ( ( Y || z ) ) {
							AG[ 0 ] += z;
							AG[ 1 ] += Y;
						}
						AG[ 0 ] = AB( AG[ 0 ] );
						AG[ 1 ] = AB( AG[ 1 ] );
					} else {}
					return AG;
				};
			} else {
				return function( y ) {
					var x, Y, AA, AB, AC,
						z = false,
						G = y;
					if ( E.Dom._canPosition( y ) ) {
						z = [ y[ b ], y[ P ] ];
						x = E.Dom.getDocumentScrollLeft( y[ e ] );
						Y = E.Dom.getDocumentScrollTop( y[ e ] );
						AC = ( ( H || m.webkit > 519 ) ? true : false );
						while ( ( G = G[ u ] ) ) {
							z[ 0 ] += G[ b ];
							z[ 1 ] += G[ P ];
							if ( AC ) {
								z = E.Dom._calcBorders( G, z );
							}
						}
						if ( E.Dom._getStyle( y, p ) !== f ) {
							G = y;
							while ( ( G = G[ Z ] ) && G[ C ] ) {
								AA = G[ i ];
								AB = G[ O ];
								if ( H && ( E.Dom._getStyle( G, "overflow" ) !== "visible" ) ) {
									z = E.Dom._calcBorders( G, z );
								}
								if ( AA || AB ) {
									z[ 0 ] -= AB;
									z[ 1 ] -= AA;
								}
							}
							z[ 0 ] += x;
							z[ 1 ] += Y;
						} else {
							if ( D ) {
								z[ 0 ] -= x;
								z[ 1 ] -= Y;
							} else {
								if ( I || H ) {
									z[ 0 ] += x;
									z[ 1 ] += Y;
								}
							}
						}
						z[ 0 ] = Math.floor( z[ 0 ] );
						z[ 1 ] = Math.floor( z[ 1 ] );
					} else {}
					return z;
				};
			}
		}(), getX: function( G ) {
			var Y = function( x ) {
					return E.Dom.getXY( x )[ 0 ];
				};
			return E.Dom.batch( G, Y, E.Dom, true );
		},
		getY: function( G ) {
			var Y = function( x ) {
					return E.Dom.getXY( x )[ 1 ];
				};
			return E.Dom.batch( G, Y, E.Dom, true );
		},
		setXY: function( G, x, Y ) {
			E.Dom.batch( G, E.Dom._setXY, { pos: x, noRetry: Y } );
		},
		_setXY: function( G, z ) {
			var AA = E.Dom._getStyle( G, p ),
				y = E.Dom.setStyle,
				AD = z.pos,
				Y = z.noRetry,
				AB = [ parseInt( E.Dom.getComputedStyle( G, j ), 10 ), parseInt( E.Dom.getComputedStyle( G, o ), 10 ) ],
				AC, x;
			if ( AA == "static" ) {
				AA = V;
				y( G, p, AA );
			}
			AC = E.Dom._getXY( G );
			if ( !AD || AC === false ) {
				return false;
			}
			if ( isNaN( AB[ 0 ] ) ) {
				AB[ 0 ] = ( AA == V ) ? 0 : G[ b ];
			}
			if ( isNaN( AB[ 1 ] ) ) {
				AB[ 1 ] = ( AA == V ) ? 0 : G[ P ];
			}
			if ( AD[ 0 ] !== null ) {
				y( G, j, AD[ 0 ] - AC[ 0 ] + AB[ 0 ] + "px" );
			}
			if ( AD[ 1 ] !== null ) {
				y( G, o, AD[ 1 ] - AC[ 1 ] + AB[ 1 ] + "px" );
			}
			if ( !Y ) {
				x = E.Dom._getXY( G );
				if ( ( AD[ 0 ] !== null && x[ 0 ] != AD[ 0 ] ) || ( AD[ 1 ] !== null && x[ 1 ] != AD[ 1 ] ) ) {
					E.Dom._setXY( G, { pos: AD, noRetry: true } );
				}
			}
		},
		setX: function( Y, G ) {
			E.Dom.setXY( Y, [ G, null ] );
		},
		setY: function( G, Y ) {
			E.Dom.setXY( G, [ null, Y ] );
		},
		getRegion: function( G ) {
			var Y = function( x ) {
					var y = false;
					if ( E.Dom._canPosition( x ) ) {
						y = E.Region.getRegion( x );
					} else {}
					return y;
				};
			return E.Dom.batch( G, Y, E.Dom, true );
		},
		getClientWidth: function() {
			return E.Dom.getViewportWidth();
		},
		getClientHeight: function() {
			return E.Dom.getViewportHeight();
		},
		getElementsByClassName: function( AB, AF, AC, AE, x, AD ) {
			AB = L.trim( AB );
			AF = AF || "*";
			AC = ( AC ) ? E.Dom.get( AC ) : null || K;
			if ( !AC ) {
				return [];
			}
			var Y = [],
				G = AC.getElementsByTagName( AF ),
				z = E.Dom.hasClass;
			for ( var y = 0, AA = G.length; y < AA; ++y ) {
				if ( z( G[ y ], AB ) ) {
					Y[ Y.length ] = G[ y ];
				}
			}
			if ( AE ) {
				E.Dom.batch( Y, AE, x, AD );
			}
			return Y;
		},
		hasClass: function( Y, G ) {
			return E.Dom.batch( Y, E.Dom._hasClass, G );
		},
		_hasClass: function( x, Y ) {
			var G = false,
				y; if ( x && Y ) {
				y = E.Dom.getAttribute( x, F ) || J;
				if ( Y.exec ) {
					G = Y.test( y );
				} else {
					G = Y && ( B + y + B ).indexOf( B + Y + B ) > -1;
				}
			} else {}
			return G;
		},
		addClass: function( Y, G ) {
			return E.Dom.batch( Y, E.Dom._addClass, G );
		},
		_addClass: function( x, Y ) {
			var G = false,
				y; if ( x && Y ) {
				y = E.Dom.getAttribute( x, F ) || J;
				if ( !E.Dom._hasClass( x, Y ) ) {
					E.Dom.setAttribute( x, F, A( y + B + Y ) );
					G = true;
				}
			} else {}
			return G;
		},
		removeClass: function( Y, G ) {
			return E.Dom.batch( Y, E.Dom._removeClass, G );
		},
		_removeClass: function( y, x ) {
			var Y = false,
				AA, z, G; if ( y && x ) {
				AA = E.Dom.getAttribute( y, F ) || J;
				E.Dom.setAttribute( y, F, AA.replace( E.Dom._getClassRegex( x ), J ) );
				z = E.Dom.getAttribute( y, F );
				if ( AA !== z ) {
					E.Dom.setAttribute( y, F, A( z ) );
					Y = true;
					if ( E.Dom.getAttribute( y, F ) === "" ) {
						G = ( y.hasAttribute && y.hasAttribute( g ) ) ? g : F;
						y.removeAttribute( G );
					}
				}
			} else {}
			return Y;
		},
		replaceClass: function( x, Y, G ) {
			return E.Dom.batch( x, E.Dom._replaceClass, { from: Y, to: G } );
		},
		_replaceClass: function( y, x ) {
			var Y, AB, AA,
				G = false,
				z; if ( y && x ) {
				AB = x.from;
				AA = x.to;
				if ( !AA ) {
					G = false;
				} else {
					if ( !AB ) {
						G = E.Dom._addClass( y, x.to );
					} else {
						if ( AB !== AA ) {
							z = E.Dom.getAttribute( y, F ) || J;
							Y = ( B + z.replace( E.Dom._getClassRegex( AB ), B + AA ) ).split( E.Dom._getClassRegex( AA ) );
							Y.splice( 1, 0, B + AA );
							E.Dom.setAttribute( y, F, A( Y.join( J ) ) );
							G = true;
						}
					}
				}
			} else {}
			return G;
		},
		generateId: function( G, x ) {
			x = x || "yui-gen"; var Y = function( y ) {
					if ( y && y.id ) {
						return y.id;
					}
					var z = x + YAHOO.env._id_counter++;
					if ( y ) {
						if ( y[ e ].getElementById( z ) ) {
							return E.Dom.generateId( y, z + x );
						}
						y.id = z;
					}
					return z;
				};
			return E.Dom.batch( G, Y, E.Dom, true ) || Y.apply( E.Dom, arguments );
		},
		isAncestor: function( Y, x ) {
			Y = E.Dom.get( Y );
			x = E.Dom.get( x );
			var G = false;
			if ( ( Y && x ) && ( Y[ l ] && x[ l ] ) ) {
				if ( Y.contains && Y !== x ) {
					G = Y.contains( x );
				} else {
					if ( Y.compareDocumentPosition ) {
						G = !!( Y.compareDocumentPosition( x ) & 16 );
					}
				}
			} else {}
			return G;
		},
		inDocument: function( G, Y ) {
			return E.Dom._inDoc( E.Dom.get( G ), Y );
		},
		_inDoc: function( Y, x ) {
			var G = false; if ( Y && Y[ C ] ) {
				x = x || Y[ e ];
				G = E.Dom.isAncestor( x[ v ], Y );
			} else {}
			return G;
		},
		getElementsBy: function( Y, AF, AB, AD, y, AC, AE ) {
			AF = AF || "*"; AB = ( AB ) ? E.Dom.get( AB ) : null || K;
			if ( !AB ) {
				return [];
			}
			var x = [],
				G = AB.getElementsByTagName( AF );
			for ( var z = 0, AA = G.length; z < AA; ++z ) {
				if ( Y( G[ z ] ) ) {
					if ( AE ) {
						x = G[ z ];
						break;
					} else {
						x[ x.length ] = G[ z ];
					}
				}
			}
			if ( AD ) {
				E.Dom.batch( x, AD, y, AC );
			}
			return x;
		},
		getElementBy: function( x, G, Y ) {
			return E.Dom.getElementsBy( x, G, Y, null, null, null, true );
		},
		batch: function( x, AB, AA, z ) {
			var y = [],
				Y = ( z ) ? AA : window;
			x = ( x && ( x[ C ] || x.item ) ) ? x : E.Dom.get( x );
			if ( x && AB ) {
				if ( x[ C ] || x.length === undefined ) {
					return AB.call( Y, x, AA );
				}
				for ( var G = 0; G < x.length; ++G ) {
					y[ y.length ] = AB.call( Y, x[ G ], AA );
				}
			} else {
				return false;
			}
			return y;
		},
		getDocumentHeight: function() {
			var Y = ( K[ t ] != M || I ) ? K.body.scrollHeight : W.scrollHeight,
				G = Math.max( Y, E.Dom.getViewportHeight() );
			return G;
		},
		getDocumentWidth: function() {
			var Y = ( K[ t ] != M || I ) ? K.body.scrollWidth : W.scrollWidth,
				G = Math.max( Y, E.Dom.getViewportWidth() );
			return G;
		},
		getViewportHeight: function() {
			var G = self.innerHeight,
				Y = K[ t ];
			if ( ( Y || T ) && !D ) {
				G = ( Y == M ) ? W.clientHeight : K.body.clientHeight;
			}
			return G;
		},
		getViewportWidth: function() {
			var G = self.innerWidth,
				Y = K[ t ];
			if ( Y || T ) {
				G = ( Y == M ) ? W.clientWidth : K.body.clientWidth;
			}
			return G;
		},
		getAncestorBy: function( G, Y ) {
			while ( ( G = G[ Z ] ) ) {
				if ( E.Dom._testElement( G, Y ) ) {
					return G;
				}
			}
			return null;
		},
		getAncestorByClassName: function( Y, G ) {
			Y = E.Dom.get( Y );
			if ( !Y ) {
				return null;
			}
			var x = function( y ) {
					return E.Dom.hasClass( y, G );
				};
			return E.Dom.getAncestorBy( Y, x );
		},
		getAncestorByTagName: function( Y, G ) {
			Y = E.Dom.get( Y );
			if ( !Y ) {
				return null;
			}
			var x = function( y ) {
					return y[ C ] && y[ C ].toUpperCase() == G.toUpperCase();
				};
			return E.Dom.getAncestorBy( Y, x );
		},
		getPreviousSiblingBy: function( G, Y ) {
			while ( G ) {
				G = G.previousSibling;
				if ( E.Dom._testElement( G, Y ) ) {
					return G;
				}
			}
			return null;
		},
		getPreviousSibling: function( G ) {
			G = E.Dom.get( G );
			if ( !G ) {
				return null;
			}
			return E.Dom.getPreviousSiblingBy( G );
		},
		getNextSiblingBy: function( G, Y ) {
			while ( G ) {
				G = G.nextSibling;
				if ( E.Dom._testElement( G, Y ) ) {
					return G;
				}
			}
			return null;
		},
		getNextSibling: function( G ) {
			G = E.Dom.get( G );
			if ( !G ) {
				return null;
			}
			return E.Dom.getNextSiblingBy( G );
		},
		getFirstChildBy: function( G, x ) {
			var Y = ( E.Dom._testElement( G.firstChild, x ) ) ? G.firstChild : null;
			return Y || E.Dom.getNextSiblingBy( G.firstChild, x );
		},
		getFirstChild: function( G, Y ) {
			G = E.Dom.get( G );
			if ( !G ) {
				return null;
			}
			return E.Dom.getFirstChildBy( G );
		},
		getLastChildBy: function( G, x ) {
			if ( !G ) {
				return null;
			}
			var Y = ( E.Dom._testElement( G.lastChild, x ) ) ? G.lastChild : null;
			return Y || E.Dom.getPreviousSiblingBy( G.lastChild, x );
		},
		getLastChild: function( G ) {
			G = E.Dom.get( G );
			return E.Dom.getLastChildBy( G );
		},
		getChildrenBy: function( Y, y ) {
			var x = E.Dom.getFirstChildBy( Y, y ),
				G = x ? [ x ] : [];
			E.Dom.getNextSiblingBy( x, function( z ) {
				if ( !y || y( z ) ) {
					G[ G.length ] = z;
				}
				return false;
			});
			return G;
		},
		getChildren: function( G ) {
			G = E.Dom.get( G );
			if ( !G ) {}
			return E.Dom.getChildrenBy( G );
		},
		getDocumentScrollLeft: function( G ) {
			G = G || K; return Math.max( G[ v ].scrollLeft, G.body.scrollLeft );
		},
		getDocumentScrollTop: function( G ) {
			G = G || K; return Math.max( G[ v ].scrollTop, G.body.scrollTop );
		},
		insertBefore: function( Y, G ) {
			Y = E.Dom.get( Y );
			G = E.Dom.get( G );
			if ( !Y || !G || !G[ Z ] ) {
				return null;
			}
			return G[ Z ].insertBefore( Y, G );
		},
		insertAfter: function( Y, G ) {
			Y = E.Dom.get( Y );
			G = E.Dom.get( G );
			if ( !Y || !G || !G[ Z ] ) {
				return null;
			}
			if ( G.nextSibling ) {
				return G[ Z ].insertBefore( Y, G.nextSibling );
			} else {
				return G[ Z ].appendChild( Y );
			}
		},
		getClientRegion: function() {
			var x = E.Dom.getDocumentScrollTop(),
				Y = E.Dom.getDocumentScrollLeft(),
				y = E.Dom.getViewportWidth() + Y,
				G = E.Dom.getViewportHeight() + x;
			return new E.Region( x, y, G, Y );
		},
		setAttribute: function( Y, G, x ) {
			G = E.Dom.CUSTOM_ATTRIBUTES[ G ] || G;
			Y.setAttribute( G, x );
		},
		getAttribute: function( Y, G ) {
			G = E.Dom.CUSTOM_ATTRIBUTES[ G ] || G;
			return Y.getAttribute( G );
		},
		_toCamel: function( Y ) {
			var x = d;

			function G( y, z ) {
				return z.toUpperCase();
			}
			return x[ Y ] || ( x[ Y ] = Y.indexOf( "-" ) === -1 ? Y : Y.replace( /-([a-z])/gi, G ) );
		},
		_getClassRegex: function( Y ) {
			var G; if ( Y !== undefined ) {
				if ( Y.exec ) {
					G = Y;
				} else {
					G = h[ Y ];
					if ( !G ) {
						Y = Y.replace( E.Dom._patterns.CLASS_RE_TOKENS, "\\$1" );
						G = h[ Y ] = new RegExp( s + Y + k, U );
					}
				}
			}
			return G;
		},
		_patterns: { ROOT_TAG: /^body|html$/i, CLASS_RE_TOKENS: /([\.\(\)\^\$\*\+\?\|\[\]\{\}])/g },
		_testElement: function( G, Y ) {
			return G && G[ l ] == 1 && ( !Y || Y( G ) );
		},
		_calcBorders: function( x, y ) {
			var Y = parseInt( E.Dom[ w ]( x, R ), 10 ) || 0,
				G = parseInt( E.Dom[ w ]( x, q ), 10 ) || 0;
			if ( H ) {
				if ( N.test( x[ C ] ) ) {
					Y = 0;
					G = 0;
				}
			}
			y[ 0 ] += G;
			y[ 1 ] += Y;
			return y;
		} }; var S = E.Dom[ w ];
	if ( m.opera ) {
		E.Dom[ w ] = function( Y, G ) {
			var x = S( Y, G );
			if ( X.test( G ) ) {
				x = E.Dom.Color.toRGB( x );
			}
			return x;
		};
	}
	if ( m.webkit ) {
		E.Dom[ w ] = function( Y, G ) {
			var x = S( Y, G );
			if ( x === "rgba(0, 0, 0, 0)" ) {
				x = "transparent";
			}
			return x;
		};
	}
})();
YAHOO.util.Region = function( C, D, A, B ) {
	this.top = C;
	this.y = C;
	this[ 1 ] = C;
	this.right = D;
	this.bottom = A;
	this.left = B;
	this.x = B;
	this[ 0 ] = B;
	this.width = this.right - this.left;
	this.height = this.bottom - this.top;
};
YAHOO.util.Region.prototype.contains = function( A ) {
	return ( A.left >= this.left && A.right <= this.right && A.top >= this.top && A.bottom <= this.bottom );
};
YAHOO.util.Region.prototype.getArea = function() {
	return ( ( this.bottom - this.top ) * ( this.right - this.left ) );
};
YAHOO.util.Region.prototype.intersect = function( E ) {
	var C = Math.max( this.top, E.top ),
		D = Math.min( this.right, E.right ),
		A = Math.min( this.bottom, E.bottom ),
		B = Math.max( this.left, E.left );
	if ( A >= C && D >= B ) {
		return new YAHOO.util.Region( C, D, A, B );
	} else {
		return null;
	}
};
YAHOO.util.Region.prototype.union = function( E ) {
	var C = Math.min( this.top, E.top ),
		D = Math.max( this.right, E.right ),
		A = Math.max( this.bottom, E.bottom ),
		B = Math.min( this.left, E.left );
	return new YAHOO.util.Region( C, D, A, B );
};
YAHOO.util.Region.prototype.toString = function() {
	return ( "Region {" + "top: " + this.top + ", right: " + this.right + ", bottom: " + this.bottom + ", left: " + this.left + ", height: " + this.height + ", width: " + this.width + "}" );
};
YAHOO.util.Region.getRegion = function( D ) {
	var F = YAHOO.util.Dom.getXY( D ),
		C = F[ 1 ],
		E = F[ 0 ] + D.offsetWidth,
		A = F[ 1 ] + D.offsetHeight,
		B = F[ 0 ];
	return new YAHOO.util.Region( C, E, A, B );
};
YAHOO.util.Point = function( A, B ) {
	if ( YAHOO.lang.isArray( A ) ) {
		B = A[ 1 ];
		A = A[ 0 ];
	}
	YAHOO.util.Point.superclass.constructor.call( this, B, A, B, A );
};
YAHOO.extend( YAHOO.util.Point, YAHOO.util.Region );
(function() {
	var B = YAHOO.util,
		A = "clientTop",
		F = "clientLeft",
		J = "parentNode",
		K = "right",
		W = "hasLayout",
		I = "px",
		U = "opacity",
		L = "auto",
		D = "borderLeftWidth",
		G = "borderTopWidth",
		P = "borderRightWidth",
		V = "borderBottomWidth",
		S = "visible",
		Q = "transparent",
		N = "height",
		E = "width",
		H = "style",
		T = "currentStyle",
		R = /^width|height$/,
		O = /^(\d[.\d]*)+(em|ex|px|gd|rem|vw|vh|vm|ch|mm|cm|in|pt|pc|deg|rad|ms|s|hz|khz|%){1}?/i,
		M = {
			get: function( X, Z ) {
				var Y = "",
					a = X[ T ][ Z ];
				if ( Z === U ) {
					Y = B.Dom.getStyle( X, U );
				} else {
					if ( !a || ( a.indexOf && a.indexOf( I ) > -1 ) ) {
						Y = a;
					} else {
						if ( B.Dom.IE_COMPUTED[ Z ] ) {
							Y = B.Dom.IE_COMPUTED[ Z ]( X, Z );
						} else {
							if ( O.test( a ) ) {
								Y = B.Dom.IE.ComputedStyle.getPixel( X, Z );
							} else {
								Y = a;
							}
						}
					}
				}
				return Y;
			},
			getOffset: function( Z, e ) {
				var b = Z[ T ][ e ],
					X = e.charAt( 0 ).toUpperCase() + e.substr( 1 ),
					c = "offset" + X,
					Y = "pixel" + X,
					a = "",
					d;
				if ( b == L ) {
					d = Z[ c ];
					if ( d === undefined ) {
						a = 0;
					}
					a = d;
					if ( R.test( e ) ) {
						Z[ H ][ e ] = d;
						if ( Z[ c ] > d ) {
							a = d - ( Z[ c ] - d );
						}
						Z[ H ][ e ] = L;
					}
				} else {
					if ( !Z[ H ][ Y ] && !Z[ H ][ e ] ) {
						Z[ H ][ e ] = b;
					}
					a = Z[ H ][ Y ];
				}
				return a + I;
			},
			getBorderWidth: function( X, Z ) {
				var Y = null; if ( !X[ T ][ W ] ) {
					X[ H ].zoom = 1;
				}
				switch ( Z ) {
					case G:
						Y = X[ A ];
						break;case V:
						Y = X.offsetHeight - X.clientHeight - X[ A ];
						break;case D:
						Y = X[ F ];
						break;case P:
						Y = X.offsetWidth - X.clientWidth - X[ F ];
						break;
				}
				return Y + I;
			},
			getPixel: function( Y, X ) {
				var a = null,
					b = Y[ T ][ K ],
					Z = Y[ T ][ X ];
				Y[ H ][ K ] = Z;
				a = Y[ H ].pixelRight;
				Y[ H ][ K ] = b;
				return a + I;
			},
			getMargin: function( Y, X ) {
				var Z; if ( Y[ T ][ X ] == L ) {
					Z = 0 + I;
				} else {
					Z = B.Dom.IE.ComputedStyle.getPixel( Y, X );
				}
				return Z;
			},
			getVisibility: function( Y, X ) {
				var Z; while ( ( Z = Y[ T ] ) && Z[ X ] == "inherit" ) {
					Y = Y[ J ];
				}
				return ( Z ) ? Z[ X ] : S;
			},
			getColor: function( Y, X ) {
				return B.Dom.Color.toRGB( Y[ T ][ X ] ) || Q;
			},
			getBorderColor: function( Y, X ) {
				var Z = Y[ T ],
					a = Z[ X ] || Z.color;
				return B.Dom.Color.toRGB( B.Dom.Color.toHex( a ) );
			} },
		C = {};
	C.top = C.right = C.bottom = C.left = C[ E ] = C[ N ] = M.getOffset;
	C.color = M.getColor;
	C[ G ] = C[ P ] = C[ V ] = C[ D ] = M.getBorderWidth;
	C.marginTop = C.marginRight = C.marginBottom = C.marginLeft = M.getMargin;
	C.visibility = M.getVisibility;
	C.borderColor = C.borderTopColor = C.borderRightColor = C.borderBottomColor = C.borderLeftColor = M.getBorderColor;
	B.Dom.IE_COMPUTED = C;
	B.Dom.IE_ComputedStyle = M;
})();
(function() {
	var C = "toString",
		A = parseInt,
		B = RegExp,
		D = YAHOO.util;
	D.Dom.Color = {
		KEYWORDS: { black: "000", silver: "c0c0c0", gray: "808080", white: "fff", maroon: "800000", red: "f00", purple: "800080", fuchsia: "f0f", green: "008000", lime: "0f0", olive: "808000", yellow: "ff0", navy: "000080", blue: "00f", teal: "008080", aqua: "0ff" },
		re_RGB: /^rgb\(([0-9]+)\s*,\s*([0-9]+)\s*,\s*([0-9]+)\)$/i, re_hex: /^#?([0-9A-F]{2})([0-9A-F]{2})([0-9A-F]{2})$/i, re_hex3: /([0-9A-F])/gi, toRGB: function( E ) {
			if ( !D.Dom.Color.re_RGB.test( E ) ) {
				E = D.Dom.Color.toHex( E );
			}
			if ( D.Dom.Color.re_hex.exec( E ) ) {
				E = "rgb(" + [ A( B.$1, 16 ), A( B.$2, 16 ), A( B.$3, 16 ) ].join( ", " ) + ")";
			}
			return E;
		},
		toHex: function( H ) {
			H = D.Dom.Color.KEYWORDS[ H ] || H;
			if ( D.Dom.Color.re_RGB.exec( H ) ) {
				var G = ( B.$1.length === 1 ) ? "0" + B.$1 : Number( B.$1 ),
					F = ( B.$2.length === 1 ) ? "0" + B.$2 : Number( B.$2 ),
					E = ( B.$3.length === 1 ) ? "0" + B.$3 : Number( B.$3 );
				H = [ G[ C ]( 16 ), F[ C ]( 16 ), E[ C ]( 16 ) ].join( "" );
			}
			if ( H.length < 6 ) {
				H = H.replace( D.Dom.Color.re_hex3, "$1$1" );
			}
			if ( H !== "transparent" && H.indexOf( "#" ) < 0 ) {
				H = "#" + H;
			}
			return H.toLowerCase();
		} };
}() );
YAHOO.register( "dom", YAHOO.util.Dom, { version: "2.7.0", build: "1796" } );
YAHOO.util.CustomEvent = function( D, C, B, A ) {
	this.type = D;
	this.scope = C || window;
	this.silent = B;
	this.signature = A || YAHOO.util.CustomEvent.LIST;
	this.subscribers = [];
	if ( !this.silent ) {}
	var E = "_YUICEOnSubscribe";
	if ( D !== E ) {
		this.subscribeEvent = new YAHOO.util.CustomEvent( E, this, true );
	}
	this.lastError = null;
};
YAHOO.util.CustomEvent.LIST = 0;
YAHOO.util.CustomEvent.FLAT = 1;
YAHOO.util.CustomEvent.prototype = {
	subscribe: function( A, B, C ) {
		if ( !A ) {
			throw new Error( "Invalid callback for subscriber to '" + this.type + "'" );
		}
		if ( this.subscribeEvent ) {
			this.subscribeEvent.fire( A, B, C );
		}
		this.subscribers.push( new YAHOO.util.Subscriber( A, B, C ) );
	},
	unsubscribe: function( D, F ) {
		if ( !D ) {
			return this.unsubscribeAll();
		}
		var E = false;
		for ( var B = 0, A = this.subscribers.length; B < A; ++B ) {
			var C = this.subscribers[ B ];
			if ( C && C.contains( D, F ) ) {
				this._delete( B );
				E = true;
			}
		}
		return E;
	},
	fire: function() {
		this.lastError = null; var K = [],
			E = this.subscribers.length;
		if ( !E && this.silent ) {
			return true;
		}
		var I = [].slice.call( arguments, 0 ),
			G = true,
			D,
			J = false;
		if ( !this.silent ) {}
		var C = this.subscribers.slice(),
			A = YAHOO.util.Event.throwErrors;
		for ( D = 0; D < E; ++D ) {
			var M = C[ D ];
			if ( !M ) {
				J = true;
			} else {
				if ( !this.silent ) {}
				var L = M.getScope( this.scope );
				if ( this.signature == YAHOO.util.CustomEvent.FLAT ) {
					var B = null;
					if ( I.length > 0 ) {
						B = I[ 0 ];
					}
					try {
						G = M.fn.call( L, B, M.obj );
					} catch ( F ) {
						this.lastError = F;
						if ( A ) {
							throw F;
						}
					}
				} else {
					try {
						G = M.fn.call( L, this.type, I, M.obj );
					} catch ( H ) {
						this.lastError = H;
						if ( A ) {
							throw H;
						}
					}
				}
				if ( false === G ) {
					if ( !this.silent ) {}
					break;
				}
			}
		}
		return ( G !== false );
	},
	unsubscribeAll: function() {
		var A = this.subscribers.length,
			B; for ( B = A - 1; B > -1; B-- ) {
			this._delete( B );
		}
		this.subscribers = [];
		return A;
	},
	_delete: function( A ) {
		var B = this.subscribers[ A ];
		if ( B ) {
			delete B.fn;
			delete B.obj;
		}
		this.subscribers.splice( A, 1 );
	},
	toString: function() {
		return "CustomEvent: " + "'" + this.type + "', " + "context: " + this.scope;
	} }; YAHOO.util.Subscriber = function( A, B, C ) {
	this.fn = A;
	this.obj = YAHOO.lang.isUndefined( B ) ? null : B;
	this.overrideContext = C;
};
YAHOO.util.Subscriber.prototype.getScope = function( A ) {
	if ( this.overrideContext ) {
		if ( this.overrideContext === true ) {
			return this.obj;
		} else {
			return this.overrideContext;
		}
	}
	return A;
};
YAHOO.util.Subscriber.prototype.contains = function( A, B ) {
	if ( B ) {
		return ( this.fn == A && this.obj == B );
	} else {
		return ( this.fn == A );
	}
};
YAHOO.util.Subscriber.prototype.toString = function() {
	return "Subscriber { obj: " + this.obj + ", overrideContext: " + ( this.overrideContext || "no" ) + " }";
};
if ( !YAHOO.util.Event ) {
	YAHOO.util.Event = function() {
		var H = false;
		var I = [];
		var J = [];
		var G = [];
		var E = [];
		var C = 0;
		var F = [];
		var B = [];
		var A = 0;
		var D = { 63232: 38, 63233: 40, 63234: 37, 63235: 39, 63276: 33, 63277: 34, 25: 9 }; var K = YAHOO.env.ua.ie ? "focusin" : "focus"; var L = YAHOO.env.ua.ie ? "focusout" : "blur"; return {
			POLL_RETRYS: 2000, POLL_INTERVAL: 20, EL: 0, TYPE: 1, FN: 2, WFN: 3, UNLOAD_OBJ: 3, ADJ_SCOPE: 4, OBJ: 5, OVERRIDE: 6, lastError: null, isSafari: YAHOO.env.ua.webkit, webkit: YAHOO.env.ua.webkit, isIE: YAHOO.env.ua.ie, _interval: null, _dri: null, DOMReady: false, throwErrors: false, startInterval: function() {
				if ( !this._interval ) {
					var M = this;
					var N = function() {
							M._tryPreloadAttach();
						};
					this._interval = setInterval( N, this.POLL_INTERVAL );
				}
			},
			onAvailable: function( S, O, Q, R, P ) {
				var M = ( YAHOO.lang.isString( S ) ) ? [ S ] : S;
				for ( var N = 0; N < M.length; N = N + 1 ) {
					F.push({ id: M[ N ], fn: O, obj: Q, overrideContext: R, checkReady: P } );
				}
				C = this.POLL_RETRYS;
				this.startInterval();
			},
			onContentReady: function( P, M, N, O ) {
				this.onAvailable( P, M, N, O, true );
			},
			onDOMReady: function( M, N, O ) {
				if ( this.DOMReady ) {
					setTimeout( function() {
						var P = window;
						if ( O ) {
							if ( O === true ) {
								P = N;
							} else {
								P = O;
							}
						}
						M.call( P, "DOMReady", [], N );
					}, 0 );
				} else {
					this.DOMReadyEvent.subscribe( M, N, O );
				}
			},
			_addListener: function( O, M, Y, S, W, b ) {
				if ( !Y || !Y.call ) {
					return false;
				}
				if ( this._isValidCollection( O ) ) {
					var Z = true;
					for ( var T = 0, V = O.length; T < V; ++T ) {
						Z = this.on( O[ T ], M, Y, S, W ) && Z;
					}
					return Z;
				} else {
					if ( YAHOO.lang.isString( O ) ) {
						var R = this.getEl( O );
						if ( R ) {
							O = R;
						} else {
							this.onAvailable( O, function() {
								YAHOO.util.Event.on( O, M, Y, S, W );
							});
							return true;
						}
					}
				}
				if ( !O ) {
					return false;
				}
				if ( "unload" == M && S !== this ) {
					J[ J.length ] = [ O, M, Y, S, W ];
					return true;
				}
				var N = O;
				if ( W ) {
					if ( W === true ) {
						N = S;
					} else {
						N = W;
					}
				}
				var P = function( c ) {
						return Y.call( N, YAHOO.util.Event.getEvent( c, O ), S );
					};
				var a = [ O, M, Y, P, N, S, W ];
				var U = I.length;
				I[ U ] = a;
				if ( this.useLegacyEvent( O, M ) ) {
					var Q = this.getLegacyIndex( O, M );
					if ( Q == -1 || O != G[ Q ][ 0 ] ) {
						Q = G.length;
						B[ O.id + M ] = Q;
						G[ Q ] = [ O, M, O[ "on" + M ] ];
						E[ Q ] = [];
						O[ "on" + M ] = function( c ) {
							YAHOO.util.Event.fireLegacyEvent( YAHOO.util.Event.getEvent( c ), Q );
						};
					}
					E[ Q ].push( a );
				} else {
					try {
						this._simpleAdd( O, M, P, b );
					} catch ( X ) {
						this.lastError = X;
						this.removeListener( O, M, Y );
						return false;
					}
				}
				return true;
			},
			addListener: function( N, Q, M, O, P ) {
				return this._addListener( N, Q, M, O, P, false );
			},
			addFocusListener: function( N, M, O, P ) {
				return this._addListener( N, K, M, O, P, true );
			},
			removeFocusListener: function( N, M ) {
				return this.removeListener( N, K, M );
			},
			addBlurListener: function( N, M, O, P ) {
				return this._addListener( N, L, M, O, P, true );
			},
			removeBlurListener: function( N, M ) {
				return this.removeListener( N, L, M );
			},
			fireLegacyEvent: function( R, P ) {
				var T = true,
					M, V, U, N, S; V = E[ P ].slice();
				for ( var O = 0, Q = V.length; O < Q; ++O ) {
					U = V[ O ];
					if ( U && U[ this.WFN ] ) {
						N = U[ this.ADJ_SCOPE ];
						S = U[ this.WFN ].call( N, R );
						T = ( T && S );
					}
				}
				M = G[ P ];
				if ( M && M[ 2 ] ) {
					M[ 2 ]( R );
				}
				return T;
			},
			getLegacyIndex: function( N, O ) {
				var M = this.generateId( N ) + O;
				if ( typeof B[ M ] == "undefined" ) {
					return -1;
				} else {
					return B[ M ];
				}
			},
			useLegacyEvent: function( M, N ) {
				return ( this.webkit && this.webkit < 419 && ( "click" == N || "dblclick" == N ) );
			},
			removeListener: function( N, M, V ) {
				var Q, T, X; if ( typeof N == "string" ) {
					N = this.getEl( N );
				} else {
					if ( this._isValidCollection( N ) ) {
						var W = true;
						for ( Q = N.length - 1; Q > -1; Q-- ) {
							W = ( this.removeListener( N[ Q ], M, V ) && W );
						}
						return W;
					}
				}
				if ( !V || !V.call ) {
					return this.purgeElement( N, false, M );
				}
				if ( "unload" == M ) {
					for ( Q = J.length - 1; Q > -1; Q-- ) {
						X = J[ Q ];
						if ( X && X[ 0 ] == N && X[ 1 ] == M && X[ 2 ] == V ) {
							J.splice( Q, 1 );
							return true;
						}
					}
					return false;
				}
				var R = null;
				var S = arguments[ 3 ];
				if ( "undefined" === typeof S ) {
					S = this._getCacheIndex( N, M, V );
				}
				if ( S >= 0 ) {
					R = I[ S ];
				}
				if ( !N || !R ) {
					return false;
				}
				if ( this.useLegacyEvent( N, M ) ) {
					var P = this.getLegacyIndex( N, M );
					var O = E[ P ];
					if ( O ) {
						for ( Q = 0, T = O.length; Q < T; ++Q ) {
							X = O[ Q ];
							if ( X && X[ this.EL ] == N && X[ this.TYPE ] == M && X[ this.FN ] == V ) {
								O.splice( Q, 1 );
								break;
							}
						}
					}
				} else {
					try {
						this._simpleRemove( N, M, R[ this.WFN ], false );
					} catch ( U ) {
						this.lastError = U;
						return false;
					}
				}
				delete I[ S ][ this.WFN ];
				delete I[ S ][ this.FN ];
				I.splice( S, 1 );
				return true;
			},
			getTarget: function( O, N ) {
				var M = O.target || O.srcElement; return this.resolveTextNode( M );
			},
			resolveTextNode: function( N ) {
				try {
					if ( N && 3 == N.nodeType ) {
						return N.parentNode;
					}
				} catch ( M ) {}
				return N;
			},
			getPageX: function( N ) {
				var M = N.pageX; if ( !M && 0 !== M ) {
					M = N.clientX || 0;
					if ( this.isIE ) {
						M += this._getScrollLeft();
					}
				}
				return M;
			},
			getPageY: function( M ) {
				var N = M.pageY; if ( !N && 0 !== N ) {
					N = M.clientY || 0;
					if ( this.isIE ) {
						N += this._getScrollTop();
					}
				}
				return N;
			},
			getXY: function( M ) {
				return [ this.getPageX( M ), this.getPageY( M ) ];
			},
			getRelatedTarget: function( N ) {
				var M = N.relatedTarget; if ( !M ) {
					if ( N.type == "mouseout" ) {
						M = N.toElement;
					} else {
						if ( N.type == "mouseover" ) {
							M = N.fromElement;
						}
					}
				}
				return this.resolveTextNode( M );
			},
			getTime: function( O ) {
				if ( !O.time ) {
					var N = new Date().getTime();
					try {
						O.time = N;
					} catch ( M ) {
						this.lastError = M;
						return N;
					}
				}
				return O.time;
			},
			stopEvent: function( M ) {
				this.stopPropagation( M );
				this.preventDefault( M );
			},
			stopPropagation: function( M ) {
				if ( M.stopPropagation ) {
					M.stopPropagation();
				} else {
					M.cancelBubble = true;
				}
			},
			preventDefault: function( M ) {
				if ( M.preventDefault ) {
					M.preventDefault();
				} else {
					M.returnValue = false;
				}
			},
			getEvent: function( O, M ) {
				var N = O || window.event; if ( !N ) {
					var P = this.getEvent.caller;
					while ( P ) {
						N = P.arguments[ 0 ];
						if ( N && Event == N.constructor ) {
							break;
						}
						P = P.caller;
					}
				}
				return N;
			},
			getCharCode: function( N ) {
				var M = N.keyCode || N.charCode || 0; if ( YAHOO.env.ua.webkit && ( M in D ) ) {
					M = D[ M ];
				}
				return M;
			},
			_getCacheIndex: function( Q, R, P ) {
				for ( var O = 0, N = I.length; O < N; O = O + 1 ) {
					var M = I[ O ];
					if ( M && M[ this.FN ] == P && M[ this.EL ] == Q && M[ this.TYPE ] == R ) {
						return O;
					}
				}
				return -1;
			},
			generateId: function( M ) {
				var N = M.id; if ( !N ) {
					N = "yuievtautoid-" + A;
					++A;
					M.id = N;
				}
				return N;
			},
			_isValidCollection: function( N ) {
				try {
					return ( N && typeof N !== "string" && N.length && !N.tagName && !N.alert && typeof N[ 0 ] !== "undefined" );
				} catch ( M ) {
					return false;
				}
			},
			elCache: {},
			getEl: function( M ) {
				return ( typeof M === "string" ) ? document.getElementById( M ) : M;
			},
			clearCache: function() {},
			DOMReadyEvent: new YAHOO.util.CustomEvent( "DOMReady", this ), _load: function( N ) {
				if ( !H ) {
					H = true;
					var M = YAHOO.util.Event;
					M._ready();
					M._tryPreloadAttach();
				}
			},
			_ready: function( N ) {
				var M = YAHOO.util.Event; if ( !M.DOMReady ) {
					M.DOMReady = true;
					M.DOMReadyEvent.fire();
					M._simpleRemove( document, "DOMContentLoaded", M._ready );
				}
			},
			_tryPreloadAttach: function() {
				if ( F.length === 0 ) {
					C = 0;
					if ( this._interval ) {
						clearInterval( this._interval );
						this._interval = null;
					}
					return;
				}
				if ( this.locked ) {
					return;
				}
				if ( this.isIE ) {
					if ( !this.DOMReady ) {
						this.startInterval();
						return;
					}
				}
				this.locked = true;
				var S = !H;
				if ( !S ) {
					S = ( C > 0 && F.length > 0 );
				}
				var R = [];
				var T = function( V, W ) {
						var U = V;
						if ( W.overrideContext ) {
							if ( W.overrideContext === true ) {
								U = W.obj;
							} else {
								U = W.overrideContext;
							}
						}
						W.fn.call( U, W.obj );
					};
				var N, M, Q, P,
					O = [];
				for ( N = 0, M = F.length; N < M; N = N + 1 ) {
					Q = F[ N ];
					if ( Q ) {
						P = this.getEl( Q.id );
						if ( P ) {
							if ( Q.checkReady ) {
								if ( H || P.nextSibling || !S ) {
									O.push( Q );
									F[ N ] = null;
								}
							} else {
								T( P, Q );
								F[ N ] = null;
							}
						} else {
							R.push( Q );
						}
					}
				}
				for ( N = 0, M = O.length; N < M; N = N + 1 ) {
					Q = O[ N ];
					T( this.getEl( Q.id ), Q );
				}
				C--;
				if ( S ) {
					for ( N = F.length - 1; N > -1; N-- ) {
						Q = F[ N ];
						if ( !Q || !Q.id ) {
							F.splice( N, 1 );
						}
					}
					this.startInterval();
				} else {
					if ( this._interval ) {
						clearInterval( this._interval );
						this._interval = null;
					}
				}
				this.locked = false;
			},
			purgeElement: function( Q, R, T ) {
				var O = ( YAHOO.lang.isString( Q ) ) ? this.getEl( Q ) : Q;
				var S = this.getListeners( O, T ),
					P, M;
				if ( S ) {
					for ( P = S.length - 1; P > -1; P-- ) {
						var N = S[ P ];
						this.removeListener( O, N.type, N.fn );
					}
				}
				if ( R && O && O.childNodes ) {
					for ( P = 0, M = O.childNodes.length; P < M; ++P ) {
						this.purgeElement( O.childNodes[ P ], R, T );
					}
				}
			},
			getListeners: function( O, M ) {
				var R = [],
					N;
				if ( !M ) {
					N = [ I, J ];
				} else {
					if ( M === "unload" ) {
						N = [ J ];
					} else {
						N = [ I ];
					}
				}
				var T = ( YAHOO.lang.isString( O ) ) ? this.getEl( O ) : O;
				for ( var Q = 0; Q < N.length; Q = Q + 1 ) {
					var V = N[ Q ];
					if ( V ) {
						for ( var S = 0, U = V.length; S < U; ++S ) {
							var P = V[ S ];
							if ( P && P[ this.EL ] === T && ( !M || M === P[ this.TYPE ] ) ) {
								R.push({ type: P[ this.TYPE ], fn: P[ this.FN ], obj: P[ this.OBJ ], adjust: P[ this.OVERRIDE ], scope: P[ this.ADJ_SCOPE ], index: S } );
							}
						}
					}
				}
				return ( R.length ) ? R : null;
			},
			_unload: function( T ) {
				var N = YAHOO.util.Event,
					Q, P, O, S, R,
					U = J.slice(),
					M;
				for ( Q = 0, S = J.length; Q < S; ++Q ) {
					O = U[ Q ];
					if ( O ) {
						M = window;
						if ( O[ N.ADJ_SCOPE ] ) {
							if ( O[ N.ADJ_SCOPE ] === true ) {
								M = O[ N.UNLOAD_OBJ ];
							} else {
								M = O[ N.ADJ_SCOPE ];
							}
						}
						O[ N.FN ].call( M, N.getEvent( T, O[ N.EL ] ), O[ N.UNLOAD_OBJ ] );
						U[ Q ] = null;
					}
				}
				O = null;
				M = null;
				J = null;
				if ( I ) {
					for ( P = I.length - 1; P > -1; P-- ) {
						O = I[ P ];
						if ( O ) {
							N.removeListener( O[ N.EL ], O[ N.TYPE ], O[ N.FN ], P );
						}
					}
					O = null;
				}
				G = null;
				N._simpleRemove( window, "unload", N._unload );
			},
			_getScrollLeft: function() {
				return this._getScroll()[ 1 ];
			},
			_getScrollTop: function() {
				return this._getScroll()[ 0 ];
			},
			_getScroll: function() {
				var M = document.documentElement,
					N = document.body; if ( M && ( M.scrollTop || M.scrollLeft ) ) {
					return [ M.scrollTop, M.scrollLeft ];
				} else {
					if ( N ) {
						return [ N.scrollTop, N.scrollLeft ];
					} else {
						return [ 0, 0 ];
					}
				}
			},
			regCE: function() {},
			_simpleAdd: function() {
				if ( window.addEventListener ) {
					return function( O, P, N, M ) {
						O.addEventListener( P, N, ( M ) );
					};
				} else {
					if ( window.attachEvent ) {
						return function( O, P, N, M ) {
							O.attachEvent( "on" + P, N );
						};
					} else {
						return function() {};
					}
				}
			}(), _simpleRemove: function() {
				if ( window.removeEventListener ) {
					return function( O, P, N, M ) {
						O.removeEventListener( P, N, ( M ) );
					};
				} else {
					if ( window.detachEvent ) {
						return function( N, O, M ) {
							N.detachEvent( "on" + O, M );
						};
					} else {
						return function() {};
					}
				}
			}() };
	}();
	(function() {
		var EU = YAHOO.util.Event;
		EU.on = EU.addListener;
		EU.onFocus = EU.addFocusListener;
		EU.onBlur = EU.addBlurListener;
		/* DOMReady: based on work by: Dean Edwards/John Resig/Matthias Miller */
		if ( EU.isIE ) {
			YAHOO.util.Event.onDOMReady( YAHOO.util.Event._tryPreloadAttach, YAHOO.util.Event, true );
			var n = document.createElement( "p" );
			EU._dri = setInterval( function() {
				try {
					n.doScroll( "left" );
					clearInterval( EU._dri );
					EU._dri = null;
					EU._ready();
					n = null;
				} catch ( ex ) {}
			}, EU.POLL_INTERVAL );
		} else {
			if ( EU.webkit && EU.webkit < 525 ) {
				EU._dri = setInterval( function() {
					var rs = document.readyState;
					if ( "loaded" == rs || "complete" == rs ) {
						clearInterval( EU._dri );
						EU._dri = null;
						EU._ready();
					}
				}, EU.POLL_INTERVAL );
			} else {
				EU._simpleAdd( document, "DOMContentLoaded", EU._ready );
			}
		}
		EU._simpleAdd( window, "load", EU._load );
		EU._simpleAdd( window, "unload", EU._unload );
		EU._tryPreloadAttach();
	})();
}
YAHOO.util.EventProvider = function() {};
YAHOO.util.EventProvider.prototype = {
	__yui_events: null, __yui_subscribers: null, subscribe: function( A, C, F, E ) {
		this.__yui_events = this.__yui_events || {};
		var D = this.__yui_events[ A ];
		if ( D ) {
			D.subscribe( C, F, E );
		} else {
			this.__yui_subscribers = this.__yui_subscribers || {};
			var B = this.__yui_subscribers;
			if ( !B[ A ] ) {
				B[ A ] = [];
			}
			B[ A ].push({ fn: C, obj: F, overrideContext: E } );
		}
	},
	unsubscribe: function( C, E, G ) {
		this.__yui_events = this.__yui_events || {};
		var A = this.__yui_events;
		if ( C ) {
			var F = A[ C ];
			if ( F ) {
				return F.unsubscribe( E, G );
			}
		} else {
			var B = true;
			for ( var D in A ) {
				if ( YAHOO.lang.hasOwnProperty( A, D ) ) {
					B = B && A[ D ].unsubscribe( E, G );
				}
			}
			return B;
		}
		return false;
	},
	unsubscribeAll: function( A ) {
		return this.unsubscribe( A );
	},
	createEvent: function( G, D ) {
		this.__yui_events = this.__yui_events || {};
		var A = D || {};
		var I = this.__yui_events;
		if ( I[ G ] ) {} else {
			var H = A.scope || this;
			var E = ( A.silent );
			var B = new YAHOO.util.CustomEvent( G, H, E, YAHOO.util.CustomEvent.FLAT );
			I[ G ] = B;
			if ( A.onSubscribeCallback ) {
				B.subscribeEvent.subscribe( A.onSubscribeCallback );
			}
			this.__yui_subscribers = this.__yui_subscribers || {};
			var F = this.__yui_subscribers[ G ];
			if ( F ) {
				for ( var C = 0; C < F.length; ++C ) {
					B.subscribe( F[ C ].fn, F[ C ].obj, F[ C ].overrideContext );
				}
			}
		}
		return I[ G ];
	},
	fireEvent: function( E, D, A, C ) {
		this.__yui_events = this.__yui_events || {};
		var G = this.__yui_events[ E ];
		if ( !G ) {
			return null;
		}
		var B = [];
		for ( var F = 1; F < arguments.length; ++F ) {
			B.push( arguments[ F ] );
		}
		return G.fire.apply( G, B );
	},
	hasEvent: function( A ) {
		if ( this.__yui_events ) {
			if ( this.__yui_events[ A ] ) {
				return true;
			}
		}
		return false;
	} };
(function() {
	var A = YAHOO.util.Event,
		C = YAHOO.lang;
	YAHOO.util.KeyListener = function( D, I, E, F ) {
		if ( !D ) {} else {
			if ( !I ) {} else {
				if ( !E ) {}
			}
		}
		if ( !F ) {
			F = YAHOO.util.KeyListener.KEYDOWN;
		}
		var G = new YAHOO.util.CustomEvent( "keyPressed" );
		this.enabledEvent = new YAHOO.util.CustomEvent( "enabled" );
		this.disabledEvent = new YAHOO.util.CustomEvent( "disabled" );
		if ( C.isString( D ) ) {
			D = document.getElementById( D );
		}
		if ( C.isFunction( E ) ) {
			G.subscribe( E );
		} else {
			G.subscribe( E.fn, E.scope, E.correctScope );
		}
		function H( O, N ) {
			if ( !I.shift ) {
				I.shift = false;
			}
			if ( !I.alt ) {
				I.alt = false;
			}
			if ( !I.ctrl ) {
				I.ctrl = false;
			}
			if ( O.shiftKey == I.shift && O.altKey == I.alt && O.ctrlKey == I.ctrl ) {
				var J,
					M = I.keys,
					L;
				if ( YAHOO.lang.isArray( M ) ) {
					for ( var K = 0; K < M.length; K++ ) {
						J = M[ K ];
						L = A.getCharCode( O );
						if ( J == L ) {
							G.fire( L, O );
							break;
						}
					}
				} else {
					L = A.getCharCode( O );
					if ( M == L ) {
						G.fire( L, O );
					}
				}
			}
		}
		this.enable = function() {
			if ( !this.enabled ) {
				A.on( D, F, H );
				this.enabledEvent.fire( I );
			}
			this.enabled = true;
		};
		this.disable = function() {
			if ( this.enabled ) {
				A.removeListener( D, F, H );
				this.disabledEvent.fire( I );
			}
			this.enabled = false;
		};
		this.toString = function() {
			return "KeyListener [" + I.keys + "] " + D.tagName + ( D.id ? "[" + D.id + "]" : "" );
		};
	};
	var B = YAHOO.util.KeyListener;
	B.KEYDOWN = "keydown";
	B.KEYUP = "keyup";
	B.KEY = { ALT: 18, BACK_SPACE: 8, CAPS_LOCK: 20, CONTROL: 17, DELETE: 46, DOWN: 40, END: 35, ENTER: 13, ESCAPE: 27, HOME: 36, LEFT: 37, META: 224, NUM_LOCK: 144, PAGE_DOWN: 34, PAGE_UP: 33, PAUSE: 19, PRINTSCREEN: 44, RIGHT: 39, SCROLL_LOCK: 145, SHIFT: 16, SPACE: 32, TAB: 9, UP: 38 };
})();
YAHOO.register( "event", YAHOO.util.Event, { version: "2.7.0", build: "1796" } );
YAHOO.register( "yahoo-dom-event", YAHOO, { version: "2.7.0", build: "1796" } );
/*
Copyright (c) 2009, Yahoo! Inc. All rights reserved.
Code licensed under the BSD License:
http://developer.yahoo.net/yui/license.txt
version: 2.7.0
*/
if ( !YAHOO.util.DragDropMgr ) {
	YAHOO.util.DragDropMgr = function() {
		var A = YAHOO.util.Event,
			B = YAHOO.util.Dom;
		return {
			useShim: false, _shimActive: false, _shimState: false, _debugShim: false, _createShim: function() {
				var C = document.createElement( "div" );
				C.id = "yui-ddm-shim";
				if ( document.body.firstChild ) {
					document.body.insertBefore( C, document.body.firstChild );
				} else {
					document.body.appendChild( C );
				}
				C.style.display = "none";
				C.style.backgroundColor = "red";
				C.style.position = "absolute";
				C.style.zIndex = "99999";
				B.setStyle( C, "opacity", "0" );
				this._shim = C;
				A.on( C, "mouseup", this.handleMouseUp, this, true );
				A.on( C, "mousemove", this.handleMouseMove, this, true );
				A.on( window, "scroll", this._sizeShim, this, true );
			},
			_sizeShim: function() {
				if ( this._shimActive ) {
					var C = this._shim;
					C.style.height = B.getDocumentHeight() + "px";
					C.style.width = B.getDocumentWidth() + "px";
					C.style.top = "0";
					C.style.left = "0";
				}
			},
			_activateShim: function() {
				if ( this.useShim ) {
					if ( !this._shim ) {
						this._createShim();
					}
					this._shimActive = true;
					var C = this._shim,
						D = "0";
					if ( this._debugShim ) {
						D = ".5";
					}
					B.setStyle( C, "opacity", D );
					this._sizeShim();
					C.style.display = "block";
				}
			},
			_deactivateShim: function() {
				this._shim.style.display = "none"; this._shimActive = false;
			},
			_shim: null, ids: {},
			handleIds: {},
			dragCurrent: null, dragOvers: {},
			deltaX: 0, deltaY: 0, preventDefault: true, stopPropagation: true, initialized: false, locked: false, interactionInfo: null, init: function() {
				this.initialized = true;
			},
			POINT: 0, INTERSECT: 1, STRICT_INTERSECT: 2, mode: 0, _execOnAll: function( E, D ) {
				for ( var F in this.ids ) {
					for ( var C in this.ids[ F ] ) {
						var G = this.ids[ F ][ C ];
						if ( !this.isTypeOfDD( G ) ) {
							continue;
						}
						G[ E ].apply( G, D );
					}
				}
			},
			_onLoad: function() {
				this.init();
				A.on( document, "mouseup", this.handleMouseUp, this, true );
				A.on( document, "mousemove", this.handleMouseMove, this, true );
				A.on( window, "unload", this._onUnload, this, true );
				A.on( window, "resize", this._onResize, this, true );
			},
			_onResize: function( C ) {
				this._execOnAll( "resetConstraints", [] );
			},
			lock: function() {
				this.locked = true;
			},
			unlock: function() {
				this.locked = false;
			},
			isLocked: function() {
				return this.locked;
			},
			locationCache: {},
			useCache: true, clickPixelThresh: 3, clickTimeThresh: 1000, dragThreshMet: false, clickTimeout: null, startX: 0, startY: 0, fromTimeout: false, regDragDrop: function( D, C ) {
				if ( !this.initialized ) {
					this.init();
				}
				if ( !this.ids[ C ] ) {
					this.ids[ C ] = {};
				}
				this.ids[ C ][ D.id ] = D;
			},
			removeDDFromGroup: function( E, C ) {
				if ( !this.ids[ C ] ) {
					this.ids[ C ] = {};
				}
				var D = this.ids[ C ];
				if ( D && D[ E.id ] ) {
					delete D[ E.id ];
				}
			},
			_remove: function( E ) {
				for ( var D in E.groups ) {
					if ( D ) {
						var C = this.ids[ D ];
						if ( C && C[ E.id ] ) {
							delete C[ E.id ];
						}
					}
				}
				delete this.handleIds[ E.id ];
			},
			regHandle: function( D, C ) {
				if ( !this.handleIds[ D ] ) {
					this.handleIds[ D ] = {};
				}
				this.handleIds[ D ][ C ] = C;
			},
			isDragDrop: function( C ) {
				return ( this.getDDById( C ) ) ? true : false;
			},
			getRelated: function( H, D ) {
				var G = [];
				for ( var F in H.groups ) {
					for ( var E in this.ids[ F ] ) {
						var C = this.ids[ F ][ E ];
						if ( !this.isTypeOfDD( C ) ) {
							continue;
						}
						if ( !D || C.isTarget ) {
							G[ G.length ] = C;
						}
					}
				}
				return G;
			},
			isLegalTarget: function( G, F ) {
				var D = this.getRelated( G, true );
				for ( var E = 0, C = D.length; E < C; ++E ) {
					if ( D[ E ].id == F.id ) {
						return true;
					}
				}
				return false;
			},
			isTypeOfDD: function( C ) {
				return ( C && C.__ygDragDrop );
			},
			isHandle: function( D, C ) {
				return ( this.handleIds[ D ] && this.handleIds[ D ][ C ] );
			},
			getDDById: function( D ) {
				for ( var C in this.ids ) {
					if ( this.ids[ C ][ D ] ) {
						return this.ids[ C ][ D ];
					}
				}
				return null;
			},
			handleMouseDown: function( E, D ) {
				this.currentTarget = YAHOO.util.Event.getTarget( E );
				this.dragCurrent = D;
				var C = D.getEl();
				this.startX = YAHOO.util.Event.getPageX( E );
				this.startY = YAHOO.util.Event.getPageY( E );
				this.deltaX = this.startX - C.offsetLeft;
				this.deltaY = this.startY - C.offsetTop;
				this.dragThreshMet = false;
				this.clickTimeout = setTimeout( function() {
					var F = YAHOO.util.DDM;
					F.startDrag( F.startX, F.startY );
					F.fromTimeout = true;
				}, this.clickTimeThresh );
			},
			startDrag: function( C, E ) {
				if ( this.dragCurrent && this.dragCurrent.useShim ) {
					this._shimState = this.useShim;
					this.useShim = true;
				}
				this._activateShim();
				clearTimeout( this.clickTimeout );
				var D = this.dragCurrent;
				if ( D && D.events.b4StartDrag ) {
					D.b4StartDrag( C, E );
					D.fireEvent( "b4StartDragEvent", { x: C, y: E } );
				}
				if ( D && D.events.startDrag ) {
					D.dragStart($event);
					D.fireEvent( "startDragEvent", { x: C, y: E } );
				}
				this.dragThreshMet = true;
			},
			handleMouseUp: function( C ) {
				if ( this.dragCurrent ) {
					clearTimeout( this.clickTimeout );
					if ( this.dragThreshMet ) {
						if ( this.fromTimeout ) {
							this.fromTimeout = false;
							this.handleMouseMove( C );
						}
						this.fromTimeout = false;
						this.fireEvents( C, true );
					} else {}
					this.stopDrag( C );
					this.stopEvent( C );
				}
			},
			stopEvent: function( C ) {
				if ( this.stopPropagation ) {
					YAHOO.util.Event.stopPropagation( C );
				}
				if ( this.preventDefault ) {
					YAHOO.util.Event.preventDefault( C );
				}
			},
			stopDrag: function( E, D ) {
				var C = this.dragCurrent; if ( C && !D ) {
					if ( this.dragThreshMet ) {
						if ( C.events.b4EndDrag ) {
							C.b4EndDrag( E );
							C.fireEvent( "b4EndDragEvent", { e: E } );
						}
						if ( C.events.endDrag ) {
							C.endDrag( E );
							C.fireEvent( "endDragEvent", { e: E } );
						}
					}
					if ( C.events.mouseUp ) {
						C.onMouseUp( E );
						C.fireEvent( "mouseUpEvent", { e: E } );
					}
				}
				if ( this._shimActive ) {
					this._deactivateShim();
					if ( this.dragCurrent && this.dragCurrent.useShim ) {
						this.useShim = this._shimState;
						this._shimState = false;
					}
				}
				this.dragCurrent = null;
				this.dragOvers = {};
			},
			handleMouseMove: function( F ) {
				var C = this.dragCurrent; if ( C ) {
					if ( YAHOO.util.Event.isIE && !F.button ) {
						this.stopEvent( F );
						return this.handleMouseUp( F );
					} else {
						if ( F.clientX < 0 || F.clientY < 0 ) {}
					}
					if ( !this.dragThreshMet ) {
						var E = Math.abs( this.startX - YAHOO.util.Event.getPageX( F ) );
						var D = Math.abs( this.startY - YAHOO.util.Event.getPageY( F ) );
						if ( E > this.clickPixelThresh || D > this.clickPixelThresh ) {
							this.startDrag( this.startX, this.startY );
						}
					}
					if ( this.dragThreshMet ) {
						if ( C && C.events.b4Drag ) {
							C.b4Drag( F );
							C.fireEvent( "b4DragEvent", { e: F } );
						}
						if ( C && C.events.drag ) {
							C.onDrag( F );
							C.fireEvent( "dragEvent", { e: F } );
						}
						if ( C ) {
							this.fireEvents( F, false );
						}
					}
					this.stopEvent( F );
				}
			},
			fireEvents: function( V, L ) {
				var a = this.dragCurrent; if ( !a || a.isLocked() || a.dragOnly ) {
					return;
				}
				var N = YAHOO.util.Event.getPageX( V ),
					M = YAHOO.util.Event.getPageY( V ),
					P = new YAHOO.util.Point( N, M ),
					K = a.getTargetCoord( P.x, P.y ),
					F = a.getDragEl(),
					E = [ "out", "over", "drop", "enter" ],
					U = new YAHOO.util.Region( K.y, K.x + F.offsetWidth, K.y + F.offsetHeight, K.x ),
					I = [],
					D = {},
					Q = [],
					c = { outEvts: [], overEvts: [], dropEvts: [], enterEvts: [] }; for ( var S in this.dragOvers ) {
					var d = this.dragOvers[ S ];
					if ( !this.isTypeOfDD( d ) ) {
						continue;
					}
					if ( !this.isOverTarget( P, d, this.mode, U ) ) {
						c.outEvts.push( d );
					}
					I[ S ] = true;
					delete this.dragOvers[ S ];
				}
				for ( var R in a.groups ) {
					if ( "string" != typeof R ) {
						continue;
					}
					for ( S in this.ids[ R ] ) {
						var G = this.ids[ R ][ S ];
						if ( !this.isTypeOfDD( G ) ) {
							continue;
						}
						if ( G.isTarget && !G.isLocked() && G != a ) {
							if ( this.isOverTarget( P, G, this.mode, U ) ) {
								D[ R ] = true;
								if ( L ) {
									c.dropEvts.push( G );
								} else {
									if ( !I[ G.id ] ) {
										c.enterEvts.push( G );
									} else {
										c.overEvts.push( G );
									}
									this.dragOvers[ G.id ] = G;
								}
							}
						}
					}
				}
				this.interactionInfo = { out: c.outEvts, enter: c.enterEvts, over: c.overEvts, drop: c.dropEvts, point: P, draggedRegion: U, sourceRegion: this.locationCache[ a.id ], validDrop: L }; for ( var C in D ) {
					Q.push( C );
				}
				if ( L && !c.dropEvts.length ) {
					this.interactionInfo.validDrop = false;
					if ( a.events.invalidDrop ) {
						a.onInvalidDrop( V );
						a.fireEvent( "invalidDropEvent", { e: V } );
					}
				}
				for ( S = 0; S < E.length; S++ ) {
					var Y = null;
					if ( c[ E[ S ] + "Evts" ] ) {
						Y = c[ E[ S ] + "Evts" ];
					}
					if ( Y && Y.length ) {
						var H = E[ S ].charAt( 0 ).toUpperCase() + E[ S ].substr( 1 ),
							X = "onDrag" + H,
							J = "b4Drag" + H,
							O = "drag" + H + "Event",
							W = "drag" + H;
						if ( this.mode ) {
							if ( a.events[ J ] ) {
								a[ J ]( V, Y, Q );
								a.fireEvent( J + "Event", { event: V, info: Y, group: Q } );
							}
							if ( a.events[ W ] ) {
								a[ X ]( V, Y, Q );
								a.fireEvent( O, { event: V, info: Y, group: Q } );
							}
						} else {
							for ( var Z = 0, T = Y.length; Z < T; ++Z ) {
								if ( a.events[ J ] ) {
									a[ J ]( V, Y[ Z ].id, Q[ 0 ] );
									a.fireEvent( J + "Event", { event: V, info: Y[ Z ].id, group: Q[ 0 ] } );
								}
								if ( a.events[ W ] ) {
									a[ X ]( V, Y[ Z ].id, Q[ 0 ] );
									a.fireEvent( O, { event: V, info: Y[ Z ].id, group: Q[ 0 ] } );
								}
							}
						}
					}
				}
			},
			getBestMatch: function( E ) {
				var G = null; var D = E.length; if ( D == 1 ) {
					G = E[ 0 ];
				} else {
					for ( var F = 0; F < D; ++F ) {
						var C = E[ F ];
						if ( this.mode == this.INTERSECT && C.cursorIsOver ) {
							G = C;
							break;
						} else {
							if ( !G || !G.overlap || ( C.overlap && G.overlap.getArea() < C.overlap.getArea() ) ) {
								G = C;
							}
						}
					}
				}
				return G;
			},
			refreshCache: function( D ) {
				var F = D || this.ids; for ( var C in F ) {
					if ( "string" != typeof C ) {
						continue;
					}
					for ( var E in this.ids[ C ] ) {
						var G = this.ids[ C ][ E ];
						if ( this.isTypeOfDD( G ) ) {
							var H = this.getLocation( G );
							if ( H ) {
								this.locationCache[ G.id ] = H;
							} else {
								delete this.locationCache[ G.id ];
							}
						}
					}
				}
			},
			verifyEl: function( D ) {
				try {
					if ( D ) {
						var C = D.offsetParent;
						if ( C ) {
							return true;
						}
					}
				} catch ( E ) {}
				return false;
			},
			getLocation: function( H ) {
				if ( !this.isTypeOfDD( H ) ) {
					return null;
				}
				var F = H.getEl(),
					K, E, D, M, L, N, C, J, G;
				try {
					K = YAHOO.util.Dom.getXY( F );
				} catch ( I ) {}
				if ( !K ) {
					return null;
				}
				E = K[ 0 ];
				D = E + F.offsetWidth;
				M = K[ 1 ];
				L = M + F.offsetHeight;
				N = M - H.padding[ 0 ];
				C = D + H.padding[ 1 ];
				J = L + H.padding[ 2 ];
				G = E - H.padding[ 3 ];
				return new YAHOO.util.Region( N, C, J, G );
			},
			isOverTarget: function( K, C, E, F ) {
				var G = this.locationCache[ C.id ];
				if ( !G || !this.useCache ) {
					G = this.getLocation( C );
					this.locationCache[ C.id ] = G;
				}
				if ( !G ) {
					return false;
				}
				C.cursorIsOver = G.contains( K );
				var J = this.dragCurrent;
				if ( !J || ( !E && !J.constrainX && !J.constrainY ) ) {
					return C.cursorIsOver;
				}
				C.overlap = null;
				if ( !F ) {
					var H = J.getTargetCoord( K.x, K.y );
					var D = J.getDragEl();
					F = new YAHOO.util.Region( H.y, H.x + D.offsetWidth, H.y + D.offsetHeight, H.x );
				}
				var I = F.intersect( G );
				if ( I ) {
					C.overlap = I;
					return ( E ) ? true : C.cursorIsOver;
				} else {
					return false;
				}
			},
			_onUnload: function( D, C ) {
				this.unregAll();
			},
			unregAll: function() {
				if ( this.dragCurrent ) {
					this.stopDrag();
					this.dragCurrent = null;
				}
				this._execOnAll( "unreg", [] );
				this.ids = {};
			},
			elementCache: {},
			getElWrapper: function( D ) {
				var C = this.elementCache[ D ];
				if ( !C || !C.el ) {
					C = this.elementCache[ D ] = new this.ElementWrapper( YAHOO.util.Dom.get( D ) );
				}
				return C;
			},
			getElement: function( C ) {
				return YAHOO.util.Dom.get( C );
			},
			getCss: function( D ) {
				var C = YAHOO.util.Dom.get( D );
				return ( C ) ? C.style : null;
			},
			ElementWrapper: function( C ) {
				this.el = C || null; this.id = this.el && C.id; this.css = this.el && C.style;
			},
			getPosX: function( C ) {
				return YAHOO.util.Dom.getX( C );
			},
			getPosY: function( C ) {
				return YAHOO.util.Dom.getY( C );
			},
			swapNode: function( E, C ) {
				if ( E.swapNode ) {
					E.swapNode( C );
				} else {
					var F = C.parentNode;
					var D = C.nextSibling;
					if ( D == E ) {
						F.insertBefore( E, C );
					} else {
						if ( C == E.nextSibling ) {
							F.insertBefore( C, E );
						} else {
							E.parentNode.replaceChild( C, E );
							F.insertBefore( E, D );
						}
					}
				}
			},
			getScroll: function() {
				var E, C,
					F = document.documentElement,
					D = document.body; if ( F && ( F.scrollTop || F.scrollLeft ) ) {
					E = F.scrollTop;
					C = F.scrollLeft;
				} else {
					if ( D ) {
						E = D.scrollTop;
						C = D.scrollLeft;
					} else {}
				}
				return { top: E, left: C };
			},
			getStyle: function( D, C ) {
				return YAHOO.util.Dom.getStyle( D, C );
			},
			getScrollTop: function() {
				return this.getScroll().top;
			},
			getScrollLeft: function() {
				return this.getScroll().left;
			},
			moveToEl: function( C, E ) {
				var D = YAHOO.util.Dom.getXY( E );
				YAHOO.util.Dom.setXY( C, D );
			},
			getClientHeight: function() {
				return YAHOO.util.Dom.getViewportHeight();
			},
			getClientWidth: function() {
				return YAHOO.util.Dom.getViewportWidth();
			},
			numericSort: function( D, C ) {
				return ( D - C );
			},
			_timeoutCount: 0, _addListeners: function() {
				var C = YAHOO.util.DDM; if ( YAHOO.util.Event && document ) {
					C._onLoad();
				} else {
					if ( C._timeoutCount > 2000 ) {} else {
						setTimeout( C._addListeners, 10 );
						if ( document && document.body ) {
							C._timeoutCount += 1;
						}
					}
				}
			},
			handleWasClicked: function( C, E ) {
				if ( this.isHandle( E, C.id ) ) {
					return true;
				} else {
					var D = C.parentNode;
					while ( D ) {
						if ( this.isHandle( E, D.id ) ) {
							return true;
						} else {
							D = D.parentNode;
						}
					}
				}
				return false;
			} };
	}();
	YAHOO.util.DDM = YAHOO.util.DragDropMgr;
	YAHOO.util.DDM._addListeners();
}( function() {
	var A = YAHOO.util.Event;
	var B = YAHOO.util.Dom;
	YAHOO.util.DragDrop = function( E, C, D ) {
		if ( E ) {
			this.init( E, C, D );
		}
	};
	YAHOO.util.DragDrop.prototype = {
		events: null, on: function() {
			this.subscribe.apply( this, arguments );
		},
		id: null, config: null, dragElId: null, handleElId: null, invalidHandleTypes: null, invalidHandleIds: null, invalidHandleClasses: null, startPageX: 0, startPageY: 0, groups: null, locked: false, lock: function() {
			this.locked = true;
		},
		unlock: function() {
			this.locked = false;
		},
		isTarget: true, padding: null, dragOnly: false, useShim: false, _domRef: null, __ygDragDrop: true, constrainX: false, constrainY: false, minX: 0, maxX: 0, minY: 0, maxY: 0, deltaX: 0, deltaY: 0, maintainOffset: false, xTicks: null, yTicks: null, primaryButtonOnly: true, available: false, hasOuterHandles: false, cursorIsOver: false, overlap: null, b4StartDrag: function( C, D ) {},
		startDrag: function( C, D ) {},
		b4Drag: function( C ) {},
		onDrag: function( C ) {},
		onDragEnter: function( C, D ) {},
		b4DragOver: function( C ) {},
		onDragOver: function( C, D ) {},
		b4DragOut: function( C ) {},
		onDragOut: function( C, D ) {},
		b4DragDrop: function( C ) {},
		onDragDrop: function( C, D ) {},
		onInvalidDrop: function( C ) {},
		b4EndDrag: function( C ) {},
		endDrag: function( C ) {},
		b4MouseDown: function( C ) {},
		onMouseDown: function( C ) {},
		onMouseUp: function( C ) {},
		onAvailable: function() {},
		getEl: function() {
			if ( !this._domRef ) {
				this._domRef = B.get( this.id );
			}
			return this._domRef;
		},
		getDragEl: function() {
			return B.get( this.dragElId );
		},
		init: function( F, C, D ) {
			this.initTarget( F, C, D );
			A.on( this._domRef || this.id, "mousedown", this.handleMouseDown, this, true );
			for ( var E in this.events ) {
				this.createEvent( E + "Event" );
			}
		},
		initTarget: function( E, C, D ) {
			this.config = D || {};
			this.events = {};
			this.DDM = YAHOO.util.DDM;
			this.groups = {};
			if ( typeof E !== "string" ) {
				this._domRef = E;
				E = B.generateId( E );
			}
			this.id = E;
			this.addToGroup( ( C ) ? C : "default" );
			this.handleElId = E;
			A.onAvailable( E, this.handleOnAvailable, this, true );
			this.setDragElId( E );
			this.invalidHandleTypes = { A: "A" }; this.invalidHandleIds = {};
			this.invalidHandleClasses = [];
			this.applyConfig();
		},
		applyConfig: function() {
			this.events = { mouseDown: true, b4MouseDown: true, mouseUp: true, b4StartDrag: true, startDrag: true, b4EndDrag: true, endDrag: true, drag: true, b4Drag: true, invalidDrop: true, b4DragOut: true, dragOut: true, dragEnter: true, b4DragOver: true, dragOver: true, b4DragDrop: true, dragDrop: true }; if ( this.config.events ) {
				for ( var C in this.config.events ) {
					if ( this.config.events[ C ] === false ) {
						this.events[ C ] = false;
					}
				}
			}
			this.padding = this.config.padding || [ 0, 0, 0, 0 ];
			this.isTarget = ( this.config.isTarget !== false );
			this.maintainOffset = ( this.config.maintainOffset );
			this.primaryButtonOnly = ( this.config.primaryButtonOnly !== false );
			this.dragOnly = ( ( this.config.dragOnly === true ) ? true : false );
			this.useShim = ( ( this.config.useShim === true ) ? true : false );
		},
		handleOnAvailable: function() {
			this.available = true; this.resetConstraints();
			this.onAvailable();
		},
		setPadding: function( E, C, F, D ) {
			if ( !C && 0 !== C ) {
				this.padding = [ E, E, E, E ];
			} else {
				if ( !F && 0 !== F ) {
					this.padding = [ E, C, E, C ];
				} else {
					this.padding = [ E, C, F, D ];
				}
			}
		},
		setInitPosition: function( F, E ) {
			var G = this.getEl();
			if ( !this.DDM.verifyEl( G ) ) {
				if ( G && G.style && ( G.style.display == "none" ) ) {} else {}
				return;
			}
			var D = F || 0;
			var C = E || 0;
			var H = B.getXY( G );
			this.initPageX = H[ 0 ] - D;
			this.initPageY = H[ 1 ] - C;
			this.lastPageX = H[ 0 ];
			this.lastPageY = H[ 1 ];
			this.setStartPosition( H );
		},
		setStartPosition: function( D ) {
			var C = D || B.getXY( this.getEl() );
			this.deltaSetXY = null;
			this.startPageX = C[ 0 ];
			this.startPageY = C[ 1 ];
		},
		addToGroup: function( C ) {
			this.groups[ C ] = true;
			this.DDM.regDragDrop( this, C );
		},
		removeFromGroup: function( C ) {
			if ( this.groups[ C ] ) {
				delete this.groups[ C ];
			}
			this.DDM.removeDDFromGroup( this, C );
		},
		setDragElId: function( C ) {
			this.dragElId = C;
		},
		setHandleElId: function( C ) {
			if ( typeof C !== "string" ) {
				C = B.generateId( C );
			}
			this.handleElId = C;
			this.DDM.regHandle( this.id, C );
		},
		setOuterHandleElId: function( C ) {
			if ( typeof C !== "string" ) {
				C = B.generateId( C );
			}
			A.on( C, "mousedown", this.handleMouseDown, this, true );
			this.setHandleElId( C );
			this.hasOuterHandles = true;
		},
		unreg: function() {
			A.removeListener( this.id, "mousedown", this.handleMouseDown );
			this._domRef = null;
			this.DDM._remove( this );
		},
		isLocked: function() {
			return ( this.DDM.isLocked() || this.locked );
		},
		handleMouseDown: function( J, I ) {
			var D = J.which || J.button; if ( this.primaryButtonOnly && D > 1 ) {
				return;
			}
			if ( this.isLocked() ) {
				return;
			}
			var C = this.b4MouseDown( J ),
				F = true;
			if ( this.events.b4MouseDown ) {
				F = this.fireEvent( "b4MouseDownEvent", J );
			}
			var E = this.onMouseDown( J ),
				H = true;
			if ( this.events.mouseDown ) {
				H = this.fireEvent( "mouseDownEvent", J );
			}
			if ( ( C === false ) || ( E === false ) || ( F === false ) || ( H === false ) ) {
				return;
			}
			this.DDM.refreshCache( this.groups );
			var G = new YAHOO.util.Point( A.getPageX( J ), A.getPageY( J ) );
			if ( !this.hasOuterHandles && !this.DDM.isOverTarget( G, this ) ) {} else {
				if ( this.clickValidator( J ) ) {
					this.setStartPosition();
					this.DDM.handleMouseDown( J, this );
					this.DDM.stopEvent( J );
				} else {}
			}
		},
		clickValidator: function( D ) {
			var C = YAHOO.util.Event.getTarget( D );
			return ( this.isValidHandleChild( C ) && ( this.id == this.handleElId || this.DDM.handleWasClicked( C, this.id ) ) );
		},
		getTargetCoord: function( E, D ) {
			var C = E - this.deltaX; var F = D - this.deltaY; if ( this.constrainX ) {
				if ( C < this.minX ) {
					C = this.minX;
				}
				if ( C > this.maxX ) {
					C = this.maxX;
				}
			}
			if ( this.constrainY ) {
				if ( F < this.minY ) {
					F = this.minY;
				}
				if ( F > this.maxY ) {
					F = this.maxY;
				}
			}
			C = this.getTick( C, this.xTicks );
			F = this.getTick( F, this.yTicks );
			return { x: C, y: F };
		},
		addInvalidHandleType: function( C ) {
			var D = C.toUpperCase();
			this.invalidHandleTypes[ D ] = D;
		},
		addInvalidHandleId: function( C ) {
			if ( typeof C !== "string" ) {
				C = B.generateId( C );
			}
			this.invalidHandleIds[ C ] = C;
		},
		addInvalidHandleClass: function( C ) {
			this.invalidHandleClasses.push( C );
		},
		removeInvalidHandleType: function( C ) {
			var D = C.toUpperCase();
			delete this.invalidHandleTypes[ D ];
		},
		removeInvalidHandleId: function( C ) {
			if ( typeof C !== "string" ) {
				C = B.generateId( C );
			}
			delete this.invalidHandleIds[ C ];
		},
		removeInvalidHandleClass: function( D ) {
			for ( var E = 0, C = this.invalidHandleClasses.length; E < C; ++E ) {
				if ( this.invalidHandleClasses[ E ] == D ) {
					delete this.invalidHandleClasses[ E ];
				}
			}
		},
		isValidHandleChild: function( F ) {
			var E = true; var H; try {
				H = F.nodeName.toUpperCase();
			} catch ( G ) {
				H = F.nodeName;
			}
			E = E && !this.invalidHandleTypes[ H ];
			E = E && !this.invalidHandleIds[ F.id ];
			for ( var D = 0, C = this.invalidHandleClasses.length; E && D < C; ++D ) {
				E = !B.hasClass( F, this.invalidHandleClasses[ D ] );
			}
			return E;
		},
		setXTicks: function( F, C ) {
			this.xTicks = [];
			this.xTickSize = C;
			var E = {};
			for ( var D = this.initPageX; D >= this.minX; D = D - C ) {
				if ( !E[ D ] ) {
					this.xTicks[ this.xTicks.length ] = D;
					E[ D ] = true;
				}
			}
			for ( D = this.initPageX; D <= this.maxX; D = D + C ) {
				if ( !E[ D ] ) {
					this.xTicks[ this.xTicks.length ] = D;
					E[ D ] = true;
				}
			}
			this.xTicks.sort( this.DDM.numericSort );
		},
		setYTicks: function( F, C ) {
			this.yTicks = [];
			this.yTickSize = C;
			var E = {};
			for ( var D = this.initPageY; D >= this.minY; D = D - C ) {
				if ( !E[ D ] ) {
					this.yTicks[ this.yTicks.length ] = D;
					E[ D ] = true;
				}
			}
			for ( D = this.initPageY; D <= this.maxY; D = D + C ) {
				if ( !E[ D ] ) {
					this.yTicks[ this.yTicks.length ] = D;
					E[ D ] = true;
				}
			}
			this.yTicks.sort( this.DDM.numericSort );
		},
		setXConstraint: function( E, D, C ) {
			this.leftConstraint = parseInt( E, 10 );
			this.rightConstraint = parseInt( D, 10 );
			this.minX = this.initPageX - this.leftConstraint;
			this.maxX = this.initPageX + this.rightConstraint;
			if ( C ) {
				this.setXTicks( this.initPageX, C );
			}
			this.constrainX = true;
		},
		clearConstraints: function() {
			this.constrainX = false; this.constrainY = false; this.clearTicks();
		},
		clearTicks: function() {
			this.xTicks = null; this.yTicks = null; this.xTickSize = 0; this.yTickSize = 0;
		},
		setYConstraint: function( C, E, D ) {
			this.topConstraint = parseInt( C, 10 );
			this.bottomConstraint = parseInt( E, 10 );
			this.minY = this.initPageY - this.topConstraint;
			this.maxY = this.initPageY + this.bottomConstraint;
			if ( D ) {
				this.setYTicks( this.initPageY, D );
			}
			this.constrainY = true;
		},
		resetConstraints: function() {
			if ( this.initPageX || this.initPageX === 0 ) {
				var D = ( this.maintainOffset ) ? this.lastPageX - this.initPageX : 0;
				var C = ( this.maintainOffset ) ? this.lastPageY - this.initPageY : 0;
				this.setInitPosition( D, C );
			} else {
				this.setInitPosition();
			}
			if ( this.constrainX ) {
				this.setXConstraint( this.leftConstraint, this.rightConstraint, this.xTickSize );
			}
			if ( this.constrainY ) {
				this.setYConstraint( this.topConstraint, this.bottomConstraint, this.yTickSize );
			}
		},
		getTick: function( I, F ) {
			if ( !F ) {
				return I;
			} else {
				if ( F[ 0 ] >= I ) {
					return F[ 0 ];
				} else {
					for ( var D = 0, C = F.length; D < C; ++D ) {
						var E = D + 1;
						if ( F[ E ] && F[ E ] >= I ) {
							var H = I - F[ D ];
							var G = F[ E ] - I;
							return ( G > H ) ? F[ D ] : F[ E ];
						}
					}
					return F[ F.length - 1 ];
				}
			}
		},
		toString: function() {
			return ( "DragDrop " + this.id );
		} }; YAHOO.augment( YAHOO.util.DragDrop, YAHOO.util.EventProvider );
})();
YAHOO.util.DD = function( C, A, B ) {
	if ( C ) {
		this.init( C, A, B );
	}
};
YAHOO.extend( YAHOO.util.DD, YAHOO.util.DragDrop, {
	scroll: true, autoOffset: function( C, B ) {
		var A = C - this.startPageX; var D = B - this.startPageY; this.setDelta( A, D );
	},
	setDelta: function( B, A ) {
		this.deltaX = B; this.deltaY = A;
	},
	setDragElPos: function( C, B ) {
		var A = this.getDragEl();
		this.alignElWithMouse( A, C, B );
	},
	alignElWithMouse: function( C, G, F ) {
		var E = this.getTargetCoord( G, F );
		if ( !this.deltaSetXY ) {
			var H = [ E.x, E.y ];
			YAHOO.util.Dom.setXY( C, H );
			var D = parseInt( YAHOO.util.Dom.getStyle( C, "left" ), 10 );
			var B = parseInt( YAHOO.util.Dom.getStyle( C, "top" ), 10 );
			this.deltaSetXY = [ D - E.x, B - E.y ];
		} else {
			YAHOO.util.Dom.setStyle( C, "left", ( E.x + this.deltaSetXY[ 0 ] ) + "px" );
			YAHOO.util.Dom.setStyle( C, "top", ( E.y + this.deltaSetXY[ 1 ] ) + "px" );
		}
		this.cachePosition( E.x, E.y );
		var A = this;
		setTimeout( function() {
			A.autoScroll.call( A, E.x, E.y, C.offsetHeight, C.offsetWidth );
		}, 0 );
	},
	cachePosition: function( B, A ) {
		if ( B ) {
			this.lastPageX = B;
			this.lastPageY = A;
		} else {
			var C = YAHOO.util.Dom.getXY( this.getEl() );
			this.lastPageX = C[ 0 ];
			this.lastPageY = C[ 1 ];
		}
	},
	autoScroll: function( J, I, E, K ) {
		if ( this.scroll ) {
			var L = this.DDM.getClientHeight();
			var B = this.DDM.getClientWidth();
			var N = this.DDM.getScrollTop();
			var D = this.DDM.getScrollLeft();
			var H = E + I;
			var M = K + J;
			var G = ( L + N - I - this.deltaY );
			var F = ( B + D - J - this.deltaX );
			var C = 40;
			var A = ( document.all ) ? 80 : 30;
			if ( H > L && G < C ) {
				window.scrollTo( D, N + A );
			}
			if ( I < N && N > 0 && I - N < C ) {
				window.scrollTo( D, N - A );
			}
			if ( M > B && F < C ) {
				window.scrollTo( D + A, N );
			}
			if ( J < D && D > 0 && J - D < C ) {
				window.scrollTo( D - A, N );
			}
		}
	},
	applyConfig: function() {
		YAHOO.util.DD.superclass.applyConfig.call( this );
		this.scroll = ( this.config.scroll !== false );
	},
	b4MouseDown: function( A ) {
		this.setStartPosition();
		this.autoOffset( YAHOO.util.Event.getPageX( A ), YAHOO.util.Event.getPageY( A ) );
	},
	b4Drag: function( A ) {
		this.setDragElPos( YAHOO.util.Event.getPageX( A ), YAHOO.util.Event.getPageY( A ) );
	},
	toString: function() {
		return ( "DD " + this.id );
	} } );
YAHOO.util.DDProxy = function( C, A, B ) {
	if ( C ) {
		this.init( C, A, B );
		this.initFrame();
	}
};
YAHOO.util.DDProxy.dragElId = "ygddfdiv";
YAHOO.extend( YAHOO.util.DDProxy, YAHOO.util.DD, {
	resizeFrame: true, centerFrame: false, createFrame: function() {
		var B = this,
			A = document.body; if ( !A || !A.firstChild ) {
			setTimeout( function() {
				B.createFrame();
			}, 50 );
			return;
		}
		var F = this.getDragEl(),
			E = YAHOO.util.Dom;
		if ( !F ) {
			F = document.createElement( "div" );
			F.id = this.dragElId;
			var D = F.style;
			D.position = "absolute";
			D.visibility = "hidden";
			D.cursor = "move";
			D.border = "2px solid #aaa";
			D.zIndex = 999;
			D.height = "25px";
			D.width = "25px";
			var C = document.createElement( "div" );
			E.setStyle( C, "height", "100%" );
			E.setStyle( C, "width", "100%" );
			E.setStyle( C, "background-color", "#ccc" );
			E.setStyle( C, "opacity", "0" );
			F.appendChild( C );
			A.insertBefore( F, A.firstChild );
		}
	},
	initFrame: function() {
		this.createFrame();
	},
	applyConfig: function() {
		YAHOO.util.DDProxy.superclass.applyConfig.call( this );
		this.resizeFrame = ( this.config.resizeFrame !== false );
		this.centerFrame = ( this.config.centerFrame );
		this.setDragElId( this.config.dragElId || YAHOO.util.DDProxy.dragElId );
	},
	showFrame: function( E, D ) {
		var C = this.getEl();
		var A = this.getDragEl();
		var B = A.style;
		this._resizeProxy();
		if ( this.centerFrame ) {
			this.setDelta( Math.round( parseInt( B.width, 10 ) / 2 ), Math.round( parseInt( B.height, 10 ) / 2 ) );
		}
		this.setDragElPos( E, D );
		YAHOO.util.Dom.setStyle( A, "visibility", "visible" );
	},
	_resizeProxy: function() {
		if ( this.resizeFrame ) {
			var H = YAHOO.util.Dom;
			var B = this.getEl();
			var C = this.getDragEl();
			var G = parseInt( H.getStyle( C, "borderTopWidth" ), 10 );
			var I = parseInt( H.getStyle( C, "borderRightWidth" ), 10 );
			var F = parseInt( H.getStyle( C, "borderBottomWidth" ), 10 );
			var D = parseInt( H.getStyle( C, "borderLeftWidth" ), 10 );
			if ( isNaN( G ) ) {
				G = 0;
			}
			if ( isNaN( I ) ) {
				I = 0;
			}
			if ( isNaN( F ) ) {
				F = 0;
			}
			if ( isNaN( D ) ) {
				D = 0;
			}
			var E = Math.max( 0, B.offsetWidth - I - D );
			var A = Math.max( 0, B.offsetHeight - G - F );
			H.setStyle( C, "width", E + "px" );
			H.setStyle( C, "height", A + "px" );
		}
	},
	b4MouseDown: function( B ) {
		this.setStartPosition();
		var A = YAHOO.util.Event.getPageX( B );
		var C = YAHOO.util.Event.getPageY( B );
		this.autoOffset( A, C );
	},
	b4StartDrag: function( A, B ) {
		this.showFrame( A, B );
	},
	b4EndDrag: function( A ) {
		YAHOO.util.Dom.setStyle( this.getDragEl(), "visibility", "hidden" );
	},
	endDrag: function( D ) {
		var C = YAHOO.util.Dom; var B = this.getEl();
		var A = this.getDragEl();
		C.setStyle( A, "visibility", "" );
		C.setStyle( B, "visibility", "hidden" );
		YAHOO.util.DDM.moveToEl( B, A );
		C.setStyle( A, "visibility", "hidden" );
		C.setStyle( B, "visibility", "" );
	},
	toString: function() {
		return ( "DDProxy " + this.id );
	} } );
YAHOO.util.DDTarget = function( C, A, B ) {
	if ( C ) {
		this.initTarget( C, A, B );
	}
};
YAHOO.extend( YAHOO.util.DDTarget, YAHOO.util.DragDrop, {
	toString: function() {
		return ( "DDTarget " + this.id );
	} } );
YAHOO.register( "dragdrop", YAHOO.util.DragDropMgr, { version: "2.7.0", build: "1796" } );
/*
Copyright (c) 2009, Yahoo! Inc. All rights reserved.
Code licensed under the BSD License:
http://developer.yahoo.net/yui/license.txt
version: 2.7.0
*/ ( function() {
	var B = YAHOO.util.Dom.getXY,
		A = YAHOO.util.Event,
		D = Array.prototype.slice;

	function C( G, E, F, H ) {
		C.ANIM_AVAIL = ( !YAHOO.lang.isUndefined( YAHOO.util.Anim ) );
		if ( G ) {
			this.init( G, E, true );
			this.initSlider( H );
			this.initThumb( F );
		}
	}
	YAHOO.lang.augmentObject( C, {
		getHorizSlider: function( F, G, I, H, E ) {
			return new C( F, F, new YAHOO.widget.SliderThumb( G, F, I, H, 0, 0, E ), "horiz" );
		},
		getVertSlider: function( G, H, E, I, F ) {
			return new C( G, G, new YAHOO.widget.SliderThumb( H, G, 0, 0, E, I, F ), "vert" );
		},
		getSliderRegion: function( G, H, J, I, E, K, F ) {
			return new C( G, G, new YAHOO.widget.SliderThumb( H, G, J, I, E, K, F ), "region" );
		},
		SOURCE_UI_EVENT: 1, SOURCE_SET_VALUE: 2, SOURCE_KEY_EVENT: 3, ANIM_AVAIL: false }, true );
	YAHOO.extend( C, YAHOO.util.DragDrop, {
		_mouseDown: false, dragOnly: true, initSlider: function( E ) {
			this.type = E; this.createEvent( "change", this );
			this.createEvent( "slideStart", this );
			this.createEvent( "slideEnd", this );
			this.isTarget = false;
			this.animate = C.ANIM_AVAIL;
			this.backgroundEnabled = true;
			this.tickPause = 40;
			this.enableKeys = true;
			this.keyIncrement = 20;
			this.moveComplete = true;
			this.animationDuration = 0.2;
			this.SOURCE_UI_EVENT = 1;
			this.SOURCE_SET_VALUE = 2;
			this.valueChangeSource = 0;
			this._silent = false;
			this.lastOffset = [ 0, 0 ];
		},
		initThumb: function( F ) {
			var E = this; this.thumb = F; F.cacheBetweenDrags = true; if ( F._isHoriz && F.xTicks && F.xTicks.length ) {
				this.tickPause = Math.round( 360 / F.xTicks.length );
			} else {
				if ( F.yTicks && F.yTicks.length ) {
					this.tickPause = Math.round( 360 / F.yTicks.length );
				}
			}
			F.onAvailable = function() {
				return E.setStartSliderState();
			};
			F.onMouseDown = function() {
				E._mouseDown = true;
				return E.focus();
			};
			F.startDrag = function() {
				E._slideStart();
			};
			F.onDrag = function() {
				E.fireEvents( true );
			};
			F.onMouseUp = function() {
				E.thumbMouseUp();
			};
		},
		onAvailable: function() {
			this._bindKeyEvents();
		},
		_bindKeyEvents: function() {
			A.on( this.id, "keydown", this.handleKeyDown, this, true );
			A.on( this.id, "keypress", this.handleKeyPress, this, true );
		},
		handleKeyPress: function( F ) {
			if ( this.enableKeys ) {
				var E = A.getCharCode( F );
				switch ( E ) {
					case 37:
					case 38:
					case 39:
					case 40:
					case 36:
					case 35:
						A.preventDefault( F );
						break;default:
				}
			}
		},
		handleKeyDown: function( J ) {
			if ( this.enableKeys ) {
				var G = A.getCharCode( J ),
					F = this.thumb,
					H = this.getXValue(),
					E = this.getYValue(),
					I = true;
				switch ( G ) {
					case 37:
						H -= this.keyIncrement;
						break;case 38:
						E -= this.keyIncrement;
						break;case 39:
						H += this.keyIncrement;
						break;case 40:
						E += this.keyIncrement;
						break;case 36:
						H = F.leftConstraint;
						E = F.topConstraint;
						break;case 35:
						H = F.rightConstraint;
						E = F.bottomConstraint;
						break;default:
						I = false;
				}
				if ( I ) {
					if ( F._isRegion ) {
						this._setRegionValue( C.SOURCE_KEY_EVENT, H, E, true );
					} else {
						this._setValue( C.SOURCE_KEY_EVENT, ( F._isHoriz ? H : E ), true );
					}
					A.stopEvent( J );
				}
			}
		},
		setStartSliderState: function() {
			this.setThumbCenterPoint();
			this.baselinePos = B( this.getEl() );
			this.thumb.startOffset = this.thumb.getOffsetFromParent( this.baselinePos );
			if ( this.thumb._isRegion ) {
				if ( this.deferredSetRegionValue ) {
					this._setRegionValue.apply( this, this.deferredSetRegionValue );
					this.deferredSetRegionValue = null;
				} else {
					this.setRegionValue( 0, 0, true, true, true );
				}
			} else {
				if ( this.deferredSetValue ) {
					this._setValue.apply( this, this.deferredSetValue );
					this.deferredSetValue = null;
				} else {
					this.setValue( 0, true, true, true );
				}
			}
		},
		setThumbCenterPoint: function() {
			var E = this.thumb.getEl();
			if ( E ) {
				this.thumbCenterPoint = { x: parseInt( E.offsetWidth / 2, 10 ), y: parseInt( E.offsetHeight / 2, 10 ) };
			}
		},
		lock: function() {
			this.thumb.lock();
			this.locked = true;
		},
		unlock: function() {
			this.thumb.unlock();
			this.locked = false;
		},
		thumbMouseUp: function() {
			this._mouseDown = false; if ( !this.isLocked() && !this.moveComplete ) {
				this.endMove();
			}
		},
		onMouseUp: function() {
			this._mouseDown = false; if ( this.backgroundEnabled && !this.isLocked() && !this.moveComplete ) {
				this.endMove();
			}
		},
		getThumb: function() {
			return this.thumb;
		},
		focus: function() {
			this.valueChangeSource = C.SOURCE_UI_EVENT; var E = this.getEl();
			if ( E.focus ) {
				try {
					E.focus();
				} catch ( F ) {}
			}
			this.verifyOffset();
			return !this.isLocked();
		},
		onChange: function( E, F ) {},
		onSlideStart: function() {},
		onSlideEnd: function() {},
		getValue: function() {
			return this.thumb.getValue();
		},
		getXValue: function() {
			return this.thumb.getXValue();
		},
		getYValue: function() {
			return this.thumb.getYValue();
		},
		setValue: function() {
			var E = D.call( arguments );
			E.unshift( C.SOURCE_SET_VALUE );
			return this._setValue.apply( this, E );
		},
		_setValue: function( I, L, G, H, E ) {
			var F = this.thumb,
				K, J; if ( !F.available ) {
				this.deferredSetValue = arguments;
				return false;
			}
			if ( this.isLocked() && !H ) {
				return false;
			}
			if ( isNaN( L ) ) {
				return false;
			}
			if ( F._isRegion ) {
				return false;
			}
			this._silent = E;
			this.valueChangeSource = I || C.SOURCE_SET_VALUE;
			F.lastOffset = [ L, L ];
			this.verifyOffset( true );
			this._slideStart();
			if ( F._isHoriz ) {
				K = F.initPageX + L + this.thumbCenterPoint.x;
				this.moveThumb( K, F.initPageY, G );
			} else {
				J = F.initPageY + L + this.thumbCenterPoint.y;
				this.moveThumb( F.initPageX, J, G );
			}
			return true;
		},
		setRegionValue: function() {
			var E = D.call( arguments );
			E.unshift( C.SOURCE_SET_VALUE );
			return this._setRegionValue.apply( this, E );
		},
		_setRegionValue: function( F, J, H, I, G, K ) {
			var L = this.thumb,
				E, M; if ( !L.available ) {
				this.deferredSetRegionValue = arguments;
				return false;
			}
			if ( this.isLocked() && !G ) {
				return false;
			}
			if ( isNaN( J ) ) {
				return false;
			}
			if ( !L._isRegion ) {
				return false;
			}
			this._silent = K;
			this.valueChangeSource = F || C.SOURCE_SET_VALUE;
			L.lastOffset = [ J, H ];
			this.verifyOffset( true );
			this._slideStart();
			E = L.initPageX + J + this.thumbCenterPoint.x;
			M = L.initPageY + H + this.thumbCenterPoint.y;
			this.moveThumb( E, M, I );
			return true;
		},
		verifyOffset: function( F ) {
			var G = B( this.getEl() ),
				E = this.thumb;
			if ( !this.thumbCenterPoint || !this.thumbCenterPoint.x ) {
				this.setThumbCenterPoint();
			}
			if ( G ) {
				if ( G[ 0 ] != this.baselinePos[ 0 ] || G[ 1 ] != this.baselinePos[ 1 ] ) {
					this.setInitPosition();
					this.baselinePos = G;
					E.initPageX = this.initPageX + E.startOffset[ 0 ];
					E.initPageY = this.initPageY + E.startOffset[ 1 ];
					E.deltaSetXY = null;
					this.resetThumbConstraints();
					return false;
				}
			}
			return true;
		},
		moveThumb: function( K, J, I, G ) {
			var L = this.thumb,
				M = this,
				F, E, H; if ( !L.available ) {
				return;
			}
			L.setDelta( this.thumbCenterPoint.x, this.thumbCenterPoint.y );
			E = L.getTargetCoord( K, J );
			F = [ Math.round( E.x ), Math.round( E.y ) ];
			if ( this.animate && L._graduated && !I ) {
				this.lock();
				this.curCoord = B( this.thumb.getEl() );
				this.curCoord = [ Math.round( this.curCoord[ 0 ] ), Math.round( this.curCoord[ 1 ] ) ];
				setTimeout( function() {
					M.moveOneTick( F );
				}, this.tickPause );
			} else {
				if ( this.animate && C.ANIM_AVAIL && !I ) {
					this.lock();
					H = new YAHOO.util.Motion( L.id, {
						points: { to: F } }, this.animationDuration, YAHOO.util.Easing.easeOut );
					H.onComplete.subscribe( function() {
						M.unlock();
						if ( !M._mouseDown ) {
							M.endMove();
						}
					});
					H.animate();
				} else {
					L.setDragElPos( K, J );
					if ( !G && !this._mouseDown ) {
						this.endMove();
					}
				}
			}
		},
		_slideStart: function() {
			if ( !this._sliding ) {
				if ( !this._silent ) {
					this.onSlideStart();
					this.fireEvent( "slideStart" );
				}
				this._sliding = true;
			}
		},
		_slideEnd: function() {
			if ( this._sliding && this.moveComplete ) {
				var E = this._silent;
				this._sliding = false;
				this._silent = false;
				this.moveComplete = false;
				if ( !E ) {
					this.onSlideEnd();
					this.fireEvent( "slideEnd" );
				}
			}
		},
		moveOneTick: function( F ) {
			var H = this.thumb,
				G = this,
				I = null,
				E, J; if ( H._isRegion ) {
				I = this._getNextX( this.curCoord, F );
				E = ( I !== null ) ? I[ 0 ] : this.curCoord[ 0 ];
				I = this._getNextY( this.curCoord, F );
				J = ( I !== null ) ? I[ 1 ] : this.curCoord[ 1 ];
				I = E !== this.curCoord[ 0 ] || J !== this.curCoord[ 1 ] ? [ E, J ] : null;
			} else {
				if ( H._isHoriz ) {
					I = this._getNextX( this.curCoord, F );
				} else {
					I = this._getNextY( this.curCoord, F );
				}
			}
			if ( I ) {
				this.curCoord = I;
				this.thumb.alignElWithMouse( H.getEl(), I[ 0 ] + this.thumbCenterPoint.x, I[ 1 ] + this.thumbCenterPoint.y );
				if ( !( I[ 0 ] == F[ 0 ] && I[ 1 ] == F[ 1 ] ) ) {
					setTimeout( function() {
						G.moveOneTick( F );
					}, this.tickPause );
				} else {
					this.unlock();
					if ( !this._mouseDown ) {
						this.endMove();
					}
				}
			} else {
				this.unlock();
				if ( !this._mouseDown ) {
					this.endMove();
				}
			}
		},
		_getNextX: function( E, F ) {
			var H = this.thumb,
				J,
				G = [],
				I = null;
			if ( E[ 0 ] > F[ 0 ] ) {
				J = H.tickSize - this.thumbCenterPoint.x;
				G = H.getTargetCoord( E[ 0 ] - J, E[ 1 ] );
				I = [ G.x, G.y ];
			} else {
				if ( E[ 0 ] < F[ 0 ] ) {
					J = H.tickSize + this.thumbCenterPoint.x;
					G = H.getTargetCoord( E[ 0 ] + J, E[ 1 ] );
					I = [ G.x, G.y ];
				} else {}
			}
			return I;
		},
		_getNextY: function( E, F ) {
			var H = this.thumb,
				J,
				G = [],
				I = null;
			if ( E[ 1 ] > F[ 1 ] ) {
				J = H.tickSize - this.thumbCenterPoint.y;
				G = H.getTargetCoord( E[ 0 ], E[ 1 ] - J );
				I = [ G.x, G.y ];
			} else {
				if ( E[ 1 ] < F[ 1 ] ) {
					J = H.tickSize + this.thumbCenterPoint.y;
					G = H.getTargetCoord( E[ 0 ], E[ 1 ] + J );
					I = [ G.x, G.y ];
				} else {}
			}
			return I;
		},
		b4MouseDown: function( E ) {
			if ( !this.backgroundEnabled ) {
				return false;
			}
			this.thumb.autoOffset();
			this.resetThumbConstraints();
		},
		onMouseDown: function( F ) {
			if ( !this.backgroundEnabled || this.isLocked() ) {
				return false;
			}
			this._mouseDown = true;
			var E = A.getPageX( F ),
				G = A.getPageY( F );
			this.focus();
			this._slideStart();
			this.moveThumb( E, G );
		},
		onDrag: function( F ) {
			if ( this.backgroundEnabled && !this.isLocked() ) {
				var E = A.getPageX( F ),
					G = A.getPageY( F );
				this.moveThumb( E, G, true, true );
				this.fireEvents();
			}
		},
		endMove: function() {
			this.unlock();
			this.fireEvents();
			this.moveComplete = true;
			this._slideEnd();
		},
		resetThumbConstraints: function() {
			var E = this.thumb; E.setXConstraint( E.leftConstraint, E.rightConstraint, E.xTickSize );
			E.setYConstraint( E.topConstraint, E.bottomConstraint, E.xTickSize );
		},
		fireEvents: function( G ) {
			var F = this.thumb,
				I, H, E; if ( !G ) {
				F.cachePosition();
			}
			if ( !this.isLocked() ) {
				if ( F._isRegion ) {
					I = F.getXValue();
					H = F.getYValue();
					if ( I != this.previousX || H != this.previousY ) {
						if ( !this._silent ) {
							this.onChange( I, H );
							this.fireEvent( "change", { x: I, y: H } );
						}
					}
					this.previousX = I;
					this.previousY = H;
				} else {
					E = F.getValue();
					if ( E != this.previousVal ) {
						if ( !this._silent ) {
							this.onChange( E );
							this.fireEvent( "change", E );
						}
					}
					this.previousVal = E;
				}
			}
		},
		toString: function() {
			return ( "Slider (" + this.type + ") " + this.id );
		} } );
	YAHOO.lang.augmentProto( C, YAHOO.util.EventProvider );
	YAHOO.widget.Slider = C;
})();
YAHOO.widget.SliderThumb = function( G, B, E, D, A, F, C ) {
	if ( G ) {
		YAHOO.widget.SliderThumb.superclass.constructor.call( this, G, B );
		this.parentElId = B;
	}
	this.isTarget = false;
	this.tickSize = C;
	this.maintainOffset = true;
	this.initSlider( E, D, A, F, C );
	this.scroll = false;
};
YAHOO.extend( YAHOO.widget.SliderThumb, YAHOO.util.DD, {
	startOffset: null, dragOnly: true, _isHoriz: false, _prevVal: 0, _graduated: false, getOffsetFromParent0: function( C ) {
		var A = YAHOO.util.Dom.getXY( this.getEl() ),
			B = C || YAHOO.util.Dom.getXY( this.parentElId );
		return [ ( A[ 0 ] - B[ 0 ] ), ( A[ 1 ] - B[ 1 ] ) ];
	},
	getOffsetFromParent: function( H ) {
		var A = this.getEl(),
			E, I, F, B, K, D, C, J, G;
		if ( !this.deltaOffset ) {
			I = YAHOO.util.Dom.getXY( A );
			F = H || YAHOO.util.Dom.getXY( this.parentElId );
			E = [ ( I[ 0 ] - F[ 0 ] ), ( I[ 1 ] - F[ 1 ] ) ];
			B = parseInt( YAHOO.util.Dom.getStyle( A, "left" ), 10 );
			K = parseInt( YAHOO.util.Dom.getStyle( A, "top" ), 10 );
			D = B - E[ 0 ];
			C = K - E[ 1 ];
			if ( isNaN( D ) || isNaN( C ) ) {} else {
				this.deltaOffset = [ D, C ];
			}
		} else {
			J = parseInt( YAHOO.util.Dom.getStyle( A, "left" ), 10 );
			G = parseInt( YAHOO.util.Dom.getStyle( A, "top" ), 10 );
			E = [ J + this.deltaOffset[ 0 ], G + this.deltaOffset[ 1 ] ];
		}
		return E;
	},
	initSlider: function( D, C, A, E, B ) {
		this.initLeft = D; this.initRight = C; this.initUp = A; this.initDown = E; this.setXConstraint( D, C, B );
		this.setYConstraint( A, E, B );
		if ( B && B > 1 ) {
			this._graduated = true;
		}
		this._isHoriz = ( D || C );
		this._isVert = ( A || E );
		this._isRegion = ( this._isHoriz && this._isVert );
	},
	clearTicks: function() {
		YAHOO.widget.SliderThumb.superclass.clearTicks.call( this );
		this.tickSize = 0;
		this._graduated = false;
	},
	getValue: function() {
		return ( this._isHoriz ) ? this.getXValue() : this.getYValue();
	},
	getXValue: function() {
		if ( !this.available ) {
			return 0;
		}
		var A = this.getOffsetFromParent();
		if ( YAHOO.lang.isNumber( A[ 0 ] ) ) {
			this.lastOffset = A;
			return ( A[ 0 ] - this.startOffset[ 0 ] );
		} else {
			return ( this.lastOffset[ 0 ] - this.startOffset[ 0 ] );
		}
	},
	getYValue: function() {
		if ( !this.available ) {
			return 0;
		}
		var A = this.getOffsetFromParent();
		if ( YAHOO.lang.isNumber( A[ 1 ] ) ) {
			this.lastOffset = A;
			return ( A[ 1 ] - this.startOffset[ 1 ] );
		} else {
			return ( this.lastOffset[ 1 ] - this.startOffset[ 1 ] );
		}
	},
	toString: function() {
		return "SliderThumb " + this.id;
	},
	onChange: function( A, B ) {} } );
(function() {
	var A = YAHOO.util.Event,
		B = YAHOO.widget;

	function C( I, F, H, D ) {
		var G = this,
			J = { min: false, max: false },
			E, K; this.minSlider = I; this.maxSlider = F; this.activeSlider = I; this.isHoriz = I.thumb._isHoriz; E = this.minSlider.thumb.onMouseDown; K = this.maxSlider.thumb.onMouseDown; this.minSlider.thumb.onMouseDown = function() {
			G.activeSlider = G.minSlider;
			E.apply( this, arguments );
		};
		this.maxSlider.thumb.onMouseDown = function() {
			G.activeSlider = G.maxSlider;
			K.apply( this, arguments );
		};
		this.minSlider.thumb.onAvailable = function() {
			I.setStartSliderState();
			J.min = true;
			if ( J.max ) {
				G.fireEvent( "ready", G );
			}
		};
		this.maxSlider.thumb.onAvailable = function() {
			F.setStartSliderState();
			J.max = true;
			if ( J.min ) {
				G.fireEvent( "ready", G );
			}
		};
		I.onMouseDown = F.onMouseDown = function( L ) {
			return this.backgroundEnabled && G._handleMouseDown( L );
		};
		I.onDrag = F.onDrag = function( L ) {
			G._handleDrag( L );
		};
		I.onMouseUp = F.onMouseUp = function( L ) {
			G._handleMouseUp( L );
		};
		I._bindKeyEvents = function() {
			G._bindKeyEvents( this );
		};
		F._bindKeyEvents = function() {};
		I.subscribe( "change", this._handleMinChange, I, this );
		I.subscribe( "slideStart", this._handleSlideStart, I, this );
		I.subscribe( "slideEnd", this._handleSlideEnd, I, this );
		F.subscribe( "change", this._handleMaxChange, F, this );
		F.subscribe( "slideStart", this._handleSlideStart, F, this );
		F.subscribe( "slideEnd", this._handleSlideEnd, F, this );
		this.createEvent( "ready", this );
		this.createEvent( "change", this );
		this.createEvent( "slideStart", this );
		this.createEvent( "slideEnd", this );
		D = YAHOO.lang.isArray( D ) ? D : [ 0, H ];
		D[ 0 ] = Math.min( Math.max( parseInt( D[ 0 ], 10 ) | 0, 0 ), H );
		D[ 1 ] = Math.max( Math.min( parseInt( D[ 1 ], 10 ) | 0, H ), 0 );
		if ( D[ 0 ] > D[ 1 ] ) {
			D.splice( 0, 2, D[ 1 ], D[ 0 ] );
		}
		this.minVal = D[ 0 ];
		this.maxVal = D[ 1 ];
		this.minSlider.setValue( this.minVal, true, true, true );
		this.maxSlider.setValue( this.maxVal, true, true, true );
	}
	C.prototype = {
		minVal: -1, maxVal: -1, minRange: 0, _handleSlideStart: function( E, D ) {
			this.fireEvent( "slideStart", D );
		},
		_handleSlideEnd: function( E, D ) {
			this.fireEvent( "slideEnd", D );
		},
		_handleDrag: function( D ) {
			B.Slider.prototype.onDrag.call( this.activeSlider, D );
		},
		_handleMinChange: function() {
			this.activeSlider = this.minSlider; this.updateValue();
		},
		_handleMaxChange: function() {
			this.activeSlider = this.maxSlider; this.updateValue();
		},
		_bindKeyEvents: function( D ) {
			A.on( D.id, "keydown", this._handleKeyDown, this, true );
			A.on( D.id, "keypress", this._handleKeyPress, this, true );
		},
		_handleKeyDown: function( D ) {
			this.activeSlider.handleKeyDown.apply( this.activeSlider, arguments );
		},
		_handleKeyPress: function( D ) {
			this.activeSlider.handleKeyPress.apply( this.activeSlider, arguments );
		},
		setValues: function( H, K, I, E, J ) {
			var F = this.minSlider,
				M = this.maxSlider,
				D = F.thumb,
				L = M.thumb,
				N = this,
				G = { min: false, max: false }; if ( D._isHoriz ) {
				D.setXConstraint( D.leftConstraint, L.rightConstraint, D.tickSize );
				L.setXConstraint( D.leftConstraint, L.rightConstraint, L.tickSize );
			} else {
				D.setYConstraint( D.topConstraint, L.bottomConstraint, D.tickSize );
				L.setYConstraint( D.topConstraint, L.bottomConstraint, L.tickSize );
			}
			this._oneTimeCallback( F, "slideEnd", function() {
				G.min = true;
				if ( G.max ) {
					N.updateValue( J );
					setTimeout( function() {
						N._cleanEvent( F, "slideEnd" );
						N._cleanEvent( M, "slideEnd" );
					}, 0 );
				}
			});
			this._oneTimeCallback( M, "slideEnd", function() {
				G.max = true;
				if ( G.min ) {
					N.updateValue( J );
					setTimeout( function() {
						N._cleanEvent( F, "slideEnd" );
						N._cleanEvent( M, "slideEnd" );
					}, 0 );
				}
			});
			F.setValue( H, I, E, false );
			M.setValue( K, I, E, false );
		},
		setMinValue: function( F, H, I, E ) {
			var G = this.minSlider,
				D = this; this.activeSlider = G; D = this; this._oneTimeCallback( G, "slideEnd", function() {
				D.updateValue( E );
				setTimeout( function() {
					D._cleanEvent( G, "slideEnd" );
				}, 0 );
			});
			G.setValue( F, H, I );
		},
		setMaxValue: function( D, H, I, F ) {
			var G = this.maxSlider,
				E = this; this.activeSlider = G; this._oneTimeCallback( G, "slideEnd", function() {
				E.updateValue( F );
				setTimeout( function() {
					E._cleanEvent( G, "slideEnd" );
				}, 0 );
			});
			G.setValue( D, H, I );
		},
		updateValue: function( J ) {
			var E = this.minSlider.getValue(),
				K = this.maxSlider.getValue(),
				F = false,
				D, M, H, I, L, G;
			if ( E != this.minVal || K != this.maxVal ) {
				F = true;
				D = this.minSlider.thumb;
				M = this.maxSlider.thumb;
				H = this.isHoriz ? "x" : "y";
				G = this.minSlider.thumbCenterPoint[ H ] + this.maxSlider.thumbCenterPoint[ H ];
				I = Math.max( K - G - this.minRange, 0 );
				L = Math.min( -E - G - this.minRange, 0 );
				if ( this.isHoriz ) {
					I = Math.min( I, M.rightConstraint );
					D.setXConstraint( D.leftConstraint, I, D.tickSize );
					M.setXConstraint( L, M.rightConstraint, M.tickSize );
				} else {
					I = Math.min( I, M.bottomConstraint );
					D.setYConstraint( D.leftConstraint, I, D.tickSize );
					M.setYConstraint( L, M.bottomConstraint, M.tickSize );
				}
			}
			this.minVal = E;
			this.maxVal = K;
			if ( F && !J ) {
				this.fireEvent( "change", this );
			}
		},
		selectActiveSlider: function( H ) {
			var E = this.minSlider,
				D = this.maxSlider,
				J = E.isLocked() || !E.backgroundEnabled,
				G = D.isLocked() || !E.backgroundEnabled,
				F = YAHOO.util.Event,
				I;
			if ( J || G ) {
				this.activeSlider = J ? D : E;
			} else {
				if ( this.isHoriz ) {
					I = F.getPageX( H ) - E.thumb.initPageX - E.thumbCenterPoint.x;
				} else {
					I = F.getPageY( H ) - E.thumb.initPageY - E.thumbCenterPoint.y;
				}
				this.activeSlider = I * 2 > D.getValue() + E.getValue() ? D : E;
			}
		},
		_handleMouseDown: function( D ) {
			if ( !D._handled ) {
				D._handled = true;
				this.selectActiveSlider( D );
				return B.Slider.prototype.onMouseDown.call( this.activeSlider, D );
			} else {
				return false;
			}
		},
		_handleMouseUp: function( D ) {
			B.Slider.prototype.onMouseUp.apply( this.activeSlider, arguments );
		},
		_oneTimeCallback: function( F, D, E ) {
			F.subscribe( D, function() {
				F.unsubscribe( D, arguments.callee );
				E.apply( {}, [].slice.apply( arguments ) );
			});
		},
		_cleanEvent: function( K, E ) {
			var J, I, D, G, H, F; if ( K.__yui_events && K.events[ E ] ) {
				for ( I = K.__yui_events.length; I >= 0; --I ) {
					if ( K.__yui_events[ I ].type === E ) {
						J = K.__yui_events[ I ];
						break;
					}
				}
				if ( J ) {
					H = J.subscribers;
					F = [];
					G = 0;
					for ( I = 0, D = H.length; I < D; ++I ) {
						if ( H[ I ] ) {
							F[ G++ ] = H[ I ];
						}
					}
					J.subscribers = F;
				}
			}
		} }; YAHOO.lang.augmentProto( C, YAHOO.util.EventProvider );
	B.Slider.getHorizDualSlider = function( H, J, K, G, F, D ) {
		var I = new B.SliderThumb( J, H, 0, G, 0, 0, F ),
			E = new B.SliderThumb( K, H, 0, G, 0, 0, F );
		return new C( new B.Slider( H, H, I, "horiz" ), new B.Slider( H, H, E, "horiz" ), G, D );
	};
	B.Slider.getVertDualSlider = function( H, J, K, G, F, D ) {
		var I = new B.SliderThumb( J, H, 0, 0, 0, G, F ),
			E = new B.SliderThumb( K, H, 0, 0, 0, G, F );
		return new B.DualSlider( new B.Slider( H, H, I, "vert" ), new B.Slider( H, H, E, "vert" ), G, D );
	};
	YAHOO.widget.DualSlider = C;
})();
YAHOO.register( "slider", YAHOO.widget.Slider, { version: "2.7.0", build: "1796" } );
/*
Copyright (c) 2009, Yahoo! Inc. All rights reserved.
Code licensed under the BSD License:
http://developer.yahoo.net/yui/license.txt
version: 2.7.0
*/
YAHOO.util.Attribute = function( B, A ) {
	if ( A ) {
		this.owner = A;
		this.configure( B, true );
	}
};
YAHOO.util.Attribute.prototype = {
	name: undefined, value: null, owner: null, readOnly: false, writeOnce: false, _initialConfig: null, _written: false, method: null, setter: null, getter: null, validator: null, getValue: function() {
		var A = this.value; if ( this.getter ) {
			A = this.getter.call( this.owner, this.name );
		}
		return A;
	},
	setValue: function( F, B ) {
		var E,
			A = this.owner,
			C = this.name; var D = { type: C, prevValue: this.getValue(), newValue: F }; if ( this.readOnly || ( this.writeOnce && this._written ) ) {
			return false;
		}
		if ( this.validator && !this.validator.call( A, F ) ) {
			return false;
		}
		if ( !B ) {
			E = A.fireBeforeChangeEvent( D );
			if ( E === false ) {
				return false;
			}
		}
		if ( this.setter ) {
			F = this.setter.call( A, F, this.name );
			if ( F === undefined ) {}
		}
		if ( this.method ) {
			this.method.call( A, F, this.name );
		}
		this.value = F;
		this._written = true;
		D.type = C;
		if ( !B ) {
			this.owner.fireChangeEvent( D );
		}
		return true;
	},
	configure: function( B, C ) {
		B = B || {};
		if ( C ) {
			this._written = false;
		}
		this._initialConfig = this._initialConfig || {};
		for ( var A in B ) {
			if ( B.hasOwnProperty( A ) ) {
				this[ A ] = B[ A ];
				if ( C ) {
					this._initialConfig[ A ] = B[ A ];
				}
			}
		}
	},
	resetValue: function() {
		return this.setValue( this._initialConfig.value );
	},
	resetConfig: function() {
		this.configure( this._initialConfig, true );
	},
	refresh: function( A ) {
		this.setValue( this.value, A );
	} };
(function() {
	var A = YAHOO.util.Lang;
	YAHOO.util.AttributeProvider = function() {};
	YAHOO.util.AttributeProvider.prototype = {
		_configs: null, get: function( C ) {
			this._configs = this._configs || {};
			var B = this._configs[ C ];
			if ( !B || !this._configs.hasOwnProperty( C ) ) {
				return null;
			}
			return B.getValue();
		},
		set: function( D, E, B ) {
			this._configs = this._configs || {};
			var C = this._configs[ D ];
			if ( !C ) {
				return false;
			}
			return C.setValue( E, B );
		},
		getAttributeKeys: function() {
			this._configs = this._configs; var C = [],
				B;
			for ( B in this._configs ) {
				if ( A.hasOwnProperty( this._configs, B ) && !A.isUndefined( this._configs[ B ] ) ) {
					C[ C.length ] = B;
				}
			}
			return C;
		},
		setAttributes: function( D, B ) {
			for ( var C in D ) {
				if ( A.hasOwnProperty( D, C ) ) {
					this.set( C, D[ C ], B );
				}
			}
		},
		resetValue: function( C, B ) {
			this._configs = this._configs || {};
			if ( this._configs[ C ] ) {
				this.set( C, this._configs[ C ]._initialConfig.value, B );
				return true;
			}
			return false;
		},
		refresh: function( E, C ) {
			this._configs = this._configs || {};
			var F = this._configs;
			E = ( ( A.isString( E ) ) ? [ E ] : E ) || this.getAttributeKeys();
			for ( var D = 0, B = E.length; D < B; ++D ) {
				if ( F.hasOwnProperty( E[ D ] ) ) {
					this._configs[ E[ D ] ].refresh( C );
				}
			}
		},
		register: function( B, C ) {
			this.setAttributeConfig( B, C );
		},
		getAttributeConfig: function( C ) {
			this._configs = this._configs || {};
			var B = this._configs[ C ] || {};
			var D = {};
			for ( C in B ) {
				if ( A.hasOwnProperty( B, C ) ) {
					D[ C ] = B[ C ];
				}
			}
			return D;
		},
		setAttributeConfig: function( B, C, D ) {
			this._configs = this._configs || {};
			C = C || {};
			if ( !this._configs[ B ] ) {
				C.name = B;
				this._configs[ B ] = this.createAttribute( C );
			} else {
				this._configs[ B ].configure( C, D );
			}
		},
		configureAttribute: function( B, C, D ) {
			this.setAttributeConfig( B, C, D );
		},
		resetAttributeConfig: function( B ) {
			this._configs = this._configs || {};
			this._configs[ B ].resetConfig();
		},
		subscribe: function( B, C ) {
			this._events = this._events || {};
			if ( !( B in this._events ) ) {
				this._events[ B ] = this.createEvent( B );
			}
			YAHOO.util.EventProvider.prototype.subscribe.apply( this, arguments );
		},
		on: function() {
			this.subscribe.apply( this, arguments );
		},
		addListener: function() {
			this.subscribe.apply( this, arguments );
		},
		fireBeforeChangeEvent: function( C ) {
			var B = "before"; B += C.type.charAt( 0 ).toUpperCase() + C.type.substr( 1 ) + "Change";
			C.type = B;
			return this.fireEvent( C.type, C );
		},
		fireChangeEvent: function( B ) {
			B.type += "Change"; return this.fireEvent( B.type, B );
		},
		createAttribute: function( B ) {
			return new YAHOO.util.Attribute( B, this );
		} }; YAHOO.augment( YAHOO.util.AttributeProvider, YAHOO.util.EventProvider );
})();
(function() {
	var B = YAHOO.util.Dom,
		C = YAHOO.util.AttributeProvider;
	var A = function( D, E ) {
			this.init.apply( this, arguments );
		};
	A.DOM_EVENTS = { "click": true, "dblclick": true, "keydown": true, "keypress": true, "keyup": true, "mousedown": true, "mousemove": true, "mouseout": true, "mouseover": true, "mouseup": true, "focus": true, "blur": true, "submit": true, "change": true }; A.prototype = {
		DOM_EVENTS: null, DEFAULT_HTML_SETTER: function( F, D ) {
			var E = this.get( "element" );
			if ( E ) {
				E[ D ] = F;
			}
		},
		DEFAULT_HTML_GETTER: function( D ) {
			var E = this.get( "element" ),
				F;
			if ( E ) {
				F = E[ D ];
			}
			return F;
		},
		appendChild: function( D ) {
			D = D.get ? D.get( "element" ) : D;
			return this.get( "element" ).appendChild( D );
		},
		getElementsByTagName: function( D ) {
			return this.get( "element" ).getElementsByTagName( D );
		},
		hasChildNodes: function() {
			return this.get( "element" ).hasChildNodes();
		},
		insertBefore: function( D, E ) {
			D = D.get ? D.get( "element" ) : D;
			E = ( E && E.get ) ? E.get( "element" ) : E;
			return this.get( "element" ).insertBefore( D, E );
		},
		removeChild: function( D ) {
			D = D.get ? D.get( "element" ) : D;
			return this.get( "element" ).removeChild( D );
		},
		replaceChild: function( D, E ) {
			D = D.get ? D.get( "element" ) : D;
			E = E.get ? E.get( "element" ) : E;
			return this.get( "element" ).replaceChild( D, E );
		},
		initAttributes: function( D ) {},
		addListener: function( H, G, I, F ) {
			var E = this.get( "element" ) || this.get( "id" );
			F = F || this;
			var D = this;
			if ( !this._events[ H ] ) {
				if ( E && this.DOM_EVENTS[ H ] ) {
					YAHOO.util.Event.addListener( E, H, function( J ) {
						if ( J.srcElement && !J.target ) {
							J.target = J.srcElement;
						}
						D.fireEvent( H, J );
					}, I, F );
				}
				this.createEvent( H, this );
			}
			return YAHOO.util.EventProvider.prototype.subscribe.apply( this, arguments );
		},
		on: function() {
			return this.addListener.apply( this, arguments );
		},
		subscribe: function() {
			return this.addListener.apply( this, arguments );
		},
		removeListener: function( E, D ) {
			return this.unsubscribe.apply( this, arguments );
		},
		addClass: function( D ) {
			B.addClass( this.get( "element" ), D );
		},
		getElementsByClassName: function( E, D ) {
			return B.getElementsByClassName( E, D, this.get( "element" ) );
		},
		hasClass: function( D ) {
			return B.hasClass( this.get( "element" ), D );
		},
		removeClass: function( D ) {
			return B.removeClass( this.get( "element" ), D );
		},
		replaceClass: function( E, D ) {
			return B.replaceClass( this.get( "element" ), E, D );
		},
		setStyle: function( E, D ) {
			return B.setStyle( this.get( "element" ), E, D );
		},
		getStyle: function( D ) {
			return B.getStyle( this.get( "element" ), D );
		},
		fireQueue: function() {
			var E = this._queue; for ( var F = 0, D = E.length; F < D; ++F ) {
				this[ E[ F ][ 0 ] ].apply( this, E[ F ][ 1 ] );
			}
		},
		appendTo: function( E, F ) {
			E = ( E.get ) ? E.get( "element" ) : B.get( E );
			this.fireEvent( "beforeAppendTo", { type: "beforeAppendTo", target: E } );
			F = ( F && F.get ) ? F.get( "element" ) : B.get( F );
			var D = this.get( "element" );
			if ( !D ) {
				return false;
			}
			if ( !E ) {
				return false;
			}
			if ( D.parent != E ) {
				if ( F ) {
					E.insertBefore( D, F );
				} else {
					E.appendChild( D );
				}
			}
			this.fireEvent( "appendTo", { type: "appendTo", target: E } );
			return D;
		},
		get: function( D ) {
			var F = this._configs || {},
				E = F.element;
			if ( E && !F[ D ] && !YAHOO.lang.isUndefined( E.value[ D ] ) ) {
				this._setHTMLAttrConfig( D );
			}
			return C.prototype.get.call( this, D );
		},
		setAttributes: function( J, G ) {
			var E = {},
				H = this._configOrder;
			for ( var I = 0, D = H.length; I < D; ++I ) {
				if ( J[ H[ I ] ] !== undefined ) {
					E[ H[ I ] ] = true;
					this.set( H[ I ], J[ H[ I ] ], G );
				}
			}
			for ( var F in J ) {
				if ( J.hasOwnProperty( F ) && !E[ F ] ) {
					this.set( F, J[ F ], G );
				}
			}
		},
		set: function( E, G, D ) {
			var F = this.get( "element" );
			if ( !F ) {
				this._queue[ this._queue.length ] = [ "set", arguments ];
				if ( this._configs[ E ] ) {
					this._configs[ E ].value = G;
				}
				return;
			}
			if ( !this._configs[ E ] && !YAHOO.lang.isUndefined( F[ E ] ) ) {
				this._setHTMLAttrConfig( E );
			}
			return C.prototype.set.apply( this, arguments );
		},
		setAttributeConfig: function( D, E, F ) {
			this._configOrder.push( D );
			C.prototype.setAttributeConfig.apply( this, arguments );
		},
		createEvent: function( E, D ) {
			this._events[ E ] = true;
			return C.prototype.createEvent.apply( this, arguments );
		},
		init: function( E, D ) {
			this._initElement( E, D );
		},
		destroy: function() {
			var D = this.get( "element" );
			YAHOO.util.Event.purgeElement( D, true );
			this.unsubscribeAll();
			if ( D && D.parentNode ) {
				D.parentNode.removeChild( D );
			}
			this._queue = [];
			this._events = {};
			this._configs = {};
			this._configOrder = [];
		},
		_initElement: function( F, E ) {
			this._queue = this._queue || [];
			this._events = this._events || {};
			this._configs = this._configs || {};
			this._configOrder = [];
			E = E || {};
			E.element = E.element || F || null;
			var H = false;
			var D = A.DOM_EVENTS;
			this.DOM_EVENTS = this.DOM_EVENTS || {};
			for ( var G in D ) {
				if ( D.hasOwnProperty( G ) ) {
					this.DOM_EVENTS[ G ] = D[ G ];
				}
			}
			if ( typeof E.element === "string" ) {
				this._setHTMLAttrConfig( "id", { value: E.element } );
			}
			if ( B.get( E.element ) ) {
				H = true;
				this._initHTMLElement( E );
				this._initContent( E );
			}
			YAHOO.util.Event.onAvailable( E.element, function() {
				if ( !H ) {
					this._initHTMLElement( E );
				}
				this.fireEvent( "available", { type: "available", target: B.get( E.element ) } );
			}, this, true );
			YAHOO.util.Event.onContentReady( E.element, function() {
				if ( !H ) {
					this._initContent( E );
				}
				this.fireEvent( "contentReady", { type: "contentReady", target: B.get( E.element ) } );
			}, this, true );
		},
		_initHTMLElement: function( D ) {
			this.setAttributeConfig( "element", { value: B.get( D.element ), readOnly: true } );
		},
		_initContent: function( D ) {
			this.initAttributes( D );
			this.setAttributes( D, true );
			this.fireQueue();
		},
		_setHTMLAttrConfig: function( D, F ) {
			var E = this.get( "element" );
			F = F || {};
			F.name = D;
			F.setter = F.setter || this.DEFAULT_HTML_SETTER;
			F.getter = F.getter || this.DEFAULT_HTML_GETTER;
			F.value = F.value || E[ D ];
			this._configs[ D ] = new YAHOO.util.Attribute( F, this );
		} }; YAHOO.augment( A, C );
	YAHOO.util.Element = A;
})();
YAHOO.register( "element", YAHOO.util.Element, { version: "2.7.0", build: "1796" } );
/*
Copyright (c) 2009, Yahoo! Inc. All rights reserved.
Code licensed under the BSD License:
http://developer.yahoo.net/yui/license.txt
version: 2.7.0
*/
YAHOO.util.Color = function() {
	var A = "0",
		B = YAHOO.lang.isArray,
		C = YAHOO.lang.isNumber;
	return {
		real2dec: function( D ) {
			return Math.min( 255, Math.round( D * 256 ) );
		},
		hsv2rgb: function( H, O, M ) {
			if ( B( H ) ) {
				return this.hsv2rgb.call( this, H[ 0 ], H[ 1 ], H[ 2 ] );
			}
			var D, I, L,
				G = Math.floor( ( H / 60 ) % 6 ),
				J = ( H / 60 ) - G,
				F = M * ( 1 - O ),
				E = M * ( 1 - J * O ),
				N = M * ( 1 - ( 1 - J ) * O ),
				K;
			switch ( G ) {
				case 0:
					D = M;
					I = N;
					L = F;
					break;case 1:
					D = E;
					I = M;
					L = F;
					break;case 2:
					D = F;
					I = M;
					L = N;
					break;case 3:
					D = F;
					I = E;
					L = M;
					break;case 4:
					D = N;
					I = F;
					L = M;
					break;case 5:
					D = M;
					I = F;
					L = E;
					break;
			}
			K = this.real2dec;
			return [ K( D ), K( I ), K( L ) ];
		},
		rgb2hsv: function( D, H, I ) {
			if ( B( D ) ) {
				return this.rgb2hsv.apply( this, D );
			}
			D /= 255;
			H /= 255;
			I /= 255;
			var G, L,
				E = Math.min( Math.min( D, H ), I ),
				J = Math.max( Math.max( D, H ), I ),
				K = J - E,
				F;
			switch ( J ) {
				case E:
					G = 0;
					break;case D:
					G = 60 * ( H - I ) / K;
					if ( H < I ) {
						G += 360;
					}
					break;case H:
					G = ( 60 * ( I - D ) / K ) + 120;
					break;case I:
					G = ( 60 * ( D - H ) / K ) + 240;
					break;
			}
			L = ( J === 0 ) ? 0 : 1 - ( E / J );
			F = [ Math.round( G ), L, J ];
			return F;
		},
		rgb2hex: function( F, E, D ) {
			if ( B( F ) ) {
				return this.rgb2hex.apply( this, F );
			}
			var G = this.dec2hex;
			return G( F ) + G( E ) + G( D );
		},
		dec2hex: function( D ) {
			D = parseInt( D, 10 ) | 0;
			D = ( D > 255 || D < 0 ) ? 0 : D;
			return ( A + D.toString( 16 ) ).slice( -2 ).toUpperCase();
		},
		hex2dec: function( D ) {
			return parseInt( D, 16 );
		},
		hex2rgb: function( D ) {
			var E = this.hex2dec; return [ E( D.slice( 0, 2 ) ), E( D.slice( 2, 4 ) ), E( D.slice( 4, 6 ) ) ];
		},
		websafe: function( F, E, D ) {
			if ( B( F ) ) {
				return this.websafe.apply( this, F );
			}
			var G = function( H ) {
					if ( C( H ) ) {
						H = Math.min( Math.max( 0, H ), 255 );
						var I, J;
						for ( I = 0; I < 256; I = I + 51 ) {
							J = I + 51;
							if ( H >= I && H <= J ) {
								return ( H - I > 25 ) ? J : I;
							}
						}
					}
					return H;
				};
			return [ G( F ), G( E ), G( D ) ];
		} };
}();
(function() {
	var J = 0,
		F = YAHOO.util,
		C = YAHOO.lang,
		D = YAHOO.widget.Slider,
		B = F.Color,
		E = F.Dom,
		I = F.Event,
		A = C.substitute,
		H = "yui-picker";

	function G( L, K ) {
		J = J + 1;
		K = K || {};
		if ( arguments.length === 1 && !YAHOO.lang.isString( L ) && !L.nodeName ) {
			K = L;
			L = K.element || null;
		}
		if ( !L && !K.element ) {
			L = this._createHostElement( K );
		}
		G.superclass.constructor.call( this, L, K );
		this.initPicker();
	}
	YAHOO.extend( G, YAHOO.util.Element, {
		ID: { R: H + "-r", R_HEX: H + "-rhex", G: H + "-g", G_HEX: H + "-ghex", B: H + "-b", B_HEX: H + "-bhex", H: H + "-h", S: H + "-s", V: H + "-v", PICKER_BG: H + "-bg", PICKER_THUMB: H + "-thumb", HUE_BG: H + "-hue-bg", HUE_THUMB: H + "-hue-thumb", HEX: H + "-hex", SWATCH: H + "-swatch", WEBSAFE_SWATCH: H + "-websafe-swatch", CONTROLS: H + "-controls", RGB_CONTROLS: H + "-rgb-controls", HSV_CONTROLS: H + "-hsv-controls", HEX_CONTROLS: H + "-hex-controls", HEX_SUMMARY: H + "-hex-summary", CONTROLS_LABEL: H + "-controls-label" },
		TXT: { ILLEGAL_HEX: "Illegal hex value entered", SHOW_CONTROLS: "Show color details", HIDE_CONTROLS: "Hide color details", CURRENT_COLOR: "Currently selected color: {rgb}", CLOSEST_WEBSAFE: "Closest websafe color: {rgb}. Click to select.", R: "R", G: "G", B: "B", H: "H", S: "S", V: "V", HEX: "#", DEG: "\u00B0", PERCENT: "%" },
		IMAGE: { PICKER_THUMB: "../../build/colorpicker/assets/picker_thumb.png", HUE_THUMB: "../../build/colorpicker/assets/hue_thumb.png" },
		DEFAULT: { PICKER_SIZE: 180 },
		OPT: { HUE: "hue", SATURATION: "saturation", VALUE: "value", RED: "red", GREEN: "green", BLUE: "blue", HSV: "hsv", RGB: "rgb", WEBSAFE: "websafe", HEX: "hex", PICKER_SIZE: "pickersize", SHOW_CONTROLS: "showcontrols", SHOW_RGB_CONTROLS: "showrgbcontrols", SHOW_HSV_CONTROLS: "showhsvcontrols", SHOW_HEX_CONTROLS: "showhexcontrols", SHOW_HEX_SUMMARY: "showhexsummary", SHOW_WEBSAFE: "showwebsafe", CONTAINER: "container", IDS: "ids", ELEMENTS: "elements", TXT: "txt", IMAGES: "images", ANIMATE: "animate" },
		skipAnim: true, _createHostElement: function() {
			var K = document.createElement( "div" );
			if ( this.CSS.BASE ) {
				K.className = this.CSS.BASE;
			}
			return K;
		},
		_updateHueSlider: function() {
			var K = this.get( this.OPT.PICKER_SIZE ),
				L = this.get( this.OPT.HUE );
			L = K - Math.round( L / 360 * K );
			if ( L === K ) {
				L = 0;
			}
			this.hueSlider.setValue( L, this.skipAnim );
		},
		_updatePickerSlider: function() {
			var L = this.get( this.OPT.PICKER_SIZE ),
				M = this.get( this.OPT.SATURATION ),
				K = this.get( this.OPT.VALUE );
			M = Math.round( M * L / 100 );
			K = Math.round( L - ( K * L / 100 ) );
			this.pickerSlider.setRegionValue( M, K, this.skipAnim );
		},
		_updateSliders: function() {
			this._updateHueSlider();
			this._updatePickerSlider();
		},
		setValue: function( L, K ) {
			K = ( K ) || false;
			this.set( this.OPT.RGB, L, K );
			this._updateSliders();
		},
		hueSlider: null, pickerSlider: null, _getH: function() {
			var K = this.get( this.OPT.PICKER_SIZE ),
				L = ( K - this.hueSlider.getValue() ) / K;
			L = Math.round( L * 360 );
			return ( L === 360 ) ? 0 : L;
		},
		_getS: function() {
			return this.pickerSlider.getXValue() / this.get( this.OPT.PICKER_SIZE );
		},
		_getV: function() {
			var K = this.get( this.OPT.PICKER_SIZE );
			return ( K - this.pickerSlider.getYValue() ) / K;
		},
		_updateSwatch: function() {
			var M = this.get( this.OPT.RGB ),
				O = this.get( this.OPT.WEBSAFE ),
				N = this.getElement( this.ID.SWATCH ),
				L = M.join( "," ),
				K = this.get( this.OPT.TXT );
			E.setStyle( N, "background-color", "rgb(" + L + ")" );
			N.title = A( K.CURRENT_COLOR, { "rgb": "#" + this.get( this.OPT.HEX ) } );
			N = this.getElement( this.ID.WEBSAFE_SWATCH );
			L = O.join( "," );
			E.setStyle( N, "background-color", "rgb(" + L + ")" );
			N.title = A( K.CLOSEST_WEBSAFE, { "rgb": "#" + B.rgb2hex( O ) } );
		},
		_getValuesFromSliders: function() {
			this.set( this.OPT.RGB, B.hsv2rgb( this._getH(), this._getS(), this._getV() ) );
		},
		_updateFormFields: function() {
			this.getElement( this.ID.H ).value = this.get( this.OPT.HUE );
			this.getElement( this.ID.S ).value = this.get( this.OPT.SATURATION );
			this.getElement( this.ID.V ).value = this.get( this.OPT.VALUE );
			this.getElement( this.ID.R ).value = this.get( this.OPT.RED );
			this.getElement( this.ID.R_HEX ).innerHTML = B.dec2hex( this.get( this.OPT.RED ) );
			this.getElement( this.ID.G ).value = this.get( this.OPT.GREEN );
			this.getElement( this.ID.G_HEX ).innerHTML = B.dec2hex( this.get( this.OPT.GREEN ) );
			this.getElement( this.ID.B ).value = this.get( this.OPT.BLUE );
			this.getElement( this.ID.B_HEX ).innerHTML = B.dec2hex( this.get( this.OPT.BLUE ) );
			this.getElement( this.ID.HEX ).value = this.get( this.OPT.HEX );
		},
		_onHueSliderChange: function( N ) {
			var L = this._getH(),
				K = B.hsv2rgb( L, 1, 1 ),
				M = "rgb(" + K.join( "," ) + ")";
			this.set( this.OPT.HUE, L, true );
			E.setStyle( this.getElement( this.ID.PICKER_BG ), "background-color", M );
			if ( this.hueSlider.valueChangeSource !== D.SOURCE_SET_VALUE ) {
				this._getValuesFromSliders();
			}
			this._updateFormFields();
			this._updateSwatch();
		},
		_onPickerSliderChange: function( M ) {
			var L = this._getS(),
				K = this._getV();
			this.set( this.OPT.SATURATION, Math.round( L * 100 ), true );
			this.set( this.OPT.VALUE, Math.round( K * 100 ), true );
			if ( this.pickerSlider.valueChangeSource !== D.SOURCE_SET_VALUE ) {
				this._getValuesFromSliders();
			}
			this._updateFormFields();
			this._updateSwatch();
		},
		_getCommand: function( K ) {
			var L = I.getCharCode( K );
			if ( L === 38 ) {
				return 3;
			} else {
				if ( L === 13 ) {
					return 6;
				} else {
					if ( L === 40 ) {
						return 4;
					} else {
						if ( L >= 48 && L <= 57 ) {
							return 1;
						} else {
							if ( L >= 97 && L <= 102 ) {
								return 2;
							} else {
								if ( L >= 65 && L <= 70 ) {
									return 2;
								} else {
									if ( "8, 9, 13, 27, 37, 39".indexOf( L ) > -1 || K.ctrlKey || K.metaKey ) {
										return 5;
									} else {
										return 0;
									}
								}
							}
						}
					}
				}
			}
		},
		_useFieldValue: function( L, K, N ) {
			var M = K.value; if ( N !== this.OPT.HEX ) {
				M = parseInt( M, 10 );
			}
			if ( M !== this.get( N ) ) {
				this.set( N, M );
			}
		},
		_rgbFieldKeypress: function( M, K, O ) {
			var N = this._getCommand( M ),
				L = ( M.shiftKey ) ? 10 : 1;
			switch ( N ) {
				case 6:
					this._useFieldValue.apply( this, arguments );
					break;case 3:
					this.set( O, Math.min( this.get( O ) + L, 255 ) );
					this._updateFormFields();
					break;case 4:
					this.set( O, Math.max( this.get( O ) - L, 0 ) );
					this._updateFormFields();
					break;default:
			}
		},
		_hexFieldKeypress: function( L, K, N ) {
			var M = this._getCommand( L );
			if ( M === 6 ) {
				this._useFieldValue.apply( this, arguments );
			}
		},
		_hexOnly: function( L, K ) {
			var M = this._getCommand( L );
			switch ( M ) {
				case 6:
				case 5:
				case 1:
					break;case 2:
					if ( K !== true ) {
						break;
					}default:
					I.stopEvent( L );
					return false;
			}
		},
		_numbersOnly: function( K ) {
			return this._hexOnly( K, true );
		},
		getElement: function( K ) {
			return this.get( this.OPT.ELEMENTS )[ this.get( this.OPT.IDS )[ K ] ];
		},
		_createElements: function() {
			var N, M, P, O, L,
				K = this.get( this.OPT.IDS ),
				Q = this.get( this.OPT.TXT ),
				S = this.get( this.OPT.IMAGES ),
				R = function( U, V ) {
					var W = document.createElement( U );
					if ( V ) {
						C.augmentObject( W, V, true );
					}
					return W;
				},
				T = function( U, V ) {
					var W = C.merge({ autocomplete: "off", value: "0", size: 3, maxlength: 3 }, V );
					W.name = W.id;
					return new R( U, W );
				};
			L = this.get( "element" );
			N = new R( "div", { id: K[ this.ID.PICKER_BG ], className: "yui-picker-bg", tabIndex: -1, hideFocus: true } );
			M = new R( "div", { id: K[ this.ID.PICKER_THUMB ], className: "yui-picker-thumb" } );
			P = new R( "img", { src: S.PICKER_THUMB } );
			M.appendChild( P );
			N.appendChild( M );
			L.appendChild( N );
			N = new R( "div", { id: K[ this.ID.HUE_BG ], className: "yui-picker-hue-bg", tabIndex: -1, hideFocus: true } );
			M = new R( "div", { id: K[ this.ID.HUE_THUMB ], className: "yui-picker-hue-thumb" } );
			P = new R( "img", { src: S.HUE_THUMB } );
			M.appendChild( P );
			N.appendChild( M );
			L.appendChild( N );
			N = new R( "div", { id: K[ this.ID.CONTROLS ], className: "yui-picker-controls" } );
			L.appendChild( N );
			L = N;
			N = new R( "div", { className: "hd" } );
			M = new R( "a", { id: K[ this.ID.CONTROLS_LABEL ], href: "#" } );
			N.appendChild( M );
			L.appendChild( N );
			N = new R( "div", { className: "bd" } );
			L.appendChild( N );
			L = N;
			N = new R( "ul", { id: K[ this.ID.RGB_CONTROLS ], className: "yui-picker-rgb-controls" } );
			M = new R( "li" );
			M.appendChild( document.createTextNode( Q.R + " " ) );
			O = new T( "input", { id: K[ this.ID.R ], className: "yui-picker-r" } );
			M.appendChild( O );
			N.appendChild( M );
			M = new R( "li" );
			M.appendChild( document.createTextNode( Q.G + " " ) );
			O = new T( "input", { id: K[ this.ID.G ], className: "yui-picker-g" } );
			M.appendChild( O );
			N.appendChild( M );
			M = new R( "li" );
			M.appendChild( document.createTextNode( Q.B + " " ) );
			O = new T( "input", { id: K[ this.ID.B ], className: "yui-picker-b" } );
			M.appendChild( O );
			N.appendChild( M );
			L.appendChild( N );
			N = new R( "ul", { id: K[ this.ID.HSV_CONTROLS ], className: "yui-picker-hsv-controls" } );
			M = new R( "li" );
			M.appendChild( document.createTextNode( Q.H + " " ) );
			O = new T( "input", { id: K[ this.ID.H ], className: "yui-picker-h" } );
			M.appendChild( O );
			M.appendChild( document.createTextNode( " " + Q.DEG ) );
			N.appendChild( M );
			M = new R( "li" );
			M.appendChild( document.createTextNode( Q.S + " " ) );
			O = new T( "input", { id: K[ this.ID.S ], className: "yui-picker-s" } );
			M.appendChild( O );
			M.appendChild( document.createTextNode( " " + Q.PERCENT ) );
			N.appendChild( M );
			M = new R( "li" );
			M.appendChild( document.createTextNode( Q.V + " " ) );
			O = new T( "input", { id: K[ this.ID.V ], className: "yui-picker-v" } );
			M.appendChild( O );
			M.appendChild( document.createTextNode( " " + Q.PERCENT ) );
			N.appendChild( M );
			L.appendChild( N );
			N = new R( "ul", { id: K[ this.ID.HEX_SUMMARY ], className: "yui-picker-hex_summary" } );
			M = new R( "li", { id: K[ this.ID.R_HEX ] } );
			N.appendChild( M );
			M = new R( "li", { id: K[ this.ID.G_HEX ] } );
			N.appendChild( M );
			M = new R( "li", { id: K[ this.ID.B_HEX ] } );
			N.appendChild( M );
			L.appendChild( N );
			N = new R( "div", { id: K[ this.ID.HEX_CONTROLS ], className: "yui-picker-hex-controls" } );
			N.appendChild( document.createTextNode( Q.HEX + " " ) );
			M = new T( "input", { id: K[ this.ID.HEX ], className: "yui-picker-hex", size: 6, maxlength: 6 } );
			N.appendChild( M );
			L.appendChild( N );
			L = this.get( "element" );
			N = new R( "div", { id: K[ this.ID.SWATCH ], className: "yui-picker-swatch" } );
			L.appendChild( N );
			N = new R( "div", { id: K[ this.ID.WEBSAFE_SWATCH ], className: "yui-picker-websafe-swatch" } );
			L.appendChild( N );
		},
		_attachRGBHSV: function( L, K ) {
			I.on( this.getElement( L ), "keydown", function( N, M ) {
				M._rgbFieldKeypress( N, this, K );
			}, this );
			I.on( this.getElement( L ), "keypress", this._numbersOnly, this, true );
			I.on( this.getElement( L ), "blur", function( N, M ) {
				M._useFieldValue( N, this, K );
			}, this );
		},
		_updateRGB: function() {
			var K = [ this.get( this.OPT.RED ), this.get( this.OPT.GREEN ), this.get( this.OPT.BLUE ) ];
			this.set( this.OPT.RGB, K );
			this._updateSliders();
		},
		_initElements: function() {
			var O = this.OPT,
				N = this.get( O.IDS ),
				L = this.get( O.ELEMENTS ),
				K, M, P;
			for ( K in this.ID ) {
				if ( C.hasOwnProperty( this.ID, K ) ) {
					N[ this.ID[ K ] ] = N[ K ];
				}
			}
			M = E.get( N[ this.ID.PICKER_BG ] );
			if ( !M ) {
				this._createElements();
			} else {}
			for ( K in N ) {
				if ( C.hasOwnProperty( N, K ) ) {
					M = E.get( N[ K ] );
					P = E.generateId( M );
					N[ K ] = P;
					N[ N[ K ] ] = P;
					L[ P ] = M;
				}
			}
		},
		initPicker: function() {
			this._initSliders();
			this._bindUI();
			this.syncUI( true );
		},
		_initSliders: function() {
			var K = this.ID,
				L = this.get( this.OPT.PICKER_SIZE );
			this.hueSlider = D.getVertSlider( this.getElement( K.HUE_BG ), this.getElement( K.HUE_THUMB ), 0, L );
			this.pickerSlider = D.getSliderRegion( this.getElement( K.PICKER_BG ), this.getElement( K.PICKER_THUMB ), 0, L, 0, L );
			this.set( this.OPT.ANIMATE, this.get( this.OPT.ANIMATE ) );
		},
		_bindUI: function() {
			var K = this.ID,
				L = this.OPT; this.hueSlider.subscribe( "change", this._onHueSliderChange, this, true );
			this.pickerSlider.subscribe( "change", this._onPickerSliderChange, this, true );
			I.on( this.getElement( K.WEBSAFE_SWATCH ), "click", function( M ) {
				this.setValue( this.get( L.WEBSAFE ) );
			}, this, true );
			I.on( this.getElement( K.CONTROLS_LABEL ), "click", function( M ) {
				this.set( L.SHOW_CONTROLS, !this.get( L.SHOW_CONTROLS ) );
				I.preventDefault( M );
			}, this, true );
			this._attachRGBHSV( K.R, L.RED );
			this._attachRGBHSV( K.G, L.GREEN );
			this._attachRGBHSV( K.B, L.BLUE );
			this._attachRGBHSV( K.H, L.HUE );
			this._attachRGBHSV( K.S, L.SATURATION );
			this._attachRGBHSV( K.V, L.VALUE );
			I.on( this.getElement( K.HEX ), "keydown", function( N, M ) {
				M._hexFieldKeypress( N, this, L.HEX );
			}, this );
			I.on( this.getElement( this.ID.HEX ), "keypress", this._hexOnly, this, true );
			I.on( this.getElement( this.ID.HEX ), "blur", function( N, M ) {
				M._useFieldValue( N, this, L.HEX );
			}, this );
		},
		syncUI: function( K ) {
			this.skipAnim = K; this._updateRGB();
			this.skipAnim = false;
		},
		_updateRGBFromHSV: function() {
			var L = [ this.get( this.OPT.HUE ), this.get( this.OPT.SATURATION ) / 100, this.get( this.OPT.VALUE ) / 100 ],
				K = B.hsv2rgb( L );
			this.set( this.OPT.RGB, K );
			this._updateSliders();
		},
		_updateHex: function() {
			var N = this.get( this.OPT.HEX ),
				K = N.length,
				O, M, L;
			if ( K === 3 ) {
				O = N.split( "" );
				for ( M = 0; M < K; M = M + 1 ) {
					O[ M ] = O[ M ] + O[ M ];
				}
				N = O.join( "" );
			}
			if ( N.length !== 6 ) {
				return false;
			}
			L = B.hex2rgb( N );
			this.setValue( L );
		},
		_hideShowEl: function( M, K ) {
			var L = ( C.isString( M ) ? this.getElement( M ) : M );
			E.setStyle( L, "display", ( K ) ? "" : "none" );
		},
		initAttributes: function( K ) {
			K = K || {};
			G.superclass.initAttributes.call( this, K );
			this.setAttributeConfig( this.OPT.PICKER_SIZE, { value: K.size || this.DEFAULT.PICKER_SIZE } );
			this.setAttributeConfig( this.OPT.HUE, { value: K.hue || 0, validator: C.isNumber } );
			this.setAttributeConfig( this.OPT.SATURATION, { value: K.saturation || 0, validator: C.isNumber } );
			this.setAttributeConfig( this.OPT.VALUE, { value: C.isNumber( K.value ) ? K.value : 100, validator: C.isNumber } );
			this.setAttributeConfig( this.OPT.RED, { value: C.isNumber( K.red ) ? K.red : 255, validator: C.isNumber } );
			this.setAttributeConfig( this.OPT.GREEN, { value: C.isNumber( K.green ) ? K.green : 255, validator: C.isNumber } );
			this.setAttributeConfig( this.OPT.BLUE, { value: C.isNumber( K.blue ) ? K.blue : 255, validator: C.isNumber } );
			this.setAttributeConfig( this.OPT.HEX, { value: K.hex || "FFFFFF", validator: C.isString } );
			this.setAttributeConfig( this.OPT.RGB, {
				value: K.rgb || [ 255, 255, 255 ], method: function( O ) {
					this.set( this.OPT.RED, O[ 0 ], true );
					this.set( this.OPT.GREEN, O[ 1 ], true );
					this.set( this.OPT.BLUE, O[ 2 ], true );
					var Q = B.websafe( O ),
						P = B.rgb2hex( O ),
						N = B.rgb2hsv( O );
					this.set( this.OPT.WEBSAFE, Q, true );
					this.set( this.OPT.HEX, P, true );
					if ( N[ 1 ] ) {
						this.set( this.OPT.HUE, N[ 0 ], true );
					}
					this.set( this.OPT.SATURATION, Math.round( N[ 1 ] * 100 ), true );
					this.set( this.OPT.VALUE, Math.round( N[ 2 ] * 100 ), true );
				},
				readonly: true } );
			this.setAttributeConfig( this.OPT.CONTAINER, {
				value: null, method: function( N ) {
					if ( N ) {
						N.showEvent.subscribe( function() {
							this.pickerSlider.focus();
						}, this, true );
					}
				} } );
			this.setAttributeConfig( this.OPT.WEBSAFE, { value: K.websafe || [ 255, 255, 255 ] } );
			var M = K.ids || C.merge( {}, this.ID ),
				L;
			if ( !K.ids && J > 1 ) {
				for ( L in M ) {
					if ( C.hasOwnProperty( M, L ) ) {
						M[ L ] = M[ L ] + J;
					}
				}
			}
			this.setAttributeConfig( this.OPT.IDS, { value: M, writeonce: true } );
			this.setAttributeConfig( this.OPT.TXT, { value: K.txt || this.TXT, writeonce: true } );
			this.setAttributeConfig( this.OPT.IMAGES, { value: K.images || this.IMAGE, writeonce: true } );
			this.setAttributeConfig( this.OPT.ELEMENTS, {
				value: {},
				readonly: true } );
			this.setAttributeConfig( this.OPT.SHOW_CONTROLS, {
				value: C.isBoolean( K.showcontrols ) ? K.showcontrols : true, method: function( N ) {
					var O = E.getElementsByClassName( "bd", "div", this.getElement( this.ID.CONTROLS ) )[ 0 ];
					this._hideShowEl( O, N );
					this.getElement( this.ID.CONTROLS_LABEL ).innerHTML = ( N ) ? this.get( this.OPT.TXT ).HIDE_CONTROLS : this.get( this.OPT.TXT ).SHOW_CONTROLS;
				} } );
			this.setAttributeConfig( this.OPT.SHOW_RGB_CONTROLS, {
				value: C.isBoolean( K.showrgbcontrols ) ? K.showrgbcontrols : true, method: function( N ) {
					this._hideShowEl( this.ID.RGB_CONTROLS, N );
				} } );
			this.setAttributeConfig( this.OPT.SHOW_HSV_CONTROLS, {
				value: C.isBoolean( K.showhsvcontrols ) ? K.showhsvcontrols : false, method: function( N ) {
					this._hideShowEl( this.ID.HSV_CONTROLS, N );
					if ( N && this.get( this.OPT.SHOW_HEX_SUMMARY ) ) {
						this.set( this.OPT.SHOW_HEX_SUMMARY, false );
					}
				} } );
			this.setAttributeConfig( this.OPT.SHOW_HEX_CONTROLS, {
				value: C.isBoolean( K.showhexcontrols ) ? K.showhexcontrols : false, method: function( N ) {
					this._hideShowEl( this.ID.HEX_CONTROLS, N );
				} } );
			this.setAttributeConfig( this.OPT.SHOW_WEBSAFE, {
				value: C.isBoolean( K.showwebsafe ) ? K.showwebsafe : true, method: function( N ) {
					this._hideShowEl( this.ID.WEBSAFE_SWATCH, N );
				} } );
			this.setAttributeConfig( this.OPT.SHOW_HEX_SUMMARY, {
				value: C.isBoolean( K.showhexsummary ) ? K.showhexsummary : true, method: function( N ) {
					this._hideShowEl( this.ID.HEX_SUMMARY, N );
					if ( N && this.get( this.OPT.SHOW_HSV_CONTROLS ) ) {
						this.set( this.OPT.SHOW_HSV_CONTROLS, false );
					}
				} } );
			this.setAttributeConfig( this.OPT.ANIMATE, {
				value: C.isBoolean( K.animate ) ? K.animate : true, method: function( N ) {
					if ( this.pickerSlider ) {
						this.pickerSlider.animate = N;
						this.hueSlider.animate = N;
					}
				} } );
			this.on( this.OPT.HUE + "Change", this._updateRGBFromHSV, this, true );
			this.on( this.OPT.SATURATION + "Change", this._updateRGBFromHSV, this, true );
			this.on( this.OPT.VALUE + "Change", this._updateRGBFromHSV, this, true );
			this.on( this.OPT.RED + "Change", this._updateRGB, this, true );
			this.on( this.OPT.GREEN + "Change", this._updateRGB, this, true );
			this.on( this.OPT.BLUE + "Change", this._updateRGB, this, true );
			this.on( this.OPT.HEX + "Change", this._updateHex, this, true );
			this._initElements();
		} } );
	YAHOO.widget.ColorPicker = G;
})();
YAHOO.register( "colorpicker", YAHOO.widget.ColorPicker, { version: "2.7.0", build: "1796" } );

/*
Copyright (c) 2009, Yahoo! Inc. All rights reserved.
Code licensed under the BSD License:
http://developer.yahoo.net/yui/license.txt
version: 2.7.0
*/ ( function() {
	var B = YAHOO.util;
	var A = function( D, C, E, F ) {
			if ( !D ) {}
			this.init( D, C, E, F );
		};
	A.NAME = "Anim";
	A.prototype = {
		toString: function() {
			var C = this.getEl() || {};
			var D = C.id || C.tagName;
			return ( this.constructor.NAME + ": " + D );
		},
		patterns: { noNegatives: /width|height|opacity|padding/i, offsetAttribute: /^((width|height)|(top|left))$/, defaultUnit: /width|height|top$|bottom$|left$|right$/i, offsetUnit: /\d+(em|%|en|ex|pt|in|cm|mm|pc)$/i },
		doMethod: function( C, E, D ) {
			return this.method( this.currentFrame, E, D - E, this.totalFrames );
		},
		setAttribute: function( C, F, E ) {
			var D = this.getEl();
			if ( this.patterns.noNegatives.test( C ) ) {
				F = ( F > 0 ) ? F : 0;
			}
			if ( "style" in D ) {
				B.Dom.setStyle( D, C, F + E );
			} else {
				if ( C in D ) {
					D[ C ] = F;
				}
			}
		},
		getAttribute: function( C ) {
			var E = this.getEl();
			var G = B.Dom.getStyle( E, C );
			if ( G !== "auto" && !this.patterns.offsetUnit.test( G ) ) {
				return parseFloat( G );
			}
			var D = this.patterns.offsetAttribute.exec( C ) || [];
			var H = !!( D[ 3 ] );
			var F = !!( D[ 2 ] );
			if ( "style" in E ) {
				if ( F || ( B.Dom.getStyle( E, "position" ) == "absolute" && H ) ) {
					G = E[ "offset" + D[ 0 ].charAt( 0 ).toUpperCase() + D[ 0 ].substr( 1 ) ];
				} else {
					G = 0;
				}
			} else {
				if ( C in E ) {
					G = E[ C ];
				}
			}
			return G;
		},
		getDefaultUnit: function( C ) {
			if ( this.patterns.defaultUnit.test( C ) ) {
				return "px";
			}
			return "";
		},
		setRuntimeAttribute: function( D ) {
			var I; var E; var F = this.attributes; this.runtimeAttributes[ D ] = {};
			var H = function( J ) {
					return ( typeof J !== "undefined" );
				};
			if ( !H( F[ D ][ "to" ] ) && !H( F[ D ][ "by" ] ) ) {
				return false;
			}
			I = ( H( F[ D ][ "from" ] ) ) ? F[ D ][ "from" ] : this.getAttribute( D );
			if ( H( F[ D ][ "to" ] ) ) {
				E = F[ D ][ "to" ];
			} else {
				if ( H( F[ D ][ "by" ] ) ) {
					if ( I.constructor == Array ) {
						E = [];
						for ( var G = 0, C = I.length; G < C; ++G ) {
							E[ G ] = I[ G ] + F[ D ][ "by" ][ G ] * 1;
						}
					} else {
						E = I + F[ D ][ "by" ] * 1;
					}
				}
			}
			this.runtimeAttributes[ D ].start = I;
			this.runtimeAttributes[ D ].end = E;
			this.runtimeAttributes[ D ].unit = ( H( F[ D ].unit ) ) ? F[ D ][ "unit" ] : this.getDefaultUnit( D );
			return true;
		},
		init: function( E, J, I, C ) {
			var D = false; var F = null; var H = 0; E = B.Dom.get( E );
			this.attributes = J || {};
			this.duration = !YAHOO.lang.isUndefined( I ) ? I : 1;
			this.method = C || B.Easing.easeNone;
			this.useSeconds = true;
			this.currentFrame = 0;
			this.totalFrames = B.AnimMgr.fps;
			this.setEl = function( M ) {
				E = B.Dom.get( M );
			};
			this.getEl = function() {
				return E;
			};
			this.isAnimated = function() {
				return D;
			};
			this.getStartTime = function() {
				return F;
			};
			this.runtimeAttributes = {};
			this.animate = function() {
				if ( this.isAnimated() ) {
					return false;
				}
				this.currentFrame = 0;
				this.totalFrames = ( this.useSeconds ) ? Math.ceil( B.AnimMgr.fps * this.duration ) : this.duration;
				if ( this.duration === 0 && this.useSeconds ) {
					this.totalFrames = 1;
				}
				B.AnimMgr.registerElement( this );
				return true;
			};
			this.stop = function( M ) {
				if ( !this.isAnimated() ) {
					return false;
				}
				if ( M ) {
					this.currentFrame = this.totalFrames;
					this._onTween.fire();
				}
				B.AnimMgr.stop( this );
			};
			var L = function() {
					this.onStart.fire();
					this.runtimeAttributes = {};
					for ( var M in this.attributes ) {
						this.setRuntimeAttribute( M );
					}
					D = true;
					H = 0;
					F = new Date();
				};
			var K = function() {
					var O = { duration: new Date() - this.getStartTime(), currentFrame: this.currentFrame }; O.toString = function() {
						return ( "duration: " + O.duration + ", currentFrame: " + O.currentFrame );
					};
					this.onTween.fire( O );
					var N = this.runtimeAttributes;
					for ( var M in N ) {
						this.setAttribute( M, this.doMethod( M, N[ M ].start, N[ M ].end ), N[ M ].unit );
					}
					H += 1;
				};
			var G = function() {
					var M = ( new Date() - F ) / 1000;
					var N = { duration: M, frames: H, fps: H / M }; N.toString = function() {
						return ( "duration: " + N.duration + ", frames: " + N.frames + ", fps: " + N.fps );
					};
					D = false;
					H = 0;
					this.onComplete.fire( N );
				};
			this._onStart = new B.CustomEvent( "_start", this, true );
			this.onStart = new B.CustomEvent( "start", this );
			this.onTween = new B.CustomEvent( "tween", this );
			this._onTween = new B.CustomEvent( "_tween", this, true );
			this.onComplete = new B.CustomEvent( "complete", this );
			this._onComplete = new B.CustomEvent( "_complete", this, true );
			this._onStart.subscribe( L );
			this._onTween.subscribe( K );
			this._onComplete.subscribe( G );
		} }; B.Anim = A;
})();
YAHOO.util.AnimMgr = new function() {
	var C = null;
	var B = [];
	var A = 0;
	this.fps = 1000;
	this.delay = 1;
	this.registerElement = function( F ) {
		B[ B.length ] = F;
		A += 1;
		F._onStart.fire();
		this.start();
	};
	this.unRegister = function( G, F ) {
		F = F || E( G );
		if ( !G.isAnimated() || F == -1 ) {
			return false;
		}
		G._onComplete.fire();
		B.splice( F, 1 );
		A -= 1;
		if ( A <= 0 ) {
			this.stop();
		}
		return true;
	};
	this.start = function() {
		if ( C === null ) {
			C = setInterval( this.run, this.delay );
		}
	};
	this.stop = function( H ) {
		if ( !H ) {
			clearInterval( C );
			for ( var G = 0, F = B.length; G < F; ++G ) {
				this.unRegister( B[ 0 ], 0 );
			}
			B = [];
			C = null;
			A = 0;
		} else {
			this.unRegister( H );
		}
	};
	this.run = function() {
		for ( var H = 0, F = B.length; H < F; ++H ) {
			var G = B[ H ];
			if ( !G || !G.isAnimated() ) {
				continue;
			}
			if ( G.currentFrame < G.totalFrames || G.totalFrames === null ) {
				G.currentFrame += 1;
				if ( G.useSeconds ) {
					D( G );
				}
				G._onTween.fire();
			} else {
				YAHOO.util.AnimMgr.stop( G, H );
			}
		}
	};
	var E = function( H ) {
			for ( var G = 0, F = B.length; G < F; ++G ) {
				if ( B[ G ] == H ) {
					return G;
				}
			}
			return -1;
		};
	var D = function( G ) {
			var J = G.totalFrames;
			var I = G.currentFrame;
			var H = ( G.currentFrame * G.duration * 1000 / G.totalFrames );
			var F = ( new Date() - G.getStartTime() );
			var K = 0;
			if ( F < G.duration * 1000 ) {
				K = Math.round( ( F / H - 1 ) * G.currentFrame );
			} else {
				K = J - ( I + 1 );
			}
			if ( K > 0 && isFinite( K ) ) {
				if ( G.currentFrame + K >= J ) {
					K = J - ( I + 1 );
				}
				G.currentFrame += K;
			}
		};
};
YAHOO.util.Bezier = new function() {
	this.getPosition = function( E, D ) {
		var F = E.length;
		var C = [];
		for ( var B = 0; B < F; ++B ) {
			C[ B ] = [ E[ B ][ 0 ], E[ B ][ 1 ] ];
		}
		for ( var A = 1; A < F; ++A ) {
			for ( B = 0; B < F - A; ++B ) {
				C[ B ][ 0 ] = ( 1 - D ) * C[ B ][ 0 ] + D * C[ parseInt( B + 1, 10 ) ][ 0 ];
				C[ B ][ 1 ] = ( 1 - D ) * C[ B ][ 1 ] + D * C[ parseInt( B + 1, 10 ) ][ 1 ];
			}
		}
		return [ C[ 0 ][ 0 ], C[ 0 ][ 1 ] ];
	};
};
(function() {
	var A = function( F, E, G, H ) {
			A.superclass.constructor.call( this, F, E, G, H );
		};
	A.NAME = "ColorAnim";
	A.DEFAULT_BGCOLOR = "#fff";
	var C = YAHOO.util;
	YAHOO.extend( A, C.Anim );
	var D = A.superclass;
	var B = A.prototype;
	B.patterns.color = /color$/i;
	B.patterns.rgb = /^rgb\(([0-9]+)\s*,\s*([0-9]+)\s*,\s*([0-9]+)\)$/i;
	B.patterns.hex = /^#?([0-9A-F]{2})([0-9A-F]{2})([0-9A-F]{2})$/i;
	B.patterns.hex3 = /^#?([0-9A-F]{1})([0-9A-F]{1})([0-9A-F]{1})$/i;
	B.patterns.transparent = /^transparent|rgba\(0, 0, 0, 0\)$/;
	B.parseColor = function( E ) {
		if ( E.length == 3 ) {
			return E;
		}
		var F = this.patterns.hex.exec( E );
		if ( F && F.length == 4 ) {
			return [ parseInt( F[ 1 ], 16 ), parseInt( F[ 2 ], 16 ), parseInt( F[ 3 ], 16 ) ];
		}
		F = this.patterns.rgb.exec( E );
		if ( F && F.length == 4 ) {
			return [ parseInt( F[ 1 ], 10 ), parseInt( F[ 2 ], 10 ), parseInt( F[ 3 ], 10 ) ];
		}
		F = this.patterns.hex3.exec( E );
		if ( F && F.length == 4 ) {
			return [ parseInt( F[ 1 ] + F[ 1 ], 16 ), parseInt( F[ 2 ] + F[ 2 ], 16 ), parseInt( F[ 3 ] + F[ 3 ], 16 ) ];
		}
		return null;
	};
	B.getAttribute = function( E ) {
		var G = this.getEl();
		if ( this.patterns.color.test( E ) ) {
			var I = YAHOO.util.Dom.getStyle( G, E );
			var H = this;
			if ( this.patterns.transparent.test( I ) ) {
				var F = YAHOO.util.Dom.getAncestorBy( G, function( J ) {
					return !H.patterns.transparent.test( I );
				});
				if ( F ) {
					I = C.Dom.getStyle( F, E );
				} else {
					I = A.DEFAULT_BGCOLOR;
				}
			}
		} else {
			I = D.getAttribute.call( this, E );
		}
		return I;
	};
	B.doMethod = function( F, J, G ) {
		var I;
		if ( this.patterns.color.test( F ) ) {
			I = [];
			for ( var H = 0, E = J.length; H < E; ++H ) {
				I[ H ] = D.doMethod.call( this, F, J[ H ], G[ H ] );
			}
			I = "rgb(" + Math.floor( I[ 0 ] ) + "," + Math.floor( I[ 1 ] ) + "," + Math.floor( I[ 2 ] ) + ")";
		} else {
			I = D.doMethod.call( this, F, J, G );
		}
		return I;
	};
	B.setRuntimeAttribute = function( F ) {
		D.setRuntimeAttribute.call( this, F );
		if ( this.patterns.color.test( F ) ) {
			var H = this.attributes;
			var J = this.parseColor( this.runtimeAttributes[ F ].start );
			var G = this.parseColor( this.runtimeAttributes[ F ].end );
			if ( typeof H[ F ][ "to" ] === "undefined" && typeof H[ F ][ "by" ] !== "undefined" ) {
				G = this.parseColor( H[ F ].by );
				for ( var I = 0, E = J.length; I < E; ++I ) {
					G[ I ] = J[ I ] + G[ I ];
				}
			}
			this.runtimeAttributes[ F ].start = J;
			this.runtimeAttributes[ F ].end = G;
		}
	};
	C.ColorAnim = A;
})();
/*
TERMS OF USE - EASING EQUATIONS
Open source under the BSD License.
Copyright 2001 Robert Penner All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
 * Neither the name of the author nor the names of contributors may be used to endorse or promote products derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
YAHOO.util.Easing = {
	easeNone: function( B, A, D, C ) {
		return D * B / C + A;
	},
	easeIn: function( B, A, D, C ) {
		return D * ( B /= C ) * B + A;
	},
	easeOut: function( B, A, D, C ) {
		return -D * ( B /= C ) * ( B - 2 ) + A;
	},
	easeBoth: function( B, A, D, C ) {
		if ( ( B /= C / 2 ) < 1 ) {
			return D / 2 * B * B + A;
		}
		return -D / 2 * ( ( --B ) * ( B - 2 ) - 1 ) + A;
	},
	easeInStrong: function( B, A, D, C ) {
		return D * ( B /= C ) * B * B * B + A;
	},
	easeOutStrong: function( B, A, D, C ) {
		return -D * ( ( B = B / C - 1 ) * B * B * B - 1 ) + A;
	},
	easeBothStrong: function( B, A, D, C ) {
		if ( ( B /= C / 2 ) < 1 ) {
			return D / 2 * B * B * B * B + A;
		}
		return -D / 2 * ( ( B -= 2 ) * B * B * B - 2 ) + A;
	},
	elasticIn: function( C, A, G, F, B, E ) {
		if ( C == 0 ) {
			return A;
		}
		if ( ( C /= F ) == 1 ) {
			return A + G;
		}
		if ( !E ) {
			E = F * 0.3;
		}
		if ( !B || B < Math.abs( G ) ) {
			B = G;
			var D = E / 4;
		} else {
			var D = E / ( 2 * Math.PI ) * Math.asin( G / B );
		}
		return -( B * Math.pow( 2, 10 * ( C -= 1 ) ) * Math.sin( ( C * F - D ) * ( 2 * Math.PI ) / E ) ) + A;
	},
	elasticOut: function( C, A, G, F, B, E ) {
		if ( C == 0 ) {
			return A;
		}
		if ( ( C /= F ) == 1 ) {
			return A + G;
		}
		if ( !E ) {
			E = F * 0.3;
		}
		if ( !B || B < Math.abs( G ) ) {
			B = G;
			var D = E / 4;
		} else {
			var D = E / ( 2 * Math.PI ) * Math.asin( G / B );
		}
		return B * Math.pow( 2, -10 * C ) * Math.sin( ( C * F - D ) * ( 2 * Math.PI ) / E ) + G + A;
	},
	elasticBoth: function( C, A, G, F, B, E ) {
		if ( C == 0 ) {
			return A;
		}
		if ( ( C /= F / 2 ) == 2 ) {
			return A + G;
		}
		if ( !E ) {
			E = F * ( 0.3 * 1.5 );
		}
		if ( !B || B < Math.abs( G ) ) {
			B = G;
			var D = E / 4;
		} else {
			var D = E / ( 2 * Math.PI ) * Math.asin( G / B );
		}
		if ( C < 1 ) {
			return -0.5 * ( B * Math.pow( 2, 10 * ( C -= 1 ) ) * Math.sin( ( C * F - D ) * ( 2 * Math.PI ) / E ) ) + A;
		}
		return B * Math.pow( 2, -10 * ( C -= 1 ) ) * Math.sin( ( C * F - D ) * ( 2 * Math.PI ) / E ) * 0.5 + G + A;
	},
	backIn: function( B, A, E, D, C ) {
		if ( typeof C == "undefined" ) {
			C = 1.70158;
		}
		return E * ( B /= D ) * B * ( ( C + 1 ) * B - C ) + A;
	},
	backOut: function( B, A, E, D, C ) {
		if ( typeof C == "undefined" ) {
			C = 1.70158;
		}
		return E * ( ( B = B / D - 1 ) * B * ( ( C + 1 ) * B + C ) + 1 ) + A;
	},
	backBoth: function( B, A, E, D, C ) {
		if ( typeof C == "undefined" ) {
			C = 1.70158;
		}
		if ( ( B /= D / 2 ) < 1 ) {
			return E / 2 * ( B * B * ( ( ( C *= ( 1.525 ) ) + 1 ) * B - C ) ) + A;
		}
		return E / 2 * ( ( B -= 2 ) * B * ( ( ( C *= ( 1.525 ) ) + 1 ) * B + C ) + 2 ) + A;
	},
	bounceIn: function( B, A, D, C ) {
		return D - YAHOO.util.Easing.bounceOut( C - B, 0, D, C ) + A;
	},
	bounceOut: function( B, A, D, C ) {
		if ( ( B /= C ) < ( 1 / 2.75 ) ) {
			return D * ( 7.5625 * B * B ) + A;
		} else {
			if ( B < ( 2 / 2.75 ) ) {
				return D * ( 7.5625 * ( B -= ( 1.5 / 2.75 ) ) * B + 0.75 ) + A;
			} else {
				if ( B < ( 2.5 / 2.75 ) ) {
					return D * ( 7.5625 * ( B -= ( 2.25 / 2.75 ) ) * B + 0.9375 ) + A;
				}
			}
		}
		return D * ( 7.5625 * ( B -= ( 2.625 / 2.75 ) ) * B + 0.984375 ) + A;
	},
	bounceBoth: function( B, A, D, C ) {
		if ( B < C / 2 ) {
			return YAHOO.util.Easing.bounceIn( B * 2, 0, D, C ) * 0.5 + A;
		}
		return YAHOO.util.Easing.bounceOut( B * 2 - C, 0, D, C ) * 0.5 + D * 0.5 + A;
	} };
(function() {
	var A = function( H, G, I, J ) {
			if ( H ) {
				A.superclass.constructor.call( this, H, G, I, J );
			}
		};
	A.NAME = "Motion";
	var E = YAHOO.util;
	YAHOO.extend( A, E.ColorAnim );
	var F = A.superclass;
	var C = A.prototype;
	C.patterns.points = /^points$/i;
	C.setAttribute = function( G, I, H ) {
		if ( this.patterns.points.test( G ) ) {
			H = H || "px";
			F.setAttribute.call( this, "left", I[ 0 ], H );
			F.setAttribute.call( this, "top", I[ 1 ], H );
		} else {
			F.setAttribute.call( this, G, I, H );
		}
	};
	C.getAttribute = function( G ) {
		if ( this.patterns.points.test( G ) ) {
			var H = [ F.getAttribute.call( this, "left" ), F.getAttribute.call( this, "top" ) ];
		} else {
			H = F.getAttribute.call( this, G );
		}
		return H;
	};
	C.doMethod = function( G, K, H ) {
		var J = null;
		if ( this.patterns.points.test( G ) ) {
			var I = this.method( this.currentFrame, 0, 100, this.totalFrames ) / 100;
			J = E.Bezier.getPosition( this.runtimeAttributes[ G ], I );
		} else {
			J = F.doMethod.call( this, G, K, H );
		}
		return J;
	};
	C.setRuntimeAttribute = function( P ) {
		if ( this.patterns.points.test( P ) ) {
			var H = this.getEl();
			var J = this.attributes;
			var G;
			var L = J[ "points" ][ "control" ] || [];
			var I;
			var M, O;
			if ( L.length > 0 && !( L[ 0 ] instanceof Array ) ) {
				L = [ L ];
			} else {
				var K = [];
				for ( M = 0, O = L.length; M < O; ++M ) {
					K[ M ] = L[ M ];
				}
				L = K;
			}
			if ( E.Dom.getStyle( H, "position" ) == "static" ) {
				E.Dom.setStyle( H, "position", "relative" );
			}
			if ( D( J[ "points" ][ "from" ] ) ) {
				E.Dom.setXY( H, J[ "points" ][ "from" ] );
			} else {
				E.Dom.setXY( H, E.Dom.getXY( H ) );
			}
			G = this.getAttribute( "points" );
			if ( D( J[ "points" ][ "to" ] ) ) {
				I = B.call( this, J[ "points" ][ "to" ], G );
				var N = E.Dom.getXY( this.getEl() );
				for ( M = 0, O = L.length; M < O; ++M ) {
					L[ M ] = B.call( this, L[ M ], G );
				}
			} else {
				if ( D( J[ "points" ][ "by" ] ) ) {
					I = [ G[ 0 ] + J[ "points" ][ "by" ][ 0 ], G[ 1 ] + J[ "points" ][ "by" ][ 1 ] ];
					for ( M = 0, O = L.length; M < O; ++M ) {
						L[ M ] = [ G[ 0 ] + L[ M ][ 0 ], G[ 1 ] + L[ M ][ 1 ] ];
					}
				}
			}
			this.runtimeAttributes[ P ] = [ G ];
			if ( L.length > 0 ) {
				this.runtimeAttributes[ P ] = this.runtimeAttributes[ P ].concat( L );
			}
			this.runtimeAttributes[ P ][ this.runtimeAttributes[ P ].length ] = I;
		} else {
			F.setRuntimeAttribute.call( this, P );
		}
	};
	var B = function( G, I ) {
			var H = E.Dom.getXY( this.getEl() );
			G = [ G[ 0 ] - H[ 0 ] + I[ 0 ], G[ 1 ] - H[ 1 ] + I[ 1 ] ];
			return G;
		};
	var D = function( G ) {
			return ( typeof G !== "undefined" );
		};
	E.Motion = A;
})();
(function() {
	var D = function( F, E, G, H ) {
			if ( F ) {
				D.superclass.constructor.call( this, F, E, G, H );
			}
		};
	D.NAME = "Scroll";
	var B = YAHOO.util;
	YAHOO.extend( D, B.ColorAnim );
	var C = D.superclass;
	var A = D.prototype;
	A.doMethod = function( E, H, F ) {
		var G = null;
		if ( E == "scroll" ) {
			G = [ this.method( this.currentFrame, H[ 0 ], F[ 0 ] - H[ 0 ], this.totalFrames ), this.method( this.currentFrame, H[ 1 ], F[ 1 ] - H[ 1 ], this.totalFrames ) ];
		} else {
			G = C.doMethod.call( this, E, H, F );
		}
		return G;
	};
	A.getAttribute = function( E ) {
		var G = null;
		var F = this.getEl();
		if ( E == "scroll" ) {
			G = [ F.scrollLeft, F.scrollTop ];
		} else {
			G = C.getAttribute.call( this, E );
		}
		return G;
	};
	A.setAttribute = function( E, H, G ) {
		var F = this.getEl();
		if ( E == "scroll" ) {
			F.scrollLeft = H[ 0 ];
			F.scrollTop = H[ 1 ];
		} else {
			C.setAttribute.call( this, E, H, G );
		}
	};
	B.Scroll = D;
})();
YAHOO.register( "animation", YAHOO.util.Anim, { version: "2.7.0", build: "1799" } );
