ace.define("ace/keyboard/vim",["require","exports","module","ace/range","ace/lib/event_emitter","ace/lib/dom","ace/lib/oop","ace/lib/keys","ace/lib/event","ace/search","ace/lib/useragent","ace/search_highlight","ace/commands/multi_select_commands","ace/mode/text","ace/multi_select"],(function(e,t,r){"use strict";function n(){var e="";function t(e){if(typeof e!="object")return e+"";if("line"in e){return e.line+":"+e.ch}if("anchor"in e){return t(e.anchor)+"->"+t(e.head)}if(Array.isArray(e))return"["+e.map((function(e){return t(e)}))+"]";return JSON.stringify(e)}for(var r=0;r<arguments.length;r++){var n=arguments[r];var i=t(n);e+=i+"  "}console.log(e)}var i=e("../range").Range;var a=e("../lib/event_emitter").EventEmitter;var o=e("../lib/dom");var s=e("../lib/oop");var l=e("../lib/keys");var c=e("../lib/event");var u=e("../search").Search;var f=e("../lib/useragent");var h=e("../search_highlight").SearchHighlight;var p=e("../commands/multi_select_commands");var d=e("../mode/text").Mode.prototype.tokenRe;e("../multi_select");var v=function e(t){this.ace=t;this.state={};this.marks={};this.$uid=0;this.onChange=this.onChange.bind(this);this.onSelectionChange=this.onSelectionChange.bind(this);this.onBeforeEndOperation=this.onBeforeEndOperation.bind(this);this.ace.on("change",this.onChange);this.ace.on("changeSelection",this.onSelectionChange);this.ace.on("beforeEndOperation",this.onBeforeEndOperation)};v.Pos=function(e,t){if(!(this instanceof x))return new x(e,t);this.line=e;this.ch=t};v.defineOption=function(e,t,r){};v.commands={redo:function e(t){t.ace.redo()},undo:function e(t){t.ace.undo()},newlineAndIndent:function e(t){t.ace.insert("\n")}};v.keyMap={};v.addClass=v.rmClass=function(){};v.e_stop=v.e_preventDefault=c.stopEvent;v.keyName=function(e){var t=l[e.keyCode]||e.key||"";if(t.length==1)t=t.toUpperCase();t=c.getModifierString(e).replace(/(^|-)\w/g,(function(e){return e.toUpperCase()}))+t;return t};v.keyMap["default"]=function(e){return function(t){var r=t.ace.commands.commandKeyBinding[e.toLowerCase()];return r&&t.ace.execCommand(r)!==false}};v.lookupKey=function e(t,r,n){if(!r)r="default";if(typeof r=="string")r=v.keyMap[r];var i=typeof r=="function"?r(t):r[t];if(i===false)return"nothing";if(i==="...")return"multi";if(i!=null&&n(i))return"handled";if(r.fallthrough){if(!Array.isArray(r.fallthrough))return e(t,r.fallthrough,n);for(var a=0;a<r.fallthrough.length;a++){var o=e(t,r.fallthrough[a],n);if(o)return o}}};v.signal=function(e,t,r){return e._signal(t,r)};v.on=c.addListener;v.off=c.removeListener;v.isWordChar=function(e){if(e<"")return/^\w$/.test(e);d.lastIndex=0;return d.test(e)};(function(){s.implement(v.prototype,a);this.destroy=function(){this.ace.off("change",this.onChange);this.ace.off("changeSelection",this.onSelectionChange);this.ace.off("beforeEndOperation",this.onBeforeEndOperation);this.removeOverlay()};this.virtualSelectionMode=function(){return this.ace.inVirtualSelectionMode&&this.ace.selection.index};this.onChange=function(e){var t={text:e.action[0]=="i"?e.lines:[]};var r=this.curOp=this.curOp||{};if(!r.changeHandlers)r.changeHandlers=this._eventRegistry["change"]&&this._eventRegistry["change"].slice();if(!r.lastChange){r.lastChange=r.change=t}else{r.lastChange.next=r.lastChange=t}this.$updateMarkers(e)};this.onSelectionChange=function(){var e=this.curOp=this.curOp||{};if(!e.cursorActivityHandlers)e.cursorActivityHandlers=this._eventRegistry["cursorActivity"]&&this._eventRegistry["cursorActivity"].slice();this.curOp.cursorActivity=true;if(this.ace.inMultiSelectMode){this.ace.keyBinding.removeKeyboardHandler(p.keyboardHandler)}};this.operation=function(e,t){if(!t&&this.curOp||t&&this.curOp&&this.curOp.force){return e()}if(t||!this.ace.curOp){if(this.curOp)this.onBeforeEndOperation()}if(!this.ace.curOp){var r=this.ace.prevOp;this.ace.startOperation({command:{name:"vim",scrollIntoView:"cursor"}})}var n=this.curOp=this.curOp||{};this.curOp.force=t;var i=e();if(this.ace.curOp&&this.ace.curOp.command.name=="vim"){if(this.state.dialog)this.ace.curOp.command.scrollIntoView=false;this.ace.endOperation();if(!n.cursorActivity&&!n.lastChange&&r)this.ace.prevOp=r}if(t||!this.ace.curOp){if(this.curOp)this.onBeforeEndOperation()}return i};this.onBeforeEndOperation=function(){var e=this.curOp;if(e){if(e.change){this.signal("change",e.change,e)}if(e&&e.cursorActivity){this.signal("cursorActivity",null,e)}this.curOp=null}};this.signal=function(e,t,r){var n=r?r[e+"Handlers"]:(this._eventRegistry||{})[e];if(!n)return;n=n.slice();for(var i=0;i<n.length;i++){n[i](this,t)}};this.firstLine=function(){return 0};this.lastLine=function(){return this.ace.session.getLength()-1};this.lineCount=function(){return this.ace.session.getLength()};this.setCursor=function(e,t){if(typeof e==="object"){t=e.ch;e=e.line}if(!this.ace.inVirtualSelectionMode)this.ace.exitMultiSelectMode();this.ace.session.unfold({row:e,column:t});this.ace.selection.moveTo(e,t)};this.getCursor=function(e){var t=this.ace.selection;var r=e=="anchor"?t.isEmpty()?t.lead:t.anchor:e=="head"||!e?t.lead:t.getRange()[e];return g(r)};this.listSelections=function(e){var t=this.ace.multiSelect.rangeList.ranges;if(!t.length||this.ace.inVirtualSelectionMode)return[{anchor:this.getCursor("anchor"),head:this.getCursor("head")}];return t.map((function(e){return{anchor:this.clipPos(g(e.cursor==e.end?e.start:e.end)),head:this.clipPos(g(e.cursor))}}),this)};this.setSelections=function(e,t){var r=this.ace.multiSelect;var n=e.map((function(e){var t=m(e.anchor);var r=m(e.head);var n=i.comparePoints(t,r)<0?new i.fromPoints(t,r):new i.fromPoints(r,t);n.cursor=i.comparePoints(n.start,r)?n.end:n.start;return n}));if(this.ace.inVirtualSelectionMode){this.ace.selection.fromOrientedRange(n[0]);return}if(!t){n=n.reverse()}else if(n[t]){n.push(n.splice(t,1)[0])}r.toSingleRange(n[0].clone());var a=this.ace.session;for(var o=0;o<n.length;o++){var s=a.$clipRangeToDocument(n[o]);r.addRange(s)}};this.setSelection=function(e,t,r){var n=this.ace.selection;n.moveTo(e.line,e.ch);n.selectTo(t.line,t.ch);if(r&&r.origin=="*mouse"){this.onBeforeEndOperation()}};this.somethingSelected=function(e){return!this.ace.selection.isEmpty()};this.clipPos=function(e){var t=this.ace.session.$clipPositionToDocument(e.line,e.ch);return g(t)};this.markText=function(e){return{clear:function e(){},find:function e(){}}};this.$updateMarkers=function(e){var t=e.action=="insert";var r=e.start;var n=e.end;var a=(n.row-r.row)*(t?1:-1);var o=(n.column-r.column)*(t?1:-1);if(t)n=r;for(var s in this.marks){var l=this.marks[s];var c=i.comparePoints(l,r);if(c<0){continue}if(c===0){if(t){if(l.bias==1){c=1}else{l.bias=-1;continue}}}var u=t?c:i.comparePoints(l,n);if(u>0){l.row+=a;l.column+=l.row==n.row?o:0;continue}if(!t&&u<=0){l.row=r.row;l.column=r.column;if(u===0)l.bias=1}}};var e=function e(t,r,n,i){this.cm=t;this.id=r;this.row=n;this.column=i;t.marks[this.id]=this};e.prototype.clear=function(){delete this.cm.marks[this.id]};e.prototype.find=function(){return g(this)};this.setBookmark=function(t,r){var n=new e(this,this.$uid++,t.line,t.ch);if(!r||!r.insertLeft)n.$insertRight=true;this.marks[n.id]=n;return n};this.moveH=function(e,t){if(t=="char"){var r=this.ace.selection;r.clearSelection();r.moveCursorBy(0,e)}};this.findPosV=function(e,t,r,n){if(r=="page"){var i=this.ace.renderer;var a=i.layerConfig;t=t*Math.floor(a.height/a.lineHeight);r="line"}if(r=="line"){var o=this.ace.session.documentToScreenPosition(e.line,e.ch);if(n!=null)o.column=n;o.row+=t;o.row=Math.min(Math.max(0,o.row),this.ace.session.getScreenLength()-1);var s=this.ace.session.screenToDocumentPosition(o.row,o.column);return g(s)}else{debugger}};this.charCoords=function(e,t){if(t=="div"||!t){var r=this.ace.session.documentToScreenPosition(e.line,e.ch);return{left:r.column,top:r.row}}if(t=="local"){var n=this.ace.renderer;var r=this.ace.session.documentToScreenPosition(e.line,e.ch);var i=n.layerConfig.lineHeight;var a=n.layerConfig.characterWidth;var o=i*r.row;return{left:r.column*a,top:o,bottom:o+i}}};this.coordsChar=function(e,t){var r=this.ace.renderer;if(t=="local"){var n=Math.max(0,Math.floor(e.top/r.lineHeight));var i=Math.max(0,Math.floor(e.left/r.characterWidth));var a=r.session.screenToDocumentPosition(n,i);return g(a)}else if(t=="div"){throw"not implemented"}};this.getSearchCursor=function(e,t,r){var n=false;var i=false;if(e instanceof RegExp&&!e.global){n=!e.ignoreCase;e=e.source;i=true}var a=new u;if(t.ch==undefined)t.ch=Number.MAX_VALUE;var o={row:t.line,column:t.ch};var s=this;var l=null;return{findNext:function e(){return this.find(false)},findPrevious:function e(){return this.find(true)},find:function t(r){a.setOptions({needle:e,caseSensitive:n,wrap:false,backwards:r,regExp:i,start:l||o});var c=a.find(s.ace.session);if(c&&c.isEmpty()){if(s.getLine(c.start.row).length==c.start.column){a.$options.start=c;c=a.find(s.ace.session)}}l=c;return l},from:function e(){return l&&g(l.start)},to:function e(){return l&&g(l.end)},replace:function e(t){if(l){l.end=s.ace.session.doc.replace(l,t)}}}};this.scrollTo=function(e,t){var r=this.ace.renderer;var n=r.layerConfig;var i=n.maxHeight;i-=(r.$size.scrollerHeight-r.lineHeight)*r.$scrollPastEnd;if(t!=null)this.ace.session.setScrollTop(Math.max(0,Math.min(t,i)));if(e!=null)this.ace.session.setScrollLeft(Math.max(0,Math.min(e,n.width)))};this.scrollInfo=function(){return 0};this.scrollIntoView=function(e,t){if(e){var r=this.ace.renderer;var n={top:0,bottom:t};r.scrollCursorIntoView(m(e),r.lineHeight*2/r.$size.scrollerHeight,n)}};this.getLine=function(e){return this.ace.session.getLine(e)};this.getRange=function(e,t){return this.ace.session.getTextRange(new i(e.line,e.ch,t.line,t.ch))};this.replaceRange=function(e,t,r){if(!r)r=t;return this.ace.session.replace(new i(t.line,t.ch,r.line,r.ch),e)};this.replaceSelection=this.replaceSelections=function(e){var t=this.ace.selection;if(this.ace.inVirtualSelectionMode){this.ace.session.replace(t.getRange(),e[0]||"");return}t.inVirtualSelectionMode=true;var r=t.rangeList.ranges;if(!r.length)r=[this.ace.multiSelect.getRange()];for(var n=r.length;n--;){this.ace.session.replace(r[n],e[n]||"")}t.inVirtualSelectionMode=false};this.getSelection=function(){return this.ace.getSelectedText()};this.getSelections=function(){return this.listSelections().map((function(e){return this.getRange(e.anchor,e.head)}),this)};this.getInputField=function(){return this.ace.textInput.getElement()};this.getWrapperElement=function(){return this.ace.container};var t={indentWithTabs:"useSoftTabs",indentUnit:"tabSize",tabSize:"tabSize",firstLineNumber:"firstLineNumber",readOnly:"readOnly"};this.setOption=function(e,r){this.state[e]=r;switch(e){case"indentWithTabs":e=t[e];r=!r;break;case"keyMap":this.state.$keyMap=r;return;break;default:e=t[e]}if(e)this.ace.setOption(e,r)};this.getOption=function(e,r){var n=t[e];if(n)r=this.ace.getOption(n);switch(e){case"indentWithTabs":e=t[e];return!r;case"keyMap":return this.state.$keyMap}return n?r:this.state[e]};this.toggleOverwrite=function(e){this.state.overwrite=e;return this.ace.setOverwrite(e)};this.addOverlay=function(e){if(!this.$searchHighlight||!this.$searchHighlight.session){var t=new h(null,"ace_highlight-marker","text");var r=this.ace.session.addDynamicMarker(t);t.id=r.id;t.session=this.ace.session;t.destroy=function(e){t.session.off("change",t.updateOnChange);t.session.off("changeEditor",t.destroy);t.session.removeMarker(t.id);t.session=null};t.updateOnChange=function(e){var r=e.start.row;if(r==e.end.row)t.cache[r]=undefined;else t.cache.splice(r,t.cache.length)};t.session.on("changeEditor",t.destroy);t.session.on("change",t.updateOnChange)}var n=new RegExp(e.query.source,"gmi");this.$searchHighlight=e.highlight=t;this.$searchHighlight.setRegexp(n);this.ace.renderer.updateBackMarkers()};this.removeOverlay=function(e){if(this.$searchHighlight&&this.$searchHighlight.session){this.$searchHighlight.destroy()}};this.getScrollInfo=function(){var e=this.ace.renderer;var t=e.layerConfig;return{left:e.scrollLeft,top:e.scrollTop,height:t.maxHeight,width:t.width,clientHeight:t.height,clientWidth:t.width}};this.getValue=function(){return this.ace.getValue()};this.setValue=function(e){return this.ace.setValue(e,-1)};this.getTokenTypeAt=function(e){var t=this.ace.session.getTokenAt(e.line,e.ch);return t&&/comment|string/.test(t.type)?"string":""};this.findMatchingBracket=function(e){var t=this.ace.session.findMatchingBracket(m(e));return{to:t&&g(t)}};this.indentLine=function(e,t){if(t===true)this.ace.session.indentRows(e,e,"\t");else if(t===false)this.ace.session.outdentRows(new i(e,0,e,0))};this.indexFromPos=function(e){return this.ace.session.doc.positionToIndex(m(e))};this.posFromIndex=function(e){return g(this.ace.session.doc.indexToPosition(e))};this.focus=function(e){return this.ace.textInput.focus()};this.blur=function(e){return this.ace.blur()};this.defaultTextHeight=function(e){return this.ace.renderer.layerConfig.lineHeight};this.scanForBracket=function(e,t,r,n){var i=n.bracketRegex.source;var a=/paren|text|operator|tag/;if(t==1){var o=this.ace.session.$findClosingBracket(i.slice(1,2),m(e),a)}else{var o=this.ace.session.$findOpeningBracket(i.slice(-2,-1),{row:e.line,column:e.ch+1},a)}return o&&{pos:g(o)}};this.refresh=function(){return this.ace.resize(true)};this.getMode=function(){return{name:this.getOption("mode")}};this.execCommand=function(e){if(e=="indentAuto")this.ace.execCommand("autoindent");else console.log(e+" is not implemented")}}).call(v.prototype);function m(e){return{row:e.line,column:e.ch}}function g(e){return new x(e.row,e.column)}var y=v.StringStream=function(e,t){this.pos=this.start=0;this.string=e;this.tabSize=t||8;this.lastColumnPos=this.lastColumnValue=0;this.lineStart=0};y.prototype={eol:function e(){return this.pos>=this.string.length},sol:function e(){return this.pos==this.lineStart},peek:function e(){return this.string.charAt(this.pos)||undefined},next:function e(){if(this.pos<this.string.length)return this.string.charAt(this.pos++)},eat:function e(t){var r=this.string.charAt(this.pos);if(typeof t=="string")var n=r==t;else var n=r&&(t.test?t.test(r):t(r));if(n){++this.pos;return r}},eatWhile:function e(t){var r=this.pos;while(this.eat(t)){}return this.pos>r},eatSpace:function e(){var t=this.pos;while(/[\s\u00a0]/.test(this.string.charAt(this.pos))){++this.pos}return this.pos>t},skipToEnd:function e(){this.pos=this.string.length},skipTo:function e(t){var r=this.string.indexOf(t,this.pos);if(r>-1){this.pos=r;return true}},backUp:function e(t){this.pos-=t},column:function e(){throw"not implemented"},indentation:function e(){throw"not implemented"},match:function e(t,r,n){if(typeof t=="string"){var i=function e(t){return n?t.toLowerCase():t};var a=this.string.substr(this.pos,t.length);if(i(a)==i(t)){if(r!==false)this.pos+=t.length;return true}}else{var e=this.string.slice(this.pos).match(t);if(e&&e.index>0)return null;if(e&&r!==false)this.pos+=e[0].length;return e}},current:function e(){return this.string.slice(this.start,this.pos)},hideFirstChars:function e(t,r){this.lineStart+=t;try{return r()}finally{this.lineStart-=t}}};v.defineExtension=function(e,t){v.prototype[e]=t};o.importCssString(".normal-mode .ace_cursor{    border: none;    background-color: rgba(255,0,0,0.5);}.normal-mode .ace_hidden-cursors .ace_cursor{  background-color: transparent;  border: 1px solid red;  opacity: 0.7}.ace_dialog {  position: absolute;  left: 0; right: 0;  background: inherit;  z-index: 15;  padding: .1em .8em;  overflow: hidden;  color: inherit;}.ace_dialog-top {  border-bottom: 1px solid #444;  top: 0;}.ace_dialog-bottom {  border-top: 1px solid #444;  bottom: 0;}.ace_dialog input {  border: none;  outline: none;  background: transparent;  width: 20em;  color: inherit;  font-family: monospace;}","vimMode");(function(){function e(e,t,r){var n=e.ace.container;var i;i=n.appendChild(document.createElement("div"));if(r)i.className="ace_dialog ace_dialog-bottom";else i.className="ace_dialog ace_dialog-top";if(typeof t=="string"){i.innerHTML=t}else{i.appendChild(t)}return i}function t(e,t){if(e.state.currentNotificationClose)e.state.currentNotificationClose();e.state.currentNotificationClose=t}v.defineExtension("openDialog",(function(r,n,i){if(this.virtualSelectionMode())return;if(!i)i={};t(this,null);var a=e(this,r,i.bottom);var o=false,s=this;this.state.dialog=a;function l(e){if(typeof e=="string"){c.value=e}else{if(o)return;if(e&&e.type=="blur"){if(document.activeElement===c)return}s.state.dialog=null;o=true;a.parentNode.removeChild(a);s.focus();if(i.onClose)i.onClose(a)}}var c=a.getElementsByTagName("input")[0],u;if(c){if(i.value){c.value=i.value;if(i.selectValueOnOpen!==false)c.select()}if(i.onInput)v.on(c,"input",(function(e){i.onInput(e,c.value,l)}));if(i.onKeyUp)v.on(c,"keyup",(function(e){i.onKeyUp(e,c.value,l)}));v.on(c,"keydown",(function(e){if(i&&i.onKeyDown&&i.onKeyDown(e,c.value,l)){return}if(e.keyCode==13)n(c.value);if(e.keyCode==27||i.closeOnEnter!==false&&e.keyCode==13){c.blur();v.e_stop(e);l()}}));if(i.closeOnBlur!==false)v.on(c,"blur",l);c.focus()}else if(u=a.getElementsByTagName("button")[0]){v.on(u,"click",(function(){l();s.focus()}));if(i.closeOnBlur!==false)v.on(u,"blur",l);u.focus()}return l}));v.defineExtension("openNotification",(function(r,n){if(this.virtualSelectionMode())return;t(this,l);var i=e(this,r,n&&n.bottom);var a=false,o;var s=n&&typeof n.duration!=="undefined"?n.duration:5e3;function l(){if(a)return;a=true;clearTimeout(o);i.parentNode.removeChild(i)}v.on(i,"click",(function(e){v.e_preventDefault(e);l()}));if(s)o=setTimeout(l,s);return l}))})();var k=[{keys:"<Left>",type:"keyToKey",toKeys:"h"},{keys:"<Right>",type:"keyToKey",toKeys:"l"},{keys:"<Up>",type:"keyToKey",toKeys:"k"},{keys:"<Down>",type:"keyToKey",toKeys:"j"},{keys:"<Space>",type:"keyToKey",toKeys:"l"},{keys:"<BS>",type:"keyToKey",toKeys:"h",context:"normal"},{keys:"<Del>",type:"keyToKey",toKeys:"x",context:"normal"},{keys:"<C-Space>",type:"keyToKey",toKeys:"W"},{keys:"<C-BS>",type:"keyToKey",toKeys:"B",context:"normal"},{keys:"<S-Space>",type:"keyToKey",toKeys:"w"},{keys:"<S-BS>",type:"keyToKey",toKeys:"b",context:"normal"},{keys:"<C-n>",type:"keyToKey",toKeys:"j"},{keys:"<C-p>",type:"keyToKey",toKeys:"k"},{keys:"<C-[>",type:"keyToKey",toKeys:"<Esc>"},{keys:"<C-c>",type:"keyToKey",toKeys:"<Esc>"},{keys:"<C-[>",type:"keyToKey",toKeys:"<Esc>",context:"insert"},{keys:"<C-c>",type:"keyToKey",toKeys:"<Esc>",context:"insert"},{keys:"<C-Esc>",type:"keyToKey",toKeys:"<Esc>"},{keys:"<C-Esc>",type:"keyToKey",toKeys:"<Esc>",context:"insert"},{keys:"s",type:"keyToKey",toKeys:"cl",context:"normal"},{keys:"s",type:"keyToKey",toKeys:"c",context:"visual"},{keys:"S",type:"keyToKey",toKeys:"cc",context:"normal"},{keys:"S",type:"keyToKey",toKeys:"VdO",context:"visual"},{keys:"<Home>",type:"keyToKey",toKeys:"0"},{keys:"<End>",type:"keyToKey",toKeys:"$"},{keys:"<PageUp>",type:"keyToKey",toKeys:"<C-b>"},{keys:"<PageDown>",type:"keyToKey",toKeys:"<C-f>"},{keys:"<CR>",type:"keyToKey",toKeys:"j^",context:"normal"},{keys:"<Ins>",type:"action",action:"toggleOverwrite",context:"insert"},{keys:"H",type:"motion",motion:"moveToTopLine",motionArgs:{linewise:true,toJumplist:true}},{keys:"M",type:"motion",motion:"moveToMiddleLine",motionArgs:{linewise:true,toJumplist:true}},{keys:"L",type:"motion",motion:"moveToBottomLine",motionArgs:{linewise:true,toJumplist:true}},{keys:"h",type:"motion",motion:"moveByCharacters",motionArgs:{forward:false}},{keys:"l",type:"motion",motion:"moveByCharacters",motionArgs:{forward:true}},{keys:"j",type:"motion",motion:"moveByLines",motionArgs:{forward:true,linewise:true}},{keys:"k",type:"motion",motion:"moveByLines",motionArgs:{forward:false,linewise:true}},{keys:"gj",type:"motion",motion:"moveByDisplayLines",motionArgs:{forward:true}},{keys:"gk",type:"motion",motion:"moveByDisplayLines",motionArgs:{forward:false}},{keys:"w",type:"motion",motion:"moveByWords",motionArgs:{forward:true,wordEnd:false}},{keys:"W",type:"motion",motion:"moveByWords",motionArgs:{forward:true,wordEnd:false,bigWord:true}},{keys:"e",type:"motion",motion:"moveByWords",motionArgs:{forward:true,wordEnd:true,inclusive:true}},{keys:"E",type:"motion",motion:"moveByWords",motionArgs:{forward:true,wordEnd:true,bigWord:true,inclusive:true}},{keys:"b",type:"motion",motion:"moveByWords",motionArgs:{forward:false,wordEnd:false}},{keys:"B",type:"motion",motion:"moveByWords",motionArgs:{forward:false,wordEnd:false,bigWord:true}},{keys:"ge",type:"motion",motion:"moveByWords",motionArgs:{forward:false,wordEnd:true,inclusive:true}},{keys:"gE",type:"motion",motion:"moveByWords",motionArgs:{forward:false,wordEnd:true,bigWord:true,inclusive:true}},{keys:"{",type:"motion",motion:"moveByParagraph",motionArgs:{forward:false,toJumplist:true}},{keys:"}",type:"motion",motion:"moveByParagraph",motionArgs:{forward:true,toJumplist:true}},{keys:"(",type:"motion",motion:"moveBySentence",motionArgs:{forward:false}},{keys:")",type:"motion",motion:"moveBySentence",motionArgs:{forward:true}},{keys:"<C-f>",type:"motion",motion:"moveByPage",motionArgs:{forward:true}},{keys:"<C-b>",type:"motion",motion:"moveByPage",motionArgs:{forward:false}},{keys:"<C-d>",type:"motion",motion:"moveByScroll",motionArgs:{forward:true,explicitRepeat:true}},{keys:"<C-u>",type:"motion",motion:"moveByScroll",motionArgs:{forward:false,explicitRepeat:true}},{keys:"gg",type:"motion",motion:"moveToLineOrEdgeOfDocument",motionArgs:{forward:false,explicitRepeat:true,linewise:true,toJumplist:true}},{keys:"G",type:"motion",motion:"moveToLineOrEdgeOfDocument",motionArgs:{forward:true,explicitRepeat:true,linewise:true,toJumplist:true}},{keys:"0",type:"motion",motion:"moveToStartOfLine"},{keys:"^",type:"motion",motion:"moveToFirstNonWhiteSpaceCharacter"},{keys:"+",type:"motion",motion:"moveByLines",motionArgs:{forward:true,toFirstChar:true}},{keys:"-",type:"motion",motion:"moveByLines",motionArgs:{forward:false,toFirstChar:true}},{keys:"_",type:"motion",motion:"moveByLines",motionArgs:{forward:true,toFirstChar:true,repeatOffset:-1}},{keys:"$",type:"motion",motion:"moveToEol",motionArgs:{inclusive:true}},{keys:"%",type:"motion",motion:"moveToMatchedSymbol",motionArgs:{inclusive:true,toJumplist:true}},{keys:"f<character>",type:"motion",motion:"moveToCharacter",motionArgs:{forward:true,inclusive:true}},{keys:"F<character>",type:"motion",motion:"moveToCharacter",motionArgs:{forward:false}},{keys:"t<character>",type:"motion",motion:"moveTillCharacter",motionArgs:{forward:true,inclusive:true}},{keys:"T<character>",type:"motion",motion:"moveTillCharacter",motionArgs:{forward:false}},{keys:";",type:"motion",motion:"repeatLastCharacterSearch",motionArgs:{forward:true}},{keys:",",type:"motion",motion:"repeatLastCharacterSearch",motionArgs:{forward:false}},{keys:"'<character>",type:"motion",motion:"goToMark",motionArgs:{toJumplist:true,linewise:true}},{keys:"`<character>",type:"motion",motion:"goToMark",motionArgs:{toJumplist:true}},{keys:"]`",type:"motion",motion:"jumpToMark",motionArgs:{forward:true}},{keys:"[`",type:"motion",motion:"jumpToMark",motionArgs:{forward:false}},{keys:"]'",type:"motion",motion:"jumpToMark",motionArgs:{forward:true,linewise:true}},{keys:"['",type:"motion",motion:"jumpToMark",motionArgs:{forward:false,linewise:true}},{keys:"]p",type:"action",action:"paste",isEdit:true,actionArgs:{after:true,isEdit:true,matchIndent:true}},{keys:"[p",type:"action",action:"paste",isEdit:true,actionArgs:{after:false,isEdit:true,matchIndent:true}},{keys:"]<character>",type:"motion",motion:"moveToSymbol",motionArgs:{forward:true,toJumplist:true}},{keys:"[<character>",type:"motion",motion:"moveToSymbol",motionArgs:{forward:false,toJumplist:true}},{keys:"|",type:"motion",motion:"moveToColumn"},{keys:"o",type:"motion",motion:"moveToOtherHighlightedEnd",context:"visual"},{keys:"O",type:"motion",motion:"moveToOtherHighlightedEnd",motionArgs:{sameLine:true},context:"visual"},{keys:"d",type:"operator",operator:"delete"},{keys:"y",type:"operator",operator:"yank"},{keys:"c",type:"operator",operator:"change"},{keys:"=",type:"operator",operator:"indentAuto"},{keys:">",type:"operator",operator:"indent",operatorArgs:{indentRight:true}},{keys:"<",type:"operator",operator:"indent",operatorArgs:{indentRight:false}},{keys:"g~",type:"operator",operator:"changeCase"},{keys:"gu",type:"operator",operator:"changeCase",operatorArgs:{toLower:true},isEdit:true},{keys:"gU",type:"operator",operator:"changeCase",operatorArgs:{toLower:false},isEdit:true},{keys:"n",type:"motion",motion:"findNext",motionArgs:{forward:true,toJumplist:true}},{keys:"N",type:"motion",motion:"findNext",motionArgs:{forward:false,toJumplist:true}},{keys:"x",type:"operatorMotion",operator:"delete",motion:"moveByCharacters",motionArgs:{forward:true},operatorMotionArgs:{visualLine:false}},{keys:"X",type:"operatorMotion",operator:"delete",motion:"moveByCharacters",motionArgs:{forward:false},operatorMotionArgs:{visualLine:true}},{keys:"D",type:"operatorMotion",operator:"delete",motion:"moveToEol",motionArgs:{inclusive:true},context:"normal"},{keys:"D",type:"operator",operator:"delete",operatorArgs:{linewise:true},context:"visual"},{keys:"Y",type:"operatorMotion",operator:"yank",motion:"expandToLine",motionArgs:{linewise:true},context:"normal"},{keys:"Y",type:"operator",operator:"yank",operatorArgs:{linewise:true},context:"visual"},{keys:"C",type:"operatorMotion",operator:"change",motion:"moveToEol",motionArgs:{inclusive:true},context:"normal"},{keys:"C",type:"operator",operator:"change",operatorArgs:{linewise:true},context:"visual"},{keys:"~",type:"operatorMotion",operator:"changeCase",motion:"moveByCharacters",motionArgs:{forward:true},operatorArgs:{shouldMoveCursor:true},context:"normal"},{keys:"~",type:"operator",operator:"changeCase",context:"visual"},{keys:"<C-w>",type:"operatorMotion",operator:"delete",motion:"moveByWords",motionArgs:{forward:false,wordEnd:false},context:"insert"},{keys:"<C-w>",type:"idle",context:"normal"},{keys:"<C-i>",type:"action",action:"jumpListWalk",actionArgs:{forward:true}},{keys:"<C-o>",type:"action",action:"jumpListWalk",actionArgs:{forward:false}},{keys:"<C-e>",type:"action",action:"scroll",actionArgs:{forward:true,linewise:true}},{keys:"<C-y>",type:"action",action:"scroll",actionArgs:{forward:false,linewise:true}},{keys:"a",type:"action",action:"enterInsertMode",isEdit:true,actionArgs:{insertAt:"charAfter"},context:"normal"},{keys:"A",type:"action",action:"enterInsertMode",isEdit:true,actionArgs:{insertAt:"eol"},context:"normal"},{keys:"A",type:"action",action:"enterInsertMode",isEdit:true,actionArgs:{insertAt:"endOfSelectedArea"},context:"visual"},{keys:"i",type:"action",action:"enterInsertMode",isEdit:true,actionArgs:{insertAt:"inplace"},context:"normal"},{keys:"gi",type:"action",action:"enterInsertMode",isEdit:true,actionArgs:{insertAt:"lastEdit"},context:"normal"},{keys:"I",type:"action",action:"enterInsertMode",isEdit:true,actionArgs:{insertAt:"firstNonBlank"},context:"normal"},{keys:"gI",type:"action",action:"enterInsertMode",isEdit:true,actionArgs:{insertAt:"bol"},context:"normal"},{keys:"I",type:"action",action:"enterInsertMode",isEdit:true,actionArgs:{insertAt:"startOfSelectedArea"},context:"visual"},{keys:"o",type:"action",action:"newLineAndEnterInsertMode",isEdit:true,interlaceInsertRepeat:true,actionArgs:{after:true},context:"normal"},{keys:"O",type:"action",action:"newLineAndEnterInsertMode",isEdit:true,interlaceInsertRepeat:true,actionArgs:{after:false},context:"normal"},{keys:"v",type:"action",action:"toggleVisualMode"},{keys:"V",type:"action",action:"toggleVisualMode",actionArgs:{linewise:true}},{keys:"<C-v>",type:"action",action:"toggleVisualMode",actionArgs:{blockwise:true}},{keys:"<C-q>",type:"action",action:"toggleVisualMode",actionArgs:{blockwise:true}},{keys:"gv",type:"action",action:"reselectLastSelection"},{keys:"J",type:"action",action:"joinLines",isEdit:true},{keys:"gJ",type:"action",action:"joinLines",actionArgs:{keepSpaces:true},isEdit:true},{keys:"p",type:"action",action:"paste",isEdit:true,actionArgs:{after:true,isEdit:true}},{keys:"P",type:"action",action:"paste",isEdit:true,actionArgs:{after:false,isEdit:true}},{keys:"r<character>",type:"action",action:"replace",isEdit:true},{keys:"@<character>",type:"action",action:"replayMacro"},{keys:"q<character>",type:"action",action:"enterMacroRecordMode"},{keys:"R",type:"action",action:"enterInsertMode",isEdit:true,actionArgs:{replace:true},context:"normal"},{keys:"R",type:"operator",operator:"change",operatorArgs:{linewise:true,fullLine:true},context:"visual",exitVisualBlock:true},{keys:"u",type:"action",action:"undo",context:"normal"},{keys:"u",type:"operator",operator:"changeCase",operatorArgs:{toLower:true},context:"visual",isEdit:true},{keys:"U",type:"operator",operator:"changeCase",operatorArgs:{toLower:false},context:"visual",isEdit:true},{keys:"<C-r>",type:"action",action:"redo"},{keys:"m<character>",type:"action",action:"setMark"},{keys:'"<character>',type:"action",action:"setRegister"},{keys:"zz",type:"action",action:"scrollToCursor",actionArgs:{position:"center"}},{keys:"z.",type:"action",action:"scrollToCursor",actionArgs:{position:"center"},motion:"moveToFirstNonWhiteSpaceCharacter"},{keys:"zt",type:"action",action:"scrollToCursor",actionArgs:{position:"top"}},{keys:"z<CR>",type:"action",action:"scrollToCursor",actionArgs:{position:"top"},motion:"moveToFirstNonWhiteSpaceCharacter"},{keys:"z-",type:"action",action:"scrollToCursor",actionArgs:{position:"bottom"}},{keys:"zb",type:"action",action:"scrollToCursor",actionArgs:{position:"bottom"},motion:"moveToFirstNonWhiteSpaceCharacter"},{keys:".",type:"action",action:"repeatLastEdit"},{keys:"<C-a>",type:"action",action:"incrementNumberToken",isEdit:true,actionArgs:{increase:true,backtrack:false}},{keys:"<C-x>",type:"action",action:"incrementNumberToken",isEdit:true,actionArgs:{increase:false,backtrack:false}},{keys:"<C-t>",type:"action",action:"indent",actionArgs:{indentRight:true},context:"insert"},{keys:"<C-d>",type:"action",action:"indent",actionArgs:{indentRight:false},context:"insert"},{keys:"a<character>",type:"motion",motion:"textObjectManipulation"},{keys:"i<character>",type:"motion",motion:"textObjectManipulation",motionArgs:{textObjectInner:true}},{keys:"/",type:"search",searchArgs:{forward:true,querySrc:"prompt",toJumplist:true}},{keys:"?",type:"search",searchArgs:{forward:false,querySrc:"prompt",toJumplist:true}},{keys:"*",type:"search",searchArgs:{forward:true,querySrc:"wordUnderCursor",wholeWordOnly:true,toJumplist:true}},{keys:"#",type:"search",searchArgs:{forward:false,querySrc:"wordUnderCursor",wholeWordOnly:true,toJumplist:true}},{keys:"g*",type:"search",searchArgs:{forward:true,querySrc:"wordUnderCursor",toJumplist:true}},{keys:"g#",type:"search",searchArgs:{forward:false,querySrc:"wordUnderCursor",toJumplist:true}},{keys:":",type:"ex"}];var C=k.length;var w=[{name:"colorscheme",shortName:"colo"},{name:"map"},{name:"imap",shortName:"im"},{name:"nmap",shortName:"nm"},{name:"vmap",shortName:"vm"},{name:"unmap"},{name:"write",shortName:"w"},{name:"undo",shortName:"u"},{name:"redo",shortName:"red"},{name:"set",shortName:"se"},{name:"set",shortName:"se"},{name:"setlocal",shortName:"setl"},{name:"setglobal",shortName:"setg"},{name:"sort",shortName:"sor"},{name:"substitute",shortName:"s",possiblyAsync:true},{name:"nohlsearch",shortName:"noh"},{name:"yank",shortName:"y"},{name:"delmarks",shortName:"delm"},{name:"registers",shortName:"reg",excludeFromCommandHistory:true},{name:"global",shortName:"g"}];var x=v.Pos;var M=function e(){return se};function S(e){e.setOption("disableInput",true);e.setOption("showCursorWhenSelecting",false);v.signal(e,"vim-mode-change",{mode:"normal"});e.on("cursorActivity",Yt);ne(e);v.on(e.getInputField(),"paste",B(e))}function A(e){e.setOption("disableInput",false);e.off("cursorActivity",Yt);v.off(e.getInputField(),"paste",B(e));e.state.vim=null}function b(e,t){if(this==v.keyMap.vim)v.rmClass(e.getWrapperElement(),"cm-fat-cursor");if(!t||t.attach!=L)A(e)}function L(e,t){if(this==v.keyMap.vim)v.addClass(e.getWrapperElement(),"cm-fat-cursor");if(!t||t.attach!=L)S(e)}v.defineOption("vimMode",false,(function(e,t,r){if(t&&e.getOption("keyMap")!="vim")e.setOption("keyMap","vim");else if(!t&&r!=v.Init&&/^vim/.test(e.getOption("keyMap")))e.setOption("keyMap","default")}));function O(e,t){if(!t){return undefined}if(this[e]){return this[e]}var r=R(e);if(!r){return false}var n=v.Vim.findKey(t,r);if(typeof n=="function"){v.signal(t,"vim-keypress",r)}return n}var T={Shift:"S",Ctrl:"C",Alt:"A",Cmd:"D",Mod:"A"};var E={Enter:"CR",Backspace:"BS",Delete:"Del",Insert:"Ins"};function R(e){if(e.charAt(0)=="'"){return e.charAt(1)}var t=e.split(/-(?!$)/);var r=t[t.length-1];if(t.length==1&&t[0].length==1){return false}else if(t.length==2&&t[0]=="Shift"&&r.length==1){return false}var n=false;for(var i=0;i<t.length;i++){var a=t[i];if(a in T){t[i]=T[a]}else{n=true}if(a in E){t[i]=E[a]}}if(!n){return false}if(z(r)){t[t.length-1]=r.toLowerCase()}return"<"+t.join("-")+">"}function B(e){var t=e.state.vim;if(!t.onPasteFn){t.onPasteFn=function(){if(!t.insertMode){e.setCursor(Se(e.getCursor(),0,1));Ce.enterInsertMode(e,{},t)}}}return t.onPasteFn}var I=/[\d]/;var K=[v.isWordChar,function(e){return e&&!v.isWordChar(e)&&!/\s/.test(e)}],N=[function(e){return/\S/.test(e)}];function P(e,t){var r=[];for(var n=e;n<e+t;n++){r.push(String.fromCharCode(n))}return r}var _=P(65,26);var H=P(97,26);var V=P(48,10);var $=[].concat(_,H,V,["<",">"]);var j=[].concat(_,H,V,["-",'"',".",":","/"]);function D(e,t){return t>=e.firstLine()&&t<=e.lastLine()}function W(e){return/^[a-z]$/.test(e)}function F(e){return"()[]{}".indexOf(e)!=-1}function U(e){return I.test(e)}function z(e){return/^[A-Z]$/.test(e)}function J(e){return/^\s*$/.test(e)}function q(e){return".?!".indexOf(e)!=-1}function Q(e,t){for(var r=0;r<t.length;r++){if(t[r]==e){return true}}return false}var G={};function X(e,t,r,n,i){if(t===undefined&&!i){throw Error("defaultValue is required unless callback is provided")}if(!r){r="string"}G[e]={type:r,defaultValue:t,callback:i};if(n){for(var a=0;a<n.length;a++){G[n[a]]=G[e]}}if(t){Z(e,t)}}function Z(e,t,r,n){var i=G[e];n=n||{};var a=n.scope;if(!i){return new Error("Unknown option: "+e)}if(i.type=="boolean"){if(t&&t!==true){return new Error("Invalid argument: "+e+"="+t)}else if(t!==false){t=true}}if(i.callback){if(a!=="local"){i.callback(t,undefined)}if(a!=="global"&&r){i.callback(t,r)}}else{if(a!=="local"){i.value=i.type=="boolean"?!!t:t}if(a!=="global"&&r){r.state.vim.options[e]={value:t}}}}function Y(e,t,r){var n=G[e];r=r||{};var i=r.scope;if(!n){return new Error("Unknown option: "+e)}if(n.callback){var a=t&&n.callback(undefined,t);if(i!=="global"&&a!==undefined){return a}if(i!=="local"){return n.callback()}return}else{var a=i!=="global"&&t&&t.state.vim.options[e];return(a||i!=="local"&&n||{}).value}}X("filetype",undefined,"string",["ft"],(function(e,t){if(t===undefined){return}if(e===undefined){var r=t.getOption("mode");return r=="null"?"":r}else{var r=e==""?"null":e;t.setOption("mode",r)}}));var ee=function e(){var t=100;var r=-1;var n=0;var i=0;var a=new Array(t);function o(e,o,s){var l=r%t;var c=a[l];function u(n){var i=++r%t;var o=a[i];if(o){o.clear()}a[i]=e.setBookmark(n)}if(c){var f=c.find();if(f&&!Ee(f,o)){u(o)}}else{u(o)}u(s);n=r;i=r-t+1;if(i<0){i=0}}function s(e,o){r+=o;if(r>n){r=n}else if(r<i){r=i}var s=a[(t+r)%t];if(s&&!s.find()){var l=o>0?1:-1;var c;var u=e.getCursor();do{r+=l;s=a[(t+r)%t];if(s&&(c=s.find())&&!Ee(u,c)){break}}while(r<n&&r>i)}return s}function l(e,t){var n=r;var i=s(e,t);r=n;return i&&i.find()}return{cachedCursor:undefined,add:o,find:l,move:s}};var te=function e(t){if(t){return{changes:t.changes,expectCursorActivityForChange:t.expectCursorActivityForChange}}return{changes:[],expectCursorActivityForChange:false}};function re(){this.latestRegister=undefined;this.isPlaying=false;this.isRecording=false;this.replaySearchQueries=[];this.onRecordingDone=undefined;this.lastInsertModeChanges=te()}re.prototype={exitMacroRecordMode:function e(){var t=ie.macroModeState;if(t.onRecordingDone){t.onRecordingDone()}t.onRecordingDone=undefined;t.isRecording=false},enterMacroRecordMode:function e(t,r){var n=ie.registerController.getRegister(r);if(n){n.clear();this.latestRegister=r;if(t.openDialog){this.onRecordingDone=t.openDialog("(recording)["+r+"]",null,{bottom:true})}this.isRecording=true}}};function ne(e){if(!e.state.vim){e.state.vim={inputState:new le,lastEditInputState:undefined,lastEditActionCommand:undefined,lastHPos:-1,lastHSPos:-1,lastMotion:null,marks:{},fakeCursor:null,insertMode:false,insertModeRepeat:undefined,visualMode:false,visualLine:false,visualBlock:false,lastSelection:null,lastPastedText:null,sel:{},options:{}}}return e.state.vim}var ie;function ae(){ie={searchQuery:null,searchIsReversed:false,lastSubstituteReplacePart:undefined,jumpList:ee(),macroModeState:new re,lastCharacterSearch:{increment:0,forward:true,selectedCharacter:""},registerController:new he({}),searchHistoryController:new pe,exCommandHistoryController:new pe};for(var e in G){var t=G[e];t.value=t.defaultValue}}var oe;var se={buildKeyMap:function e(){},getRegisterController:function e(){return ie.registerController},resetVimGlobalState_:ae,getVimGlobalState_:function e(){return ie},maybeInitVimState_:ne,suppressErrorLogging:false,InsertModeKey:rr,map:function e(t,r,n){Wt.map(t,r,n)},unmap:function e(t,r){Wt.unmap(t,r)},noremap:function e(t,r,n){function i(e){return e?[e]:["normal","insert","visual"]}var a=i(n);var o=k.length,s=C;for(var l=o-s;l<o&&a.length;l++){var c=k[l];if(c.keys==r&&(!n||!c.context||c.context===n)&&c.type.substr(0,2)!=="ex"&&c.type.substr(0,3)!=="key"){var u={};for(var f in c){u[f]=c[f]}u.keys=t;if(n&&!u.context){u.context=n}this._mapCommand(u);var h=i(c.context);a=a.filter((function(e){return h.indexOf(e)===-1}))}}},mapclear:function e(t){var r=k.length,n=C;var i=k.slice(0,r-n);k=k.slice(r-n);if(t){for(var a=i.length-1;a>=0;a--){var o=i[a];if(t!==o.context){if(o.context){this._mapCommand(o)}else{var s=["normal","insert","visual"];for(var l in s){if(s[l]!==t){var c={};for(var u in o){c[u]=o[u]}c.context=s[l];this._mapCommand(c)}}}}}}},setOption:Z,getOption:Y,defineOption:X,defineEx:function e(t,r,n){if(!r){r=t}else if(t.indexOf(r)!==0){throw new Error('(Vim.defineEx) "'+r+'" is not a prefix of "'+t+'", command not registered')}Dt[t]=n;Wt.commandMap_[r]={name:t,shortName:r,type:"api"}},handleKey:function e(t,r,n){var i=this.findKey(t,r,n);if(typeof i==="function"){return i()}},findKey:function e(t,r,n){var i=ne(t);function a(){var e=ie.macroModeState;if(e.isRecording){if(r=="q"){e.exitMacroRecordMode();ce(t);return true}if(n!="mapping"){Qt(e,r)}}}function o(){if(r=="<Esc>"){ce(t);if(i.visualMode){qe(t)}else if(i.insertMode){Ut(t)}return true}}function s(e){var n;while(e){n=/<\w+-.+?>|<\w+>|./.exec(e);r=n[0];e=e.substring(n.index+r.length);v.Vim.handleKey(t,r,"mapping")}}function l(){if(o()){return true}var e=i.inputState.keyBuffer=i.inputState.keyBuffer+r;var n=r.length==1;var a=de.matchCommand(e,k,i.inputState,"insert");while(e.length>1&&a.type!="full"){var e=i.inputState.keyBuffer=e.slice(1);var s=de.matchCommand(e,k,i.inputState,"insert");if(s.type!="none"){a=s}}if(a.type=="none"){ce(t);return false}else if(a.type=="partial"){if(oe){window.clearTimeout(oe)}oe=window.setTimeout((function(){if(i.insertMode&&i.inputState.keyBuffer){ce(t)}}),Y("insertModeEscKeysTimeout"));return!n}if(oe){window.clearTimeout(oe)}if(n){var l=t.listSelections();for(var c=0;c<l.length;c++){var u=l[c].head;t.replaceRange("",Se(u,0,-(e.length-1)),u,"+input")}ie.macroModeState.lastInsertModeChanges.changes.pop()}ce(t);return a.command}function c(){if(a()||o()){return true}var e=i.inputState.keyBuffer=i.inputState.keyBuffer+r;if(/^[1-9]\d*$/.test(e)){return true}var n=/^(\d*)(.*)$/.exec(e);if(!n){ce(t);return false}var s=i.visualMode?"visual":"normal";var l=de.matchCommand(n[2]||n[1],k,i.inputState,s);if(l.type=="none"){ce(t);return false}else if(l.type=="partial"){return true}i.inputState.keyBuffer="";var n=/^(\d*)(.*)$/.exec(e);if(n[1]&&n[1]!="0"){i.inputState.pushRepeatDigit(n[1])}return l.command}var u;if(i.insertMode){u=l()}else{u=c()}if(u===false){return undefined}else if(u===true){return function(){return true}}else{return function(){if((u.operator||u.isEdit)&&t.getOption("readOnly"))return;return t.operation((function(){t.curOp.isVimOp=true;try{if(u.type=="keyToKey"){s(u.toKeys)}else{de.processCommand(t,i,u)}}catch(e){t.state.vim=undefined;ne(t);if(!v.Vim.suppressErrorLogging){console["log"](e)}throw e}return true}))}}},handleEx:function e(t,r){Wt.processCommand(t,r)},defineMotion:me,defineAction:we,defineOperator:ke,mapCommand:Jt,_mapCommand:zt,defineRegister:fe,exitVisualMode:qe,exitInsertMode:Ut};function le(){this.prefixRepeat=[];this.motionRepeat=[];this.operator=null;this.operatorArgs=null;this.motion=null;this.motionArgs=null;this.keyBuffer=[];this.registerName=null}le.prototype.pushRepeatDigit=function(e){if(!this.operator){this.prefixRepeat=this.prefixRepeat.concat(e)}else{this.motionRepeat=this.motionRepeat.concat(e)}};le.prototype.getRepeat=function(){var e=0;if(this.prefixRepeat.length>0||this.motionRepeat.length>0){e=1;if(this.prefixRepeat.length>0){e*=parseInt(this.prefixRepeat.join(""),10)}if(this.motionRepeat.length>0){e*=parseInt(this.motionRepeat.join(""),10)}}return e};function ce(e,t){e.state.vim.inputState=new le;v.signal(e,"vim-command-done",t)}function ue(e,t,r){this.clear();this.keyBuffer=[e||""];this.insertModeChanges=[];this.searchQueries=[];this.linewise=!!t;this.blockwise=!!r}ue.prototype={setText:function e(t,r,n){this.keyBuffer=[t||""];this.linewise=!!r;this.blockwise=!!n},pushText:function e(t,r){if(r){if(!this.linewise){this.keyBuffer.push("\n")}this.linewise=true}this.keyBuffer.push(t)},pushInsertModeChanges:function e(t){this.insertModeChanges.push(te(t))},pushSearchQuery:function e(t){this.searchQueries.push(t)},clear:function e(){this.keyBuffer=[];this.insertModeChanges=[];this.searchQueries=[];this.linewise=false},toString:function e(){return this.keyBuffer.join("")}};function fe(e,t){var r=ie.registerController.registers;if(!e||e.length!=1){throw Error("Register name must be 1 character")}r[e]=t;j.push(e)}function he(e){this.registers=e;this.unnamedRegister=e['"']=new ue;e["."]=new ue;e[":"]=new ue;e["/"]=new ue}he.prototype={pushText:function e(t,r,n,i,a){if(i&&n.charAt(n.length-1)!=="\n"){n+="\n"}var o=this.isValidRegister(t)?this.getRegister(t):null;if(!o){switch(r){case"yank":this.registers["0"]=new ue(n,i,a);break;case"delete":case"change":if(n.indexOf("\n")==-1){this.registers["-"]=new ue(n,i)}else{this.shiftNumericRegisters_();this.registers["1"]=new ue(n,i)}break}this.unnamedRegister.setText(n,i,a);return}var s=z(t);if(s){o.pushText(n,i)}else{o.setText(n,i,a)}this.unnamedRegister.setText(o.toString(),i)},getRegister:function e(t){if(!this.isValidRegister(t)){return this.unnamedRegister}t=t.toLowerCase();if(!this.registers[t]){this.registers[t]=new ue}return this.registers[t]},isValidRegister:function e(t){return t&&Q(t,j)},shiftNumericRegisters_:function e(){for(var t=9;t>=2;t--){this.registers[t]=this.getRegister(""+(t-1))}}};function pe(){this.historyBuffer=[];this.iterator=0;this.initialPrefix=null}pe.prototype={nextMatch:function e(t,r){var n=this.historyBuffer;var i=r?-1:1;if(this.initialPrefix===null)this.initialPrefix=t;for(var a=this.iterator+i;r?a>=0:a<n.length;a+=i){var o=n[a];for(var s=0;s<=o.length;s++){if(this.initialPrefix==o.substring(0,s)){this.iterator=a;return o}}}if(a>=n.length){this.iterator=n.length;return this.initialPrefix}if(a<0)return t},pushInput:function e(t){var r=this.historyBuffer.indexOf(t);if(r>-1)this.historyBuffer.splice(r,1);if(t.length)this.historyBuffer.push(t)},reset:function e(){this.initialPrefix=null;this.iterator=this.historyBuffer.length}};var de={matchCommand:function e(t,r,n,i){var a=Ae(t,r,i,n);if(!a.full&&!a.partial){return{type:"none"}}else if(!a.full&&a.partial){return{type:"partial"}}var o;for(var s=0;s<a.full.length;s++){var l=a.full[s];if(!o){o=l}}if(o.keys.slice(-11)=="<character>"){var c=Le(t);if(/<C-.>/.test(c)||!c)return{type:"none"};n.selectedCharacter=c}return{type:"full",command:o}},processCommand:function e(t,r,n){r.inputState.repeatOverride=n.repeatOverride;switch(n.type){case"motion":this.processMotion(t,r,n);break;case"operator":this.processOperator(t,r,n);break;case"operatorMotion":this.processOperatorMotion(t,r,n);break;case"action":this.processAction(t,r,n);break;case"search":this.processSearch(t,r,n);break;case"ex":case"keyToEx":this.processEx(t,r,n);break;default:break}},processMotion:function e(t,r,n){r.inputState.motion=n.motion;r.inputState.motionArgs=Me(n.motionArgs);this.evalInput(t,r)},processOperator:function e(t,r,n){var i=r.inputState;if(i.operator){if(i.operator==n.operator){i.motion="expandToLine";i.motionArgs={linewise:true};this.evalInput(t,r);return}else{ce(t)}}i.operator=n.operator;i.operatorArgs=Me(n.operatorArgs);if(n.exitVisualBlock){r.visualBlock=false;Ue(t)}if(r.visualMode){this.evalInput(t,r)}},processOperatorMotion:function e(t,r,n){var i=r.visualMode;var a=Me(n.operatorMotionArgs);if(a){if(i&&a.visualLine){r.visualLine=true}}this.processOperator(t,r,n);if(!i){this.processMotion(t,r,n)}},processAction:function e(t,r,n){var i=r.inputState;var a=i.getRepeat();var o=!!a;var s=Me(n.actionArgs)||{};if(i.selectedCharacter){s.selectedCharacter=i.selectedCharacter}if(n.operator){this.processOperator(t,r,n)}if(n.motion){this.processMotion(t,r,n)}if(n.motion||n.operator){this.evalInput(t,r)}s.repeat=a||1;s.repeatIsExplicit=o;s.registerName=i.registerName;ce(t);r.lastMotion=null;if(n.isEdit){this.recordLastEdit(r,i,n)}Ce[n.action](t,s,r)},processSearch:function e(t,r,n){if(!t.getSearchCursor){return}var i=n.searchArgs.forward;var a=n.searchArgs.wholeWordOnly;vt(t).setReversed(!i);var o=i?"/":"?";var s=vt(t).getQuery();var l=t.getScrollInfo();function c(e,i,a){ie.searchHistoryController.pushInput(e);ie.searchHistoryController.reset();try{Bt(t,e,i,a)}catch(r){Lt(t,"Invalid regex: "+e);ce(t);return}de.processMotion(t,r,{type:"motion",motion:"findNext",motionArgs:{forward:true,toJumplist:n.searchArgs.toJumplist}})}function u(e){t.scrollTo(l.left,l.top);c(e,true,true);var r=ie.macroModeState;if(r.isRecording){Xt(r,e)}}function f(e,r,n){var a=v.keyName(e),o,s;if(a=="Up"||a=="Down"){o=a=="Up"?true:false;s=e.target?e.target.selectionEnd:0;r=ie.searchHistoryController.nextMatch(r,o)||"";n(r);if(s&&e.target)e.target.selectionEnd=e.target.selectionStart=Math.min(s,e.target.value.length)}else{if(a!="Left"&&a!="Right"&&a!="Ctrl"&&a!="Alt"&&a!="Shift")ie.searchHistoryController.reset()}var c;try{c=Bt(t,r,true,true)}catch(e){}if(c){t.scrollIntoView(Nt(t,!i,c),30)}else{Pt(t);t.scrollTo(l.left,l.top)}}function h(e,r,n){var i=v.keyName(e);if(i=="Esc"||i=="Ctrl-C"||i=="Ctrl-["||i=="Backspace"&&r==""){ie.searchHistoryController.pushInput(r);ie.searchHistoryController.reset();Bt(t,s);Pt(t);t.scrollTo(l.left,l.top);v.e_stop(e);ce(t);n();t.focus()}else if(i=="Up"||i=="Down"){v.e_stop(e)}else if(i=="Ctrl-U"){v.e_stop(e);n("")}}switch(n.searchArgs.querySrc){case"prompt":var p=ie.macroModeState;if(p.isPlaying){var d=p.replaySearchQueries.shift();c(d,true,false)}else{Et(t,{onClose:u,prefix:o,desc:Tt,onKeyUp:f,onKeyDown:h})}break;case"wordUnderCursor":var m=Ze(t,false,true,false,true);var g=true;if(!m){m=Ze(t,false,true,false,false);g=false}if(!m){return}var d=t.getLine(m.start.line).substring(m.start.ch,m.end.ch);if(g&&a){d="\\b"+d+"\\b"}else{d=_e(d)}ie.jumpList.cachedCursor=t.getCursor();t.setCursor(m.start);c(d,true,false);break}},processEx:function e(t,r,n){function i(e){ie.exCommandHistoryController.pushInput(e);ie.exCommandHistoryController.reset();Wt.processCommand(t,e)}function a(e,r,n){var i=v.keyName(e),a,o;if(i=="Esc"||i=="Ctrl-C"||i=="Ctrl-["||i=="Backspace"&&r==""){ie.exCommandHistoryController.pushInput(r);ie.exCommandHistoryController.reset();v.e_stop(e);ce(t);n();t.focus()}if(i=="Up"||i=="Down"){v.e_stop(e);a=i=="Up"?true:false;o=e.target?e.target.selectionEnd:0;r=ie.exCommandHistoryController.nextMatch(r,a)||"";n(r);if(o&&e.target)e.target.selectionEnd=e.target.selectionStart=Math.min(o,e.target.value.length)}else if(i=="Ctrl-U"){v.e_stop(e);n("")}else{if(i!="Left"&&i!="Right"&&i!="Ctrl"&&i!="Alt"&&i!="Shift")ie.exCommandHistoryController.reset()}}if(n.type=="keyToEx"){Wt.processCommand(t,n.exArgs.input)}else{if(r.visualMode){Et(t,{onClose:i,prefix:":",value:"'<,'>",onKeyDown:a,selectValueOnOpen:false})}else{Et(t,{onClose:i,prefix:":",onKeyDown:a})}}},evalInput:function e(t,r){var n=r.inputState;var i=n.motion;var a=n.motionArgs||{};var o=n.operator;var s=n.operatorArgs||{};var l=n.registerName;var c=r.sel;var u=Te(r.visualMode?xe(t,c.head):t.getCursor("head"));var f=Te(r.visualMode?xe(t,c.anchor):t.getCursor("anchor"));var h=Te(u);var p=Te(f);var d,v;var m;if(o){this.recordLastEdit(r,n)}if(n.repeatOverride!==undefined){m=n.repeatOverride}else{m=n.getRepeat()}if(m>0&&a.explicitRepeat){a.repeatIsExplicit=true}else if(a.noRepeat||!a.explicitRepeat&&m===0){m=1;a.repeatIsExplicit=false}if(n.selectedCharacter){a.selectedCharacter=s.selectedCharacter=n.selectedCharacter}a.repeat=m;ce(t);if(i){var g=ve[i](t,u,a,r);r.lastMotion=ve[i];if(!g){return}if(a.toJumplist){if(!o&&t.ace.curOp!=null)t.ace.curOp.command.scrollIntoView="center-animate";var y=ie.jumpList;var k=y.cachedCursor;if(k){Ye(t,k,g);delete y.cachedCursor}else{Ye(t,u,g)}}if(g instanceof Array){v=g[0];d=g[1]}else{d=g}if(!d){d=Te(u)}if(r.visualMode){if(!(r.visualBlock&&d.ch===Infinity)){d=xe(t,d,r.visualBlock)}if(v){v=xe(t,v,true)}v=v||p;c.anchor=v;c.head=d;Ue(t);lt(t,r,"<",Re(v,d)?v:d);lt(t,r,">",Re(v,d)?d:v)}else if(!o){d=xe(t,d);t.setCursor(d.line,d.ch)}}if(o){if(s.lastSel){v=p;var C=s.lastSel;var w=Math.abs(C.head.line-C.anchor.line);var M=Math.abs(C.head.ch-C.anchor.ch);if(C.visualLine){d=x(p.line+w,p.ch)}else if(C.visualBlock){d=x(p.line+w,p.ch+M)}else if(C.head.line==C.anchor.line){d=x(p.line,p.ch+M)}else{d=x(p.line+w,p.ch)}r.visualMode=true;r.visualLine=C.visualLine;r.visualBlock=C.visualBlock;c=r.sel={anchor:v,head:d};Ue(t)}else if(r.visualMode){s.lastSel={anchor:Te(c.anchor),head:Te(c.head),visualBlock:r.visualBlock,visualLine:r.visualLine}}var S,A,b,L;var O;if(r.visualMode){S=Be(c.head,c.anchor);A=Ie(c.head,c.anchor);b=r.visualLine||s.linewise;L=r.visualBlock?"block":b?"line":"char";O=ze(t,{anchor:S,head:A},L);if(b){var T=O.ranges;if(L=="block"){for(var E=0;E<T.length;E++){T[E].head.ch=Ne(t,T[E].head.line)}}else if(L=="line"){T[0].head=x(T[0].head.line+1,0)}}}else{S=Te(v||p);A=Te(d||h);if(Re(A,S)){var R=S;S=A;A=R}b=a.linewise||s.linewise;if(b){Ge(t,S,A)}else if(a.forward){Qe(t,S,A)}L="char";var B=!a.inclusive||b;O=ze(t,{anchor:S,head:A},L,B)}t.setSelections(O.ranges,O.primary);r.lastMotion=null;s.repeat=m;s.registerName=l;s.linewise=b;var I=ye[o](t,s,O.ranges,p,d);if(r.visualMode){qe(t,I!=null)}if(I){t.setCursor(I)}}},recordLastEdit:function e(t,r,n){var i=ie.macroModeState;if(i.isPlaying){return}t.lastEditInputState=r;t.lastEditActionCommand=n;i.lastInsertModeChanges.changes=[];i.lastInsertModeChanges.expectCursorActivityForChange=false;i.lastInsertModeChanges.visualBlock=t.visualBlock?t.sel.head.line-t.sel.anchor.line:0}};var ve={moveToTopLine:function e(t,r,n){var i=Ht(t).top+n.repeat-1;return x(i,Xe(t.getLine(i)))},moveToMiddleLine:function e(t){var r=Ht(t);var n=Math.floor((r.top+r.bottom)*.5);return x(n,Xe(t.getLine(n)))},moveToBottomLine:function e(t,r,n){var i=Ht(t).bottom-n.repeat+1;return x(i,Xe(t.getLine(i)))},expandToLine:function e(t,r,n){var i=r;return x(i.line+n.repeat-1,Infinity)},findNext:function e(t,r,n){var i=vt(t);var a=i.getQuery();if(!a){return}var o=!n.forward;o=i.isReversed()?!o:o;Kt(t,a);return Nt(t,o,a,n.repeat)},goToMark:function e(t,r,n,i){var a=Vt(t,i,n.selectedCharacter);if(a){return n.linewise?{line:a.line,ch:Xe(t.getLine(a.line))}:a}return null},moveToOtherHighlightedEnd:function e(t,r,n,i){if(i.visualBlock&&n.sameLine){var a=i.sel;return[xe(t,x(a.anchor.line,a.head.ch)),xe(t,x(a.head.line,a.anchor.ch))]}else{return[i.sel.head,i.sel.anchor]}},jumpToMark:function e(t,r,n,i){var a=r;for(var o=0;o<n.repeat;o++){var s=a;for(var l in i.marks){if(!W(l)){continue}var c=i.marks[l].find();var u=n.forward?Re(c,s):Re(s,c);if(u){continue}if(n.linewise&&c.line==s.line){continue}var f=Ee(s,a);var h=n.forward?Ke(s,c,a):Ke(a,c,s);if(f||h){a=c}}}if(n.linewise){a=x(a.line,Xe(t.getLine(a.line)))}return a},moveByCharacters:function e(t,r,n){var i=r;var a=n.repeat;var o=n.forward?i.ch+a:i.ch-a;return x(i.line,o)},moveByLines:function e(t,r,n,i){var a=r;var o=a.ch;switch(i.lastMotion){case this.moveByLines:case this.moveByDisplayLines:case this.moveByScroll:case this.moveToColumn:case this.moveToEol:o=i.lastHPos;break;default:i.lastHPos=o}var s=n.repeat+(n.repeatOffset||0);var l=n.forward?a.line+s:a.line-s;var c=t.firstLine();var u=t.lastLine();if(l<c&&a.line==c){return this.moveToStartOfLine(t,r,n,i)}else if(l>u&&a.line==u){return this.moveToEol(t,r,n,i,true)}var f=t.ace.session.getFoldLine(l);if(f){if(n.forward){if(l>f.start.row)l=f.end.row+1}else{l=f.start.row}}if(n.toFirstChar){o=Xe(t.getLine(l));i.lastHPos=o}i.lastHSPos=t.charCoords(x(l,o),"div").left;return x(l,o)},moveByDisplayLines:function e(t,r,n,i){var a=r;switch(i.lastMotion){case this.moveByDisplayLines:case this.moveByScroll:case this.moveByLines:case this.moveToColumn:case this.moveToEol:break;default:i.lastHSPos=t.charCoords(a,"div").left}var o=n.repeat;var s=t.findPosV(a,n.forward?o:-o,"line",i.lastHSPos);if(s.hitSide){if(n.forward){var l=t.charCoords(s,"div");var c={top:l.top+8,left:i.lastHSPos};var s=t.coordsChar(c,"div")}else{var u=t.charCoords(x(t.firstLine(),0),"div");u.left=i.lastHSPos;s=t.coordsChar(u,"div")}}i.lastHPos=s.ch;return s},moveByPage:function e(t,r,n){var i=r;var a=n.repeat;return t.findPosV(i,n.forward?a:-a,"page")},moveByParagraph:function e(t,r,n){var i=n.forward?1:-1;return ut(t,r,n.repeat,i)},moveBySentence:function e(t,r,n){var i=n.forward?1:-1;return ft(t,r,n.repeat,i)},moveByScroll:function e(t,r,n,i){var a=t.getScrollInfo();var o=null;var s=n.repeat;if(!s){s=a.clientHeight/(2*t.defaultTextHeight())}var l=t.charCoords(r,"local");n.repeat=s;var o=ve.moveByDisplayLines(t,r,n,i);if(!o){return null}var c=t.charCoords(o,"local");t.scrollTo(null,a.top+c.top-l.top);return o},moveByWords:function e(t,r,n){return at(t,r,n.repeat,!!n.forward,!!n.wordEnd,!!n.bigWord)},moveTillCharacter:function e(t,r,n){var i=n.repeat;var a=ot(t,i,n.forward,n.selectedCharacter);var o=n.forward?-1:1;et(o,n);if(!a)return null;a.ch+=o;return a},moveToCharacter:function e(t,r,n){var i=n.repeat;et(0,n);return ot(t,i,n.forward,n.selectedCharacter)||r},moveToSymbol:function e(t,r,n){var i=n.repeat;return nt(t,i,n.forward,n.selectedCharacter)||r},moveToColumn:function e(t,r,n,i){var a=n.repeat;i.lastHPos=a-1;i.lastHSPos=t.charCoords(r,"div").left;return st(t,a)},moveToEol:function e(t,r,n,i,a){var o=r;var s=x(o.line+n.repeat-1,Infinity);var l=t.clipPos(s);l.ch--;if(!a){i.lastHPos=Infinity;i.lastHSPos=t.charCoords(l,"div").left}return s},moveToFirstNonWhiteSpaceCharacter:function e(t,r){var n=r;return x(n.line,Xe(t.getLine(n.line)))},moveToMatchedSymbol:function e(t,r){var n=r;var i=n.line;var a=n.ch;var o=t.getLine(i);var s;for(;a<o.length;a++){s=o.charAt(a);if(s&&F(s)){var l=t.getTokenTypeAt(x(i,a+1));if(l!=="string"&&l!=="comment"){break}}}if(a<o.length){var c=/[<>]/.test(o[a])?/[(){}[\]<>]/:/[(){}[\]]/;var u=t.findMatchingBracket(x(i,a+1),{bracketRegex:c});return u.to}else{return n}},moveToStartOfLine:function e(t,r){return x(r.line,0)},moveToLineOrEdgeOfDocument:function e(t,r,n){var i=n.forward?t.lastLine():t.firstLine();if(n.repeatIsExplicit){i=n.repeat-t.getOption("firstLineNumber")}return x(i,Xe(t.getLine(i)))},textObjectManipulation:function e(t,r,n,i){var a={"(":")",")":"(","{":"}","}":"{","[":"]","]":"[","<":">",">":"<"};var o={"'":true,'"':true,"`":true};var s=n.selectedCharacter;if(s=="b"){s="("}else if(s=="B"){s="{"}var l=!n.textObjectInner;var c;if(a[s]){c=ht(t,r,s,l)}else if(o[s]){c=pt(t,r,s,l)}else if(s==="W"){c=Ze(t,l,true,true)}else if(s==="w"){c=Ze(t,l,true,false)}else if(s==="p"){c=ut(t,r,n.repeat,0,l);n.linewise=true;if(i.visualMode){if(!i.visualLine){i.visualLine=true}}else{var u=i.inputState.operatorArgs;if(u){u.linewise=true}c.end.line--}}else{return null}if(!t.state.vim.visualMode){return[c.start,c.end]}else{return Fe(t,c.start,c.end)}},repeatLastCharacterSearch:function e(t,r,n){var i=ie.lastCharacterSearch;var a=n.repeat;var o=n.forward===i.forward;var s=(i.increment?1:0)*(o?-1:1);t.moveH(-s,"char");n.inclusive=o?true:false;var l=ot(t,a,o,i.selectedCharacter);if(!l){t.moveH(s,"char");return r}l.ch+=s;return l}};function me(e,t){ve[e]=t}function ge(e,t){var r=[];for(var n=0;n<t;n++){r.push(e)}return r}var ye={change:function e(t,r,n){var i,a;var o=t.state.vim;var s=n[0].anchor,l=n[0].head;if(!o.visualMode){a=t.getRange(s,l);var c=o.lastEditInputState||{};if(c.motion=="moveByWords"&&!J(a)){var u=/\s+$/.exec(a);if(u&&c.motionArgs&&c.motionArgs.forward){l=Se(l,0,-u[0].length);a=a.slice(0,-u[0].length)}}var f=new x(s.line-1,Number.MAX_VALUE);var h=t.firstLine()==t.lastLine();if(l.line>t.lastLine()&&r.linewise&&!h){t.replaceRange("",f,l)}else{t.replaceRange("",s,l)}if(r.linewise){if(!h){t.setCursor(f);v.commands.newlineAndIndent(t)}s.ch=Number.MAX_VALUE}i=s}else if(r.fullLine){l.ch=Number.MAX_VALUE;l.line--;t.setSelection(s,l);a=t.getSelection();t.replaceSelection("");i=s}else{a=t.getSelection();var p=ge("",n.length);t.replaceSelections(p);i=Be(n[0].head,n[0].anchor)}ie.registerController.pushText(r.registerName,"change",a,r.linewise,n.length>1);Ce.enterInsertMode(t,{head:i},t.state.vim)},delete:function e(t,r,n){var i,a;var o=t.state.vim;if(!o.visualBlock){var s=n[0].anchor,l=n[0].head;if(r.linewise&&l.line!=t.firstLine()&&s.line==t.lastLine()&&s.line==l.line-1){if(s.line==t.firstLine()){s.ch=0}else{s=x(s.line-1,Ne(t,s.line-1))}}a=t.getRange(s,l);t.replaceRange("",s,l);i=s;if(r.linewise){i=ve.moveToFirstNonWhiteSpaceCharacter(t,s)}}else{a=t.getSelection();var c=ge("",n.length);t.replaceSelections(c);i=n[0].anchor}ie.registerController.pushText(r.registerName,"delete",a,r.linewise,o.visualBlock);var u=o.insertMode;return xe(t,i,u)},indent:function e(t,r,n){var i=t.state.vim;var a=n[0].anchor.line;var o=i.visualBlock?n[n.length-1].anchor.line:n[0].head.line;var s=i.visualMode?r.repeat:1;if(r.linewise){o--}for(var l=a;l<=o;l++){for(var c=0;c<s;c++){t.indentLine(l,r.indentRight)}}return ve.moveToFirstNonWhiteSpaceCharacter(t,n[0].anchor)},indentAuto:function e(t,r,n){t.execCommand("indentAuto");return ve.moveToFirstNonWhiteSpaceCharacter(t,n[0].anchor)},changeCase:function e(t,r,n,i,a){var o=t.getSelections();var s=[];var l=r.toLower;for(var c=0;c<o.length;c++){var u=o[c];var f="";if(l===true){f=u.toLowerCase()}else if(l===false){f=u.toUpperCase()}else{for(var h=0;h<u.length;h++){var p=u.charAt(h);f+=z(p)?p.toLowerCase():p.toUpperCase()}}s.push(f)}t.replaceSelections(s);if(r.shouldMoveCursor){return a}else if(!t.state.vim.visualMode&&r.linewise&&n[0].anchor.line+1==n[0].head.line){return ve.moveToFirstNonWhiteSpaceCharacter(t,i)}else if(r.linewise){return i}else{return Be(n[0].anchor,n[0].head)}},yank:function e(t,r,n,i){var a=t.state.vim;var o=t.getSelection();var s=a.visualMode?Be(a.sel.anchor,a.sel.head,n[0].head,n[0].anchor):i;ie.registerController.pushText(r.registerName,"yank",o,r.linewise,a.visualBlock);return s}};function ke(e,t){ye[e]=t}var Ce={jumpListWalk:function e(t,r,n){if(n.visualMode){return}var i=r.repeat;var a=r.forward;var o=ie.jumpList;var s=o.move(t,a?i:-i);var l=s?s.find():undefined;l=l?l:t.getCursor();t.setCursor(l);t.ace.curOp.command.scrollIntoView="center-animate"},scroll:function e(t,r,n){if(n.visualMode){return}var i=r.repeat||1;var a=t.defaultTextHeight();var o=t.getScrollInfo().top;var s=a*i;var l=r.forward?o+s:o-s;var c=Te(t.getCursor());var u=t.charCoords(c,"local");if(r.forward){if(l>u.top){c.line+=(l-u.top)/a;c.line=Math.ceil(c.line);t.setCursor(c);u=t.charCoords(c,"local");t.scrollTo(null,u.top)}else{t.scrollTo(null,l)}}else{var f=l+t.getScrollInfo().clientHeight;if(f<u.bottom){c.line-=(u.bottom-f)/a;c.line=Math.floor(c.line);t.setCursor(c);u=t.charCoords(c,"local");t.scrollTo(null,u.bottom-t.getScrollInfo().clientHeight)}else{t.scrollTo(null,l)}}},scrollToCursor:function e(t,r){var n=t.getCursor().line;var i=t.charCoords(x(n,0),"local");var a=t.getScrollInfo().clientHeight;var o=i.top;var s=i.bottom-o;switch(r.position){case"center":o=o-a/2+s;break;case"bottom":o=o-a+s;break}t.scrollTo(null,o)},replayMacro:function e(t,r,n){var i=r.selectedCharacter;var a=r.repeat;var o=ie.macroModeState;if(i=="@"){i=o.latestRegister}else{o.latestRegister=i}while(a--){qt(t,n,o,i)}},enterMacroRecordMode:function e(t,r){var n=ie.macroModeState;var i=r.selectedCharacter;if(ie.registerController.isValidRegister(i)){n.enterMacroRecordMode(t,i)}},toggleOverwrite:function e(t){if(!t.state.overwrite){t.toggleOverwrite(true);t.setOption("keyMap","vim-replace");v.signal(t,"vim-mode-change",{mode:"replace"})}else{t.toggleOverwrite(false);t.setOption("keyMap","vim-insert");v.signal(t,"vim-mode-change",{mode:"insert"})}},enterInsertMode:function e(t,r,n){if(t.getOption("readOnly")){return}n.insertMode=true;n.insertModeRepeat=r&&r.repeat||1;var i=r?r.insertAt:null;var a=n.sel;var o=r.head||t.getCursor("head");var s=t.listSelections().length;if(i=="eol"){o=x(o.line,Ne(t,o.line))}else if(i=="bol"){o=x(o.line,0)}else if(i=="charAfter"){o=Se(o,0,1)}else if(i=="firstNonBlank"){o=ve.moveToFirstNonWhiteSpaceCharacter(t,o)}else if(i=="startOfSelectedArea"){if(!n.visualMode)return;if(!n.visualBlock){if(a.head.line<a.anchor.line){o=a.head}else{o=x(a.anchor.line,0)}}else{o=x(Math.min(a.head.line,a.anchor.line),Math.min(a.head.ch,a.anchor.ch));s=Math.abs(a.head.line-a.anchor.line)+1}}else if(i=="endOfSelectedArea"){if(!n.visualMode)return;if(!n.visualBlock){if(a.head.line>=a.anchor.line){o=Se(a.head,0,1)}else{o=x(a.anchor.line,0)}}else{o=x(Math.min(a.head.line,a.anchor.line),Math.max(a.head.ch+1,a.anchor.ch));s=Math.abs(a.head.line-a.anchor.line)+1}}else if(i=="inplace"){if(n.visualMode){return}}else if(i=="lastEdit"){o=$t(t)||o}t.setOption("disableInput",false);if(r&&r.replace){t.toggleOverwrite(true);t.setOption("keyMap","vim-replace");v.signal(t,"vim-mode-change",{mode:"replace"})}else{t.toggleOverwrite(false);t.setOption("keyMap","vim-insert");v.signal(t,"vim-mode-change",{mode:"insert"})}if(!ie.macroModeState.isPlaying){t.on("change",Zt);v.on(t.getInputField(),"keydown",nr)}if(n.visualMode){qe(t)}$e(t,o,s)},toggleVisualMode:function e(t,r,n){var i=r.repeat;var a=t.getCursor();var o;if(!n.visualMode){n.visualMode=true;n.visualLine=!!r.linewise;n.visualBlock=!!r.blockwise;o=xe(t,x(a.line,a.ch+i-1),true);n.sel={anchor:a,head:o};v.signal(t,"vim-mode-change",{mode:"visual",subMode:n.visualLine?"linewise":n.visualBlock?"blockwise":""});Ue(t);lt(t,n,"<",Be(a,o));lt(t,n,">",Ie(a,o))}else if(n.visualLine^r.linewise||n.visualBlock^r.blockwise){n.visualLine=!!r.linewise;n.visualBlock=!!r.blockwise;v.signal(t,"vim-mode-change",{mode:"visual",subMode:n.visualLine?"linewise":n.visualBlock?"blockwise":""});Ue(t)}else{qe(t)}},reselectLastSelection:function e(t,r,n){var i=n.lastSelection;if(n.visualMode){We(t,n)}if(i){var a=i.anchorMark.find();var o=i.headMark.find();if(!a||!o){return}n.sel={anchor:a,head:o};n.visualMode=true;n.visualLine=i.visualLine;n.visualBlock=i.visualBlock;Ue(t);lt(t,n,"<",Be(a,o));lt(t,n,">",Ie(a,o));v.signal(t,"vim-mode-change",{mode:"visual",subMode:n.visualLine?"linewise":n.visualBlock?"blockwise":""})}},joinLines:function e(t,r,n){var i,a;if(n.visualMode){i=t.getCursor("anchor");a=t.getCursor("head");if(Re(a,i)){var o=a;a=i;i=o}a.ch=Ne(t,a.line)-1}else{var s=Math.max(r.repeat,2);i=t.getCursor();a=xe(t,x(i.line+s-1,Infinity))}var l=0;for(var c=i.line;c<a.line;c++){l=Ne(t,i.line);var o=x(i.line+1,Ne(t,i.line+1));var u=t.getRange(i,o);u=r.keepSpaces?u.replace(/\n\r?/g,""):u.replace(/\n\s*/g," ");t.replaceRange(u,i,o)}var f=x(i.line,l);if(n.visualMode){qe(t,false)}t.setCursor(f)},newLineAndEnterInsertMode:function e(t,r,n){n.insertMode=true;var i=Te(t.getCursor());if(i.line===t.firstLine()&&!r.after){t.replaceRange("\n",x(t.firstLine(),0));t.setCursor(t.firstLine(),0)}else{i.line=r.after?i.line:i.line-1;i.ch=Ne(t,i.line);t.setCursor(i);var a=v.commands.newlineAndIndentContinueComment||v.commands.newlineAndIndent;a(t)}this.enterInsertMode(t,{repeat:r.repeat},n)},paste:function e(t,r,n){var i=Te(t.getCursor());var a=ie.registerController.getRegister(r.registerName);var o=a.toString();if(!o){return}if(r.matchIndent){var s=t.getOption("tabSize");var l=function e(t){var r=t.split("\t").length-1;var n=t.split(" ").length-1;return r*s+n*1};var c=t.getLine(t.getCursor().line);var u=l(c.match(/^\s*/)[0]);var f=o.replace(/\n$/,"");var h=o!==f;var p=l(o.match(/^\s*/)[0]);var o=f.replace(/^\s*/gm,(function(e){var r=u+(l(e)-p);if(r<0){return""}else if(t.getOption("indentWithTabs")){var n=Math.floor(r/s);return Array(n+1).join("\t")}else{return Array(r+1).join(" ")}}));o+=h?"\n":""}if(r.repeat>1){var o=Array(r.repeat+1).join(o)}var d=a.linewise;var v=a.blockwise;if(v){o=o.split("\n");if(d){o.pop()}for(var m=0;m<o.length;m++){o[m]=o[m]==""?" ":o[m]}i.ch+=r.after?1:0;i.ch=Math.min(Ne(t,i.line),i.ch)}else if(d){if(n.visualMode){o=n.visualLine?o.slice(0,-1):"\n"+o.slice(0,o.length-1)+"\n"}else if(r.after){o="\n"+o.slice(0,o.length-1);i.ch=Ne(t,i.line)}else{i.ch=0}}else{i.ch+=r.after?1:0}var g;var y;if(n.visualMode){n.lastPastedText=o;var k;var C=De(t,n);var w=C[0];var M=C[1];var S=t.getSelection();var A=t.listSelections();var b=new Array(A.length).join("1").split("1");if(n.lastSelection){k=n.lastSelection.headMark.find()}ie.registerController.unnamedRegister.setText(S);if(v){t.replaceSelections(b);M=x(w.line+o.length-1,w.ch);t.setCursor(w);Ve(t,M);t.replaceSelections(o);g=w}else if(n.visualBlock){t.replaceSelections(b);t.setCursor(w);t.replaceRange(o,w,w);g=w}else{t.replaceRange(o,w,M);g=t.posFromIndex(t.indexFromPos(w)+o.length-1)}if(k){n.lastSelection.headMark=t.setBookmark(k)}if(d){g.ch=0}}else{if(v){t.setCursor(i);for(var m=0;m<o.length;m++){var L=i.line+m;if(L>t.lastLine()){t.replaceRange("\n",x(L,0))}var O=Ne(t,L);if(O<i.ch){He(t,L,i.ch)}}t.setCursor(i);Ve(t,x(i.line+o.length-1,i.ch));t.replaceSelections(o);g=i}else{t.replaceRange(o,i);if(d&&r.after){g=x(i.line+1,Xe(t.getLine(i.line+1)))}else if(d&&!r.after){g=x(i.line,Xe(t.getLine(i.line)))}else if(!d&&r.after){y=t.indexFromPos(i);g=t.posFromIndex(y+o.length-1)}else{y=t.indexFromPos(i);g=t.posFromIndex(y+o.length)}}}if(n.visualMode){qe(t,false)}t.setCursor(g)},undo:function e(t,r){t.operation((function(){Oe(t,v.commands.undo,r.repeat)();t.setCursor(t.getCursor("anchor"))}))},redo:function e(t,r){Oe(t,v.commands.redo,r.repeat)()},setRegister:function e(t,r,n){n.inputState.registerName=r.selectedCharacter},setMark:function e(t,r,n){var i=r.selectedCharacter;lt(t,n,i,t.getCursor())},replace:function e(t,r,n){var i=r.selectedCharacter;var a=t.getCursor();var o;var s;var l=t.listSelections();if(n.visualMode){a=t.getCursor("start");s=t.getCursor("end")}else{var c=t.getLine(a.line);o=a.ch+r.repeat;if(o>c.length){o=c.length}s=x(a.line,o)}if(i=="\n"){if(!n.visualMode)t.replaceRange("",a,s);(v.commands.newlineAndIndentContinueComment||v.commands.newlineAndIndent)(t)}else{var u=t.getRange(a,s);u=u.replace(/[^\n]/g,i);if(n.visualBlock){var f=new Array(t.getOption("tabSize")+1).join(" ");u=t.getSelection();u=u.replace(/\t/g,f).replace(/[^\n]/g,i).split("\n");t.replaceSelections(u)}else{t.replaceRange(u,a,s)}if(n.visualMode){a=Re(l[0].anchor,l[0].head)?l[0].anchor:l[0].head;t.setCursor(a);qe(t,false)}else{t.setCursor(Se(s,0,-1))}}},incrementNumberToken:function e(t,r){var n=t.getCursor();var i=t.getLine(n.line);var a=/(-?)(?:(0x)([\da-f]+)|(0b|0|)(\d+))/gi;var o;var s;var l;var c;while((o=a.exec(i))!==null){s=o.index;l=s+o[0].length;if(n.ch<l)break}if(!r.backtrack&&l<=n.ch)return;if(o){var u=o[2]||o[4];var f=o[3]||o[5];var h=r.increase?1:-1;var p={"0b":2,0:8,"":10,"0x":16}[u.toLowerCase()];var d=parseInt(o[1]+f,p)+h*r.repeat;c=d.toString(p);var v=u?new Array(f.length-c.length+1+o[1].length).join("0"):"";if(c.charAt(0)==="-"){c="-"+u+v+c.substr(1)}else{c=u+v+c}var m=x(n.line,s);var g=x(n.line,l);t.replaceRange(c,m,g)}else{return}t.setCursor(x(n.line,s+c.length-1))},repeatLastEdit:function e(t,r,n){var i=n.lastEditInputState;if(!i){return}var a=r.repeat;if(a&&r.repeatIsExplicit){n.lastEditInputState.repeatOverride=a}else{a=n.lastEditInputState.repeatOverride||a}ir(t,n,a,false)},indent:function e(t,r){t.indentLine(t.getCursor().line,r.indentRight)},exitInsertMode:Ut};function we(e,t){Ce[e]=t}function xe(e,t,r){var n=Math.min(Math.max(e.firstLine(),t.line),e.lastLine());var i=Ne(e,n)-1;i=r?i+1:i;var a=Math.min(Math.max(0,t.ch),i);return x(n,a)}function Me(e){var t={};for(var r in e){if(e.hasOwnProperty(r)){t[r]=e[r]}}return t}function Se(e,t,r){if(typeof t==="object"){r=t.ch;t=t.line}return x(e.line+t,e.ch+r)}function Ae(e,t,r,n){var i,a=[],o=[];for(var s=0;s<t.length;s++){var l=t[s];if(r=="insert"&&l.context!="insert"||l.context&&l.context!=r||n.operator&&l.type=="action"||!(i=be(e,l.keys))){continue}if(i=="partial"){a.push(l)}if(i=="full"){o.push(l)}}return{partial:a.length&&a,full:o.length&&o}}function be(e,t){if(t.slice(-11)=="<character>"){var r=t.length-11;var n=e.slice(0,r);var i=t.slice(0,r);return n==i&&e.length>r?"full":i.indexOf(n)==0?"partial":false}else{return e==t?"full":t.indexOf(e)==0?"partial":false}}function Le(e){var t=/^.*(<[^>]+>)$/.exec(e);var r=t?t[1]:e.slice(-1);if(r.length>1){switch(r){case"<CR>":r="\n";break;case"<Space>":r=" ";break;default:r="";break}}return r}function Oe(e,t,r){return function(){for(var n=0;n<r;n++){t(e)}}}function Te(e){return x(e.line,e.ch)}function Ee(e,t){return e.ch==t.ch&&e.line==t.line}function Re(e,t){if(e.line<t.line){return true}if(e.line==t.line&&e.ch<t.ch){return true}return false}function Be(e,t){if(arguments.length>2){t=Be.apply(undefined,Array.prototype.slice.call(arguments,1))}return Re(e,t)?e:t}function Ie(e,t){if(arguments.length>2){t=Ie.apply(undefined,Array.prototype.slice.call(arguments,1))}return Re(e,t)?t:e}function Ke(e,t,r){var n=Re(e,t);var i=Re(t,r);return n&&i}function Ne(e,t){return e.getLine(t).length}function Pe(e){if(e.trim){return e.trim()}return e.replace(/^\s+|\s+$/g,"")}function _e(e){return e.replace(/([.?*+$\[\]\/\\(){}|\-])/g,"\\$1")}function He(e,t,r){var n=Ne(e,t);var i=new Array(r-n+1).join(" ");e.setCursor(x(t,n));e.replaceRange(i,e.getCursor())}function Ve(e,t){var r=[],n=e.listSelections();var i=Te(e.clipPos(t));var a=!Ee(t,i);var o=e.getCursor("head");var s=je(n,o);var l=Ee(n[s].head,n[s].anchor);var c=n.length-1;var u=c-s>s?c:0;var f=n[u].anchor;var h=Math.min(f.line,i.line);var p=Math.max(f.line,i.line);var d=f.ch,v=i.ch;var m=n[u].head.ch-d;var g=v-d;if(m>0&&g<=0){d++;if(!a){v--}}else if(m<0&&g>=0){d--;if(!l){v++}}else if(m<0&&g==-1){d--;v++}for(var y=h;y<=p;y++){var k={anchor:new x(y,d),head:new x(y,v)};r.push(k)}e.setSelections(r);t.ch=v;f.ch=d;return f}function $e(e,t,r){var n=[];for(var i=0;i<r;i++){var a=Se(t,i,0);n.push({anchor:a,head:a})}e.setSelections(n,0)}function je(e,t,r){for(var n=0;n<e.length;n++){var i=r!="head"&&Ee(e[n].anchor,t);var a=r!="anchor"&&Ee(e[n].head,t);if(i||a){return n}}return-1}function De(e,t){var r=t.lastSelection;var n=function t(){var r=e.listSelections();var n=r[0];var i=r[r.length-1];var a=Re(n.anchor,n.head)?n.anchor:n.head;var o=Re(i.anchor,i.head)?i.head:i.anchor;return[a,o]};var i=function t(){var n=e.getCursor();var i=e.getCursor();var a=r.visualBlock;if(a){var o=a.width;var s=a.height;i=x(n.line+s,n.ch+o);var l=[];for(var c=n.line;c<i.line;c++){var u=x(c,n.ch);var f=x(c,i.ch);var h={anchor:u,head:f};l.push(h)}e.setSelections(l)}else{var p=r.anchorMark.find();var d=r.headMark.find();var v=d.line-p.line;var m=d.ch-p.ch;i={line:i.line+v,ch:v?i.ch:m+i.ch};if(r.visualLine){n=x(n.line,0);i=x(i.line,Ne(e,i.line))}e.setSelection(n,i)}return[n,i]};if(!t.visualMode){return i()}else{return n()}}function We(e,t){var r=t.sel.anchor;var n=t.sel.head;if(t.lastPastedText){n=e.posFromIndex(e.indexFromPos(r)+t.lastPastedText.length);t.lastPastedText=null}t.lastSelection={anchorMark:e.setBookmark(r),headMark:e.setBookmark(n),anchor:Te(r),head:Te(n),visualMode:t.visualMode,visualLine:t.visualLine,visualBlock:t.visualBlock}}function Fe(e,t,r){var n=e.state.vim.sel;var i=n.head;var a=n.anchor;var o;if(Re(r,t)){o=r;r=t;t=o}if(Re(i,a)){i=Be(t,i);a=Ie(a,r)}else{a=Be(t,a);i=Ie(i,r);i=Se(i,0,-1);if(i.ch==-1&&i.line!=e.firstLine()){i=x(i.line-1,Ne(e,i.line-1))}}return[a,i]}function Ue(e,t,r){var n=e.state.vim;t=t||n.sel;var r=r||n.visualLine?"line":n.visualBlock?"block":"char";var i=ze(e,t,r);e.setSelections(i.ranges,i.primary);er(e)}function ze(e,t,r,n){var i=Te(t.head);var a=Te(t.anchor);if(r=="char"){var o=!n&&!Re(t.head,t.anchor)?1:0;var s=Re(t.head,t.anchor)?1:0;i=Se(t.head,0,o);a=Se(t.anchor,0,s);return{ranges:[{anchor:a,head:i}],primary:0}}else if(r=="line"){if(!Re(t.head,t.anchor)){a.ch=0;var l=e.lastLine();if(i.line>l){i.line=l}i.ch=Ne(e,i.line)}else{i.ch=0;a.ch=Ne(e,a.line)}return{ranges:[{anchor:a,head:i}],primary:0}}else if(r=="block"){var c=Math.min(a.line,i.line),u=Math.min(a.ch,i.ch),f=Math.max(a.line,i.line),h=Math.max(a.ch,i.ch)+1;var p=f-c+1;var d=i.line==c?0:p-1;var v=[];for(var m=0;m<p;m++){v.push({anchor:x(c+m,u),head:x(c+m,h)})}return{ranges:v,primary:d}}}function Je(e){var t=e.getCursor("head");if(e.getSelection().length==1){t=Be(t,e.getCursor("anchor"))}return t}function qe(e,t){var r=e.state.vim;if(t!==false){e.setCursor(xe(e,r.sel.head))}We(e,r);r.visualMode=false;r.visualLine=false;r.visualBlock=false;v.signal(e,"vim-mode-change",{mode:"normal"});if(r.fakeCursor){r.fakeCursor.clear()}}function Qe(e,t,r){var n=e.getRange(t,r);if(/\n\s*$/.test(n)){var i=n.split("\n");i.pop();var a;for(var a=i.pop();i.length>0&&a&&J(a);a=i.pop()){r.line--;r.ch=0}if(a){r.line--;r.ch=Ne(e,r.line)}else{r.ch=0}}}function Ge(e,t,r){t.ch=0;r.ch=0;r.line++}function Xe(e){if(!e){return 0}var t=e.search(/\S/);return t==-1?e.length:t}function Ze(e,t,r,n,i){var a=Je(e);var o=e.getLine(a.line);var s=a.ch;var l=i?K[0]:N[0];while(!l(o.charAt(s))){s++;if(s>=o.length){return null}}if(n){l=N[0]}else{l=K[0];if(!l(o.charAt(s))){l=K[1]}}var c=s,u=s;while(l(o.charAt(c))&&c<o.length){c++}while(l(o.charAt(u))&&u>=0){u--}u++;if(t){var f=c;while(/\s/.test(o.charAt(c))&&c<o.length){c++}if(f==c){var h=u;while(/\s/.test(o.charAt(u-1))&&u>0){u--}if(!u){u=h}}}return{start:x(a.line,u),end:x(a.line,c)}}function Ye(e,t,r){if(!Ee(t,r)){ie.jumpList.add(e,t,r)}}function et(e,t){ie.lastCharacterSearch.increment=e;ie.lastCharacterSearch.forward=t.forward;ie.lastCharacterSearch.selectedCharacter=t.selectedCharacter}var tt={"(":"bracket",")":"bracket","{":"bracket","}":"bracket","[":"section","]":"section","*":"comment","/":"comment",m:"method",M:"method","#":"preprocess"};var rt={bracket:{isComplete:function e(t){if(t.nextCh===t.symb){t.depth++;if(t.depth>=1)return true}else if(t.nextCh===t.reverseSymb){t.depth--}return false}},section:{init:function e(t){t.curMoveThrough=true;t.symb=(t.forward?"]":"[")===t.symb?"{":"}"},isComplete:function e(t){return t.index===0&&t.nextCh===t.symb}},comment:{isComplete:function e(t){var r=t.lastCh==="*"&&t.nextCh==="/";t.lastCh=t.nextCh;return r}},method:{init:function e(t){t.symb=t.symb==="m"?"{":"}";t.reverseSymb=t.symb==="{"?"}":"{"},isComplete:function e(t){if(t.nextCh===t.symb)return true;return false}},preprocess:{init:function e(t){t.index=0},isComplete:function e(t){if(t.nextCh==="#"){var r=t.lineText.match(/#(\w+)/)[1];if(r==="endif"){if(t.forward&&t.depth===0){return true}t.depth++}else if(r==="if"){if(!t.forward&&t.depth===0){return true}t.depth--}if(r==="else"&&t.depth===0)return true}return false}}};function nt(e,t,r,n){var i=Te(e.getCursor());var a=r?1:-1;var o=r?e.lineCount():-1;var s=i.ch;var l=i.line;var c=e.getLine(l);var u={lineText:c,nextCh:c.charAt(s),lastCh:null,index:s,symb:n,reverseSymb:(r?{")":"(","}":"{"}:{"(":")","{":"}"})[n],forward:r,depth:0,curMoveThrough:false};var f=tt[n];if(!f)return i;var h=rt[f].init;var p=rt[f].isComplete;if(h){h(u)}while(l!==o&&t){u.index+=a;u.nextCh=u.lineText.charAt(u.index);if(!u.nextCh){l+=a;u.lineText=e.getLine(l)||"";if(a>0){u.index=0}else{var d=u.lineText.length;u.index=d>0?d-1:0}u.nextCh=u.lineText.charAt(u.index)}if(p(u)){i.line=l;i.ch=u.index;t--}}if(u.nextCh||u.curMoveThrough){return x(l,u.index)}return i}function it(e,t,r,n,i){var a=t.line;var o=t.ch;var s=e.getLine(a);var l=r?1:-1;var c=n?N:K;if(i&&s==""){a+=l;s=e.getLine(a);if(!D(e,a)){return null}o=r?0:s.length}while(true){if(i&&s==""){return{from:0,to:0,line:a}}var u=l>0?s.length:-1;var f=u,h=u;while(o!=u){var p=false;for(var d=0;d<c.length&&!p;++d){if(c[d](s.charAt(o))){f=o;while(o!=u&&c[d](s.charAt(o))){o+=l}h=o;p=f!=h;if(f==t.ch&&a==t.line&&h==f+l){continue}else{return{from:Math.min(f,h+1),to:Math.max(f,h),line:a}}}}if(!p){o+=l}}a+=l;if(!D(e,a)){return null}s=e.getLine(a);o=l>0?0:s.length}}function at(e,t,r,n,i,a){var o=Te(t);var s=[];if(n&&!i||!n&&i){r++}var l=!(n&&i);for(var c=0;c<r;c++){var u=it(e,t,n,a,l);if(!u){var f=Ne(e,e.lastLine());s.push(n?{line:e.lastLine(),from:f,to:f}:{line:0,from:0,to:0});break}s.push(u);t=x(u.line,n?u.to-1:u.from)}var h=s.length!=r;var p=s[0];var d=s.pop();if(n&&!i){if(!h&&(p.from!=o.ch||p.line!=o.line)){d=s.pop()}return x(d.line,d.from)}else if(n&&i){return x(d.line,d.to-1)}else if(!n&&i){if(!h&&(p.to!=o.ch||p.line!=o.line)){d=s.pop()}return x(d.line,d.to)}else{return x(d.line,d.from)}}function ot(e,t,r,n){var i=e.getCursor();var a=i.ch;var o;for(var s=0;s<t;s++){var l=e.getLine(i.line);o=ct(a,l,n,r,true);if(o==-1){return null}a=o}return x(e.getCursor().line,o)}function st(e,t){var r=e.getCursor().line;return xe(e,x(r,t-1))}function lt(e,t,r,n){if(!Q(r,$)){return}if(t.marks[r]){t.marks[r].clear()}t.marks[r]=e.setBookmark(n)}function ct(e,t,r,n,i){var a;if(n){a=t.indexOf(r,e+1);if(a!=-1&&!i){a-=1}}else{a=t.lastIndexOf(r,e-1);if(a!=-1&&!i){a+=1}}return a}function ut(e,t,r,n,i){var a=t.line;var o=e.firstLine();var s=e.lastLine();var l,c,u=a;function f(t){return!/\S/.test(e.getLine(t))}function h(e,t,r){if(r){return f(e)!=f(e+t)}return!f(e)&&f(e+t)}function p(t){n=n>0?1:-1;var r=e.ace.session.getFoldLine(t);if(r){if(t+n>r.start.row&&t+n<r.end.row)n=(n>0?r.end.row:r.start.row)-t}}if(n){while(o<=u&&u<=s&&r>0){p(u);if(h(u,n)){r--}u+=n}return new x(u,0)}var d=e.state.vim;if(d.visualLine&&h(a,1,true)){var v=d.sel.anchor;if(h(v.line,-1,true)){if(!i||v.line!=a){a+=1}}}var m=f(a);for(u=a;u<=s&&r;u++){if(h(u,1,true)){if(!i||f(u)!=m){r--}}}c=new x(u,0);if(u>s&&!m){m=true}else{i=false}for(u=a;u>o;u--){if(!i||f(u)==m||u==a){if(h(u,-1,true)){break}}}l=new x(u,0);return{start:l,end:c}}function ft(e,t,r,n){function i(e,t){if(t.pos+t.dir<0||t.pos+t.dir>=t.line.length){t.ln+=t.dir;if(!D(e,t.ln)){t.line=null;t.ln=null;t.pos=null;return}t.line=e.getLine(t.ln);t.pos=t.dir>0?0:t.line.length-1}else{t.pos+=t.dir}}function a(e,t,r,n){var a=e.getLine(t);var o=a==="";var s={line:a,ln:t,pos:r,dir:n};var l={ln:s.ln,pos:s.pos};var c=s.line==="";i(e,s);while(s.line!==null){l.ln=s.ln;l.pos=s.pos;if(s.line===""&&!c){return{ln:s.ln,pos:s.pos}}else if(o&&s.line!==""&&!J(s.line[s.pos])){return{ln:s.ln,pos:s.pos}}else if(q(s.line[s.pos])&&!o&&(s.pos===s.line.length-1||J(s.line[s.pos+1]))){o=true}i(e,s)}var a=e.getLine(l.ln);l.pos=0;for(var u=a.length-1;u>=0;--u){if(!J(a[u])){l.pos=u;break}}return l}function o(e,t,r,n){var a=e.getLine(t);var o={line:a,ln:t,pos:r,dir:n};var s={ln:o.ln,pos:null};var l=o.line==="";i(e,o);while(o.line!==null){if(o.line===""&&!l){if(s.pos!==null){return s}else{return{ln:o.ln,pos:o.pos}}}else if(q(o.line[o.pos])&&s.pos!==null&&!(o.ln===s.ln&&o.pos+1===s.pos)){return s}else if(o.line!==""&&!J(o.line[o.pos])){l=false;s={ln:o.ln,pos:o.pos}}i(e,o)}var a=e.getLine(s.ln);s.pos=0;for(var c=0;c<a.length;++c){if(!J(a[c])){s.pos=c;break}}return s}var s={ln:t.line,pos:t.ch};while(r>0){if(n<0){s=o(e,s.ln,s.pos,n)}else{s=a(e,s.ln,s.pos,n)}r--}return x(s.ln,s.pos)}function ht(e,t,r,n){var i=t,a,o;var s={"(":/[()]/,")":/[()]/,"[":/[[\]]/,"]":/[[\]]/,"{":/[{}]/,"}":/[{}]/,"<":/[<>]/,">":/[<>]/}[r];var l={"(":"(",")":"(","[":"[","]":"[","{":"{","}":"{","<":"<",">":"<"}[r];var c=e.getLine(i.line).charAt(i.ch);var u=c===l?1:0;a=e.scanForBracket(x(i.line,i.ch+u),-1,undefined,{bracketRegex:s});o=e.scanForBracket(x(i.line,i.ch+u),1,undefined,{bracketRegex:s});if(!a||!o){return{start:i,end:i}}a=a.pos;o=o.pos;if(a.line==o.line&&a.ch>o.ch||a.line>o.line){var f=a;a=o;o=f}if(n){o.ch+=1}else{a.ch+=1}return{start:a,end:o}}function pt(e,t,r,n){var i=Te(t);var a=e.getLine(i.line);var o=a.split("");var s,l,c,u;var f=o.indexOf(r);if(i.ch<f){i.ch=f}else if(f<i.ch&&o[i.ch]==r){l=i.ch;--i.ch}if(o[i.ch]==r&&!l){s=i.ch+1}else{for(c=i.ch;c>-1&&!s;c--){if(o[c]==r){s=c+1}}}if(s&&!l){for(c=s,u=o.length;c<u&&!l;c++){if(o[c]==r){l=c}}}if(!s||!l){return{start:i,end:i}}if(n){--s;++l}return{start:x(i.line,s),end:x(i.line,l)}}X("pcre",true,"boolean");function dt(){}dt.prototype={getQuery:function e(){return ie.query},setQuery:function e(t){ie.query=t},getOverlay:function e(){return this.searchOverlay},setOverlay:function e(t){this.searchOverlay=t},isReversed:function e(){return ie.isReversed},setReversed:function e(t){ie.isReversed=t},getScrollbarAnnotate:function e(){return this.annotate},setScrollbarAnnotate:function e(t){this.annotate=t}};function vt(e){var t=e.state.vim;return t.searchState_||(t.searchState_=new dt)}function mt(e,t,r,n,i){if(e.openDialog){e.openDialog(t,n,{bottom:true,value:i.value,onKeyDown:i.onKeyDown,onKeyUp:i.onKeyUp,selectValueOnOpen:false,onClose:function t(){if(e.state.vim){e.state.vim.status="";e.ace.renderer.$loop.schedule(e.ace.renderer.CHANGE_CURSOR)}}})}else{n(prompt(r,""))}}function gt(e){return kt(e,"/")}function yt(e){return Ct(e,"/")}function kt(e,t){var r=Ct(e,t)||[];if(!r.length)return[];var n=[];if(r[0]!==0)return;for(var i=0;i<r.length;i++){if(typeof r[i]=="number")n.push(e.substring(r[i]+1,r[i+1]))}return n}function Ct(e,t){if(!t)t="/";var r=false;var n=[];for(var i=0;i<e.length;i++){var a=e.charAt(i);if(!r&&a==t){n.push(i)}r=!r&&a=="\\"}return n}function wt(e){var t="|(){";var r="}";var n=false;var i=[];for(var a=-1;a<e.length;a++){var o=e.charAt(a)||"";var s=e.charAt(a+1)||"";var l=s&&t.indexOf(s)!=-1;if(n){if(o!=="\\"||!l){i.push(o)}n=false}else{if(o==="\\"){n=true;if(s&&r.indexOf(s)!=-1){l=true}if(!l||s==="\\"){i.push(o)}}else{i.push(o);if(l&&s!=="\\"){i.push("\\")}}}}return i.join("")}var xt={"\\n":"\n","\\r":"\r","\\t":"\t"};function Mt(e){var t=false;var r=[];for(var n=-1;n<e.length;n++){var i=e.charAt(n)||"";var a=e.charAt(n+1)||"";if(xt[i+a]){r.push(xt[i+a]);n++}else if(t){r.push(i);t=false}else{if(i==="\\"){t=true;if(U(a)||a==="$"){r.push("$")}else if(a!=="/"&&a!=="\\"){r.push("\\")}}else{if(i==="$"){r.push("$")}r.push(i);if(a==="/"){r.push("\\")}}}}return r.join("")}var St={"\\/":"/","\\\\":"\\","\\n":"\n","\\r":"\r","\\t":"\t"};function At(e){var t=new v.StringStream(e);var r=[];while(!t.eol()){while(t.peek()&&t.peek()!="\\"){r.push(t.next())}var n=false;for(var i in St){if(t.match(i,true)){n=true;r.push(St[i]);break}}if(!n){r.push(t.next())}}return r.join("")}function bt(e,t,r){var n=ie.registerController.getRegister("/");n.setText(e);if(e instanceof RegExp){return e}var i=yt(e);var a;var o;if(!i.length){a=e}else{a=e.substring(0,i[0]);var s=e.substring(i[0]);o=s.indexOf("i")!=-1}if(!a){return null}if(!Y("pcre")){a=wt(a)}if(r){t=/^[^A-Z]*$/.test(a)}var l=new RegExp(a,t||o?"i":undefined);return l}function Lt(e,t){if(e.openNotification){e.openNotification('<span style="color: red">'+t+"</span>",{bottom:true,duration:5e3})}else{alert(t)}}function Ot(e,t){var r='<span style="font-family: monospace; white-space: pre">'+(e||"")+'<input type="text" autocorrect="off" autocapitalize="none" autocomplete="off"></span>';if(t)r+=' <span style="color: #888">'+t+"</span>";return r}var Tt="(Javascript regexp)";function Et(e,t){var r=(t.prefix||"")+" "+(t.desc||"");var n=Ot(t.prefix,t.desc);mt(e,n,r,t.onClose,t)}function Rt(e,t){if(e instanceof RegExp&&t instanceof RegExp){var r=["global","multiline","ignoreCase","source"];for(var n=0;n<r.length;n++){var i=r[n];if(e[i]!==t[i]){return false}}return true}return false}function Bt(e,t,r,n){if(!t){return}var i=vt(e);var a=bt(t,!!r,!!n);if(!a){return}Kt(e,a);if(Rt(a,i.getQuery())){return a}i.setQuery(a);return a}function It(e){if(e.source.charAt(0)=="^"){var t=true}return{token:function r(n){if(t&&!n.sol()){n.skipToEnd();return}var i=n.match(e,false);if(i){if(i[0].length==0){n.next();return"searching"}if(!n.sol()){n.backUp(1);if(!e.exec(n.next()+i[0])){n.next();return null}}n.match(e);return"searching"}while(!n.eol()){n.next();if(n.match(e,false))break}},query:e}}function Kt(e,t){var r=vt(e);var n=r.getOverlay();if(!n||t!=n.query){if(n){e.removeOverlay(n)}n=It(t);e.addOverlay(n);if(e.showMatchesOnScrollbar){if(r.getScrollbarAnnotate()){r.getScrollbarAnnotate().clear()}r.setScrollbarAnnotate(e.showMatchesOnScrollbar(t))}r.setOverlay(n)}}function Nt(e,t,r,n){if(n===undefined){n=1}return e.operation((function(){var i=e.getCursor();var a=e.getSearchCursor(r,i);for(var o=0;o<n;o++){var s=a.find(t);if(o==0&&s&&Ee(a.from(),i)){s=a.find(t)}if(!s){a=e.getSearchCursor(r,t?x(e.lastLine()):x(e.firstLine(),0));if(!a.find(t)){return}}}return a.from()}))}function Pt(e){var t=vt(e);e.removeOverlay(vt(e).getOverlay());t.setOverlay(null);if(t.getScrollbarAnnotate()){t.getScrollbarAnnotate().clear();t.setScrollbarAnnotate(null)}}function _t(e,t,r){if(typeof e!="number"){e=e.line}if(t instanceof Array){return Q(e,t)}else{if(r){return e>=t&&e<=r}else{return e==t}}}function Ht(e){var t=e.ace.renderer;return{top:t.getFirstFullyVisibleRow(),bottom:t.getLastFullyVisibleRow()}}function Vt(e,t,r){if(r=="'"||r=="`"){return ie.jumpList.find(e,-1)||x(0,0)}else if(r=="."){return $t(e)}var n=t.marks[r];return n&&n.find()}function $t(e){var t=e.ace.session.$undoManager;if(t&&t.$lastDelta)return g(t.$lastDelta.end)}var jt=function e(){this.buildCommandMap_()};jt.prototype={processCommand:function e(t,r,n){var i=this;t.operation((function(){t.curOp.isVimOp=true;i._processCommand(t,r,n)}))},_processCommand:function e(t,r,n){var i=t.state.vim;var a=ie.registerController.getRegister(":");var o=a.toString();if(i.visualMode){qe(t)}var s=new v.StringStream(r);a.setText(r);var l=n||{};l.input=r;try{this.parseInput_(t,s,l)}catch(e){Lt(t,e);throw e}var c;var u;if(!l.commandName){if(l.line!==undefined){u="move"}}else{c=this.matchCommand_(l.commandName);if(c){u=c.name;if(c.excludeFromCommandHistory){a.setText(o)}this.parseCommandArgs_(s,l,c);if(c.type=="exToKey"){for(var f=0;f<c.toKeys.length;f++){v.Vim.handleKey(t,c.toKeys[f],"mapping")}return}else if(c.type=="exToEx"){this.processCommand(t,c.toInput);return}}}if(!u){Lt(t,'Not an editor command ":'+r+'"');return}try{Dt[u](t,l);if((!c||!c.possiblyAsync)&&l.callback){l.callback()}}catch(e){Lt(t,e);throw e}},parseInput_:function e(t,r,n){r.eatWhile(":");if(r.eat("%")){n.line=t.firstLine();n.lineEnd=t.lastLine()}else{n.line=this.parseLineSpec_(t,r);if(n.line!==undefined&&r.eat(",")){n.lineEnd=this.parseLineSpec_(t,r)}}var i=r.match(/^(\w+)/);if(i){n.commandName=i[1]}else{n.commandName=r.match(/.*/)[0]}return n},parseLineSpec_:function e(t,r){var n=r.match(/^(\d+)/);if(n){return parseInt(n[1],10)-1}switch(r.next()){case".":return this.parseLineSpecOffset_(r,t.getCursor().line);case"$":return this.parseLineSpecOffset_(r,t.lastLine());case"'":var i=r.next();var a=Vt(t,t.state.vim,i);if(!a)throw new Error("Mark not set");return this.parseLineSpecOffset_(r,a.line);case"-":case"+":r.backUp(1);return this.parseLineSpecOffset_(r,t.getCursor().line);default:r.backUp(1);return undefined}},parseLineSpecOffset_:function e(t,r){var n=t.match(/^([+-])?(\d+)/);if(n){var i=parseInt(n[2],10);if(n[1]=="-"){r-=i}else{r+=i}}return r},parseCommandArgs_:function e(t,r,n){if(t.eol()){return}r.argString=t.match(/.*/)[0];var i=n.argDelimiter||/\s+/;var a=Pe(r.argString).split(i);if(a.length&&a[0]){r.args=a}},matchCommand_:function e(t){for(var r=t.length;r>0;r--){var n=t.substring(0,r);if(this.commandMap_[n]){var i=this.commandMap_[n];if(i.name.indexOf(t)===0){return i}}}return null},buildCommandMap_:function e(){this.commandMap_={};for(var t=0;t<w.length;t++){var r=w[t];var n=r.shortName||r.name;this.commandMap_[n]=r}},map:function e(t,r,n){if(t!=":"&&t.charAt(0)==":"){if(n){throw Error("Mode not supported for ex mappings")}var i=t.substring(1);if(r!=":"&&r.charAt(0)==":"){this.commandMap_[i]={name:i,type:"exToEx",toInput:r.substring(1),user:true}}else{this.commandMap_[i]={name:i,type:"exToKey",toKeys:r,user:true}}}else{if(r!=":"&&r.charAt(0)==":"){var a={keys:t,type:"keyToEx",exArgs:{input:r.substring(1)}};if(n){a.context=n}k.unshift(a)}else{var a={keys:t,type:"keyToKey",toKeys:r};if(n){a.context=n}k.unshift(a)}}},unmap:function e(t,r){if(t!=":"&&t.charAt(0)==":"){if(r){throw Error("Mode not supported for ex mappings")}var n=t.substring(1);if(this.commandMap_[n]&&this.commandMap_[n].user){delete this.commandMap_[n];return}}else{var i=t;for(var a=0;a<k.length;a++){if(i==k[a].keys&&k[a].context===r){k.splice(a,1);return}}}}};var Dt={colorscheme:function e(t,r){if(!r.args||r.args.length<1){Lt(t,t.getOption("theme"));return}t.setOption("theme",r.args[0])},map:function e(t,r,n){var i=r.args;if(!i||i.length<2){if(t){Lt(t,"Invalid mapping: "+r.input)}return}Wt.map(i[0],i[1],n)},imap:function e(t,r){this.map(t,r,"insert")},nmap:function e(t,r){this.map(t,r,"normal")},vmap:function e(t,r){this.map(t,r,"visual")},unmap:function e(t,r,n){var i=r.args;if(!i||i.length<1){if(t){Lt(t,"No such mapping: "+r.input)}return}Wt.unmap(i[0],n)},move:function e(t,r){de.processCommand(t,t.state.vim,{type:"motion",motion:"moveToLineOrEdgeOfDocument",motionArgs:{forward:false,explicitRepeat:true,linewise:true},repeatOverride:r.line+1})},set:function e(t,r){var n=r.args;var i=r.setCfg||{};if(!n||n.length<1){if(t){Lt(t,"Invalid mapping: "+r.input)}return}var a=n[0].split("=");var o=a[0];var s=a[1];var l=false;if(o.charAt(o.length-1)=="?"){if(s){throw Error("Trailing characters: "+r.argString)}o=o.substring(0,o.length-1);l=true}if(s===undefined&&o.substring(0,2)=="no"){o=o.substring(2);s=false}var c=G[o]&&G[o].type=="boolean";if(c&&s==undefined){s=true}if(!c&&s===undefined||l){var u=Y(o,t,i);if(u instanceof Error){Lt(t,u.message)}else if(u===true||u===false){Lt(t," "+(u?"":"no")+o)}else{Lt(t,"  "+o+"="+u)}}else{var f=Z(o,s,t,i);if(f instanceof Error){Lt(t,f.message)}}},setlocal:function e(t,r){r.setCfg={scope:"local"};this.set(t,r)},setglobal:function e(t,r){r.setCfg={scope:"global"};this.set(t,r)},registers:function e(t,r){var n=r.args;var e=ie.registerController.registers;var i="----------Registers----------<br><br>";if(!n){for(var a in e){var o=e[a].toString();if(o.length){i+='"'+a+"    "+o+"<br>"}}}else{var a;n=n.join("");for(var s=0;s<n.length;s++){a=n.charAt(s);if(!ie.registerController.isValidRegister(a)){continue}var l=e[a]||new ue;i+='"'+a+"    "+l.toString()+"<br>"}}Lt(t,i)},sort:function e(t,r){var n,i,a,o,s;function l(){if(r.argString){var e=new v.StringStream(r.argString);if(e.eat("!")){n=true}if(e.eol()){return}if(!e.eatSpace()){return"Invalid arguments"}var t=e.match(/([dinuox]+)?\s*(\/.+\/)?\s*/);if(!t&&!e.eol()){return"Invalid arguments"}if(t[1]){i=t[1].indexOf("i")!=-1;a=t[1].indexOf("u")!=-1;var l=t[1].indexOf("d")!=-1||t[1].indexOf("n")!=-1&&1;var c=t[1].indexOf("x")!=-1&&1;var u=t[1].indexOf("o")!=-1&&1;if(l+c+u>1){return"Invalid arguments"}o=l&&"decimal"||c&&"hex"||u&&"octal"}if(t[2]){s=new RegExp(t[2].substr(1,t[2].length-2),i?"i":"")}}}var c=l();if(c){Lt(t,c+": "+r.argString);return}var u=r.line||t.firstLine();var f=r.lineEnd||r.line||t.lastLine();if(u==f){return}var h=x(u,0);var p=x(f,Ne(t,f));var d=t.getRange(h,p).split("\n");var m=s?s:o=="decimal"?/(-?)([\d]+)/:o=="hex"?/(-?)(?:0x)?([0-9a-f]+)/i:o=="octal"?/([0-7]+)/:null;var g=o=="decimal"?10:o=="hex"?16:o=="octal"?8:null;var y=[],k=[];if(o||s){for(var C=0;C<d.length;C++){var w=s?d[C].match(s):null;if(w&&w[0]!=""){y.push(w)}else if(!s&&m.exec(d[C])){y.push(d[C])}else{k.push(d[C])}}}else{k=d}function M(e,t){if(n){var r;r=e;e=t;t=r}if(i){e=e.toLowerCase();t=t.toLowerCase()}var a=o&&m.exec(e);var s=o&&m.exec(t);if(!a){return e<t?-1:1}a=parseInt((a[1]+a[2]).toLowerCase(),g);s=parseInt((s[1]+s[2]).toLowerCase(),g);return a-s}function S(e,t){if(n){var r;r=e;e=t;t=r}if(i){e[0]=e[0].toLowerCase();t[0]=t[0].toLowerCase()}return e[0]<t[0]?-1:1}y.sort(s?S:M);if(s){for(var C=0;C<y.length;C++){y[C]=y[C].input}}else if(!o){k.sort(M)}d=!n?k.concat(y):y.concat(k);if(a){var A=d;var b;d=[];for(var C=0;C<A.length;C++){if(A[C]!=b){d.push(A[C])}b=A[C]}}t.replaceRange(d.join("\n"),h,p)},global:function e(t,r){var n=r.argString;if(!n){Lt(t,"Regular Expression missing from global");return}var i=r.line!==undefined?r.line:t.firstLine();var a=r.lineEnd||r.line||t.lastLine();var o=gt(n);var s=n,l;if(o.length){s=o[0];l=o.slice(1,o.length).join("/")}if(s){try{Bt(t,s,true,true)}catch(e){Lt(t,"Invalid regex: "+s);return}}var c=vt(t).getQuery();var u=[],f="";for(var h=i;h<=a;h++){var p=c.test(t.getLine(h));if(p){u.push(h+1);f+=t.getLine(h)+"<br>"}}if(!l){Lt(t,f);return}var d=0;var v=function e(){if(d<u.length){var r=u[d]+l;Wt.processCommand(t,r,{callback:e})}d++};v()},substitute:function e(t,r){if(!t.getSearchCursor){throw new Error("Search feature not available. Requires searchcursor.js or "+"any other getSearchCursor implementation.")}var n=r.argString;var i=n?kt(n,n[0]):[];var a,o="",s,l,c;var u=false;var f=false;if(i.length){a=i[0];if(Y("pcre")&&a!==""){a=new RegExp(a).source}o=i[1];if(a&&a[a.length-1]==="$"){a=a.slice(0,a.length-1)+"\\n";o=o?o+"\n":"\n"}if(o!==undefined){if(Y("pcre")){o=At(o.replace(/([^\\])&/g,"$1$$&"))}else{o=Mt(o)}ie.lastSubstituteReplacePart=o}s=i[2]?i[2].split(" "):[]}else{if(n&&n.length){Lt(t,"Substitutions should be of the form "+":s/pattern/replace/");return}}if(s){l=s[0];c=parseInt(s[1]);if(l){if(l.indexOf("c")!=-1){u=true;l.replace("c","")}if(l.indexOf("g")!=-1){f=true;l.replace("g","")}if(Y("pcre")){a=a+"/"+l}else{a=a.replace(/\//g,"\\/")+"/"+l}}}if(a){try{Bt(t,a,true,true)}catch(e){Lt(t,"Invalid regex: "+a);return}}o=o||ie.lastSubstituteReplacePart;if(o===undefined){Lt(t,"No previous substitute regular expression");return}var h=vt(t);var p=h.getQuery();var d=r.line!==undefined?r.line:t.getCursor().line;var v=r.lineEnd||d;if(d==t.firstLine()&&v==t.lastLine()){v=Infinity}if(c){d=v;v=d+c-1}var m=xe(t,x(d,0));var g=t.getSearchCursor(p,m);Ft(t,u,f,d,v,g,p,o,r.callback)},redo:v.commands.redo,undo:v.commands.undo,write:function e(t){if(v.commands.save){v.commands.save(t)}else if(t.save){t.save()}},nohlsearch:function e(t){Pt(t)},yank:function e(t){var r=Te(t.getCursor());var n=r.line;var i=t.getLine(n);ie.registerController.pushText("0","yank",i,true,true)},delmarks:function e(t,r){if(!r.argString||!Pe(r.argString)){Lt(t,"Argument required");return}var n=t.state.vim;var i=new v.StringStream(Pe(r.argString));while(!i.eol()){i.eatSpace();var a=i.pos;if(!i.match(/[a-zA-Z]/,false)){Lt(t,"Invalid argument: "+r.argString.substring(a));return}var o=i.next();if(i.match("-",true)){if(!i.match(/[a-zA-Z]/,false)){Lt(t,"Invalid argument: "+r.argString.substring(a));return}var s=o;var l=i.next();if(W(s)&&W(l)||z(s)&&z(l)){var c=s.charCodeAt(0);var u=l.charCodeAt(0);if(c>=u){Lt(t,"Invalid argument: "+r.argString.substring(a));return}for(var f=0;f<=u-c;f++){var h=String.fromCharCode(c+f);delete n.marks[h]}}else{Lt(t,"Invalid argument: "+s+"-");return}}else{delete n.marks[o]}}}};var Wt=new jt;function Ft(e,t,r,n,i,a,o,s,l){e.state.vim.exMode=true;var c=false;var u=a.from();function f(){e.operation((function(){while(!c){h();p()}d()}))}function h(){var t=e.getRange(a.from(),a.to());var r=t.replace(o,s);a.replace(r)}function p(){while(a.findNext()&&_t(a.from(),n,i)){if(!r&&u&&a.from().line==u.line){continue}e.scrollIntoView(a.from(),30);e.setSelection(a.from(),a.to());u=a.from();c=false;return}c=true}function d(t){if(t){t()}e.focus();if(u){e.setCursor(u);var r=e.state.vim;r.exMode=false;r.lastHPos=r.lastHSPos=u.ch}if(l){l()}}function m(t,r,n){v.e_stop(t);var i=v.keyName(t);switch(i){case"Y":h();p();break;case"N":p();break;case"A":var a=l;l=undefined;e.operation(f);l=a;break;case"L":h();case"Q":case"Esc":case"Ctrl-C":case"Ctrl-[":d(n);break}if(c){d(n)}return true}p();if(c){Lt(e,"No matches for "+o.source);return}if(!t){f();if(l){l()}return}Et(e,{prefix:"replace with <strong>"+s+"</strong> (y/n/a/q/l)",onKeyDown:m})}v.keyMap.vim={attach:L,detach:b,call:O};function Ut(e){var t=e.state.vim;var r=ie.macroModeState;var n=ie.registerController.getRegister(".");var i=r.isPlaying;var a=r.lastInsertModeChanges;if(!i){e.off("change",Zt);v.off(e.getInputField(),"keydown",nr)}if(!i&&t.insertModeRepeat>1){ir(e,t,t.insertModeRepeat-1,true);t.lastEditInputState.repeatOverride=t.insertModeRepeat}delete t.insertModeRepeat;t.insertMode=false;e.setCursor(e.getCursor().line,e.getCursor().ch-1);e.setOption("keyMap","vim");e.setOption("disableInput",true);e.toggleOverwrite(false);n.setText(a.changes.join(""));v.signal(e,"vim-mode-change",{mode:"normal"});if(r.isRecording){Gt(r)}}function zt(e){k.unshift(e)}function Jt(e,t,r,n,i){var a={keys:e,type:t};a[t]=r;a[t+"Args"]=n;for(var o in i){a[o]=i[o]}zt(a)}X("insertModeEscKeysTimeout",200,"number");v.keyMap["vim-insert"]={fallthrough:["default"],attach:L,detach:b,call:O};v.keyMap["vim-replace"]={Backspace:"goCharLeft",fallthrough:["vim-insert"],attach:L,detach:b,call:O};function qt(e,t,r,n){var i=ie.registerController.getRegister(n);if(n==":"){if(i.keyBuffer[0]){Wt.processCommand(e,i.keyBuffer[0])}r.isPlaying=false;return}var a=i.keyBuffer;var o=0;r.isPlaying=true;r.replaySearchQueries=i.searchQueries.slice(0);for(var s=0;s<a.length;s++){var l=a[s];var c,u;while(l){c=/<\w+-.+?>|<\w+>|./.exec(l);u=c[0];l=l.substring(c.index+u.length);v.Vim.handleKey(e,u,"macro");if(t.insertMode){var f=i.insertModeChanges[o++].changes;ie.macroModeState.lastInsertModeChanges.changes=f;ar(e,f,1);Ut(e)}}}r.isPlaying=false}function Qt(e,t){if(e.isPlaying){return}var r=e.latestRegister;var n=ie.registerController.getRegister(r);if(n){n.pushText(t)}}function Gt(e){if(e.isPlaying){return}var t=e.latestRegister;var r=ie.registerController.getRegister(t);if(r&&r.pushInsertModeChanges){r.pushInsertModeChanges(e.lastInsertModeChanges)}}function Xt(e,t){if(e.isPlaying){return}var r=e.latestRegister;var n=ie.registerController.getRegister(r);if(n&&n.pushSearchQuery){n.pushSearchQuery(t)}}function Zt(e,t){var r=ie.macroModeState;var n=r.lastInsertModeChanges;if(!r.isPlaying){while(t){n.expectCursorActivityForChange=true;if(n.ignoreCount>1){n.ignoreCount--}else if(t.origin=="+input"||t.origin=="paste"||t.origin===undefined){var i=e.listSelections().length;if(i>1)n.ignoreCount=i;var a=t.text.join("\n");if(n.maybeReset){n.changes=[];n.maybeReset=false}if(a){if(e.state.overwrite&&!/\n/.test(a)){n.changes.push([a])}else{n.changes.push(a)}}}t=t.next}}}function Yt(e){var t=e.state.vim;if(t.insertMode){var r=ie.macroModeState;if(r.isPlaying){return}var n=r.lastInsertModeChanges;if(n.expectCursorActivityForChange){n.expectCursorActivityForChange=false}else{n.maybeReset=true}}else if(!e.curOp.isVimOp){tr(e,t)}if(t.visualMode){er(e)}}function er(e){var t=e.state.vim;var r=xe(e,Te(t.sel.head));var n=Se(r,0,1);if(t.fakeCursor){t.fakeCursor.clear()}t.fakeCursor=e.markText(r,n,{className:"cm-animate-fat-cursor"})}function tr(e,t,r){var n=e.getCursor("anchor");var i=e.getCursor("head");if(t.visualMode&&!e.somethingSelected()){qe(e,false)}else if(!t.visualMode&&!t.insertMode&&e.somethingSelected()){t.visualMode=true;t.visualLine=false;v.signal(e,"vim-mode-change",{mode:"visual"})}if(t.visualMode){var a=!Re(i,n)?-1:0;var o=Re(i,n)?-1:0;i=Se(i,0,a);n=Se(n,0,o);t.sel={anchor:n,head:i};lt(e,t,"<",Be(i,n));lt(e,t,">",Ie(i,n))}else if(!t.insertMode&&!r){t.lastHPos=e.getCursor().ch}}function rr(e){this.keyName=e}function nr(e){var t=ie.macroModeState;var r=t.lastInsertModeChanges;var n=v.keyName(e);if(!n){return}function i(){if(r.maybeReset){r.changes=[];r.maybeReset=false}r.changes.push(new rr(n));return true}if(n.indexOf("Delete")!=-1||n.indexOf("Backspace")!=-1){v.lookupKey(n,"vim-insert",i)}}function ir(e,t,r,n){var i=ie.macroModeState;i.isPlaying=true;var a=!!t.lastEditActionCommand;var o=t.inputState;function s(){if(a){de.processAction(e,t,t.lastEditActionCommand)}else{de.evalInput(e,t)}}function l(r){if(i.lastInsertModeChanges.changes.length>0){r=!t.lastEditActionCommand?1:r;var n=i.lastInsertModeChanges;ar(e,n.changes,r)}}t.inputState=t.lastEditInputState;if(a&&t.lastEditActionCommand.interlaceInsertRepeat){for(var c=0;c<r;c++){s();l(1)}}else{if(!n){s()}l(r)}t.inputState=o;if(t.insertMode&&!n){Ut(e)}i.isPlaying=false}function ar(e,t,r){function n(t){if(typeof t=="string"){v.commands[t](e)}else{t(e)}return true}var i=e.getCursor("head");var a=ie.macroModeState.lastInsertModeChanges.visualBlock;if(a){$e(e,i,a+1);r=e.listSelections().length;e.setCursor(i)}for(var o=0;o<r;o++){if(a){e.setCursor(Se(i,o,0))}for(var s=0;s<t.length;s++){var l=t[s];if(l instanceof rr){v.lookupKey(l.keyName,"vim-insert",n)}else if(typeof l=="string"){var c=e.getCursor();e.replaceRange(l,c,c)}else{var u=e.getCursor();var f=Se(u,0,l[0].length);e.replaceRange(l[0],u,f)}}}if(a){e.setCursor(Se(i,0,1))}}ae();v.Vim=M();M=v.Vim;var or={return:"CR",backspace:"BS",delete:"Del",esc:"Esc",left:"Left",right:"Right",up:"Up",down:"Down",space:"Space",home:"Home",end:"End",pageup:"PageUp",pagedown:"PageDown",enter:"CR"};function sr(e,t,r){if(t.length>1&&t[0]=="n"){t=t.replace("numpad","")}t=or[t]||t;var n="";if(r.ctrlKey){n+="C-"}if(r.altKey){n+="A-"}if((n||t.length>1)&&r.shiftKey){n+="S-"}n+=t;if(n.length>1){n="<"+n+">"}return n}var lr=M.handleKey.bind(M);M.handleKey=function(e,t,r){return e.operation((function(){return lr(e,t,r)}),true)};function cr(e){var t=new e.constructor;Object.keys(e).forEach((function(r){var n=e[r];if(Array.isArray(n))n=n.slice();else if(n&&typeof n=="object"&&n.constructor!=Object)n=cr(n);t[r]=n}));if(e.sel){t.sel={head:e.sel.head&&Te(e.sel.head),anchor:e.sel.anchor&&Te(e.sel.anchor)}}return t}function ur(e,t,r){var n=false;var i=M.maybeInitVimState_(e);var a=i.visualBlock||i.wasInVisualBlock;var o=e.ace.inMultiSelectMode;if(i.wasInVisualBlock&&!o){i.wasInVisualBlock=false}else if(o&&i.visualBlock){i.wasInVisualBlock=true}if(t=="<Esc>"&&!i.insertMode&&!i.visualMode&&o){e.ace.exitMultiSelectMode()}else if(a||!o||e.ace.inVirtualSelectionMode){n=M.handleKey(e,t,r)}else{var s=cr(i);e.operation((function(){e.ace.forEachSelection((function(){var i=e.ace.selection;e.state.vim.lastHPos=i.$desiredColumn==null?i.lead.column:i.$desiredColumn;var a=e.getCursor("head");var o=e.getCursor("anchor");var l=!Re(a,o)?-1:0;var c=Re(a,o)?-1:0;a=Se(a,0,l);o=Se(o,0,c);e.state.vim.sel.head=a;e.state.vim.sel.anchor=o;n=lr(e,t,r);i.$desiredColumn=e.state.vim.lastHPos==-1?null:e.state.vim.lastHPos;if(e.virtualSelectionMode()){e.state.vim=cr(s)}}));if(e.curOp.cursorActivity&&!n)e.curOp.cursorActivity=false}),true)}if(n&&!i.visualMode&&!i.insert&&i.visualMode!=e.somethingSelected()){tr(e,i,true)}return n}t.CodeMirror=v;var fr=M.maybeInitVimState_;t.handler={$id:"ace/keyboard/vim",drawCursor:function e(t,r,n,a,s){var l=this.state.vim||{};var c=n.characterWidth;var u=n.lineHeight;var f=r.top;var h=r.left;if(!l.insertMode){var p=!a.cursor?s.selection.isBackwards()||s.selection.isEmpty():i.comparePoints(a.cursor,a.start)<=0;if(!p&&h>c)h-=c}if(!l.insertMode&&l.status){u=u/2;f+=u}o.translate(t,h,f);o.setStyle(t.style,"width",c+"px");o.setStyle(t.style,"height",u+"px")},handleKeyboard:function e(t,r,n,i,a){var o=t.editor;var s=o.state.cm;var l=fr(s);if(i==-1)return;if(!l.insertMode){if(r==-1){if(n.charCodeAt(0)>255){if(t.inputKey){n=t.inputKey;if(n&&t.inputHash==4)n=n.toUpperCase()}}t.inputChar=n}else if(r==4||r==0){if(t.inputKey==n&&t.inputHash==r&&t.inputChar){n=t.inputChar;r=-1}else{t.inputChar=null;t.inputKey=n;t.inputHash=r}}else{t.inputChar=t.inputKey=null}}if(n=="c"&&r==1){if(!f.isMac&&o.getCopyText()){o.once("copy",(function(){o.selection.clearSelection()}));return{command:"null",passEvent:true}}}if(n=="esc"&&!l.insertMode&&!l.visualMode&&!s.ace.inMultiSelectMode){var c=vt(s);var u=c.getOverlay();if(u)s.removeOverlay(u)}if(r==-1||r&1||r===0&&n.length>1){var h=l.insertMode;var p=sr(r,n,a||{});if(l.status==null)l.status="";var d=ur(s,p,"user");l=fr(s);if(d&&l.status!=null)l.status+=p;else if(l.status==null)l.status="";s._signal("changeStatus");if(!d&&(r!=-1||h))return;return{command:"null",passEvent:!d}}},attach:function e(t){if(!t.state)t.state={};var r=new v(t);t.state.cm=r;t.$vimModeHandler=this;v.keyMap.vim.attach(r);fr(r).status=null;r.on("vim-command-done",(function(){if(r.virtualSelectionMode())return;fr(r).status=null;r.ace._signal("changeStatus");r.ace.session.markUndoGroup()}));r.on("changeStatus",(function(){r.ace.renderer.updateCursor();r.ace._signal("changeStatus")}));r.on("vim-mode-change",(function(){if(r.virtualSelectionMode())return;n();r._signal("changeStatus")}));function n(){var e=fr(r).insertMode;r.ace.renderer.setStyle("normal-mode",!e);t.textInput.setCommandMode(!e);t.renderer.$keepTextAreaAtCursor=e;t.renderer.$blockCursor=!e}n();t.renderer.$cursorLayer.drawCursor=this.drawCursor.bind(r)},detach:function e(t){var r=t.state.cm;v.keyMap.vim.detach(r);r.destroy();t.state.cm=null;t.$vimModeHandler=null;t.renderer.$cursorLayer.drawCursor=null;t.renderer.setStyle("normal-mode",false);t.textInput.setCommandMode(false);t.renderer.$keepTextAreaAtCursor=true},getStatusText:function e(t){var r=t.state.cm;var n=fr(r);if(n.insertMode)return"INSERT";var i="";if(n.visualMode){i+="VISUAL";if(n.visualLine)i+=" LINE";if(n.visualBlock)i+=" BLOCK"}if(n.status)i+=(i?" ":"")+n.status;return i}};M.defineOption({name:"wrap",set:function e(t,r){if(r){r.ace.setOption("wrap",t)}},type:"boolean"},false);M.defineEx("write","w",(function(){console.log(":write is not implemented")}));k.push({keys:"zc",type:"action",action:"fold",actionArgs:{open:false}},{keys:"zC",type:"action",action:"fold",actionArgs:{open:false,all:true}},{keys:"zo",type:"action",action:"fold",actionArgs:{open:true}},{keys:"zO",type:"action",action:"fold",actionArgs:{open:true,all:true}},{keys:"za",type:"action",action:"fold",actionArgs:{toggle:true}},{keys:"zA",type:"action",action:"fold",actionArgs:{toggle:true,all:true}},{keys:"zf",type:"action",action:"fold",actionArgs:{open:true,all:true}},{keys:"zd",type:"action",action:"fold",actionArgs:{open:true,all:true}},{keys:"<C-A-k>",type:"action",action:"aceCommand",actionArgs:{name:"addCursorAbove"}},{keys:"<C-A-j>",type:"action",action:"aceCommand",actionArgs:{name:"addCursorBelow"}},{keys:"<C-A-S-k>",type:"action",action:"aceCommand",actionArgs:{name:"addCursorAboveSkipCurrent"}},{keys:"<C-A-S-j>",type:"action",action:"aceCommand",actionArgs:{name:"addCursorBelowSkipCurrent"}},{keys:"<C-A-h>",type:"action",action:"aceCommand",actionArgs:{name:"selectMoreBefore"}},{keys:"<C-A-l>",type:"action",action:"aceCommand",actionArgs:{name:"selectMoreAfter"}},{keys:"<C-A-S-h>",type:"action",action:"aceCommand",actionArgs:{name:"selectNextBefore"}},{keys:"<C-A-S-l>",type:"action",action:"aceCommand",actionArgs:{name:"selectNextAfter"}});Ce.aceCommand=function(e,t,r){e.vimCmd=t;if(e.ace.inVirtualSelectionMode)e.ace.on("beforeEndOperation",hr);else hr(null,e.ace)};function hr(e,t){t.off("beforeEndOperation",hr);var r=t.state.cm.vimCmd;if(r){t.execCommand(r.exec?r:r.name,r.args)}t.curOp=t.prevOp}Ce.fold=function(e,t,r){e.ace.execCommand(["toggleFoldWidget","toggleFoldWidget","foldOther","unfoldall"][(t.all?2:0)+(t.open?1:0)])};t.handler.defaultKeymap=k;t.handler.actions=Ce;t.Vim=M}));(function(){ace.require(["ace/keyboard/vim"],(function(e){if(typeof module=="object"&&typeof exports=="object"&&module){module.exports=e}}))})();