/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.it.buildergenerator;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.squashtest.it.buildergenerator.TableRowGeneratorException;

public class TableRowBuilderGenerator {
    private static final String PATH_TO_DTD_FILE = "../dtd-generator/target/generated-resources/dbunit.dtd";
    private static final String TARGET_PACKAGE = "org.squashtest.it.datasetbuilder.rowbuilders";
    private static final String GENERATED_RESOURCES_PATH = "target/generated-sources/java";
    private static final Pattern ELEMENT_PATTERN = Pattern.compile("<!ELEMENT\\s+(\\w+)\\s+EMPTY>");
    private static final Pattern ATTLIST_PATTERN = Pattern.compile("<!ATTLIST\\s+(\\w+)\\s+((?:[^>]+\\n?)*?)>");
    private static final Pattern COLUMN_PATTERN = Pattern.compile("(\\w+)\\s+CDATA");
    private static final String CLOSE_METHOD = "    }\n";

    public static void main(String[] args) {
        String content;
        String basedir = System.getProperty("basedir");
        Path dtdPath = Paths.get(basedir, PATH_TO_DTD_FILE);
        if (!Files.exists(dtdPath, new LinkOption[0])) {
            throw new TableRowGeneratorException("DTD file not found at: " + String.valueOf(dtdPath));
        }
        try {
            content = Files.readString(dtdPath);
        }
        catch (IOException e) {
            throw new TableRowGeneratorException("Failed to read DTD file", e);
        }
        Map<String, String> builders = TableRowBuilderGenerator.generateBuildersFromDTD(content);
        for (Map.Entry<String, String> entry : builders.entrySet()) {
            String className = TableRowBuilderGenerator.getClassName(entry.getKey());
            String packageName = TARGET_PACKAGE.replace(".", "/");
            Path outputPath = Paths.get(basedir, "%s/%s/%s.java".formatted(GENERATED_RESOURCES_PATH, packageName, className));
            try {
                Files.createDirectories(Paths.get(outputPath.toUri()).getParent(), new FileAttribute[0]);
                Files.writeString(outputPath, (CharSequence)entry.getValue(), new OpenOption[0]);
            }
            catch (IOException e) {
                throw new TableRowGeneratorException("Failed to write builder to file", e);
            }
        }
        TableRowBuilderGenerator.generateSequenceGenerators(builders, basedir);
    }

    private static Map<String, String> generateBuildersFromDTD(String dtdContent) {
        Map<String, List<String>> tables = TableRowBuilderGenerator.parseDTD(dtdContent);
        HashMap<String, String> builders = new HashMap<String, String>();
        for (Map.Entry<String, List<String>> entry : tables.entrySet()) {
            builders.put(entry.getKey(), TableRowBuilderGenerator.generateBuilder(entry.getKey(), entry.getValue()));
        }
        return builders;
    }

    private static Map<String, List<String>> parseDTD(String dtdContent) {
        HashMap<String, List<String>> tables = new HashMap<String, List<String>>();
        Matcher elementMatcher = ELEMENT_PATTERN.matcher(dtdContent);
        while (elementMatcher.find()) {
            String tableName = elementMatcher.group(1);
            tables.put(tableName, new ArrayList());
        }
        Matcher attlistMatcher = ATTLIST_PATTERN.matcher(dtdContent);
        while (attlistMatcher.find()) {
            String tableName = attlistMatcher.group(1);
            String attlistContent = attlistMatcher.group(2);
            Matcher columnMatcher = COLUMN_PATTERN.matcher(attlistContent);
            while (columnMatcher.find()) {
                ((List)tables.get(tableName)).add(columnMatcher.group(1));
            }
        }
        return tables;
    }

    private static String toCamelCase(String input) {
        StringBuilder camelCase = new StringBuilder();
        boolean capitalizeNext = true;
        char[] cArray = input.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == '_') {
                capitalizeNext = true;
            } else {
                camelCase.append(capitalizeNext ? Character.toUpperCase(c) : Character.toLowerCase(c));
                capitalizeNext = false;
            }
            ++n2;
        }
        return camelCase.toString();
    }

    private static String generateBuilder(String tableName, List<String> columns) {
        String className = TableRowBuilderGenerator.getClassName(tableName);
        StringBuilder builder = new StringBuilder();
        builder.append("package ").append(TARGET_PACKAGE).append(";\n\n");
        builder.append("import org.squashtest.it.datasetbuilder.SequenceGenerator;\n");
        builder.append("import org.squashtest.it.datasetbuilder.TableRow;\n\n");
        builder.append("public record ").append(className).append("(\n");
        int i = 0;
        while (i < columns.size()) {
            builder.append("    Object ").append(columns.get(i));
            if (i < columns.size() - 1) {
                builder.append(",\n");
            } else {
                builder.append("\n");
            }
            ++i;
        }
        builder.append(") {\n\n");
        builder.append("    public static final SequenceGenerator sequence = new SequenceGenerator();\n\n");
        builder.append("    public static final class Builder {\n");
        for (String column : columns) {
            builder.append("        private Object ").append(column).append(";\n");
        }
        builder.append("\n");
        builder.append("        private Builder() {}\n\n");
        for (String column : columns) {
            String methodName = TableRowBuilderGenerator.toCamelCase(column);
            builder.append("        public Builder with").append(methodName).append("(Object value) {\n").append("            this.").append(column).append(" = value;\n").append("            return this;\n").append("        }\n\n");
        }
        builder.append("        public ").append(className).append(" build() {\n").append("            return new ").append(className).append("(\n");
        i = 0;
        while (i < columns.size()) {
            builder.append("                ").append(columns.get(i));
            if (i < columns.size() - 1) {
                builder.append(",\n");
            } else {
                builder.append("\n");
            }
            ++i;
        }
        builder.append("            );\n").append("        }\n");
        builder.append("    }\n\n");
        builder.append("    public static Builder builder() {\n").append("        return new Builder();\n").append(CLOSE_METHOD);
        builder.append("\n").append("    public TableRow toTableRow() {\n").append("        TableRow row = new TableRow(\"").append(tableName).append("\");\n");
        for (String column : columns) {
            builder.append("        row.with(\"").append(column).append("\", this.").append(column).append(");\n");
        }
        builder.append("        return row;\n").append(CLOSE_METHOD);
        builder.append("}\n");
        return builder.toString();
    }

    private static void generateSequenceGenerators(Map<String, String> builders, String basedir) {
        StringBuilder sequenceGenerators = new StringBuilder();
        sequenceGenerators.append("package ").append(TARGET_PACKAGE).append(";\n\n");
        sequenceGenerators.append("public class SequenceGenerators {\n").append("    public static void  resetSequenceGenerators() {\n");
        for (String tableName : builders.keySet()) {
            String className = TableRowBuilderGenerator.getClassName(tableName);
            sequenceGenerators.append("        ").append(className).append(".sequence.reset();\n");
        }
        sequenceGenerators.append(CLOSE_METHOD).append("}\n");
        Path outputPath = Paths.get(basedir, "%s/%s/SequenceGenerators.java".formatted(GENERATED_RESOURCES_PATH, TARGET_PACKAGE.replace(".", "/")));
        try {
            Files.createDirectories(Paths.get(outputPath.toUri()).getParent(), new FileAttribute[0]);
            Files.writeString(outputPath, (CharSequence)sequenceGenerators.toString(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new TableRowGeneratorException("Failed to write sequence generators to file", e);
        }
    }

    private static String getClassName(String tableName) {
        return TableRowBuilderGenerator.toCamelCase(tableName) + "Row";
    }
}

