/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.database.linter.rules;

import java.util.Arrays;
import java.util.List;
import org.dom4j.Element;
import org.squashtest.tm.database.linter.AbstractLinterRule;
import org.squashtest.tm.database.linter.LintErrorCollector;
import org.squashtest.tm.database.linter.RuleId;

public class DbmsRule
extends AbstractLinterRule {
    private static final List<String> ALLOWED_DBMS = Arrays.asList("h2", "mariadb", "postgresql");

    @Override
    public RuleId getRuleId() {
        return RuleId.DBMS;
    }

    @Override
    public void check(Element changeSet, LintErrorCollector errors) {
        String dbms = changeSet.attributeValue("dbms");
        if (dbms == null) {
            return;
        }
        List<String> dbmsList = Arrays.stream(dbms.split(",")).map(String::trim).toList();
        for (String dbmsValue : dbmsList) {
            if (ALLOWED_DBMS.contains(dbmsValue)) continue;
            errors.add("Invalid dbms value: " + dbmsValue);
        }
    }
}

