/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.database.linter.rules;

import java.util.List;
import java.util.stream.Stream;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.squashtest.tm.database.linter.AbstractLinterRule;
import org.squashtest.tm.database.linter.LintErrorCollector;
import org.squashtest.tm.database.linter.RuleId;

public class DbmsSpecificSequenceRule
extends AbstractLinterRule {
    public static final String SEQUENCE_FORMAT = "%s_%s_seq";

    @Override
    public RuleId getRuleId() {
        return RuleId.DBMS_SPECIFIC_SEQUENCES;
    }

    @Override
    public void check(Element changeSet, LintErrorCollector errors) {
        List<Element> createTableWithPrimaryKey = changeSet.elements("createTable").stream().filter(createTableElement -> createTableElement.elements("column").stream().anyMatch(AbstractLinterRule::isPrimaryKeyColumn)).toList();
        if (createTableWithPrimaryKey.isEmpty()) {
            return;
        }
        Attribute dbmsAttribute = changeSet.attribute("dbms");
        if (dbmsAttribute == null) {
            errors.add("Missing 'dbms' attribute");
            return;
        }
        List<String> dbmsList = Stream.of(dbmsAttribute.getValue().split(",")).map(String::trim).toList();
        for (Element createTableElement2 : createTableWithPrimaryKey) {
            for (String dbms : dbmsList) {
                if ("postgresql".equals(dbms)) {
                    this.checkPostgresSpecificSequences(createTableElement2, errors);
                    continue;
                }
                this.checkMariaDbAndH2SpecificSequences(createTableElement2, errors);
            }
        }
    }

    private void checkPostgresSpecificSequences(Element createTableElement, LintErrorCollector errors) {
        for (Element columnElement : createTableElement.elements("column")) {
            if (!DbmsSpecificSequenceRule.isPrimaryKeyColumn(columnElement)) continue;
            String columnName = columnElement.attribute("name").getValue();
            if (columnElement.attribute("autoIncrement") == null) {
                errors.add("Missing 'autoIncrement' attribute for column " + columnName);
            } else if (!Boolean.parseBoolean(columnElement.attribute("autoIncrement").getValue())) {
                errors.add("'autoIncrement' attribute must be set to true for column " + columnName);
            }
            if (columnElement.attribute("defaultValueComputed") == null) continue;
            errors.add("'defaultValueComputed' attribute must not be set for column '%s' for postgresql".formatted(columnName));
        }
    }

    private void checkMariaDbAndH2SpecificSequences(Element createTableElement, LintErrorCollector errors) {
        for (Element columnElement : createTableElement.elements("column")) {
            if (!DbmsSpecificSequenceRule.isPrimaryKeyColumn(columnElement)) continue;
            if (columnElement.attribute("autoIncrement") != null) {
                errors.add("'autoIncrement' attribute must not be set for column '%s' for MariaDB and h2".formatted(columnElement.attribute("name").getValue()));
            }
            if (columnElement.attribute("defaultValueComputed") == null) {
                errors.add("Missing 'defaultValueComputed' attribute for column '%s'".formatted(columnElement.attribute("name").getValue()));
                return;
            }
            String tableName = createTableElement.attribute("tableName").getValue();
            String primaryKeyColumnName = columnElement.attribute("name").getValue();
            String sequenceName = SEQUENCE_FORMAT.formatted(tableName.toLowerCase(), primaryKeyColumnName.toLowerCase());
            String expectedDefaultValueComputed = "NEXT VALUE FOR %s".formatted(sequenceName);
            if (expectedDefaultValueComputed.equals(columnElement.attribute("defaultValueComputed").getValue())) continue;
            errors.add("'defaultValueComputed' attribute must be set to '%s' for column '%s'".formatted(expectedDefaultValueComputed, primaryKeyColumnName));
        }
    }
}

