/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.database.linter.rules;

import org.dom4j.Element;
import org.squashtest.tm.database.linter.AbstractLinterRule;
import org.squashtest.tm.database.linter.LintErrorCollector;
import org.squashtest.tm.database.linter.RuleId;

public class TableNameRule
extends AbstractLinterRule {
    @Override
    public RuleId getRuleId() {
        return RuleId.TABLE_NAME;
    }

    @Override
    public void check(Element changeSet, LintErrorCollector errors) {
        for (Element createTableElement : changeSet.elements("createTable")) {
            TableNameRule.checkTableName(createTableElement, errors);
        }
    }

    private static void checkTableName(Element createTable, LintErrorCollector errors) {
        String tableName = createTable.attributeValue("tableName");
        if (tableName == null || tableName.isEmpty()) {
            errors.add("Table name is missing");
        }
        if (tableName != null && tableName.length() > 32) {
            errors.add("Table name is too long");
        }
        if (tableName != null && !tableName.matches("^[A-Z_]*$")) {
            errors.add("Table name shoud only contain uppercase letters and underscores");
        }
    }
}

