/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.database.linter;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.dom4j.Element;
import org.squashtest.tm.database.linter.LintErrorCollector;
import org.squashtest.tm.database.linter.RuleId;

public abstract class AbstractLinterRule {
    public abstract RuleId getRuleId();

    public abstract void check(Element var1, LintErrorCollector var2);

    protected List<Element> collectChildElements(Element element, Predicate<Element> predicate) {
        ArrayList<Element> results = new ArrayList<Element>();
        this.collectChildElements(element, predicate, results);
        return results;
    }

    private void collectChildElements(Element element, Predicate<Element> predicate, List<Element> results) {
        for (Element child : element.elements()) {
            if (predicate.test(child)) {
                results.add(child);
            }
            this.collectChildElements(child, predicate, results);
        }
    }

    protected static boolean isPrimaryKeyColumn(Element columnElement) {
        return columnElement.elements("constraints").stream().anyMatch(constraint -> constraint.attribute("primaryKey") != null && Boolean.parseBoolean(constraint.attribute("primaryKey").getValue()));
    }
}

