/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.database.linter;

import java.util.Collection;
import java.util.List;
import org.dom4j.Element;
import org.squashtest.tm.database.linter.AbstractLinterRule;
import org.squashtest.tm.database.linter.LintError;
import org.squashtest.tm.database.linter.LintErrorCollector;
import org.squashtest.tm.database.linter.RuleDictionary;
import org.squashtest.tm.database.linter.RuleId;

public class ChangesetLinter {
    private final Element changeSet;
    private final LintErrorCollector errors;

    public ChangesetLinter(String fileName, Element changeSet) {
        this.changeSet = changeSet;
        String changesetId = changeSet.attributeValue("id");
        this.errors = new LintErrorCollector(fileName, changesetId);
    }

    public void lint(List<RuleId> ignoredRules) {
        for (AbstractLinterRule rule : RuleDictionary.getRules()) {
            if (ignoredRules.contains((Object)rule.getRuleId())) continue;
            rule.check(this.changeSet, this.errors);
        }
    }

    public Collection<LintError> getErrors() {
        return this.errors.getErrors();
    }
}

