/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.database.linter.rules;

import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.squashtest.tm.database.linter.AbstractLinterRule;
import org.squashtest.tm.database.linter.LintErrorCollector;
import org.squashtest.tm.database.linter.RuleId;

public class CreateTableIsDbmsSpecificRule
extends AbstractLinterRule {
    @Override
    public RuleId getRuleId() {
        return RuleId.CREATE_TABLE_IS_DBMS_SPECIFIC;
    }

    @Override
    public void check(Element changeSet, LintErrorCollector errors) {
        Attribute dbms;
        List<Element> createTableElements = this.collectChildElements(changeSet, element -> element.getName().equals("createTable"));
        List<Element> createTableWithPrimaryKey = createTableElements.stream().filter(createTableElement -> createTableElement.elements("column").stream().anyMatch(AbstractLinterRule::isPrimaryKeyColumn)).toList();
        if (!createTableWithPrimaryKey.isEmpty() && (dbms = changeSet.attribute("dbms")) == null) {
            errors.add("Table creation with primary key should be DBMS specific");
        }
    }
}

