/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.database.linter;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.squashtest.tm.database.linter.AbstractLinterRule;
import org.squashtest.tm.database.linter.RuleId;
import org.squashtest.tm.database.linter.rules.AuthorRule;
import org.squashtest.tm.database.linter.rules.AutocommitChangesRule;
import org.squashtest.tm.database.linter.rules.ChangesetIdRule;
import org.squashtest.tm.database.linter.rules.ColumnNameRule;
import org.squashtest.tm.database.linter.rules.CreateTableIsDbmsSpecificRule;
import org.squashtest.tm.database.linter.rules.DbmsRule;
import org.squashtest.tm.database.linter.rules.DbmsSpecificSequenceRule;
import org.squashtest.tm.database.linter.rules.ForeignKeyNameRule;
import org.squashtest.tm.database.linter.rules.IndexNameRule;
import org.squashtest.tm.database.linter.rules.LogicalFilePathRule;
import org.squashtest.tm.database.linter.rules.PrimaryKeyNameRule;
import org.squashtest.tm.database.linter.rules.TableNameRule;
import org.squashtest.tm.database.linter.rules.UniqueConstraintNameRule;

public final class RuleDictionary {
    private static final Map<RuleId, AbstractLinterRule> RULES = new EnumMap<RuleId, AbstractLinterRule>(RuleId.class);

    static {
        RuleDictionary.registerRule(ChangesetIdRule.class);
        RuleDictionary.registerRule(LogicalFilePathRule.class);
        RuleDictionary.registerRule(AuthorRule.class);
        RuleDictionary.registerRule(DbmsRule.class);
        RuleDictionary.registerRule(AutocommitChangesRule.class);
        RuleDictionary.registerRule(PrimaryKeyNameRule.class);
        RuleDictionary.registerRule(ForeignKeyNameRule.class);
        RuleDictionary.registerRule(UniqueConstraintNameRule.class);
        RuleDictionary.registerRule(TableNameRule.class);
        RuleDictionary.registerRule(ColumnNameRule.class);
        RuleDictionary.registerRule(IndexNameRule.class);
        RuleDictionary.registerRule(CreateTableIsDbmsSpecificRule.class);
        RuleDictionary.registerRule(DbmsSpecificSequenceRule.class);
        RuleDictionary.checkMissingRules();
    }

    private RuleDictionary() {
    }

    private static void registerRule(Class<? extends AbstractLinterRule> ruleClass) {
        try {
            AbstractLinterRule ruleInstance = ruleClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            RuleId ruleId = ruleInstance.getRuleId();
            if (RULES.containsKey((Object)ruleId)) {
                throw new IllegalStateException("Rule " + String.valueOf((Object)ruleId) + " is already registered");
            }
            RULES.put(ruleId, ruleInstance);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot instantiate rule " + ruleClass.getSimpleName(), e);
        }
    }

    private static void checkMissingRules() {
        RuleId[] ruleIdArray = RuleId.values();
        int n = ruleIdArray.length;
        int n2 = 0;
        while (n2 < n) {
            RuleId ruleId = ruleIdArray[n2];
            if (!RULES.containsKey((Object)ruleId)) {
                throw new IllegalStateException("Rule " + String.valueOf((Object)ruleId) + " is missing");
            }
            ++n2;
        }
    }

    public static List<AbstractLinterRule> getRules() {
        return RULES.entrySet().stream().filter(entry -> entry.getValue() != null).map(Map.Entry::getKey).sorted().map(RULES::get).toList();
    }
}

