/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.database.linter.rules;

import java.util.Arrays;
import java.util.List;
import org.dom4j.Element;
import org.squashtest.tm.database.linter.AbstractLinterRule;
import org.squashtest.tm.database.linter.LintErrorCollector;
import org.squashtest.tm.database.linter.RuleId;

public class ColumnNameRule
extends AbstractLinterRule {
    @Override
    public RuleId getRuleId() {
        return RuleId.COLUMN_NAME;
    }

    @Override
    public void check(Element changeSet, LintErrorCollector errors) {
        for (Element change : changeSet.elements()) {
            if (!Arrays.asList("createTable", "addColumn").contains(change.getName())) continue;
            this.checkColumnCreation(errors, change);
        }
    }

    private void checkColumnCreation(LintErrorCollector errors, Element change) {
        List<Element> columns = this.collectChildElements(change, element -> element.getName().equals("column"));
        for (Element column : columns) {
            ColumnNameRule.checkColumnName(errors, change, column);
        }
    }

    private static void checkColumnName(LintErrorCollector errors, Element change, Element column) {
        String columnName = column.attributeValue("name");
        if (columnName == null || columnName.isEmpty()) {
            errors.add("Column name is missing in '%s'".formatted(change.getName()));
        }
        if (columnName != null && columnName.length() > 32) {
            errors.add("Column name is too long (%s) in '%s'".formatted(columnName, change.getName()));
        }
        if (columnName != null && !columnName.matches("^[A-Z0-9_]*$")) {
            errors.add("Column name should only contain uppercase letters, digits, and underscores (%s) in '%s'".formatted(columnName, change.getName()));
        }
    }
}

