/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.database.linter.rules;

import org.dom4j.Element;
import org.squashtest.tm.database.linter.AbstractLinterRule;
import org.squashtest.tm.database.linter.LintErrorCollector;
import org.squashtest.tm.database.linter.RuleId;

public class ChangesetIdRule
extends AbstractLinterRule {
    @Override
    public RuleId getRuleId() {
        return RuleId.CHANGESET_ID;
    }

    @Override
    public void check(Element element, LintErrorCollector errors) {
        String changesetId = element.attributeValue("id");
        if (changesetId == null || changesetId.isEmpty()) {
            errors.add("ID is missing");
            return;
        }
        if (!changesetId.matches("tm-\\d+\\.\\d+\\.\\d+(-[a-zA-Z0-9\\-._]+)?")) {
            errors.add("Invalid changeset ID format. Expected format is 'tm-<X.Y.Z>-<ID>' but found '%s'".formatted(changesetId));
        }
    }
}

