/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.database.linter.rules;

import java.util.List;
import org.dom4j.Element;
import org.squashtest.tm.database.linter.AbstractLinterRule;
import org.squashtest.tm.database.linter.LintErrorCollector;
import org.squashtest.tm.database.linter.RuleId;

public class PrimaryKeyNameRule
extends AbstractLinterRule {
    public static final String PK_NAME_FORMAT = "pk_%s";

    @Override
    public RuleId getRuleId() {
        return RuleId.PRIMARY_KEY_NAME;
    }

    @Override
    public void check(Element changeSet, LintErrorCollector errors) {
        List changes = changeSet.elements();
        for (Element change : changes) {
            if (!"createTable".equals(change.getName())) continue;
            this.checkTableCreation(errors, change);
        }
    }

    private void checkTableCreation(LintErrorCollector errors, Element change) {
        String tableName = change.attributeValue("tableName");
        List<Element> primaryKeyColumns = this.collectChildElements(change, element -> element.attributeValue("primaryKey") != null);
        if (primaryKeyColumns.size() > 1) {
            errors.add("Multiple primary keys are defined in '%s'".formatted(tableName));
        }
        for (Element primaryKeyColumn : primaryKeyColumns) {
            String primaryKeyColumnName = primaryKeyColumn.attributeValue("primaryKeyName");
            if (primaryKeyColumnName == null) {
                errors.add("Primary key column name is missing in '%s'".formatted(tableName));
                continue;
            }
            String expectedPrimaryKeyColumnName = PK_NAME_FORMAT.formatted(tableName.toLowerCase());
            if (primaryKeyColumnName.equals(expectedPrimaryKeyColumnName)) continue;
            errors.add("Primary key name is '%s' but should be '%s'".formatted(primaryKeyColumnName, expectedPrimaryKeyColumnName));
        }
    }
}

