/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.database.linter.rules;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.dom4j.Element;
import org.squashtest.tm.database.linter.AbstractLinterRule;
import org.squashtest.tm.database.linter.LintErrorCollector;
import org.squashtest.tm.database.linter.RuleId;

public class UniqueConstraintNameRule
extends AbstractLinterRule {
    public static final String CONSTRAINT_NAME_FORMAT = "uq_%s_%s";

    @Override
    public RuleId getRuleId() {
        return RuleId.UNIQUE_CONSTRAINT_NAME;
    }

    @Override
    public void check(Element changeSet, LintErrorCollector errors) {
        List changes = changeSet.elements();
        for (Element change : changes) {
            if ("addUniqueConstraint".equals(change.getName())) {
                UniqueConstraintNameRule.checkAddUniqueConstraint(errors, change);
            }
            if (!Arrays.asList("createTable", "addColumn").contains(change.getName())) continue;
            this.checkColumnCreation(errors, change);
        }
    }

    private void checkColumnCreation(LintErrorCollector errors, Element change) {
        String tableName = change.attributeValue("tableName");
        List<Element> columns = this.collectChildElements(change, element -> element.getName().equals("column"));
        for (Element column : columns) {
            String columnName = column.attributeValue("name");
            List<Element> uniqueConstraints = this.collectChildElements(column, element -> element.getName().equals("constraints") && element.attributeValue("unique") != null);
            for (Element uniqueConstraint : uniqueConstraints) {
                String constraintName = uniqueConstraint.attributeValue("uniqueConstraintName");
                if (constraintName == null) {
                    errors.add("Unique constraint name is missing for column '%s' in '%s'".formatted(columnName, change.getName()));
                    continue;
                }
                String expectedConstraintName = CONSTRAINT_NAME_FORMAT.formatted(tableName.toLowerCase(), columnName.toLowerCase());
                if (constraintName.equals(expectedConstraintName)) continue;
                errors.add("Unique constraint name is '%s' but should be '%s' in '%s'".formatted(constraintName, expectedConstraintName, change.getName()));
            }
        }
    }

    private static void checkAddUniqueConstraint(LintErrorCollector errors, Element change) {
        String tableName = change.attributeValue("tableName");
        String columnNames = change.attributeValue("columnNames");
        String constraintName = change.attributeValue("constraintName");
        if (constraintName == null) {
            errors.add("Unique constraint name is missing for table '%s'".formatted(tableName));
            return;
        }
        String expectedConstraintName = CONSTRAINT_NAME_FORMAT.formatted(tableName.toLowerCase(), Arrays.stream(columnNames.split(",")).map(String::toLowerCase).map(String::trim).collect(Collectors.joining("_")));
        if (!constraintName.equals(expectedConstraintName)) {
            errors.add("Unique constraint name is '%s' but should be '%s' in '%s'".formatted(constraintName, expectedConstraintName, change.getName()));
        }
    }
}

