/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.database.linter.rules;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.dom4j.Element;
import org.squashtest.tm.database.linter.AbstractLinterRule;
import org.squashtest.tm.database.linter.LintErrorCollector;
import org.squashtest.tm.database.linter.RuleId;

public class AutocommitChangesRule
extends AbstractLinterRule {
    @Override
    public RuleId getRuleId() {
        return RuleId.AUTOCOMMIT_CHANGES;
    }

    @Override
    public void check(Element changeSet, LintErrorCollector errors) {
        List changes = changeSet.elements();
        HashMap<String, Integer> autocommitCountByTable = new HashMap<String, Integer>();
        for (Element change : changes) {
            if (!this.isAutocommit(change)) continue;
            List<String> tableNameAttributes = AutoCommitChangeType.forTagName((String)change.getName()).tableNameAttributes;
            List<String> tableNames = tableNameAttributes.stream().map(arg_0 -> ((Element)change).attributeValue(arg_0)).filter(value -> value != null && !value.isEmpty()).toList();
            if (tableNames.isEmpty()) {
                errors.add("Table/view name attribute is missing in '%s'".formatted(change.getName()));
                continue;
            }
            for (String tableName : tableNames) {
                int autocommitCount = autocommitCountByTable.getOrDefault(tableName, 0);
                autocommitCountByTable.put(tableName, autocommitCount + 1);
            }
        }
        if (autocommitCountByTable.entrySet().size() > 1) {
            errors.add("Multiple tables are modified in a single changeset");
        }
    }

    private boolean isAutocommit(Element change) {
        return AutoCommitChangeType.getAllTagNames().contains(change.getName());
    }

    private static enum AutoCommitChangeType {
        CREATE_TABLE("createTable"),
        DROP_TABLE("dropTable"),
        RENAME_TABLE("renameTable", List.of("oldTableName", "newTableName")),
        CREATE_INDEX("createIndex"),
        DROP_INDEX("dropIndex"),
        CREATE_VIEW("createView", List.of("viewName")),
        DROP_VIEW("dropView", List.of("viewName")),
        ADD_COLUMN("addColumn"),
        DROP_COLUMN("dropColumn"),
        RENAME_COLUMN("renameColumn");

        final String tagName;
        final List<String> tableNameAttributes;

        private AutoCommitChangeType(String tagName) {
            this(tagName, List.of("tableName"));
        }

        private AutoCommitChangeType(String tagName, List<String> tableNameAttributes) {
            this.tagName = tagName;
            this.tableNameAttributes = tableNameAttributes;
        }

        public static AutoCommitChangeType forTagName(String name) {
            return Arrays.stream(AutoCommitChangeType.values()).filter(type -> type.getTagName().equals(name)).findFirst().orElseThrow(() -> new IllegalArgumentException("Unknown tag name: " + name));
        }

        public String getTagName() {
            return this.tagName;
        }

        public static List<String> getAllTagNames() {
            return Arrays.stream(AutoCommitChangeType.values()).map(AutoCommitChangeType::getTagName).toList();
        }
    }
}

