/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.database.linter;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.squashtest.tm.database.linter.ChangesetLinter;
import org.squashtest.tm.database.linter.LintError;
import org.squashtest.tm.database.linter.RuleId;

public class Linter {
    private static final List<RuleId> IGNORED_RULES = List.of();
    private static final List<String> IGNORED_FILE_PATTERNS = Arrays.asList("tm\\.changelog-\\d\\.\\d+\\.\\d+.*", "tm\\.changelog-upgrade.*", "tm\\.changelog-install.*", "tm\\.changelog-master.*");
    private static final Logger LOGGER = Logger.getLogger(Linter.class.getName());

    public static void main(String[] args) {
        File directory;
        LOGGER.info("Start linting the changesets");
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL resource = classLoader.getResource("tm");
        if (resource == null) {
            LOGGER.severe("The changesets directory cannot be found");
            System.exit(1);
        }
        if (!(directory = new File(resource.getFile())).exists()) {
            LOGGER.severe("The changesets directory cannot be found");
            System.exit(1);
        }
        ArrayList<LintError> allErrors = new ArrayList<LintError>();
        int fileCount = 0;
        File[] fileArray = Objects.requireNonNull(directory.listFiles());
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File inputFile = fileArray[n2];
            String fileName = inputFile.getName();
            if (IGNORED_FILE_PATTERNS.stream().noneMatch(fileName::matches)) {
                ++fileCount;
                List<LintError> errors = Linter.collectLintErrors(inputFile);
                allErrors.addAll(errors);
                Linter.reportErrors(errors, fileName);
            }
            ++n2;
        }
        LOGGER.info("Linting finished. Found %s errors in %s files".formatted(allErrors.size(), fileCount));
        if (!allErrors.isEmpty()) {
            LOGGER.info("You can temporarily skip this check by activating the 'skip-changeset-linter' profile");
            System.exit(1);
        }
    }

    private static void reportErrors(List<LintError> errors, String fileName) {
        if (errors.isEmpty()) {
            return;
        }
        StringBuilder messageBuilder = new StringBuilder();
        messageBuilder.append("Found %d errors in %s".formatted(errors.size(), fileName));
        for (LintError error : errors) {
            messageBuilder.append("%n  [%s] %s".formatted(error.changesetId(), error.message()));
        }
        LOGGER.severe(messageBuilder.toString());
    }

    private static List<LintError> collectLintErrors(File inputFile) {
        try {
            LOGGER.info("Linting file: " + inputFile.getName());
            SAXReader reader = new SAXReader();
            Document document = reader.read(inputFile);
            Element rootElement = document.getRootElement();
            return Linter.processRootElement(inputFile.getName(), rootElement);
        }
        catch (DocumentException e) {
            LOGGER.severe("An error occurred while reading the file: " + e.getMessage());
            return Collections.emptyList();
        }
    }

    private static List<LintError> processRootElement(String fileName, Element rootElement) {
        List changeSets = rootElement.elements("changeSet");
        ArrayList<LintError> errors = new ArrayList<LintError>();
        for (Element changeSet : changeSets) {
            ChangesetLinter linter = new ChangesetLinter(fileName, changeSet);
            linter.lint(IGNORED_RULES);
            errors.addAll(linter.getErrors());
        }
        return errors;
    }
}

