/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.database.linter.rules;

import java.util.List;
import org.dom4j.Element;
import org.squashtest.tm.database.linter.AbstractLinterRule;
import org.squashtest.tm.database.linter.LintErrorCollector;
import org.squashtest.tm.database.linter.RuleId;

public class IndexNameRule
extends AbstractLinterRule {
    public static final String IDX_NAME_FORMAT = "idx_%s_%s";
    public static final String IDX_FK_NAME_FORMAT = "idx_fk_%s_%s";

    @Override
    public RuleId getRuleId() {
        return RuleId.INDEX_NAME;
    }

    @Override
    public void check(Element changeSet, LintErrorCollector errors) {
        List<Element> createIndexElements = this.collectChildElements(changeSet, element -> element.getName().equals("createIndex"));
        for (Element createIndexElement : createIndexElements) {
            IndexNameRule.checkCreateIndex(errors, createIndexElement);
        }
    }

    private static void checkCreateIndex(LintErrorCollector errors, Element createIndexElement) {
        Element column = createIndexElement.element("column");
        if (column == null) {
            errors.add("Index column is missing");
            return;
        }
        String indexName = createIndexElement.attributeValue("indexName");
        if (indexName == null || indexName.isEmpty()) {
            errors.add("Index name is missing");
            return;
        }
        if (indexName.startsWith("idx_fk_")) {
            IndexNameRule.checkIndexName(errors, createIndexElement, column, indexName, IDX_FK_NAME_FORMAT);
        } else {
            IndexNameRule.checkIndexName(errors, createIndexElement, column, indexName, IDX_NAME_FORMAT);
        }
    }

    private static void checkIndexName(LintErrorCollector errors, Element createIndexElement, Element column, String indexName, String expectedFormat) {
        String tableName = createIndexElement.attributeValue("tableName");
        String columnName = column.attributeValue("name");
        String expectedName = expectedFormat.formatted(tableName.toLowerCase(), columnName.toLowerCase());
        if (!indexName.equals(expectedName)) {
            errors.add("Index name is %s but should be %s".formatted(indexName, expectedName));
        }
    }
}

