/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.database.linter.rules;

import java.util.List;
import org.dom4j.Element;
import org.squashtest.tm.database.linter.AbstractLinterRule;
import org.squashtest.tm.database.linter.LintErrorCollector;
import org.squashtest.tm.database.linter.RuleId;

public class ForeignKeyNameRule
extends AbstractLinterRule {
    public static final String FK_NAME_FORMAT = "fk_%s_%s";

    @Override
    public RuleId getRuleId() {
        return RuleId.FOREIGN_KEY_NAME;
    }

    @Override
    public void check(Element changeSet, LintErrorCollector errors) {
        List changes = changeSet.elements();
        for (Element change : changes) {
            if ("addForeignKeyConstraint".equals(change.getName())) {
                String baseTableName = change.attributeValue("baseTableName");
                String referencedTableName = change.attributeValue("referencedTableName");
                String constraintName = change.attributeValue("constraintName");
                ForeignKeyNameRule.checkName(errors, change, constraintName, baseTableName, referencedTableName);
                continue;
            }
            if (!List.of("createTable", "addColumn").contains(change.getName())) continue;
            String tableName = change.attributeValue("tableName");
            List<Element> foreignKeyColumns = this.collectChildElements(change, element -> element.attributeValue("references") != null);
            for (Element foreignKeyColumn : foreignKeyColumns) {
                String foreignKeyName = foreignKeyColumn.attributeValue("foreignKeyName");
                String references = foreignKeyColumn.attributeValue("references");
                String referencedTableName = references.split("\\(")[0];
                ForeignKeyNameRule.checkName(errors, change, foreignKeyName, tableName, referencedTableName);
            }
        }
    }

    private static void checkName(LintErrorCollector errors, Element change, String constraintName, String baseTableName, String referencedTableName) {
        if (constraintName == null) {
            errors.add("Foreign key name is missing in '%s'".formatted(change.getName()));
            return;
        }
        String expectedConstraintName = FK_NAME_FORMAT.formatted(baseTableName.toLowerCase(), referencedTableName.toLowerCase());
        if (!constraintName.equals(expectedConstraintName)) {
            errors.add("Foreign key name is %s but should be %s in '%s'".formatted(constraintName, expectedConstraintName, change.getName()));
        }
    }
}

