/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.validators.helper;

import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.List;
import java.util.Objects;
import org.springframework.validation.Errors;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.campaign.CampaignFolder;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.Sprint;
import org.squashtest.tm.domain.campaign.SprintGroup;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.RawValue;
import org.squashtest.tm.domain.library.LibraryNode;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.requirement.HighLevelRequirement;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementFolder;
import org.squashtest.tm.domain.testcase.TestCaseFolder;
import org.squashtest.tm.plugin.rest.jackson.model.CustomFieldValueDto;
import org.squashtest.tm.plugin.rest.jackson.model.ParentEntity;
import org.squashtest.tm.plugin.rest.jackson.model.RestNode;
import org.squashtest.tm.plugin.rest.jackson.model.RestType;
import org.squashtest.tm.plugin.rest.validators.helper.CustomFieldValueValidationHelper;
import org.squashtest.tm.service.customfield.CustomFieldBindingFinderService;
import org.squashtest.tm.service.customfield.CustomFieldValueChangerService;

public class RestNodeValidationHelper {
    @PersistenceContext
    protected EntityManager entityManager;
    @Inject
    private CustomFieldBindingFinderService bindingFinderService;
    @Inject
    private CustomFieldValueChangerService customFieldValueChangerService;

    public void assignProject(RestNode restNode) {
        RestType restType = restNode.getParent().getRestType();
        Long id = restNode.getParent().getId();
        switch (restType) {
            case PROJECT: {
                Project project = (Project)this.entityManager.find(Project.class, (Object)id);
                restNode.notifyAssociatedWithProject(project);
                break;
            }
            case REQUIREMENT_FOLDER: {
                RequirementFolder requirementFolder = (RequirementFolder)this.entityManager.find(RequirementFolder.class, (Object)id);
                restNode.notifyAssociatedWithProject(requirementFolder.getProject());
                break;
            }
            case REQUIREMENT: {
                Requirement requirement = (Requirement)this.entityManager.find(Requirement.class, (Object)id);
                restNode.notifyAssociatedWithProject(requirement.getProject());
                break;
            }
            case HIGH_LEVEL_REQUIREMENT: {
                HighLevelRequirement highLevelRequirement = (HighLevelRequirement)this.entityManager.find(HighLevelRequirement.class, (Object)id);
                restNode.notifyAssociatedWithProject(highLevelRequirement.getProject());
                break;
            }
            case TEST_CASE_FOLDER: {
                TestCaseFolder testCaseFolder = (TestCaseFolder)this.entityManager.find(TestCaseFolder.class, (Object)id);
                restNode.notifyAssociatedWithProject(testCaseFolder.getProject());
                break;
            }
            case CAMPAIGN: {
                Campaign campaign = (Campaign)this.entityManager.find(Campaign.class, (Object)id);
                restNode.notifyAssociatedWithProject(campaign.getProject());
                break;
            }
            case CAMPAIGN_FOLDER: {
                CampaignFolder campaignFolder = (CampaignFolder)this.entityManager.find(CampaignFolder.class, (Object)id);
                restNode.notifyAssociatedWithProject(campaignFolder.getProject());
                break;
            }
            case SPRINT: {
                Sprint sprint = (Sprint)this.entityManager.find(Sprint.class, (Object)id);
                restNode.notifyAssociatedWithProject(sprint.getProject());
                break;
            }
            case SPRINT_GROUP: {
                SprintGroup sprintGroup = (SprintGroup)this.entityManager.find(SprintGroup.class, (Object)id);
                restNode.notifyAssociatedWithProject(sprintGroup.getProject());
                break;
            }
            case ITERATION: {
                Iteration iteration = (Iteration)this.entityManager.find(Iteration.class, (Object)id);
                restNode.notifyAssociatedWithProject(iteration.getProject());
                break;
            }
            default: {
                throw new IllegalArgumentException("Programmatic error you should check rest type and parent id before looking for project");
            }
        }
    }

    public void checkParent(Errors errors, RestNode restNode, RestType newNodeRestType) {
        if (restNode.getParent() == null) {
            errors.rejectValue("parent", "required", "The parent information is required to create new node.");
            return;
        }
        ParentEntity parent = restNode.getParent();
        RestType type = RestType.findByTypeName(parent.get_type());
        parent.setRestType(type);
        if (!newNodeRestType.isValidParentType(type)) {
            errors.rejectValue("parent._type", "invalid parent type", "Invalid parent type. Authorized parent types : " + String.valueOf(newNodeRestType.getValidParent()));
        } else {
            Long id = parent.getId();
            this.checkEntityExist(errors, type, id);
        }
    }

    public boolean checkEntityExist(Errors errors, RestType type, Long id) {
        Class typeClass = type.getTypeClass();
        Object o = this.entityManager.find(typeClass, (Object)id);
        if (o == null) {
            String message = String.format("No entity known for type %s and id %d", type.getTypeId(), id);
            errors.rejectValue("id", "invalid id", message);
            return false;
        }
        return true;
    }

    public void checkCufs(Errors errors, RestNode restNode, BindableEntity bindableEntity) {
        Long projectId = restNode.getProject().getId();
        List<CustomFieldValueDto> valueDtos = restNode.getCustomFields();
        if (valueDtos == null) {
            return;
        }
        for (CustomFieldValueDto valueDto : valueDtos) {
            RawValue value = valueDto.getValue();
            if (value == null) {
                throw new IllegalArgumentException("The value of [" + valueDto.getCode() + "] can not be null");
            }
            if (!value.isEmpty()) continue;
            errors.rejectValue("customFields", "blank value", "the value of [" + valueDto.getCode() + "] can not be blank");
        }
        List customFields = this.bindingFinderService.findBoundCustomFields(projectId.longValue(), bindableEntity);
        CustomFieldValueValidationHelper helper = new CustomFieldValueValidationHelper(this.customFieldValueChangerService, bindableEntity, projectId, customFields, valueDtos, errors);
        helper.validate();
    }

    public void checkCufs(Errors errors, List<CustomFieldValueDto> valueDtos, Long projectId, BindableEntity bindableEntity) {
        List customFields = this.bindingFinderService.findBoundCustomFields(projectId.longValue(), bindableEntity);
        CustomFieldValueValidationHelper helper = new CustomFieldValueValidationHelper(this.customFieldValueChangerService, bindableEntity, projectId, customFields, valueDtos, errors);
        helper.validate();
    }

    public void loadProject(RestNode restNode) {
        Object entity = this.entityManager.find(restNode.getRestType().getTypeClass(), (Object)restNode.getId());
        if (Objects.nonNull(entity)) {
            LibraryNode libraryNode = (LibraryNode)entity;
            Project project = libraryNode.getProject();
            restNode.notifyAssociatedWithProject(project);
        }
    }
}

