/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.validators;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.stereotype.Component;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.squashtest.tm.domain.campaign.SprintStatus;
import org.squashtest.tm.domain.campaign.testplan.TestPlanItem;
import org.squashtest.tm.domain.testcase.Dataset;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.plugin.rest.controller.helper.ErrorHandlerHelper;
import org.squashtest.tm.plugin.rest.jackson.model.DatasetDto;
import org.squashtest.tm.plugin.rest.jackson.model.IterationDto;
import org.squashtest.tm.plugin.rest.jackson.model.RestType;
import org.squashtest.tm.plugin.rest.jackson.model.TestCaseDto;
import org.squashtest.tm.plugin.rest.jackson.model.TestPlanItemDto;
import org.squashtest.tm.plugin.rest.validators.helper.IterationValidationHelper;
import org.squashtest.tm.service.internal.repository.DatasetDao;
import org.squashtest.tm.service.internal.repository.SprintReqVersionDao;
import org.squashtest.tm.service.internal.repository.TestPlanItemDao;
import org.squashtest.tm.service.internal.repository.UserDao;
import org.squashtest.tm.service.testplanitem.TestPlanItemAssignableUserFinder;

@Component
public class TestPlanItemValidator
implements Validator {
    private static final String POST_ITERATION_TEST_PLAN = "post-iteration-test-plan";
    private static final String POST_SPRINT_REQ_VERSION_TEST_PLAN = "post-sprint-req-version-test-plan";
    private static final String PATCH_ITERATION_TEST_PLAN = "patch-iteration-test-plan";
    @Inject
    private IterationValidationHelper validationHelper;
    @Inject
    private TestPlanItemDao testPlanItemDao;
    @Inject
    private UserDao userDao;
    @Inject
    private DatasetDao datasetDao;
    @Inject
    private TestPlanItemAssignableUserFinder testPlanItemAssignableUserFinder;
    @Inject
    private SprintReqVersionDao sprintReqVersionDao;

    public boolean supports(Class<?> clazz) {
        return IterationDto.class.equals(clazz);
    }

    public void validate(Object target, Errors errors) {
        Long dataSetId;
        TestPlanItemDto testPlanItemDto = (TestPlanItemDto)target;
        TestCaseDto referencedTcDTo = testPlanItemDto.getReferencedTestCase();
        DatasetDto referencedDatasetDto = testPlanItemDto.getReferencedDataset();
        if (testPlanItemDto.getId() != null) {
            errors.rejectValue("id", "generated value", "This attribute is generated by database and should not be provided. If you want to update an existing test plan item, please do a patch request to the test plan item id. ");
        }
        Long referencedTcDtoId = referencedTcDTo.getId();
        if (!referencedTcDTo.getRestType().equals((Object)RestType.TEST_CASE)) {
            errors.rejectValue("_type", "invalid type", "Type test-case expected");
        } else if (referencedTcDtoId == null) {
            errors.rejectValue("id", "generated value", "The test case id must not be null ");
        }
        this.validationHelper.checkEntityExist(errors, RestType.TEST_CASE, referencedTcDtoId);
        if (referencedDatasetDto != null && (dataSetId = referencedDatasetDto.getId()) != null) {
            this.validateDataSet(errors, dataSetId, referencedTcDtoId);
        }
    }

    public void validatePatchTestPlanItem(TestPlanItemDto tpiDto, Long testPlanItemId) throws BindException {
        ArrayList<Errors> errors = new ArrayList<Errors>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)tpiDto, PATCH_ITERATION_TEST_PLAN);
        boolean tpiExists = this.validationHelper.checkEntityExist((Errors)validation, RestType.TEST_PLAN_ITEM, testPlanItemId);
        Long referencedTcId = tpiExists ? ((TestPlanItem)this.testPlanItemDao.getReferenceById((Object)testPlanItemId)).getReferencedTestCase().getId() : null;
        this.validatePatch(referencedTcId, tpiDto, (Errors)validation);
        this.patchValidateAssignedTo(tpiExists, tpiDto, (Errors)validation);
        if (validation.hasErrors()) {
            errors.add((Errors)validation);
        }
        ErrorHandlerHelper.throwIfError(tpiDto, errors, PATCH_ITERATION_TEST_PLAN);
    }

    public void patchValidateAssignedTo(boolean tpiExists, TestPlanItemDto tpiDto, Errors errors) {
        this.validateAssignedTo(tpiExists, null, null, tpiDto, errors);
    }

    public void validateAssignedTo(boolean entityExists, RestType restType, Long entityId, TestPlanItemDto tpiDto, Errors errors) {
        if (tpiDto.getUser() != null) {
            User assignedTo = this.userDao.findUserByLogin(tpiDto.getUser());
            if (assignedTo == null) {
                errors.rejectValue("user", "not found value", "this user does not exist");
            } else if (entityExists) {
                this.validateUserList(restType, entityId, tpiDto, errors, assignedTo);
            }
        }
    }

    private void validateUserList(RestType restType, Long entityId, TestPlanItemDto tpiDto, Errors errors, User assignedTo) {
        List<User> listUser = this.findUserList(restType, entityId, tpiDto);
        if (listUser.isEmpty()) {
            errors.rejectValue("user", "empty value", "no user are assignable for this iteration");
        } else if (listUser.stream().noneMatch(c -> c.getLogin().equals(assignedTo.getLogin()))) {
            errors.rejectValue("user", "not found value", "this user is not assignable for this test plan");
        }
    }

    private List<User> findUserList(RestType restType, Long entityId, TestPlanItemDto tpiDto) {
        if (Objects.nonNull(entityId)) {
            return restType.equals((Object)RestType.ITERATION) ? this.testPlanItemAssignableUserFinder.findAssignableUsersByIterationId(entityId.longValue()) : this.testPlanItemAssignableUserFinder.findAssignableUsersBySprintReqVersionId(entityId.longValue());
        }
        if (Objects.nonNull(tpiDto.getId())) {
            return this.testPlanItemAssignableUserFinder.findAssignableUsersByTestPlanItemId(tpiDto.getId());
        }
        throw new IllegalArgumentException("entityId or testPlanItemDto's Id must not be null");
    }

    private void validateDataSet(Errors errors, Long dataSetId, Long referencedTcId) {
        Dataset ds;
        boolean dataSetExists = this.validationHelper.checkEntityExist(errors, RestType.DATASET, dataSetId);
        if (dataSetExists && Objects.nonNull(referencedTcId) && !(ds = (Dataset)this.datasetDao.getReferenceById((Object)dataSetId)).getTestCase().getId().equals(referencedTcId)) {
            errors.rejectValue("id", "invalid value", "This dataset is not attached to this test case");
        }
    }

    private void validateSprintStatus(Long entityId, RestType restType, BindingResult validation) {
        SprintStatus sprintStatus;
        if (restType.equals((Object)RestType.SPRINT_REQ_VERSION) && SprintStatus.CLOSED.equals((Object)(sprintStatus = this.sprintReqVersionDao.findSprintStatus(entityId)))) {
            validation.rejectValue("id", "sprint closed", "The status of the related sprint is CLOSED");
        }
    }

    public void validatePostTestPlanItem(TestPlanItemDto testPlanItemDto, Long entityId, RestType restType) throws BindException {
        String operationName = restType.equals((Object)RestType.ITERATION) ? POST_ITERATION_TEST_PLAN : POST_SPRINT_REQ_VERSION_TEST_PLAN;
        ArrayList<Errors> errors = new ArrayList<Errors>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)testPlanItemDto, operationName);
        boolean entityExists = this.validationHelper.checkEntityExist((Errors)validation, restType, entityId);
        this.validate(testPlanItemDto, (Errors)validation);
        this.validateAssignedTo(entityExists, restType, entityId, testPlanItemDto, (Errors)validation);
        this.validateSprintStatus(entityId, restType, (BindingResult)validation);
        if (validation.hasErrors()) {
            errors.add((Errors)validation);
        }
        ErrorHandlerHelper.throwIfError(testPlanItemDto, errors, operationName);
    }

    public void validatePatch(Long referencedTcId, TestPlanItemDto tpiDto, Errors errors) {
        Long dataSetId;
        DatasetDto referencedDatasetDto = tpiDto.getReferencedDataset();
        if (referencedDatasetDto != null && (dataSetId = referencedDatasetDto.getId()) != null) {
            this.validateDataSet(errors, dataSetId, referencedTcId);
        }
    }
}

