/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.validators;

import jakarta.inject.Inject;
import java.util.List;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.testcase.GetKindTestCaseVisitor;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseKind;
import org.squashtest.tm.domain.testcase.TestCaseVisitor;
import org.squashtest.tm.plugin.rest.jackson.model.GetKindTestCaseDtoVisitor;
import org.squashtest.tm.plugin.rest.jackson.model.RestType;
import org.squashtest.tm.plugin.rest.jackson.model.TestCaseDto;
import org.squashtest.tm.plugin.rest.repository.RestTestCaseRepository;
import org.squashtest.tm.plugin.rest.validators.helper.TestCaseDtoValidationHelper;
import org.squashtest.tm.service.internal.deletion.DeletionPreview;
import org.squashtest.tm.service.testcase.TestCaseLibraryNavigationService;

@Component
public class TestCasePatchValidator
implements Validator {
    private static final String NON_PATCHABLE_ATTRIBUTE = "non patchable attribute";
    @Inject
    private TestCaseDtoValidationHelper testCaseDtoValidationHelper;
    @Inject
    private RestTestCaseRepository testCaseRepository;
    @Inject
    private TestCaseLibraryNavigationService testCaseLibraryNavigationService;

    public boolean supports(Class<?> clazz) {
        return TestCaseDto.class.equals(clazz);
    }

    public void validate(Object target, Errors errors) {
        TestCaseDto patch = (TestCaseDto)target;
        this.testCaseDtoValidationHelper.checkEntityExist(errors, RestType.TEST_CASE, patch.getId());
        this.testCaseDtoValidationHelper.loadProject(patch);
        this.testCaseDtoValidationHelper.assignInfoList(errors, patch);
        this.testCaseDtoValidationHelper.checkCufs(errors, patch, BindableEntity.TEST_CASE);
        this.testCaseDtoValidationHelper.checkInvalidAttributeForEachTestCaseType(errors, patch);
        this.testCaseDtoValidationHelper.checkAutomationAttributes(errors, patch);
        this.checkForbiddenPatchAttributes(errors, patch);
    }

    private void checkForbiddenPatchAttributes(Errors errors, TestCaseDto patch) {
        if (patch.getSteps() != null) {
            errors.rejectValue("steps", NON_PATCHABLE_ATTRIBUTE, "Only attributes belonging to the test case itself can be modified. The attribute steps cannot be patched. Use direct url to the steps entity instead");
        }
        if (patch.getParameters() != null) {
            errors.rejectValue("parameters", NON_PATCHABLE_ATTRIBUTE, "Only attributes belonging to the test case itself can be modified. The attribute parameters cannot be patched. Use direct url to the parameters entity instead");
        }
        if (patch.getDatasets() != null) {
            errors.rejectValue("datasets", NON_PATCHABLE_ATTRIBUTE, "Only attributes belonging to the test case itself can be modified. The attribute datasets cannot be patched. Use direct url to the datasets entity instead");
        }
        if (patch.getRequirementVersionCoverages() != null) {
            errors.rejectValue("requirementVersionCoverages", NON_PATCHABLE_ATTRIBUTE, "Only attributes belonging to the test case itself can be modified. The attribute requirementVersionCoverages cannot be patched. Use /test-cases/{id}/coverages instead");
        }
        if (patch.getVerifiedRequirements() != null) {
            errors.rejectValue("verifiedRequirements", NON_PATCHABLE_ATTRIBUTE, "Only attributes belonging to the test case itself can be modified. The attribute verifiedRequirements cannot be patched. Use /test-cases/{id}/coverages instead");
        }
        if (patch.getMilestones() != null) {
            errors.rejectValue("milestones", NON_PATCHABLE_ATTRIBUTE, "Only attributes belonging to the test case itself can be modified. The attribute milestones cannot be patched. Use direct url to the milestones entity instead");
        }
        TestCase testCase = this.testCaseRepository.retrieveById(patch.getId());
        this.checkTestCaseTypeWithGivenDtoType(patch, testCase);
    }

    public DeletionPreview simulationDelete(List<Long> testCaseIds) {
        return this.testCaseLibraryNavigationService.simulateDeletion(testCaseIds);
    }

    private void checkTestCaseTypeWithGivenDtoType(TestCaseDto testCasePatch, TestCase testCase) {
        GetKindTestCaseVisitor entityVisitor = new GetKindTestCaseVisitor();
        testCase.accept((TestCaseVisitor)entityVisitor);
        TestCaseKind entityKind = entityVisitor.getKind();
        GetKindTestCaseDtoVisitor dtoVisitor = new GetKindTestCaseDtoVisitor();
        testCasePatch.accept(dtoVisitor);
        TestCaseKind dtoKind = dtoVisitor.getKind();
        if (!entityKind.equals((Object)dtoKind)) {
            throw new IllegalArgumentException(String.format("Invalid patch type (%s) for %s entity.", dtoKind.name(), entityKind.name()));
        }
    }
}

