/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.validators;

import java.lang.invoke.CallSite;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.squashtest.tm.domain.testautomation.AutomatedExecutionExtender;
import org.squashtest.tm.domain.testautomation.AutomatedSuite;
import org.squashtest.tm.service.internal.dto.resultimport.AttachmentDto;
import org.squashtest.tm.service.internal.dto.resultimport.ExecutionResultDto;
import org.squashtest.tm.service.internal.dto.resultimport.TestDto;

@Component
public class ResultPostValidator
implements Validator {
    private static final String CODE_REQUIRED_ATTRIBUTE = "required attribute";
    private static final String CODE_INVALID_ATTRIBUTE = "invalid attribute";
    private static final String TESTS_ARRAY = "tests[%d]";
    private static final String ATTACHMENTS_ARRAY_PROPERTY = ".attachments[%d]";
    private static final String NAME_PROPERTY = ".name";
    private static final String AUTOMATED_TEST_SUITE = "automatedTestSuite";

    public boolean supports(Class<?> clazz) {
        return ExecutionResultDto.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, Errors errors) {
        ExecutionResultDto externalPipelineResultDto = (ExecutionResultDto)target;
        Optional.ofNullable(externalPipelineResultDto.getAutomatedTestSuite()).ifPresent(suite -> this.validateAutomatedTestSuite(externalPipelineResultDto, errors));
        this.validateTests(externalPipelineResultDto, errors);
    }

    private void validateTests(ExecutionResultDto externalPipelineResultDto, Errors errors) {
        if (externalPipelineResultDto.getTests() == null || externalPipelineResultDto.getTests().isEmpty()) {
            errors.rejectValue("tests", CODE_REQUIRED_ATTRIBUTE, "The tests attribute is required");
        } else {
            int testIndex = 0;
            while (testIndex < externalPipelineResultDto.getTests().size()) {
                TestDto test = (TestDto)externalPipelineResultDto.getTests().get(testIndex);
                this.validateTest(errors, test, testIndex);
                ++testIndex;
            }
            this.checkForDuplicateReferenceDatasetTuples(externalPipelineResultDto.getTests(), errors);
        }
    }

    private void validateTest(Errors errors, TestDto test, int testIndex) {
        if (!StringUtils.hasText((String)test.getReference())) {
            errors.rejectValue(String.format(TESTS_ARRAY, testIndex) + ".reference", CODE_REQUIRED_ATTRIBUTE, "The reference attribute is required");
        }
        if (!StringUtils.hasText((String)test.getStatus())) {
            errors.rejectValue(String.format(TESTS_ARRAY, testIndex) + ".status", CODE_REQUIRED_ATTRIBUTE, "The status attribute is required");
        } else if (this.isInvalidStatus(test.getStatus(), AutomatedExecutionExtender.getImportLegalStatusSet())) {
            errors.rejectValue(String.format(TESTS_ARRAY, testIndex) + ".status", CODE_INVALID_ATTRIBUTE, "The status attribute is invalid, allowed values are: " + String.valueOf(AutomatedExecutionExtender.getImportLegalStatusSet().stream().map(Enum::name).toList()));
        }
        List attachments = test.getAttachments();
        if (attachments != null && !attachments.isEmpty()) {
            int attachmentIndex = 0;
            while (attachmentIndex < attachments.size()) {
                String attachmentName = ((AttachmentDto)attachments.get(attachmentIndex)).getName();
                this.validateExecutionAttachment(errors, testIndex, attachmentName, attachmentIndex);
                ++attachmentIndex;
            }
        }
    }

    private void validateExecutionAttachment(Errors errors, int testIndex, String attachmentName, int attachmentIndex) {
        if (!StringUtils.hasText((String)attachmentName)) {
            this.rejectAttachment(errors, TESTS_ARRAY.formatted(testIndex), attachmentIndex);
        }
    }

    private void checkForDuplicateReferenceDatasetTuples(List<TestDto> tests, Errors errors) {
        HashSet<CallSite> uniqueTuples = new HashSet<CallSite>();
        for (TestDto test : tests) {
            String datasetName = test.getDatasetName() != null ? test.getDatasetName() : "";
            String tuple = test.getReference() + ":" + datasetName;
            if (uniqueTuples.add((CallSite)((Object)tuple))) continue;
            errors.rejectValue(String.format(TESTS_ARRAY, tests.indexOf(test)), CODE_INVALID_ATTRIBUTE, "The reference and dataset name combination must be unique");
        }
    }

    private void validateAutomatedTestSuite(ExecutionResultDto externalPipelineResultDto, Errors errors) {
        String suiteStatus;
        List attachments = externalPipelineResultDto.getAutomatedTestSuite().getAttachments();
        if (attachments != null) {
            int attachmentIndex = 0;
            while (attachmentIndex < attachments.size()) {
                AttachmentDto attachmentDto = (AttachmentDto)attachments.get(attachmentIndex);
                String attachmentName = attachmentDto.getName();
                if (!StringUtils.hasText((String)attachmentName)) {
                    errors.rejectValue(AUTOMATED_TEST_SUITE + String.format(ATTACHMENTS_ARRAY_PROPERTY, attachmentIndex) + NAME_PROPERTY, CODE_REQUIRED_ATTRIBUTE, "The name attribute is required in attachments");
                }
                ++attachmentIndex;
            }
        }
        if ((suiteStatus = externalPipelineResultDto.getAutomatedTestSuite().getStatus()) != null && this.isInvalidStatus(suiteStatus, AutomatedSuite.getImportLegalStatusSet())) {
            errors.rejectValue("automatedTestSuite.status", CODE_INVALID_ATTRIBUTE, "The status attribute is invalid, allowed values are: " + String.valueOf(AutomatedSuite.getImportLegalStatusSet().stream().map(Enum::name).toList()));
        }
    }

    private boolean isInvalidStatus(String candidateStatus, Set<? extends Enum<?>> allowedStatuses) {
        return allowedStatuses.stream().map(Enum::name).noneMatch(candidateStatus::equals);
    }

    private void rejectAttachment(Errors errors, String array, int attachmentIndex) {
        errors.rejectValue(array + String.format(ATTACHMENTS_ARRAY_PROPERTY, attachmentIndex) + NAME_PROPERTY, CODE_INVALID_ATTRIBUTE, "The name attribute is required in attachments");
    }
}

