/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.repository;

import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.squashtest.tm.domain.campaign.testplan.TestPlanItem;

public interface RestTestPlanItemRepository
extends JpaRepository<TestPlanItem, Long> {
    @Query(value="select testPlans from Iteration it join it.testPlan tp join tp.testPlanItems testPlans where it.id = :iterationId order by testPlans.itemOrder")
    public Page<TestPlanItem> findAllByIterationId(@Param(value="iterationId") Long var1, Pageable var2);

    @Query(value="select distinct tpi from TestPlanItem tpi inner join tpi.testSuites ts where ts.id = :testSuiteId order by tpi.itemOrder")
    public Page<TestPlanItem> findAllByTestSuiteId(@Param(value="testSuiteId") Long var1, Pageable var2);

    @Query(value="select distinct item from TestPlanItem item\ninner join item.referencedTestCase tc\ninner join tc.requirementVersionCoverages cov\ninner join cov.verifiedRequirementVersion rv\ninner join rv.requirement req\ninner join req.syncExtender ext\ninner join ext.server server\ninner join item.testPlan.parentIteration iter\ninner join iter.campaign camp\ninner join camp.project p\nwhere ext.remoteReqId = :remoteKey\n  and server.name = :serverName\n  and p.id in :readableProjectIds")
    public Page<TestPlanItem> findItemsByCoveredRemoteRequirement(@Param(value="remoteKey") String var1, @Param(value="serverName") String var2, @Param(value="readableProjectIds") List<Long> var3, Pageable var4);

    @Query(value="    select tpis\n    from SprintReqVersion srv\n    join srv.testPlan testPlan\n    join testPlan.testPlanItems tpis\n    where srv.id = :id\n    order by tpis.itemOrder\n")
    public Page<TestPlanItem> findAllBySprintReqVersionId(long var1, Pageable var3);

    @Query(value="    select tpis\n    from Sprint s\n    join s.sprintReqVersions srv\n    join srv.testPlan testPlan\n    join testPlan.testPlanItems tpis\n    where s.id = :sprintId\n")
    public Page<TestPlanItem> findAllBySprintId(long var1, Pageable var3);
}

