/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.jackson.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.ser.VirtualBeanPropertyWriter;
import com.fasterxml.jackson.databind.util.Annotations;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.hateoas.EntityModel;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.plugin.rest.jackson.serializer.HateoasWrapperConverter;
import org.squashtest.tm.service.internal.repository.RequirementDao;
import org.squashtest.tm.service.internal.repository.display.HighLevelRequirementDisplayDao;

@Configurable
public class RestLinkedRequirementPropertyWriter
extends VirtualBeanPropertyWriter {
    @Inject
    private HighLevelRequirementDisplayDao highLevelRequirementDisplayDao;
    @Inject
    private RequirementDao requirementDao;
    @Inject
    private HateoasWrapperConverter hateoasWrapperConverter;

    public RestLinkedRequirementPropertyWriter() {
    }

    public RestLinkedRequirementPropertyWriter(BeanPropertyDefinition propDef, Annotations contextAnnotations, JavaType declaredType, HighLevelRequirementDisplayDao highLevelRequirementDisplayDao, RequirementDao requirementDao, HateoasWrapperConverter hateoasWrapperConverter) {
        super(propDef, contextAnnotations, declaredType);
        this.highLevelRequirementDisplayDao = highLevelRequirementDisplayDao;
        this.requirementDao = requirementDao;
        this.hateoasWrapperConverter = hateoasWrapperConverter;
    }

    protected Object value(Object bean, JsonGenerator gen, SerializerProvider prov) throws Exception {
        Requirement holder = (Requirement)bean;
        if (holder.isHighLevel()) {
            Set linkedLowLevelReqIds = this.highLevelRequirementDisplayDao.findStandardRequirementsByHighLvlReqId(holder.getId());
            List linkedRequirements = this.requirementDao.findAllByIds((Collection)linkedLowLevelReqIds);
            ArrayList<EntityModel<Requirement>> requirementEntityModels = new ArrayList<EntityModel<Requirement>>();
            for (Requirement linkedRequirement : linkedRequirements) {
                requirementEntityModels.add(this.hateoasWrapperConverter.convert(linkedRequirement));
            }
            return requirementEntityModels;
        }
        return null;
    }

    public VirtualBeanPropertyWriter withConfig(MapperConfig<?> config, AnnotatedClass declaringClass, BeanPropertyDefinition propDef, JavaType type) {
        return new RestLinkedRequirementPropertyWriter(propDef, declaringClass.getAnnotations(), type, this.highLevelRequirementDisplayDao, this.requirementDao, this.hateoasWrapperConverter);
    }
}

