/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.controller;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.execution.ExploratoryExecution;
import org.squashtest.tm.domain.execution.SessionNote;
import org.squashtest.tm.plugin.rest.controller.helper.ResourceLinksHelper;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.EntityGetter;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.plugin.rest.jackson.model.IssueDto;
import org.squashtest.tm.plugin.rest.service.RestIssueService;
import org.squashtest.tm.plugin.rest.service.RestSessionNoteService;

@RestApiController(value=SessionNote.class)
@UseDefaultRestApiConfiguration
public class RestSessionNoteController
extends BaseRestController {
    @Inject
    private ResourceLinksHelper linksHelper;
    @Inject
    private RestSessionNoteService service;
    @Inject
    private RestIssueService restIssueService;

    @GetMapping(value={"/session-notes/{id}"})
    @EntityGetter
    @ResponseBody
    @DynamicFilterExpression(value="*,-execution")
    public ResponseEntity<EntityModel<SessionNote>> findSessionNote(@PathVariable(value="id") long id) {
        SessionNote note = this.service.getOne(id);
        EntityModel res = this.toEntityModel((Identified)note);
        this.linksHelper.addAllLinksForSessionNote((EntityModel<SessionNote>)res);
        res.add(this.createRelationTo("issues"));
        return ResponseEntity.ok((Object)res);
    }

    @GetMapping(value={"/session-notes/{id}/issues"})
    @ResponseBody
    @DynamicFilterExpression(value="id")
    public ResponseEntity<PagedModel<EntityModel<IssueDto>>> finSessionNotesIssues(@PathVariable(value="id") long id, Pageable pageable) {
        SessionNote note = this.service.getOne(id);
        if (note == null) {
            throw new IllegalArgumentException("Session note with id " + id + " does not exist");
        }
        ExploratoryExecution exploratoryExecution = this.service.getExecutionFromSessionNote(id);
        Long exploratoryExecutionId = exploratoryExecution.getId();
        Page<IssueDto> pagedIssue = this.restIssueService.getIssuesFromExecutionIds(Collections.singletonList(exploratoryExecutionId), pageable);
        ArrayList<IssueDto> filteredIssues = new ArrayList<IssueDto>();
        for (IssueDto issue : pagedIssue.getContent()) {
            List<SessionNote> sessionNotes = this.service.getSessionNotesFromIssue(issue.getRemoteIssueId(), exploratoryExecutionId);
            issue.setSessionNotes(new HashSet<SessionNote>(sessionNotes));
            if (sessionNotes.stream().anyMatch(session -> session.getId() == id)) {
                filteredIssues.add(issue);
                issue.setSessionNotes(new HashSet<SessionNote>());
            }
            issue.getExecutions().clear();
        }
        PageImpl pagedIssueToReturn = new PageImpl(filteredIssues, pageable, (long)filteredIssues.size());
        PagedModel res = this.pageAssembler.toModel((Page)pagedIssueToReturn);
        return ResponseEntity.ok((Object)res);
    }
}

