/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.controller;

import jakarta.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.CollectionModel;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.attachment.Attachment;
import org.squashtest.tm.domain.attachment.AttachmentHolder;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.EntityGetter;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.plugin.rest.service.RestAttachmentService;

@RestApiController(value=Attachment.class)
@UseDefaultRestApiConfiguration
public class RestAttachmentController
extends BaseRestController {
    @Inject
    private RestAttachmentService restAttachmentService;

    @GetMapping(value={"/attachments/{id}"})
    @EntityGetter
    @ResponseBody
    @DynamicFilterExpression(value="*")
    public ResponseEntity<EntityModel<Attachment>> findAttachment(@PathVariable(value="id") long id) throws IOException {
        Attachment attachment = this.restAttachmentService.findById(id);
        EntityModel res = EntityModel.of((Object)attachment);
        res.add(this.createSelfLink((Identified)attachment));
        res.add(this.linkService.fromBasePath(WebMvcLinkBuilder.linkTo((Object)((RestAttachmentController)((Object)WebMvcLinkBuilder.methodOn(RestAttachmentController.class, (Object[])new Object[0]))).downloadAttachment(id))).withRel("content"));
        return ResponseEntity.ok((Object)res);
    }

    @PatchMapping(value={"/attachments/{id}"})
    @ResponseBody
    @DynamicFilterExpression(value="*")
    public ResponseEntity<EntityModel<Attachment>> renameAttachment(@PathVariable(value="id") long id, @RequestParam(value="name") String name) throws IOException {
        Attachment attachment = this.restAttachmentService.renameAttachment(id, name);
        EntityModel res = EntityModel.of((Object)attachment);
        res.add(this.createSelfLink((Identified)attachment));
        res.add(this.linkService.fromBasePath(WebMvcLinkBuilder.linkTo((Object)((RestAttachmentController)((Object)WebMvcLinkBuilder.methodOn(RestAttachmentController.class, (Object[])new Object[0]))).downloadAttachment(id))).withRel("content"));
        return ResponseEntity.ok((Object)res);
    }

    @GetMapping(value={"/attachments/{id}/content"}, produces={"application/octet-stream"})
    @Transactional(readOnly=true)
    public ResponseEntity downloadAttachment(@PathVariable(value="id") long id) throws IOException {
        Attachment attachment = this.restAttachmentService.findById(id);
        InputStream in = attachment.getContent().getStream();
        byte[] out = IOUtils.toByteArray((InputStream)in);
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.add("Content-Disposition", "attachment; filename=" + attachment.getName().replace(" ", "_"));
        responseHeaders.add("Content-Type", "application/octet-stream");
        return new ResponseEntity((Object)out, (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/{owner}/{ownerId}/attachments"})
    @ResponseBody
    @DynamicFilterExpression(value="*, -type,-size, -added_on")
    public ResponseEntity<PagedModel<EntityModel<Attachment>>> findAttachmentsByOwner(@PathVariable(value="owner") String owner, @PathVariable(value="ownerId") long ownerId, Pageable pageable) {
        AttachmentHolder holder = this.restAttachmentService.findHolder(owner, ownerId);
        Page<Attachment> attachments = this.restAttachmentService.findPagedAttachments(holder, pageable);
        PagedModel res = this.toPagedModel(attachments);
        return ResponseEntity.ok((Object)res);
    }

    @PostMapping(value={"/{owner}/{ownerId}/attachments"})
    @ResponseBody
    @DynamicFilterExpression(value="*, -type,-size, -added_on")
    public ResponseEntity<CollectionModel<EntityModel<Attachment>>> uploadAttachments(@PathVariable(value="owner") String owner, @PathVariable(value="ownerId") long ownerId, @RequestParam(value="files") List<MultipartFile> files) {
        String permissionName = this.getPermissionNameFromOwner(owner);
        Map<EntityType, AttachmentHolder> holderMap = this.restAttachmentService.findHolderWithPermission(owner, ownerId, permissionName);
        EntityType holderType = holderMap.entrySet().iterator().next().getKey();
        AttachmentHolder holder = holderMap.get(holderType);
        List<Attachment> attachments = this.restAttachmentService.addAttachments(holder, files, holderType);
        List resources = attachments.stream().map(attachment -> {
            EntityModel res = EntityModel.of((Object)attachment);
            res.add(this.createSelfLink((Identified)attachment));
            return res;
        }).collect(Collectors.toList());
        CollectionModel res = CollectionModel.of(resources);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)res);
    }

    @DeleteMapping(value={"/{owner}/{ownerId}/attachments"})
    @ResponseBody
    @DynamicFilterExpression(value="*, -type,-size, -added_on")
    public ResponseEntity<Void> deleteAttachments(@PathVariable(value="owner") String owner, @PathVariable(value="ownerId") long ownerId, @RequestParam(value="attachmentIds") List<Long> attachmentIds) throws IOException {
        String permissionName = this.getPermissionNameFromOwner(owner);
        Map<EntityType, AttachmentHolder> holderMap = this.restAttachmentService.findHolderWithPermission(owner, ownerId, permissionName);
        EntityType holderType = holderMap.entrySet().iterator().next().getKey();
        AttachmentHolder holder = holderMap.get(holderType);
        this.restAttachmentService.deleteAttachments(holder, attachmentIds, holderType);
        return ResponseEntity.noContent().build();
    }

    private String getPermissionNameFromOwner(String owner) {
        return "projects".equals(owner) ? Permissions.MANAGE_PROJECT.name() : Permissions.ATTACH.name();
    }
}

